/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

public class JarMerge {
    private boolean check = false;
    private boolean unzip = false;
    private boolean zip = false;
    private boolean add = false;
    private boolean silent = false;
    private boolean oldOverwrites = false;
    private boolean standardManifestToCreate = false;
    private Pattern fileFilterPattern = Pattern.compile(".*");
    private int compression = -1;
    private boolean detach = false;
    private String source = null;
    private String targetPath = null;
    private String manifestFile = null;
    private String identity = this.getClass().getName();

    private JarMerge(String[] args) {
        try {
            this.parseArguments(args);
        }
        catch (Exception e) {
            this.loglnError("\n abort: " + e.getMessage());
            this.printUsage();
            System.exit(-1);
        }
    }

    private void log(String msg) {
        System.out.print(msg);
    }

    private void logln(String msg) {
        System.out.println(msg);
    }

    private void loglnError(String msg) {
        System.err.println(msg);
    }

    private void printUsage() {
        String usage = "\n usage:";
        usage = usage + " java " + this.identity + " [-s] check PATH";
        usage = usage + "\n";
        usage = usage + "\n        -all jar/zip archives in directory PATH are tested";
        usage = usage + "\n         for duplicate classnames respecting the package structure";
        usage = usage + "\n         -s: silent mode, if no duplicates are found nothing will be written to console";
        usage = usage + "\n";
        usage = usage + "\n        java " + this.identity + " [-o] [-f=REGEXP] [-d] unzip SOURCE [TARGETPATH]";
        usage = usage + "\n";
        usage = usage + "\n        -extract all files contained in jar/zip archive(s) to subdirectories";
        usage = usage + "\n         relative to package structure.";
        usage = usage + "\n         SOURCE can be a directory or a single archive.";
        usage = usage + "\n         If the directory TARGETPATH is set the structure of subdirectories is created there.";
        usage = usage + "\n         By default the structure of subdirectories is created in current working directory.";
        usage = usage + "\n         If the flag -o is set older files overwrite newer ones.";
        usage = usage + "\n         By default newer files overwrite older ones.";
        usage = usage + "\n         -f: file filter for extracting, REGEXP is a regular expression";
        usage = usage + "\n         -d: (detach) all files are extracted directly to target directory";
        usage = usage + "\n             without attending to package structure";
        usage = usage + "\n";
        usage = usage + "\n        java " + this.identity + " [-m] [-f=REGEXP] [-c=LEVEL] zip SOURCEPATH JARFILE [MANIFESTFILE]";
        usage = usage + "\n";
        usage = usage + "\n        -all files of directory SOURCEPATH and subdirectories are compressed";
        usage = usage + "\n         to jar archive file JARFILE.";
        usage = usage + "\n         If a manifest file is set for MANIFESTFILE this file will be added to jar archive.";
        usage = usage + "\n         If the flag -m is set a standard manifest will be created.";
        usage = usage + "\n         This flag will be ignored if MANIFESTFILE is set.";
        usage = usage + "\n         By default it will be searched in SOURCEPATH for '/META-INF/MANIFEST.MF'.";
        usage = usage + "\n         If this manifest file is found it will be added to jar archive.";
        usage = usage + "\n         If this manifest file is not found a standard manifest will be created.";
        usage = usage + "\n         -f: file filter for compression, REGEXP is a regular expression";
        usage = usage + "\n         -c: compression level, LEVEL can be 0 to 9";
        usage = usage + "\n";
        usage = usage + "\n        java " + this.identity + " [-m] [-f=REGEXP] [-c=LEVEL] add SOURCEPATH JARFILE [MANIFESTFILE]";
        usage = usage + "\n";
        usage = usage + "\n        -all files of directory SOURCEPATH and subdirectories are added";
        usage = usage + "\n         to existing jar archive file JARFILE.";
        usage = usage + "\n         If JARFILE does not yet exist a new file will be created.";
        usage = usage + "\n         If a manifest file is set for MANIFESTFILE this file will be added to jar archive.";
        usage = usage + "\n         If the flag -m is set a standard manifest will be created.";
        usage = usage + "\n         This flag will be ignored if MANIFESTFILE is set.";
        usage = usage + "\n         By default it will be searched in SOURCEPATH for '/META-INF/MANIFEST.MF'.";
        usage = usage + "\n         If this manifest file is found it will be added to jar archive.";
        usage = usage + "\n         If this manifest file is not found a standard manifest will be created.";
        usage = usage + "\n         -f: file filter for compression, REGEXP is a regular expression";
        usage = usage + "\n         -c: compression level, LEVEL can be 0 to 9. It affects all files in the archive.";
        usage = usage + "\n";
        usage = usage + "\n        java " + this.identity + " -h";
        usage = usage + "\n";
        usage = usage + "\n        -show this help";
        this.logln(usage);
    }

    private void parseArguments(String[] args) throws Exception {
        block44: {
            String sw;
            ArrayList<String> switches;
            ArrayList<String> arguments;
            block45: {
                block43: {
                    if (args == null) {
                        throw new Exception("args is null");
                    }
                    if (args.length == 0) {
                        throw new Exception("arguments missing");
                    }
                    if ("-h".equals(args[0].toLowerCase())) {
                        if (args.length > 1) {
                            String arg = args[1];
                            if ("check".equals(arg) || "unzip".equals(arg) || "zip".equals(arg) || "add".equals(arg)) {
                                throw new Exception("unexpected command '" + arg + "'");
                            }
                            if (args[1].length() < 2) {
                                throw new Exception("unknown parameter '" + args[1] + "'");
                            }
                            arg = args[1].substring(0, 2).toLowerCase();
                            if ("-s".equals(arg) || "-o".equals(arg) || "-f".equals(arg) || "-m".equals(arg) || "-c".equals(arg) || "-d".equals(arg) || "-h".equals(arg)) {
                                throw new Exception("unexpected parameter '" + args[1] + "'");
                            }
                            throw new Exception("unknown parameter '" + args[1] + "'");
                        }
                        this.printUsage();
                        System.exit(0);
                    }
                    arguments = new ArrayList<String>();
                    switches = new ArrayList<String>();
                    for (String arg : args) {
                        if (arg.charAt(0) == '-') {
                            if (arg.length() == 1) {
                                if (args.length == 1) {
                                    throw new Exception("unknown command '-'");
                                }
                                throw new Exception("unknown parameter '-'");
                            }
                            switches.add(arg);
                            continue;
                        }
                        arguments.add(arg);
                    }
                    if (arguments.isEmpty()) {
                        throw new Exception("unknown command '" + args[0] + "'");
                    }
                    String command = (String)arguments.get(0);
                    int minNrOfArgs = 0;
                    int maxNrOfArgs = 0;
                    if ("check".equals(command)) {
                        this.check = true;
                        minNrOfArgs = 1;
                        maxNrOfArgs = 1;
                    } else if ("unzip".equals(command)) {
                        this.unzip = true;
                        minNrOfArgs = 1;
                        maxNrOfArgs = 2;
                    } else if ("zip".equals(command)) {
                        this.zip = true;
                        minNrOfArgs = 2;
                        maxNrOfArgs = 3;
                    } else if ("add".equals(command)) {
                        this.add = true;
                        minNrOfArgs = 2;
                        maxNrOfArgs = 3;
                    } else {
                        throw new Exception("unknown command '" + command + "'");
                    }
                    arguments.remove(0);
                    if (arguments.size() < minNrOfArgs) {
                        throw new Exception("arguments missing");
                    }
                    if (arguments.size() > maxNrOfArgs) {
                        throw new Exception("too many arguments");
                    }
                    sw = null;
                    if (!this.check) break block43;
                    this.source = (String)arguments.get(0);
                    for (int i = 0; i < switches.size(); ++i) {
                        sw = ((String)switches.get(i)).toLowerCase();
                        if (!"-s".equals(sw)) {
                            if ("-o".equals(sw) || "-m".equals(sw) || "-h".equals(sw) || "-d".equals(sw) || sw.matches("-f=.+") || sw.matches("-c=.+")) {
                                throw new Exception("unexpected parameter '" + (String)switches.get(i) + "'");
                            }
                            throw new Exception("unknown parameter '" + (String)switches.get(i) + "'");
                        }
                        this.silent = true;
                    }
                    break block44;
                }
                if (!this.unzip) break block45;
                this.source = (String)arguments.get(0);
                if (arguments.size() == 2) {
                    this.targetPath = (String)arguments.get(1);
                }
                for (int i = 0; i < switches.size(); ++i) {
                    sw = ((String)switches.get(i)).toLowerCase();
                    if ("-d".equals(sw)) {
                        this.detach = true;
                        continue;
                    }
                    if ("-o".equals(sw)) {
                        this.oldOverwrites = true;
                        continue;
                    }
                    if (sw.matches("-f=.+")) {
                        try {
                            this.fileFilterPattern = Pattern.compile(((String)switches.get(i)).substring(3));
                            continue;
                        }
                        catch (Exception e) {
                            throw new Exception("cannot compile pattern '" + ((String)switches.get(i)).substring(3) + "'");
                        }
                    }
                    if ("-s".equals(sw) || "-m".equals(sw) || "-h".equals(sw) || sw.matches("-c=.+")) {
                        throw new Exception("unexpected parameter '" + (String)switches.get(i) + "'");
                    }
                    throw new Exception("unknown parameter '" + (String)switches.get(i) + "'");
                }
                break block44;
            }
            if (!this.zip && !this.add) break block44;
            this.source = (String)arguments.get(0);
            this.targetPath = (String)arguments.get(1);
            if (arguments.size() == 3) {
                this.manifestFile = (String)arguments.get(2);
            }
            for (int i = 0; i < switches.size(); ++i) {
                sw = ((String)switches.get(i)).toLowerCase();
                if ("-m".equals(sw)) {
                    this.standardManifestToCreate = true;
                    continue;
                }
                if (sw.matches("-f=.+")) {
                    try {
                        this.fileFilterPattern = Pattern.compile(((String)switches.get(i)).substring(3));
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("cannot compile pattern '" + ((String)switches.get(i)).substring(3) + "'");
                    }
                }
                if (sw.matches("-c=.+")) {
                    try {
                        this.compression = Integer.parseInt(((String)switches.get(i)).substring(3));
                    }
                    catch (Exception e) {
                        throw new Exception("cannot convert '" + ((String)switches.get(i)).substring(3) + "' to int");
                    }
                    if (this.compression >= 0 && this.compression <= 9) continue;
                    throw new Exception("level of compression must be between 0 and 9");
                }
                if ("-s".equals(sw) || "-o".equals(sw) || "-d".equals(sw) || "-h".equals(sw)) {
                    throw new Exception("unexpected parameter '" + (String)switches.get(i) + "'");
                }
                throw new Exception("unknown parameter '" + (String)switches.get(i) + "'");
            }
        }
    }

    private String[] archiveFilter(String[] list) {
        int deleted = 0;
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i].length() < 4 || list[i] == null) {
                list[i] = null;
                ++deleted;
                continue;
            }
            String suffix = list[i].substring(list[i].length() - 4);
            if (".jar".equals(suffix) || ".zip".equals(suffix)) continue;
            list[i] = null;
            ++deleted;
        }
        String[] fList = new String[list.length - deleted];
        int n = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            fList[n++] = list[i];
        }
        return fList;
    }

    private File[] fileFilter(File[] list, Pattern pattern) throws Exception {
        String newjarPath = new File(this.targetPath).getCanonicalPath();
        int deleted = 0;
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != null && !list[i].getCanonicalPath().equals(newjarPath) && !Pattern.matches(".*META-INF[/\\\\]MANIFEST[.]MF", list[i].getPath()) && pattern.matcher(list[i].getName()).matches()) continue;
            list[i] = null;
            ++deleted;
        }
        File[] fList = new File[list.length - deleted];
        int n = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            fList[n++] = list[i];
        }
        return fList;
    }

    private void executeCheck() throws Exception {
        int duplicates = 0;
        File file = new File(this.source);
        String[] list = this.archiveFilter(file.list());
        if (list.length == 0) {
            this.logln("\n no jar/zip archives found");
            return;
        }
        Hashtable<String, String> inventory = new Hashtable<String, String>();
        try {
            int i = 0;
            for (i = 0; i < list.length; ++i) {
                JarFile jar = new JarFile(this.source + list[i]);
                Enumeration<JarEntry> content = jar.entries();
                while (content.hasMoreElements()) {
                    JarEntry entry = content.nextElement();
                    String classFile = entry.getName();
                    long lDate = entry.getTime();
                    long size = entry.getSize();
                    if (classFile.length() <= 6 || !".class".equals(classFile.substring(classFile.length() - 6))) continue;
                    if (!inventory.containsKey(classFile)) {
                        inventory.put(classFile, list[i] + "|" + String.valueOf(lDate) + "|" + String.valueOf(size));
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer((String)inventory.get(classFile), "|");
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    String firstFile = st.nextToken();
                    String firstDate = st.nextToken();
                    String firstSize = st.nextToken();
                    firstDate = Long.parseLong(firstDate) < 0L ? "unknown" : sdf.format(new Date(Long.parseLong(firstDate)));
                    if (Long.parseLong(firstSize) < 0L) {
                        firstSize = "unknown";
                    }
                    int gap = Math.max(firstFile.length(), firstDate.length());
                    gap = Math.max(gap, firstSize.length());
                    while (firstFile.length() < gap) {
                        firstFile = firstFile + " ";
                    }
                    while (firstDate.length() < gap) {
                        firstDate = firstDate + " ";
                    }
                    while (firstSize.length() < gap) {
                        firstSize = firstSize + " ";
                    }
                    this.logln("\n duplicate class found: " + classFile);
                    this.logln(" " + firstFile + "   " + list[i]);
                    this.logln(" " + firstDate + "   " + (lDate < 0L ? "unknown" : sdf.format(new Date(lDate))));
                    this.logln(" " + firstSize + "   " + (size < 0L ? "unknown" : String.valueOf(size)));
                    ++duplicates;
                }
            }
            if (duplicates == 0 && !this.silent) {
                this.logln("\n no duplicates found");
                this.logln(" " + i + " archive" + (i != 1 ? "s" : "") + " passed");
            } else {
                this.logln("\n " + duplicates + " duplicate" + (duplicates != 1 ? "s" : "") + " found");
                this.logln(" " + i + " archive" + (i != 1 ? "s" : "") + " passed");
            }
        }
        catch (Exception e) {
            this.loglnError("check error: " + e.getMessage());
        }
    }

    private String unpackJarEntry(JarFile jarFile, JarEntry jarEntry, String targetPath) throws JarException, IOException, Exception {
        try {
            int c;
            if (jarFile == null) {
                throw new Exception("jarFile is null");
            }
            if (jarEntry == null) {
                throw new Exception("jarEntry is null");
            }
            if (targetPath == null) {
                targetPath = "";
            }
            String filename = jarEntry.getName();
            if (this.detach) {
                int index = filename.lastIndexOf(47) + 1;
                filename = filename.substring(index);
            }
            File file = new File(targetPath + filename);
            BufferedInputStream bis = new BufferedInputStream(jarFile.getInputStream(jarEntry));
            File dir = new File(file.getParent());
            dir.mkdirs();
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            while ((c = bis.read()) != -1) {
                bos.write((byte)c);
            }
            bos.close();
            bis.close();
            file = new File(targetPath + filename);
            file.setLastModified(jarEntry.getTime());
            return targetPath + filename;
        }
        catch (JarException jax) {
            throw new JarException(jax.getMessage() + ": " + this.identity + ".unpackJarEntry: " + jarFile.getName() + " => " + targetPath + jarEntry.getName());
        }
        catch (IOException iox) {
            throw new IOException(iox.getMessage() + ": " + this.identity + ".unpackJarEntry: " + jarFile.getName() + " => " + targetPath + jarEntry.getName(), iox);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + ": " + this.identity + ".unpackJarEntry: " + jarFile.getName() + " => " + targetPath + jarEntry.getName(), e);
        }
    }

    private void createManifestFile(ArrayList<String> iSecName, ArrayList<String> iSecOrigin, ArrayList<String> iSecDate, String targetPath) throws IOException, Exception {
        Manifest manifest = null;
        File file = null;
        try {
            if (iSecName == null || iSecOrigin == null || iSecDate == null) {
                throw new Exception("iSec is null");
            }
            if (iSecName.size() != iSecOrigin.size() || iSecName.size() != iSecDate.size()) {
                throw new Exception("iSec ArrayList sizes are inconsistent " + iSecName.size() + "," + iSecOrigin.size() + "," + iSecDate.size());
            }
            if (iSecName.isEmpty()) {
                return;
            }
            if (targetPath == null) {
                targetPath = "";
            }
            if (!(file = new File(targetPath + "META-INF")).isDirectory()) {
                file.mkdir();
            }
            file = new File(targetPath + "META-INF/MANIFEST.MF");
            file.createNewFile();
            StringBuilder sb = new StringBuilder();
            sb.append("Manifest-Version: 1.0\n");
            sb.append("Created-By: " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")\n");
            sb.append("\n");
            for (int i = 0; i < iSecName.size(); ++i) {
                sb.append("Name: " + iSecName.get(i) + "\n");
                sb.append("Origin: " + iSecOrigin.get(i) + "\n");
                sb.append("Archive-Date: " + iSecDate.get(i) + "\n");
                sb.append("\n");
            }
            ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
            manifest = new Manifest(is);
            manifest.write(new FileOutputStream(file));
            this.logln("\n manifest file " + file.getCanonicalPath() + " created");
        }
        catch (IOException iox) {
            throw new IOException(this.identity + "constructManifest: " + iox.getMessage(), iox);
        }
        catch (Exception e) {
            throw new Exception(this.identity + "constructManifest: " + e.getMessage(), e);
        }
    }

    private Manifest readManifestFile(String path) throws IOException {
        Manifest manifest = null;
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (file.canRead()) {
            try {
                manifest = new Manifest(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iox) {
                throw new IOException(this.identity + "readManifestFile: " + file.getCanonicalPath() + ": " + iox.getMessage(), iox);
            }
        }
        return manifest;
    }

    private void executeUnzip() throws Exception {
        File file = null;
        String classFile = "";
        String filename = "";
        int extracted = 0;
        int processed = 0;
        ArrayList<String> iSecName = new ArrayList<String>();
        ArrayList<String> iSecOrigin = new ArrayList<String>();
        ArrayList<String> iSecDate = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        file = new File(this.source);
        String path = null;
        String[] list = null;
        if (file.isDirectory()) {
            path = this.source;
            list = this.archiveFilter(file.list());
        } else {
            path = file.getPath().substring(0, file.getPath().length() - file.getName().length());
            list = new String[]{file.getName()};
        }
        if (list.length == 0) {
            this.logln("\n no jar/zip archives found");
            return;
        }
        if (this.oldOverwrites) {
            this.logln("\n directive: overwrite newer versions");
        } else {
            this.logln("\n directive: overwrite older versions");
        }
        try {
            for (String element : list) {
                String jarDate;
                this.logln("\n unpack " + element + ":");
                JarFile jar = new JarFile(path + element);
                Enumeration<JarEntry> content = jar.entries();
                file = new File(path + element);
                String string = jarDate = file.lastModified() < 0L ? "unknown" : sdf.format(new Date(file.lastModified()));
                while (content.hasMoreElements()) {
                    int index;
                    JarEntry entry = content.nextElement();
                    classFile = entry.getName();
                    if (classFile.charAt(classFile.length() - 1) == '/' || "META-INF/MANIFEST.MF".equals(classFile.toUpperCase()) || !this.fileFilterPattern.matcher(classFile.substring(index = classFile.lastIndexOf(47) + 1)).matches()) continue;
                    filename = this.detach ? classFile.substring(index) : classFile;
                    file = new File((this.targetPath != null ? this.targetPath : "") + filename);
                    if (file.canRead()) {
                        long hdDate = file.lastModified();
                        long archiveDate = entry.getTime();
                        if (!this.oldOverwrites && archiveDate > hdDate || this.oldOverwrites && archiveDate < hdDate) {
                            this.unpackJarEntry(jar, entry, this.targetPath);
                            if (iSecName.contains(filename)) {
                                index = iSecName.indexOf(filename);
                                iSecName.remove(index);
                                iSecOrigin.remove(index);
                                iSecDate.remove(index);
                                iSecName.add(index, filename);
                                iSecOrigin.add(index, element);
                                iSecDate.add(index, jarDate);
                            } else {
                                iSecName.add(filename);
                                iSecOrigin.add(element);
                                iSecDate.add(jarDate);
                            }
                            this.logln("  extract and overwrite " + filename);
                            ++extracted;
                            continue;
                        }
                        this.logln("  do not overwrite      " + filename);
                        ++processed;
                        continue;
                    }
                    this.unpackJarEntry(jar, entry, this.targetPath);
                    this.logln("  extract and write     " + filename);
                    iSecName.add(filename);
                    iSecOrigin.add(element);
                    iSecDate.add(jarDate);
                    ++extracted;
                }
            }
            this.createManifestFile(iSecName, iSecOrigin, iSecDate, this.targetPath);
            this.logln("\n " + list.length + " archive" + (list.length != 1 ? "s" : "") + " passed");
            this.logln(" " + (processed += extracted) + " file" + (processed != 1 ? "s" : "") + " passed");
            this.logln(" " + extracted + " file" + (extracted != 1 ? "s" : "") + " extracted");
        }
        catch (Exception e) {
            this.loglnError("unzip error: " + e.getMessage() + ": " + classFile);
        }
    }

    private void createJarArchive(File jarFile, File[] tobeJared, String manifestFile) throws IOException, Exception {
        if (jarFile == null) {
            throw new Exception("jarFile is null");
        }
        if (tobeJared == null) {
            throw new Exception("array of files is null");
        }
        if (tobeJared.length == 0) {
            throw new Exception("no files to archive");
        }
        int bufferSize = 10240;
        try {
            byte[] buffer = new byte[bufferSize];
            FileOutputStream stream = new FileOutputStream(jarFile);
            Manifest manifest = this.readManifestFile(manifestFile);
            if (manifest != null) {
                File file = new File(manifestFile);
                this.logln("\n adding existing manifest file " + file.getCanonicalPath());
            } else {
                this.logln("\n create new manifest");
                StringBuilder sb = new StringBuilder();
                sb.append("Manifest-Version: 1.0\n");
                sb.append("Created-By: ").append(System.getProperty("java.vm.version")).append(" (").append(System.getProperty("java.vm.vendor")).append(")\n");
                sb.append("\n");
                ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
                manifest = new Manifest(is);
            }
            JarOutputStream out = new JarOutputStream((OutputStream)stream, manifest);
            if (this.compression != -1) {
                out.setLevel(this.compression);
            }
            for (int i = 0; i < tobeJared.length; ++i) {
                int nRead;
                if (tobeJared[i] == null || !tobeJared[i].exists() || tobeJared[i].isDirectory()) continue;
                String path = tobeJared[i].getPath().substring(this.source.length());
                path = path.replaceAll("\\\\", "/");
                this.log("\n adding " + path);
                JarEntry jarAdd = new JarEntry(path);
                jarAdd.setTime(tobeJared[i].lastModified());
                out.putNextEntry(jarAdd);
                FileInputStream in = new FileInputStream(tobeJared[i]);
                while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                    out.write(buffer, 0, nRead);
                }
                in.close();
            }
            out.close();
            stream.close();
            this.logln("\n " + tobeJared.length + " file" + (tobeJared.length != 1 ? "s" : "") + " added");
        }
        catch (IOException iox) {
            throw new IOException(iox.getMessage() + ": " + this.identity + ".createJarArchive: " + jarFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + ": " + this.identity + ".createJarArchive: " + jarFile.getAbsolutePath());
        }
    }

    private void addFilesToExistingJar(File jarFile, File[] tobeJared, String manifestFile) throws IOException, Exception {
        JarEntry entry;
        if (jarFile == null) {
            throw new Exception("jarFile is null");
        }
        if (tobeJared == null) {
            throw new Exception("array of files is null");
        }
        if (tobeJared.length == 0) {
            throw new Exception("no files to archive");
        }
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> jarEnum = jar.entries();
        Hashtable<String, String> jarContent = new Hashtable<String, String>();
        while (jarEnum.hasMoreElements()) {
            String elem = jarEnum.nextElement().getName();
            jarContent.put(elem, "notnull");
        }
        jar.close();
        Manifest manifest = this.readManifestFile(manifestFile);
        if (manifest != null) {
            File file = new File(manifestFile);
            this.logln("\n adding existing manifest file " + file.getCanonicalPath());
        } else {
            this.logln("\n create new manifest");
            StringBuilder sb = new StringBuilder();
            sb.append("Manifest-Version: 1.0\n");
            sb.append("Created-By: ").append(System.getProperty("java.vm.version")).append(" (").append(System.getProperty("java.vm.vendor")).append(")\n");
            sb.append("\n");
            ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
            manifest = new Manifest(is);
        }
        String rand1 = String.valueOf(Math.random()).substring(2);
        String rand2 = String.valueOf(Math.random()).substring(2);
        String randomName = jarFile.getName() + ".tmp." + rand1 + rand2;
        String tempfile = jarFile.getCanonicalPath();
        tempfile = tempfile.substring(0, tempfile.length() - jarFile.getName().length()) + randomName;
        JarInputStream jarIn = new JarInputStream(new FileInputStream(jarFile.getPath()));
        JarOutputStream jarOut = new JarOutputStream((OutputStream)new FileOutputStream(tempfile), manifest);
        if (this.compression != -1) {
            jarOut.setLevel(this.compression);
        }
        byte[] buffer = new byte[4096];
        Hashtable<String, String> inventory = new Hashtable<String, String>();
        int nrOfWrittenFiles = 0;
        for (int i = 0; i < tobeJared.length; ++i) {
            int nRead;
            if (tobeJared[i] == null || !tobeJared[i].exists() || tobeJared[i].isDirectory()) continue;
            String path = tobeJared[i].getPath().substring(this.source.length());
            if (jarContent.get(path = path.replaceAll("\\\\", "/")) != null) {
                this.log("\n overwriting " + path);
            } else {
                this.log("\n      adding " + path);
            }
            entry = new JarEntry(path);
            entry.setTime(tobeJared[i].lastModified());
            jarOut.putNextEntry(entry);
            FileInputStream in = new FileInputStream(tobeJared[i]);
            while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                jarOut.write(buffer, 0, nRead);
            }
            inventory.put(entry.getName(), "notnull");
            in.close();
            ++nrOfWrittenFiles;
        }
        while ((entry = jarIn.getNextJarEntry()) != null) {
            int read;
            if ("META-INF/MANIFEST.MF".equals(entry.getName()) || inventory.get(entry.getName()) != null) continue;
            jarOut.putNextEntry(entry);
            while ((read = jarIn.read(buffer)) != -1) {
                jarOut.write(buffer, 0, read);
            }
            jarOut.closeEntry();
        }
        jarOut.flush();
        jarOut.close();
        jarIn.close();
        File oldJar = new File(this.targetPath);
        try {
            if (!jarFile.delete()) {
                throw new Exception("cannot delete old " + oldJar.getCanonicalPath());
            }
            File newJar = new File(tempfile);
            if (!newJar.renameTo(oldJar)) {
                throw new Exception("cannot rename tempfile " + tempfile + " to " + oldJar.getCanonicalPath());
            }
        }
        catch (Exception e) {
            throw new Exception("cannot update jar: " + e.getMessage());
        }
        this.logln("\n " + nrOfWrittenFiles + " file" + (tobeJared.length != 1 ? "s" : "") + " added");
    }

    private ArrayList<File> getAllFiles(File file, ArrayList<File> allFiles) {
        if (allFiles == null) {
            allFiles = new ArrayList();
        }
        if (file.isDirectory()) {
            String[] list;
            for (String element : list = file.list()) {
                this.getAllFiles(new File(file.getPath() + "/" + element), allFiles);
            }
        } else {
            allFiles.add(file);
        }
        return allFiles;
    }

    private void executeZip() throws Exception {
        File file = null;
        try {
            file = new File(this.targetPath);
            if (file.isFile()) {
                file.delete();
            }
            file.createNewFile();
        }
        catch (IOException iox) {
            throw new Exception(iox.getMessage() + ": " + file.getCanonicalPath());
        }
        File directory = new File(this.source);
        ArrayList<File> classFiles = new ArrayList<File>();
        classFiles = this.getAllFiles(directory, classFiles);
        File[] classes = this.fileFilter(classFiles.toArray(new File[classFiles.size()]), this.fileFilterPattern);
        if (classes != null && classes.length > 0) {
            if (this.manifestFile != null) {
                this.createJarArchive(file, classes, this.manifestFile);
            } else if (this.standardManifestToCreate) {
                this.createJarArchive(file, classes, null);
            } else {
                this.createJarArchive(file, classes, this.source + "META-INF/MANIFEST.MF");
            }
            this.logln("\n " + file.getCanonicalPath() + " created");
        } else {
            this.logln("\n no files to archive");
        }
    }

    private void executeAdd() throws Exception {
        File file = null;
        file = new File(this.targetPath);
        if (!file.exists()) {
            this.executeZip();
            return;
        }
        if (!file.canWrite()) {
            try {
                throw new Exception("cannot write " + file.getCanonicalPath());
            }
            catch (Exception e) {
                throw new Exception("cannot write " + this.targetPath);
            }
        }
        File directory = new File(this.source);
        ArrayList<File> content = new ArrayList<File>();
        File[] filesToAdd = this.fileFilter((content = this.getAllFiles(directory, content)).toArray(new File[content.size()]), this.fileFilterPattern);
        if (filesToAdd != null && filesToAdd.length > 0) {
            if (this.manifestFile != null) {
                this.addFilesToExistingJar(file, filesToAdd, this.manifestFile);
            } else if (this.standardManifestToCreate) {
                this.addFilesToExistingJar(file, filesToAdd, null);
            } else {
                this.addFilesToExistingJar(file, filesToAdd, this.source + "META-INF/MANIFEST.MF");
            }
            this.logln("\n " + file.getCanonicalPath() + " updated");
        } else {
            this.logln("\n no files to archive");
        }
    }

    private void execute() {
        block29: {
            try {
                File file = new File(this.source);
                if (!file.canRead()) {
                    throw new Exception(this.source + " not found or not readable");
                }
                if ((this.check || this.zip || this.add) && !file.isDirectory()) {
                    throw new Exception(file.getCanonicalPath() + " is no directory");
                }
                if (this.unzip && !file.isDirectory()) {
                    if (!file.isFile()) {
                        throw new Exception(this.source + " is no normal file");
                    }
                    if (this.source.length() < 5) {
                        throw new Exception(file.getCanonicalPath() + " is no valid archiv");
                    }
                    String suffix = this.source.substring(this.source.length() - 4);
                    if (!".jar".equals(suffix) && !".zip".equals(suffix)) {
                        throw new Exception(file.getCanonicalPath() + " is no valid archiv");
                    }
                }
                if (file.isDirectory()) {
                    this.source = this.source.replaceAll("\\\\", "/");
                    if (this.source.charAt(this.source.length() - 1) != '/') {
                        this.source = this.source + "/";
                    }
                }
                if (!this.unzip) break block29;
                if (this.targetPath != null) {
                    try {
                        file = new File(this.targetPath);
                        if (!file.isDirectory()) {
                            throw new Exception(this.targetPath + " is no directory");
                        }
                        if (!file.canWrite()) {
                            throw new Exception(this.targetPath + " is not writable");
                        }
                        this.targetPath = this.targetPath.replaceAll("\\\\", "/");
                        if (this.targetPath.charAt(this.targetPath.length() - 1) != '/') {
                            this.targetPath = this.targetPath + "/";
                        }
                    }
                    catch (IOException iox) {
                        if (file.isFile()) {
                            throw new Exception(file.getCanonicalPath() + ": " + iox.getMessage());
                        }
                        throw new Exception(this.targetPath + ": " + iox.getMessage());
                    }
                }
                if (this.zip || this.add) {
                    if (this.manifestFile != null && !(file = new File(this.manifestFile)).canRead()) {
                        throw new Exception("manifest file " + file.getCanonicalPath() + " not found or not readable");
                    }
                    file = new File(this.targetPath);
                    if (file.isDirectory()) {
                        throw new Exception(file.getCanonicalPath() + " is a directory");
                    }
                }
            }
            catch (Exception e) {
                this.loglnError("\n abort: " + e.getMessage());
                System.exit(-1);
            }
        }
        try {
            if (this.check) {
                this.executeCheck();
            } else if (this.unzip) {
                this.executeUnzip();
            } else if (this.zip) {
                this.executeZip();
            } else if (this.add) {
                this.executeAdd();
            }
        }
        catch (Exception e) {
            this.loglnError("\n error: " + e.getMessage());
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        JarMerge jarmerge = new JarMerge(args);
        jarmerge.execute();
    }
}

