/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.StrSubstitutor;
import sos.util.CaseInsensitivLookupForParameter;

public class ParameterSubstitutor {
    private HashMap<String, String> keylist;
    private StrSubstitutor strSubstitutorEnv;
    private StrSubstitutor strSubstitutor;
    private boolean caseSensitive = false;
    private String openTag = "${";
    private String closeTag = "}";

    public void setOpenTag(String openTag) {
        this.openTag = openTag;
    }

    public void setCloseTag(String closeTag) {
        this.closeTag = closeTag;
    }

    public ParameterSubstitutor() {
    }

    public ParameterSubstitutor(boolean caseSensitive_) {
        this.caseSensitive = caseSensitive_;
    }

    public ParameterSubstitutor(boolean caseSensitive_, String openTag_, String closeTag_) {
        this.openTag = openTag_;
        this.closeTag = closeTag_;
        this.caseSensitive = caseSensitive_;
    }

    public ParameterSubstitutor(String openTag_, String closeTag_) {
        this.openTag = openTag_;
        this.closeTag = closeTag_;
    }

    public void addKey(String k, String v) {
        if (this.keylist == null) {
            this.keylist = new HashMap();
        }
        if (this.caseSensitive) {
            this.keylist.put(k, v);
        } else {
            this.keylist.put(k.toLowerCase(), v);
        }
    }

    public String replaceEnvVars(String source) {
        if (this.strSubstitutorEnv == null) {
            this.strSubstitutorEnv = new StrSubstitutor(System.getenv());
        }
        this.strSubstitutorEnv.setVariablePrefix(this.openTag);
        this.strSubstitutorEnv.setVariableSuffix(this.closeTag);
        return this.strSubstitutorEnv.replace(source);
    }

    public String replaceSystemProperties(String source) {
        return StrSubstitutor.replaceSystemProperties((Object)source);
    }

    public String replace(String source) {
        if (this.strSubstitutor == null) {
            this.strSubstitutor = this.caseSensitive ? new StrSubstitutor(this.keylist) : new StrSubstitutor(new CaseInsensitivLookupForParameter<String>(this.keylist));
        }
        this.strSubstitutor.setVariablePrefix(this.openTag);
        this.strSubstitutor.setVariableSuffix(this.closeTag);
        return this.strSubstitutor.replace(source);
    }

    public void replaceInFile(File in, File out) throws IOException {
        Path inPath = Paths.get(in.getAbsolutePath(), new String[0]);
        Path outPath = Paths.get(out.getAbsolutePath(), new String[0]);
        Charset charset = StandardCharsets.UTF_8;
        String content = new String(Files.readAllBytes(inPath), charset);
        content = this.replace(content);
        Files.write(outPath, content.getBytes(charset), new OpenOption[0]);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public List<String> getParameterNameFromString(String s) {
        ArrayList<String> l = new ArrayList<String>();
        String ot = Pattern.quote(this.openTag);
        String ct = Pattern.quote(this.closeTag);
        String regEx = ot + "([^" + ct + "]+)" + ct;
        Matcher m = Pattern.compile(regEx).matcher(s);
        while (m.find()) {
            l.add(m.group(1));
        }
        return l;
    }
}

