/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSClassUtil;
import sos.util.SOSFilelistFilter;
import sos.util.SOSUnicodeInputStream;

public class SOSFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSFile.class);
    static final int BUFF_SIZE = 100000;
    static final byte[] buffer = new byte[100000];

    public static boolean canReadFile(File file) throws Exception {
        boolean rep = true;
        int repeatCount = 5;
        while (rep && repeatCount != -1) {
            try {
                if (!file.exists()) {
                    rep = false;
                    throw new Exception("..file does not exist: " + file.getAbsolutePath());
                }
                FileOutputStream f = new FileOutputStream(file, true);
                f.close();
                rep = false;
            }
            catch (Exception e) {
                if (--repeatCount == -1) {
                    throw new Exception("..file cannot be accessed: " + file.getAbsolutePath() + ": " + e);
                }
                LOGGER.debug("trial " + (5 - repeatCount) + " of 5 to access order file: " + file.getAbsolutePath());
                Thread.sleep(1000L);
            }
        }
        return !rep;
    }

    public static boolean copyFile(File source, File dest) throws Exception {
        return SOSFile.copyFile(source, dest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean copyFile(File source, File dest, boolean append) throws Exception {
        InputStream in = null;
        OutputStream out = null;
        try {
            block10: {
                LOGGER.debug("Copying file " + source.getAbsolutePath() + " with buffer of " + 100000 + " bytes");
                in = new FileInputStream(source);
                out = new FileOutputStream(dest, append);
                while (true) {
                    byte[] byArray = buffer;
                    // MONITORENTER : buffer
                    int amountRead = in.read(buffer);
                    if (amountRead == -1) {
                        // MONITOREXIT : byArray
                        if (LOGGER != null) {
                            break;
                        }
                        break block10;
                    }
                    out.write(buffer, 0, amountRead);
                    // MONITOREXIT : byArray
                }
                LOGGER.debug("File " + source.getAbsolutePath() + " with buffer of " + 100000 + " bytes");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static boolean copyFile(String source, String dest) throws Exception {
        return SOSFile.copyFile(new File(source), new File(dest), false);
    }

    public static int deleteFile(File file) {
        boolean flgFileDeleted;
        int count = 0;
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                count += SOSFile.deleteFile(file2);
            }
        }
        if (!(flgFileDeleted = file.delete())) {
            throw new RuntimeException(String.format("File '%1$s' not deleted due to an error.", file.getAbsolutePath()));
        }
        return ++count;
    }

    public static Vector<File> getFilelist(String folder, String regexp, int flag) throws Exception {
        File[] files;
        Vector<File> filelist = new Vector<File>();
        if (folder == null || folder.isEmpty()) {
            throw new FileNotFoundException("empty directory not allowed!!");
        }
        File f = new File(folder);
        if (!f.exists()) {
            throw new FileNotFoundException("directory does not exist: " + folder);
        }
        filelist = new Vector();
        for (File file : files = f.listFiles(new SOSFilelistFilter(regexp, flag))) {
            if (file.isDirectory() || !file.isFile()) continue;
            filelist.add(file);
        }
        return filelist;
    }

    public static Vector<File> getFilelist(String folder, String regexp, int flag, boolean withSubFolder) throws Exception {
        Vector<File> filelist = new Vector<File>();
        File file = null;
        File[] subDir = null;
        file = new File(folder);
        subDir = file.listFiles();
        filelist.addAll(SOSFile.getFilelist(folder, regexp, flag));
        if (withSubFolder) {
            for (File element : subDir) {
                if (!element.isDirectory()) continue;
                filelist.addAll(SOSFile.getFilelist(element.getPath(), regexp, flag, true));
            }
        }
        return filelist;
    }

    public static Vector<File> getFolderlist(String folder, String regexp, int flag) throws Exception {
        Vector<File> filelist = new Vector<File>();
        if (folder == null || folder.isEmpty()) {
            throw new FileNotFoundException("empty directory not allowed!!");
        }
        File f = new File(folder);
        if (!f.exists()) {
            throw new FileNotFoundException("directory does not exist: " + folder);
        }
        filelist = new Vector();
        File[] files = f.listFiles(new SOSFilelistFilter(regexp, flag));
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (".".equals(files[i].getName()) || "..".equals(files[i].getName())) continue;
                filelist.add(files[i]);
            }
        }
        return filelist;
    }

    public static Vector<File> getFolderlist(String folder, String regexp, int flag, boolean withSubFolder) throws Exception {
        Vector<File> filelist = new Vector<File>();
        File file = null;
        File[] subDir = null;
        file = new File(folder);
        subDir = file.listFiles();
        filelist.addAll(SOSFile.getFolderlist(folder, regexp, flag));
        if (withSubFolder) {
            for (File element : subDir) {
                if (!element.isDirectory()) continue;
                filelist.addAll(SOSFile.getFolderlist(element.getPath(), regexp, flag, true));
            }
        }
        return filelist;
    }

    public static String readFile(File source) throws Exception {
        int size = (int)source.length();
        byte[] data = null;
        String retsVal = "";
        try (FileInputStream in = null;){
            in = new FileInputStream(source);
            data = new byte[size];
            for (int bytesRead = 0; bytesRead < size; bytesRead += in.read(data, bytesRead, size - bytesRead)) {
            }
            String string = retsVal = retsVal + new String(data);
            return string;
        }
    }

    public static String readFileUnicode(File source) throws Exception {
        FileInputStream in = null;
        try (SOSUnicodeInputStream uniIn = null;){
            int n;
            in = new FileInputStream(source);
            uniIn = new SOSUnicodeInputStream(in, null);
            uniIn.getEncoding();
            StringBuilder out = new StringBuilder();
            byte[] b = new byte[4096];
            while ((n = uniIn.read(b)) != -1) {
                out.append(new String(b, 0, n));
            }
            String string = out.toString();
            return string;
        }
    }

    public static boolean renameTo(File source, File dest) throws Exception {
        boolean retVal = true;
        try {
            LOGGER.debug("..trying to move File " + source.getAbsolutePath() + " to " + dest.getAbsolutePath());
            SOSFile.copyFile(source, dest);
            if (!source.delete()) {
                retVal = false;
            }
            return retVal;
        }
        catch (Exception e) {
            throw new Exception("\n ..error in " + SOSClassUtil.getMethodName() + " " + e.getMessage(), e);
        }
    }

    public static boolean renameTo(String source, String dest) throws Exception {
        return SOSFile.renameTo(new File(source), new File(dest));
    }

    public static String subFileMask(String filespec, String substitute) throws IOException {
        if (filespec == null) {
            throw new IOException("file specification is null.");
        }
        String retVal = new String();
        int ipos1 = filespec.indexOf("[");
        int ipos2 = filespec.lastIndexOf("]");
        if (ipos1 == -1 || ipos2 == -1) {
            return filespec;
        }
        String midStr = new String();
        String startStr = new String();
        String endStr = new String();
        if (ipos1 != 0) {
            startStr = filespec.substring(0, ipos1);
        }
        midStr = substitute.concat(filespec.substring(ipos2 + 1, filespec.length()));
        retVal = startStr.concat(midStr).concat(endStr);
        return retVal;
    }
}

