/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SOSGZip {
    public static void compressFile(File inputFile, File outputFile) throws Exception {
        BufferedInputStream in = null;
        DeflaterOutputStream out = null;
        try {
            int bytesRead;
            in = new BufferedInputStream(new FileInputStream(inputFile));
            out = new GZIPOutputStream(new FileOutputStream(outputFile));
            byte[] buffer = new byte[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                ((GZIPOutputStream)out).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void compressFile(FileInputStream fileInputStream, File outputFile) throws Exception {
        BufferedInputStream in = null;
        DeflaterOutputStream out = null;
        try {
            int bytesRead;
            in = new BufferedInputStream(fileInputStream);
            out = new GZIPOutputStream(new FileOutputStream(outputFile));
            byte[] buffer = new byte[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                ((GZIPOutputStream)out).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void decompress(String inFilename) throws Exception {
        SOSGZip.decompress(inFilename, null);
    }

    public static void decompress(String inFilename, String outFilename) throws Exception {
        int len;
        if (outFilename == null) {
            outFilename = inFilename.substring(0, inFilename.lastIndexOf("."));
        }
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(inFilename));
        FileOutputStream out = new FileOutputStream(outFilename);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public static void main(String[] args) {
        try {
            SOSGZip.compressFile(new File("C:/temp/a.txt"), new File("C:/temp/a.gz"));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

