/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.util.HashMap;
import java.util.Map;

public class SOSTreeElement {
    private SOSTreeElement prev = null;
    private SOSTreeElement next = null;
    private SOSTreeElement list = null;
    private SOSTreeElement parent = null;
    private String name = null;
    private String title = null;
    private String url = null;
    private String prefix = null;
    private String postfix = null;
    private Map<String, String> parameters = null;
    private Object data = null;
    private int id = -1;
    private int size = 0;
    private String path = null;
    private boolean leaf = false;
    private boolean newBool = true;
    private boolean open = false;
    private String cssClass = null;
    private String imgDir = null;
    private String imgOpenNode = null;
    private String imgCloseNode = null;
    private String imgLeaf = null;
    private String separating = ";";
    private String hrefName = null;
    private String hrefAnker = null;
    private String activeStyle = null;

    protected void append(SOSTreeElement element) {
        SOSTreeElement current = this;
        SOSTreeElement parent = current.getParent();
        while (current.getNext() != null) {
            current = current.getNext();
        }
        element.setParent(parent);
        element.setId(parent.getSize());
        element.setPrev(current);
        element.setNext(current.getNext());
        current.setNext(element);
        element.setPath();
        parent.setSize(parent.getSize() + 1);
    }

    protected void insert(SOSTreeElement element) {
        if (this.leaf) {
            throw new IllegalArgumentException("This element is set as leaf");
        }
        element.setParent(this);
        element.setId(this.size);
        SOSTreeElement current = this.getList();
        if (current == null) {
            element.setPrev(null);
            this.setList(element);
        } else {
            while (current.getNext() != null) {
                current = current.getNext();
            }
            element.setPrev(current);
            element.setNext(current.getNext());
            current.setNext(element);
        }
        element.setPath();
        ++this.size;
    }

    public void clear() {
        this.list = null;
        this.newBool = true;
        this.size = 0;
        this.open = false;
    }

    public void setParameter(String name, String val) {
        if (name == null) {
            throw new IllegalArgumentException("setParameter: parameter name is null");
        }
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(name, val);
    }

    public void deleteParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("deleteParameter: parameter name is null");
        }
        this.parameters.remove(name);
        if (this.parameters.isEmpty()) {
            this.clearParameters();
        }
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    protected Map<String, String> getParameters() {
        return this.parameters;
    }

    protected void setPrev(SOSTreeElement prev) {
        this.prev = prev;
    }

    protected void setNext(SOSTreeElement next) {
        this.next = next;
    }

    protected void setParent(SOSTreeElement parent) {
        this.parent = parent;
    }

    protected void setList(SOSTreeElement element) {
        if (this.leaf) {
            throw new IllegalArgumentException("This element is set as leaf");
        }
        this.list = element;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLeaf(boolean leaf) {
        this.clear();
        this.leaf = leaf;
    }

    public void setOpen(boolean open) {
        if (this.leaf) {
            throw new IllegalArgumentException("This element is set as leaf");
        }
        this.open = open;
    }

    protected void setNew(boolean isNew) {
        this.newBool = isNew;
    }

    protected void setId(int id) {
        this.id = id;
    }

    protected void setSize(int size) {
        this.size = size;
    }

    protected void setPath() {
        String path = null;
        for (SOSTreeElement parent = this.getParent(); parent != null; parent = parent.getParent()) {
            path = path != null ? parent.getId() + this.separating + path : String.valueOf(parent.getId());
        }
        path = path == null ? String.valueOf(this.id) : path + this.separating + this.id;
        this.path = path;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public void setImgDir(String imgDir) {
        this.imgDir = imgDir;
    }

    public void setImgOpenNode(String img) {
        this.imgOpenNode = img;
    }

    public void setImgCloseNode(String img) {
        this.imgCloseNode = img;
    }

    public void setImgLeaf(String img) {
        this.imgLeaf = img;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public SOSTreeElement getPrev() {
        return this.prev;
    }

    public SOSTreeElement getNext() {
        return this.next;
    }

    public SOSTreeElement getParent() {
        return this.parent;
    }

    public SOSTreeElement getList() {
        if (this.leaf) {
            throw new IllegalArgumentException("This element is set as leaf");
        }
        return this.list;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public boolean isNode() {
        return !this.leaf;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isNew() {
        return this.newBool;
    }

    public int getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public String getPath() {
        if (this.path == null) {
            this.setPath();
        }
        return this.path;
    }

    public String getURL() {
        return this.url;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public String getImgDir() {
        return this.imgDir;
    }

    public String getImgOpenNode() {
        return this.imgOpenNode;
    }

    public String getImgCloseNode() {
        return this.imgCloseNode;
    }

    public String getImgLeaf() {
        return this.imgLeaf;
    }

    public Object getData() {
        return this.data;
    }

    public String getHrefAnker() {
        return this.hrefAnker;
    }

    public void setHrefAnker(String anker) {
        this.hrefAnker = anker;
    }

    public String getHrefName() {
        return this.hrefName;
    }

    public void setHrefName(String name) {
        this.hrefName = name;
    }

    public String getActivStyle() {
        return this.activeStyle;
    }

    public void setActivStyle(String style) {
        this.activeStyle = style;
    }
}

