/*
 * Decompiled with CFR 0.152.
 */
package sos.util.string2bool;

import sos.util.string2bool.SOSAnd;
import sos.util.string2bool.SOSBoolean;
import sos.util.string2bool.SOSBooleanExpression;
import sos.util.string2bool.SOSBooleanUtil;
import sos.util.string2bool.SOSIBoolean;
import sos.util.string2bool.SOSMalformedBooleanException;
import sos.util.string2bool.SOSNot;
import sos.util.string2bool.SOSOrOperation;

final class SOSBoolLeftRight
extends SOSBooleanExpression {
    private String booleanExpression;
    private SOSIBoolean iBoolean;

    SOSBoolLeftRight(String newBooleanExpression) throws SOSMalformedBooleanException {
        this.booleanExpression = newBooleanExpression;
        this.iBoolean = this.toIBoolean(SOSBooleanUtil.validAndformat(newBooleanExpression), newBooleanExpression.length());
    }

    @Override
    public boolean booleanValue() {
        return this.iBoolean.booleanValue();
    }

    private SOSIBoolean toIBoolean(String formatedBooleanExpression, int index) throws SOSMalformedBooleanException {
        int lastChar = this.getLastChar(formatedBooleanExpression);
        if (new Character((char)lastChar).toString().matches("\\s")) {
            lastChar = 32;
        }
        String substring = this.getSubstringWithoutLastChar(formatedBooleanExpression);
        switch (lastChar) {
            case 32: {
                SOSIBoolean boolWhitespace = this.toIBoolean(substring, index - 1);
                return boolWhitespace;
            }
            case 41: {
                String openToEnd = this.getFromOpenParenthesisToEnd(substring, index - 1);
                String beginToOpen = this.getFromBeginToOpenParenthesis(substring, index - 1);
                SOSIBoolean boolOpenToEnd = this.toIBoolean(openToEnd, index - 1);
                SOSIBoolean boolToClose = this.toIBoolean(boolOpenToEnd, beginToOpen, index - 1);
                return boolToClose;
            }
            case 84: {
                SOSIBoolean boolTrue = this.toIBoolean(new SOSBoolean(true), substring, index - 4);
                return boolTrue;
            }
            case 70: {
                SOSIBoolean boolFalse = this.toIBoolean(new SOSBoolean(false), substring, index - 5);
                return boolFalse;
            }
        }
        throw new SOSMalformedBooleanException("Expected [ ' ', ), true, false ]", index, this.booleanExpression);
    }

    private SOSIBoolean toIBoolean(SOSIBoolean lastIBoolean, String formatedBooleanExpression, int index) throws SOSMalformedBooleanException {
        int lastChar = this.getLastChar(formatedBooleanExpression);
        if (new Character((char)lastChar).toString().matches("\\s")) {
            lastChar = 32;
        }
        String substring = this.getSubstringWithoutLastChar(formatedBooleanExpression);
        switch (lastChar) {
            case 32: {
                SOSIBoolean boolWhitespace = this.toIBoolean(lastIBoolean, substring, index - 1);
                return boolWhitespace;
            }
            case 46: {
                return lastIBoolean;
            }
            case 40: {
                SOSIBoolean boolToOpen = this.toIBoolean(lastIBoolean, substring, index - 1);
                return boolToOpen;
            }
            case 124: {
                SOSIBoolean boolFirstOr = this.toIBoolean(substring, index - 2);
                SOSOrOperation boolOr = new SOSOrOperation(boolFirstOr, lastIBoolean);
                return boolOr;
            }
            case 38: {
                SOSIBoolean boolFirstAnd = this.toIBoolean(substring, index - 2);
                SOSAnd boolAnd = new SOSAnd(boolFirstAnd, lastIBoolean);
                return boolAnd;
            }
            case 33: {
                SOSNot boolNot = new SOSNot(lastIBoolean);
                SOSIBoolean boolAll = this.toIBoolean(boolNot, substring, index - 1);
                return boolAll;
            }
        }
        throw new SOSMalformedBooleanException("Expected [ ' ', ), ||, &&, ! ]", index, this.booleanExpression);
    }

    private char getLastChar(String formatedBooleanExpression) {
        if (formatedBooleanExpression.length() == 0) {
            return '.';
        }
        return formatedBooleanExpression.charAt(formatedBooleanExpression.length() - 1);
    }

    private String getSubstringWithoutLastChar(String formatedBooleanExpression) {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        return formatedBooleanExpression.substring(0, formatedBooleanExpression.length() - 1);
    }

    private String getFromBeginToOpenParenthesis(String formatedBooleanExpression, int index) throws SOSMalformedBooleanException {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        int fromIndex = 0;
        int toIndex = this.getIndexOfOpenParenthesis(formatedBooleanExpression, index);
        return formatedBooleanExpression.substring(fromIndex, toIndex);
    }

    private String getFromOpenParenthesisToEnd(String formatedBooleanExpression, int index) throws SOSMalformedBooleanException {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        int fromIndex = this.getIndexOfOpenParenthesis(formatedBooleanExpression, index) + 1;
        int toIndex = formatedBooleanExpression.length();
        return formatedBooleanExpression.substring(fromIndex, toIndex);
    }

    private int getIndexOfOpenParenthesis(String formatedBooleanExpression, int index) throws SOSMalformedBooleanException {
        int lastIndexOfOpenParenthesis = this.getLastIndexOf(formatedBooleanExpression, "(", formatedBooleanExpression.length());
        int lastIndexOfCloseParenthesis = this.getLastIndexOf(formatedBooleanExpression, ")", formatedBooleanExpression.length());
        while (lastIndexOfCloseParenthesis != -1 && lastIndexOfOpenParenthesis < lastIndexOfCloseParenthesis) {
            lastIndexOfOpenParenthesis = this.getLastIndexOf(formatedBooleanExpression, "(", lastIndexOfOpenParenthesis);
            lastIndexOfCloseParenthesis = this.getLastIndexOf(formatedBooleanExpression, ")", lastIndexOfCloseParenthesis);
        }
        if (lastIndexOfOpenParenthesis == -1) {
            int parenthesisIndex = index - (formatedBooleanExpression.length() - lastIndexOfCloseParenthesis);
            throw new SOSMalformedBooleanException("Have a close parenthesis without an open parenthesis", parenthesisIndex, this.booleanExpression);
        }
        return lastIndexOfOpenParenthesis;
    }

    private int getLastIndexOf(String formatedBooleanExpression, String searchedString, int toIndex) {
        if (toIndex < 0) {
            return -1;
        }
        if (toIndex >= formatedBooleanExpression.length()) {
            return formatedBooleanExpression.lastIndexOf(searchedString);
        }
        String newFormatedBooleanExpression = formatedBooleanExpression.substring(0, toIndex);
        return newFormatedBooleanExpression.lastIndexOf(searchedString);
    }

    public String toString() {
        return this.iBoolean.toString();
    }
}

