/*
 * Decompiled with CFR 0.152.
 */
package com.sos.keepass.db.kdbx.dom;

import com.sos.keepass.SOSKeePassDatabase;
import com.sos.keepass.db.kdbx.ASOSKdbxHandler;
import com.sos.keepass.exceptions.SOSKeePassDatabaseException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.Database;
import org.linguafranca.pwdb.Entry;
import org.linguafranca.pwdb.kdbx.dom.DomDatabaseWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomEntryWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomGroupWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SOSKdbxDOMHandler
extends ASOSKdbxHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSKdbxDOMHandler.class);
    static final String LAST_MODIFICATION_TIME_ELEMENT_NAME = "Times/LastModificationTime";
    static final String CREATION_TIME_ELEMENT_NAME = "Times/CreationTime";
    static final String LAST_ACCESS_TIME_ELEMENT_NAME = "Times/LastAccessTime";
    static XPath xpath = XPathFactory.newInstance().newXPath();
    static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DomDatabaseWrapper load() throws SOSKeePassDatabaseException {
        try (InputStream is = Files.newInputStream(this.getKeePassFile(), new OpenOption[0]);){
            DomDatabaseWrapper domDatabaseWrapper = DomDatabaseWrapper.load((Credentials)this.getCredentials(), (InputStream)is);
            return domDatabaseWrapper;
        }
        catch (Throwable ex) {
            throw new SOSKeePassDatabaseException(String.format("[%s]%s", SOSKeePassDatabase.getFilePath(this.getKeePassFile()), ex.toString()), ex);
        }
    }

    @Override
    public Entry<?, ?, ?, ?> createEntry(String[] entryPath) throws SOSKeePassDatabaseException {
        String method = "createEntry";
        DomDatabaseWrapper d = (DomDatabaseWrapper)this.getDatabase();
        DomGroupWrapper lastGroup = d.getRootGroup();
        DomEntryWrapper entry = null;
        for (int i = 2; i < entryPath.length; ++i) {
            String name = entryPath[i];
            if (i == entryPath.length - 1) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("[%s][addEntry]%s", method, name));
                }
                entry = this.addEntry(d, lastGroup, name);
                continue;
            }
            List result = lastGroup.findGroups(name);
            if (result == null || result.size() == 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("[%s][addGroup]%s", method, name));
                }
                lastGroup = this.addGroup(d, lastGroup, name);
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[%s][useExistingGroup]%s", method, name));
            }
            lastGroup = (DomGroupWrapper)result.get(0);
        }
        this.setDatabase((Database<?, ?, ?, ?>)d);
        return entry;
    }

    private DomEntryWrapper addEntry(DomDatabaseWrapper d, DomGroupWrapper parentGroup, String entryName) {
        DomEntryWrapper e = (DomEntryWrapper)d.newEntry(entryName);
        e.setIcon(d.newIcon(Integer.valueOf(0)));
        this.setNewItemTimesAsUTC(e);
        DomEntryWrapper entry = parentGroup.addEntry(e);
        this.setModifiedItemTimesAsUTC(parentGroup);
        return entry;
    }

    private DomGroupWrapper addGroup(DomDatabaseWrapper d, DomGroupWrapper parentGroup, String groupName) {
        DomGroupWrapper g = (DomGroupWrapper)d.newGroup(groupName);
        g.setIcon(d.newIcon(Integer.valueOf(48)));
        this.setNewItemTimesAsUTC(g);
        DomGroupWrapper group = parentGroup.addGroup(g);
        this.setModifiedItemTimesAsUTC(parentGroup);
        return group;
    }

    private void setNewItemTimesAsUTC(Object obj) {
        try {
            Field f = FieldUtils.getField(obj.getClass(), (String)"element", (boolean)true);
            f.set(obj, this.setNewItemTimes((Element)f.get(obj)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setModifiedItemTimesAsUTC(Object obj) {
        try {
            Field f = FieldUtils.getField(obj.getClass(), (String)"element", (boolean)true);
            f.set(obj, this.setModifiedItemTimes((Element)f.get(obj)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Element setNewItemTimes(Element e) {
        Date now = this.getNowAsUTC();
        SOSKdbxDOMHandler.setElementDate(e, CREATION_TIME_ELEMENT_NAME, now);
        SOSKdbxDOMHandler.setElementDate(e, LAST_ACCESS_TIME_ELEMENT_NAME, now);
        SOSKdbxDOMHandler.setElementDate(e, LAST_MODIFICATION_TIME_ELEMENT_NAME, now);
        return e;
    }

    private Element setModifiedItemTimes(Element e) {
        Date now = this.getNowAsUTC();
        SOSKdbxDOMHandler.setElementDate(e, LAST_ACCESS_TIME_ELEMENT_NAME, now);
        SOSKdbxDOMHandler.setElementDate(e, LAST_MODIFICATION_TIME_ELEMENT_NAME, now);
        return e;
    }

    static void setElementDate(Element parentElement, String elementPath, Date d) {
        try {
            Element e = (Element)xpath.evaluate(elementPath, parentElement, XPathConstants.NODE);
            if (e != null) {
                e.setTextContent(dateFormatter.format(d));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

