/*
 * Decompiled with CFR 0.152.
 */
package com.sos.hibernate.classes;

import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.exceptions.SOSHibernateSQLCommandExtractorException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class SOSSQLCommandExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSQLCommandExtractor.class);
    private static final String REPLACE_BACKSLASH = "\\\\'";
    private static final String REPLACE_DOUBLE_APOSTROPHE = "''";
    private static final String REPLACEMENT_BACKSLASH = "XxxxX";
    private static final String REPLACEMENT_DOUBLE_APOSTROPHE = "YyyyY";
    private String beginProcedure = "";
    private final Enum<SOSHibernateFactory.Dbms> dbms;
    private int majorVersion = -1;
    private int minorVersion = -1;

    public SOSSQLCommandExtractor(Enum<SOSHibernateFactory.Dbms> dbms) {
        this.dbms = dbms;
    }

    public List<String> extractCommands(String content) throws SOSHibernateSQLCommandExtractorException {
        String method = "extractCommands";
        if (SOSString.isEmpty((String)content)) {
            throw new SOSHibernateSQLCommandExtractorException("content is empty");
        }
        LOGGER.debug(String.format("%s: content=%s", method, content));
        ArrayList<String> commands = new ArrayList<String>();
        Preparer preparer = new Preparer(this.dbms, this.majorVersion, this.minorVersion, content);
        preparer.prepare();
        for (String cmd : preparer.getCommands()) {
            if (cmd == null || cmd.trim().isEmpty()) continue;
            String command = cmd.trim();
            if (this.endsWithEnd(command)) {
                if (this.isProcedureSyntax(command)) {
                    commands.add(command + preparer.getCommandCloser());
                    LOGGER.debug(String.format("%s: command=%s%s", method, command, preparer.getCommandCloser()));
                    continue;
                }
                this.split(commands, this.replace(command), null, preparer.getCommandCloser(), true, 0);
                if ("".equals(this.beginProcedure)) continue;
                int posBeginProcedure = command.indexOf(this.beginProcedure);
                String subCommand = command.substring(posBeginProcedure);
                commands.add(subCommand + preparer.getCommandCloser());
                LOGGER.debug(String.format("%s: command=%s%s", method, subCommand, preparer.getCommandCloser()));
                continue;
            }
            String end = preparer.addCommandCloser() ? preparer.getCommandCloser() : "";
            this.split(commands, this.replace(command), null, end, false, 0);
        }
        return commands;
    }

    private boolean endsWithEnd(String statement) {
        String patterns = "end[\\s]*[\\S]*[;]*$";
        Pattern p = Pattern.compile(patterns, 2);
        Matcher matcher = p.matcher(statement);
        return matcher.find();
    }

    private boolean isProcedureSyntax(String command) throws SOSHibernateSQLCommandExtractorException {
        if (command == null) {
            throw new SOSHibernateSQLCommandExtractorException("command is empty");
        }
        if ((command = command.toLowerCase().trim()).startsWith("procedure") || command.startsWith("function") || command.startsWith("declare") || command.startsWith("begin")) {
            return true;
        }
        StringBuilder patterns = new StringBuilder();
        patterns.append("^(re)?create+[\\s]*procedure");
        patterns.append("|^create+[\\s]*function");
        patterns.append("|^create+[\\s]*operator");
        patterns.append("|^create+[\\s]*package");
        patterns.append("|^create+[\\s]*trigger");
        patterns.append("|^drop+[\\s]*function");
        patterns.append("|^drop+[\\s]*operator");
        patterns.append("|^drop+[\\s]*package");
        patterns.append("|^drop+[\\s]*procedure");
        patterns.append("|^drop+[\\s]*trigger");
        patterns.append("|^create+[\\s]*or+[\\s]*replace+[\\s]*procedure");
        patterns.append("|^create+[\\s]*or+[\\s]*replace+[\\s]*function");
        patterns.append("|^create+[\\s]*or+[\\s]*replace+[\\s]*package");
        patterns.append("|^create+[\\s]*or+[\\s]*replace+[\\s]*operator");
        patterns.append("|^create+[\\s]*or+[\\s]*replace+[\\s]*trigger");
        Pattern p = Pattern.compile(patterns.toString());
        Matcher matcher = p.matcher(command);
        return matcher.find();
    }

    private StringBuffer replace(String value) {
        String s = value.replaceAll(REPLACE_BACKSLASH, REPLACEMENT_BACKSLASH);
        s = s.replaceAll(REPLACE_DOUBLE_APOSTROPHE, REPLACEMENT_DOUBLE_APOSTROPHE);
        return new StringBuffer(s.trim());
    }

    private void split(List<String> commands, StringBuffer st, Integer position, String procedurEnd, boolean returnProcedureBegin, int count) throws SOSHibernateSQLCommandExtractorException {
        String method = "split";
        this.beginProcedure = "";
        ++count;
        int semicolon = -1;
        int apostropheFirst = -1;
        if (position == null) {
            semicolon = st.indexOf(";");
            apostropheFirst = st.indexOf("'");
        } else {
            semicolon = st.indexOf(";", position);
            apostropheFirst = st.indexOf("'", position);
        }
        if (apostropheFirst > semicolon || apostropheFirst == -1) {
            StringBuffer sub;
            String value = "";
            value = semicolon == -1 ? st.toString().trim() : st.toString().substring(0, semicolon).trim();
            value = value.replaceAll(REPLACEMENT_BACKSLASH, REPLACE_BACKSLASH);
            if (this.isProcedureSyntax(value = value.replaceAll(REPLACEMENT_DOUBLE_APOSTROPHE, REPLACE_DOUBLE_APOSTROPHE))) {
                if (returnProcedureBegin) {
                    this.beginProcedure = value;
                    return;
                }
                if (!"".equals(procedurEnd)) {
                    value = value + procedurEnd;
                }
            }
            if (!"".equals(value)) {
                commands.add(value);
                LOGGER.debug(String.format("%s: command=%s", method, value));
            }
            if (semicolon != -1 && (sub = new StringBuffer(st.substring(semicolon + 1))) != null && sub.length() != 0) {
                this.split(commands, sub, null, procedurEnd, returnProcedureBegin, count);
            }
        } else {
            int apostropheSecond = st.indexOf("'", apostropheFirst + 1);
            if (apostropheSecond != -1) {
                this.split(commands, st, new Integer(apostropheSecond + 1), procedurEnd, returnProcedureBegin, count);
            } else {
                throw new SOSHibernateSQLCommandExtractorException(String.format("closing apostrophe not found = %s = %s ", apostropheFirst, st));
            }
        }
    }

    public class Preparer {
        private boolean addCommandCloser;
        private String commandCloser;
        private String[] commands;
        private String commandSpltter;
        private final String content;
        private final Enum<SOSHibernateFactory.Dbms> dbms;
        private final int majorVersion;
        private final int minorVersion;

        public Preparer(Enum<SOSHibernateFactory.Dbms> dbms, int majorVersion, int minorVersion, String content) {
            this.dbms = dbms;
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.content = content;
        }

        public boolean addCommandCloser() {
            return this.addCommandCloser;
        }

        public String getCommandCloser() {
            return this.commandCloser;
        }

        public String[] getCommands() {
            return this.commands;
        }

        public String getCommandSplitter() {
            return this.commandSpltter;
        }

        public void prepare() throws SOSHibernateSQLCommandExtractorException {
            String content = this.init();
            content = this.stripComments(content);
            this.commands = content.split(this.commandSpltter);
        }

        private String init() throws SOSHibernateSQLCommandExtractorException {
            String method = "init";
            this.commandCloser = "";
            this.addCommandCloser = true;
            StringBuffer sb = new StringBuffer(this.content.replaceAll("\r\n", "\n").replaceAll("\\;[ \\t]", ";"));
            if (this.dbms.equals((Object)SOSHibernateFactory.Dbms.MSSQL)) {
                this.commandSpltter = "(?i)\nGO\\s*\n|\n/\n";
            } else if (this.dbms.equals((Object)SOSHibernateFactory.Dbms.MYSQL)) {
                this.commandSpltter = "\n\\\\g\n";
            } else if (this.dbms.equals((Object)SOSHibernateFactory.Dbms.ORACLE)) {
                this.commandSpltter = "\n/\n";
            } else if (this.dbms.equals((Object)SOSHibernateFactory.Dbms.PGSQL)) {
                this.commandSpltter = "\\$\\${1}[\\s]+(LANGUAGE|language){1}[\\s]+(plpgsql|PLPGSQL){1}[\\s]*;";
                this.commandCloser = "$$ LANGUAGE plpgsql;";
                this.addCommandCloser = false;
            } else if (this.dbms.equals((Object)SOSHibernateFactory.Dbms.DB2)) {
                this.commandSpltter = "\n@\n";
            } else if (this.dbms.equals((Object)SOSHibernateFactory.Dbms.SYBASE)) {
                this.commandSpltter = "\ngo\n";
            } else if (this.dbms.equals((Object)SOSHibernateFactory.Dbms.FBSQL)) {
                StringBuffer patterns = new StringBuffer("set+[\\s]*term[inator]*[\\s]*(.*);");
                Pattern p = Pattern.compile(patterns.toString());
                Matcher matcher = p.matcher(this.content.toString().toLowerCase().trim());
                if (matcher.find()) {
                    this.commandSpltter = "\\" + matcher.group(1);
                    String ct = this.content.replaceAll("(?i)set+[\\s]*term[inator]*[\\s]*.*\\n", "");
                    sb.delete(0, sb.length());
                    sb.append(ct);
                } else {
                    this.commandSpltter = "\n/\n";
                }
            } else {
                throw new SOSHibernateSQLCommandExtractorException(String.format("unsupported dbms=%s", this.dbms));
            }
            LOGGER.debug(String.format("%s: commandCloser=%s, commandSpltter=; or %s", method, this.commandCloser, this.commandSpltter));
            return sb.toString();
        }

        private String stripComments(String content) throws SOSHibernateSQLCommandExtractorException {
            StringBuilder sb = new StringBuilder();
            StringTokenizer st = new StringTokenizer(content, "\n");
            boolean addRow = true;
            boolean isVersionComment = false;
            boolean isMySQL = this.dbms.equals((Object)SOSHibernateFactory.Dbms.MYSQL);
            while (st.hasMoreTokens()) {
                String row = st.nextToken().trim();
                if (row == null || row.isEmpty() || row.startsWith("--") || row.startsWith("//") || row.startsWith("#") || (row = row.replaceAll("^[/][*](?s).*?[*][/][\\s]*;*", "")).isEmpty()) continue;
                if (isMySQL) {
                    String rowUpper = row.toUpperCase();
                    if (rowUpper.startsWith("DELIMITER")) continue;
                    if (rowUpper.startsWith("END$$;")) {
                        row = "END;";
                    }
                }
                if (row.startsWith("/*!")) {
                    block16: {
                        String[] rowArr = row.substring(3).trim().split(" ");
                        if (rowArr[0].length() == 5 || rowArr[0].length() == 6) {
                            String version = rowArr[0].length() == 5 ? "0" + rowArr[0] : rowArr[0];
                            try {
                                int major = Integer.parseInt(version.substring(0, 2));
                                if (this.majorVersion >= major) {
                                    LOGGER.debug(String.format("use sql comment : db major version=%s >= comment major version=%s", this.majorVersion, major));
                                    int minor = Integer.parseInt(version.substring(2, 4));
                                    if (this.minorVersion >= minor) {
                                        isVersionComment = true;
                                        LOGGER.debug(String.format("use sql comment : db minor version=%s >= comment minor version=%s", this.minorVersion, minor));
                                    } else {
                                        LOGGER.debug(String.format("skip sql comment : db minor version=%s < comment minor version=%s", this.minorVersion, minor));
                                    }
                                    break block16;
                                }
                                LOGGER.debug(String.format("skip sql comment : db major version=%s < comment major version=%s", this.majorVersion, major));
                            }
                            catch (Exception e) {
                                LOGGER.warn(String.format("skip sql comment : no numerical major/minor version in comment=%s (database major version=%s, minor version=%s", version, this.majorVersion, this.minorVersion));
                            }
                        } else {
                            LOGGER.warn(String.format("skip sql comment : invalid comment major version length=%s (database major version=%s)", rowArr[0], this.majorVersion));
                        }
                    }
                    if (isVersionComment) continue;
                    addRow = false;
                    continue;
                }
                if (row.startsWith("/*")) {
                    addRow = false;
                    continue;
                }
                if (row.endsWith("*/") || row.endsWith("*/;")) {
                    if (isVersionComment) {
                        if (!addRow) {
                            addRow = true;
                            continue;
                        }
                        isVersionComment = false;
                        continue;
                    }
                    if (!addRow) {
                        addRow = true;
                        continue;
                    }
                }
                if (!addRow) continue;
                sb.append(row + "\n");
            }
            return sb.toString();
        }
    }
}

