/*
 * Decompiled with CFR 0.152.
 */
package com.sos.hibernate.exceptions;

import com.sos.exception.SOSException;
import com.sos.hibernate.classes.SOSHibernate;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import org.hibernate.JDBCException;
import org.hibernate.StaleStateException;
import org.hibernate.hql.internal.ast.QuerySyntaxException;
import org.hibernate.query.Query;

public class SOSHibernateException
extends SOSException {
    private static final long serialVersionUID = 1L;
    private static String STATEMENT_NOT_AVAILABLE = "n/a";
    private String message = null;
    private SQLException sqlException = null;
    private String statement = null;
    private String parameters = null;
    private Object dbItem = null;

    public SOSHibernateException(IllegalArgumentException cause, String stmt) {
        for (Throwable e = cause; e != null; e = e.getCause()) {
            if (!(e instanceof QuerySyntaxException)) continue;
            QuerySyntaxException je = (QuerySyntaxException)e;
            this.initCause((Throwable)je);
            this.message = je.getMessage();
            this.statement = je.getQueryString();
            if (this.message != null && this.statement != null) {
                this.message = this.message.replace("[" + this.statement + "]", "");
            }
            return;
        }
        this.initCause(cause);
        this.message = cause.getMessage();
        this.statement = stmt;
    }

    public SOSHibernateException(IllegalStateException cause) {
        if (cause.getCause() == null) {
            this.initCause(cause);
            this.message = cause.getMessage();
        } else {
            this.initCause(cause.getCause());
            this.message = cause.getCause().getMessage();
        }
    }

    public SOSHibernateException(IllegalStateException cause, Query<?> query) {
        if (cause.getCause() == null) {
            this.initCause(cause);
            this.message = cause.getMessage();
        } else {
            this.initCause(cause.getCause());
            this.message = cause.getCause().getMessage();
        }
        if (query != null) {
            this.statement = query.getQueryString();
            this.parameters = SOSHibernate.getQueryParametersAsString(query);
        }
    }

    public SOSHibernateException(IllegalStateException cause, String stmt) {
        if (cause.getCause() == null) {
            this.initCause(cause);
            this.message = cause.getMessage();
        } else {
            this.initCause(cause.getCause());
            this.message = cause.getCause().getMessage();
        }
        this.statement = stmt;
    }

    public SOSHibernateException(PersistenceException cause) {
        for (Throwable e = cause; e != null; e = e.getCause()) {
            if (e instanceof JDBCException) {
                JDBCException je = (JDBCException)e;
                this.initCause((Throwable)je);
                this.message = je.getMessage();
                this.sqlException = je.getSQLException();
                this.statement = je.getSQL();
                if (this.sqlException != null && this.sqlException.getMessage() != null) {
                    this.message = String.format("%s: %d %s", this.message, this.sqlException.getErrorCode(), this.sqlException.getMessage());
                }
                return;
            }
            if (!(e instanceof StaleStateException)) continue;
            this.initCause(e);
            this.message = e.getMessage();
            return;
        }
        this.initCause(cause);
        this.message = String.format("%s %s", ((Object)((Object)cause)).getClass().getSimpleName(), cause.getMessage());
    }

    public SOSHibernateException(PersistenceException cause, Query<?> query) {
        this(cause);
        this.handleStatement(query);
    }

    public SOSHibernateException(PersistenceException cause, String stmt) {
        this(cause);
        this.handleStatement(stmt);
    }

    public SOSHibernateException(SQLException cause) {
        this.initCause(cause);
        this.sqlException = cause;
        this.message = String.format("%d %s", this.sqlException.getErrorCode(), this.sqlException.getMessage());
    }

    public SOSHibernateException(SQLException cause, Query<?> query) {
        this(cause);
        this.handleStatement(query);
    }

    public SOSHibernateException(SQLException cause, String sql) {
        this.initCause(cause);
        this.sqlException = cause;
        this.statement = sql;
        this.message = String.format("%d %s", this.sqlException.getErrorCode(), this.sqlException.getMessage());
    }

    public SOSHibernateException(String msg) {
        this.message = msg;
    }

    public SOSHibernateException(String msg, Query<?> query) {
        this.message = msg;
        if (query != null) {
            this.statement = query.getQueryString();
            this.parameters = SOSHibernate.getQueryParametersAsString(query);
        }
    }

    public SOSHibernateException(String msg, String stmt) {
        this.message = msg;
        this.statement = stmt;
    }

    public SOSHibernateException(String msg, Throwable cause) {
        this.message = msg;
        this.initCause(cause);
    }

    protected void setDbItem(Object val) {
        this.dbItem = val;
    }

    protected void setMessage(String val) {
        this.message = val;
    }

    protected void setStatement(String val) {
        this.statement = val;
    }

    public Object getDbItem() {
        return this.dbItem;
    }

    public String getMessage() {
        return this.message;
    }

    public SQLException getSQLException() {
        return this.sqlException;
    }

    public String getStatement() {
        return this.statement;
    }

    public String toString() {
        String result = super.toString();
        if (this.statement != null) {
            result = String.format("%s [%s]", result, this.statement);
        }
        if (this.parameters != null) {
            result = String.format("%s[%s]", result, this.parameters);
        }
        if (this.dbItem != null) {
            result = String.format("%s [%s]", result, SOSHibernate.toString(this.dbItem));
        }
        return result;
    }

    private void handleStatement(Query<?> query) {
        if (query != null) {
            this.handleStatement(query.getQueryString());
            this.parameters = SOSHibernate.getQueryParametersAsString(query);
        }
    }

    private void handleStatement(String stmt) {
        if (stmt != null && (this.statement == null || this.statement.equals(STATEMENT_NOT_AVAILABLE))) {
            int index;
            this.statement = stmt;
            if (this.message != null && (index = this.message.indexOf("Query is:")) > 0) {
                this.message = this.message.substring(0, index).trim();
            }
        }
    }
}

