/*
 * Decompiled with CFR 0.152.
 */
package com.sos.inventory.model.job;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JobReturnCodeHelper {
    @JsonIgnore
    private Map<TYPE, SortedSet<Integer>> singles = new HashMap<TYPE, SortedSet<Integer>>();
    @JsonIgnore
    private Map<TYPE, List<SortedSet<Integer>>> intervals = new HashMap<TYPE, List<SortedSet<Integer>>>();
    @JsonIgnore
    private static final Predicate<String> pred = Pattern.compile("^-?[0-9]+(\\.\\.-?[0-9]+)?(, *-?[0-9]+(\\.\\.-?[0-9]+)?)*$").asPredicate();

    @JsonIgnore
    protected String getCodes(Object codes, TYPE t) {
        if (codes == null || codes instanceof String) {
            return this.parseCodes((String)codes, t);
        }
        if (codes instanceof List) {
            this.singles.put(t, ((List)codes).stream().filter(Objects::nonNull).filter(i -> i instanceof Integer).map(i -> (Integer)i).collect(Collectors.toCollection(TreeSet::new)));
            return this.singles.get((Object)t).stream().map(Objects::toString).collect(Collectors.joining(","));
        }
        return null;
    }

    @JsonIgnore
    protected String getCodes(List<Integer> codes, TYPE t) {
        if (codes == null) {
            return null;
        }
        this.singles.put(t, new TreeSet<Integer>(codes));
        return codes.stream().filter(Objects::nonNull).map(Objects::toString).collect(Collectors.joining(","));
    }

    @JsonIgnore
    protected String getCodes(String codes, TYPE t) {
        return this.parseCodes(codes, t);
    }

    private String parseCodes(String codes, TYPE t) {
        if (codes != null && !codes.isEmpty() && pred.test(codes)) {
            SortedSet single = this.singles.getOrDefault((Object)t, new TreeSet());
            List ival = this.intervals.getOrDefault((Object)t, new ArrayList());
            codes = codes.replaceAll("\\s", "");
            Arrays.asList(codes.split(",")).stream().forEach(s -> {
                if (s.contains("..")) {
                    SortedSet sSet = Arrays.asList(s.split("\\.\\.")).stream().map(i -> Integer.valueOf(i)).collect(Collectors.toCollection(TreeSet::new));
                    if (sSet.size() == 1) {
                        single.add((Integer)sSet.iterator().next());
                    } else if (sSet.size() == 2) {
                        ival.add(sSet);
                    }
                } else {
                    single.add(Integer.valueOf(s));
                }
            });
            this.intervals.put(t, this.createUnionsOfIntervals(ival));
            single.removeIf(s -> this.isInIntervals((Integer)s, this.intervals.get((Object)t)));
            this.singles.put(t, single);
        }
        return codes;
    }

    @JsonIgnore
    protected boolean isInReturnCodes(Integer i, TYPE t) {
        if (i == null) {
            return false;
        }
        return this.singles.getOrDefault((Object)t, Collections.emptySortedSet()).contains(i) || this.isInIntervals(i, this.intervals.getOrDefault((Object)t, Collections.emptyList()));
    }

    private boolean isInReturnCodes(Integer i, SortedSet<Integer> single, List<SortedSet<Integer>> interval) {
        return single.contains(i) || this.isInIntervals(i, interval);
    }

    @JsonIgnore
    protected String normalized(TYPE t) {
        SortedSet single = this.singles.getOrDefault((Object)t, Collections.emptySortedSet());
        List interval = this.intervals.getOrDefault((Object)t, Collections.emptyList());
        if (single.isEmpty() && interval.isEmpty()) {
            return null;
        }
        return Stream.concat(single.stream().map(i -> this.constructSortedSet((Integer)i)), interval.stream()).sorted(Comparator.comparingInt(SortedSet::first)).map(i -> {
            if (i.size() == 1) {
                return ((Integer)i.first()).toString();
            }
            if (i.size() == 2) {
                return i.first() + ".." + i.last();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.joining(","));
    }

    @JsonIgnore
    protected List<SortedSet<Integer>> normalizedAsList(TYPE t) {
        SortedSet single = this.singles.getOrDefault((Object)t, Collections.emptySortedSet());
        List interval = this.intervals.getOrDefault((Object)t, Collections.emptyList());
        if (single.isEmpty() && interval.isEmpty()) {
            return Collections.emptyList();
        }
        return Stream.concat(single.stream().map(i -> this.constructSortedSet((Integer)i)), interval.stream()).filter(i -> !i.isEmpty()).sorted(Comparator.comparingInt(SortedSet::first)).collect(Collectors.toList());
    }

    private boolean isInIntervals(Integer i, List<SortedSet<Integer>> ival) {
        for (SortedSet<Integer> interval : ival) {
            if (interval.first() > i || i > interval.last()) continue;
            return true;
        }
        return false;
    }

    private List<SortedSet<Integer>> createUnionsOfIntervals(List<SortedSet<Integer>> ival) {
        Collections.sort(ival, Comparator.comparingInt(SortedSet::first));
        ArrayList<SortedSet<Integer>> union = new ArrayList<SortedSet<Integer>>();
        int left = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        if (!ival.isEmpty()) {
            for (SortedSet<Integer> interval : ival) {
                int currentRight = interval.last();
                int currentLeft = interval.first();
                if (currentLeft <= right && currentRight > right) {
                    right = currentRight;
                }
                if (currentLeft < left && currentRight >= right) {
                    left = currentLeft;
                    right = currentRight;
                }
                if (currentLeft <= right) continue;
                union.add(this.constructSortedSet(left, right));
                left = currentLeft;
                right = currentRight;
            }
            union.add(this.constructSortedSet(left, right));
        }
        return union;
    }

    private boolean isOverlapping(Integer ivalFirst, Integer ivalLast, SortedSet<Integer> otherIval) {
        return ivalLast >= otherIval.first() && ivalFirst <= otherIval.last();
    }

    protected String deleteIntersectionByOtherIntervals(TYPE t, Object other, TYPE tOther) {
        this.getCodes(other, tOther);
        SortedSet otherSingle = this.singles.getOrDefault((Object)tOther, Collections.emptySortedSet());
        List<SortedSet<Integer>> otherIvals = this.intervals.getOrDefault((Object)tOther, Collections.emptyList());
        SortedSet<Integer> single = this.singles.getOrDefault((Object)t, Collections.emptySortedSet());
        single.removeIf(s -> this.isInReturnCodes((Integer)s, otherSingle, otherIvals));
        List ivals = this.intervals.getOrDefault((Object)t, Collections.emptyList());
        otherSingle.forEach(s -> otherIvals.add(this.constructSortedSet((Integer)s)));
        ArrayList<SortedSet<Integer>> intersections = new ArrayList<SortedSet<Integer>>();
        for (SortedSet sortedSet : ivals) {
            intersections.addAll(this.deleteIntersectionByOtherIntervals(sortedSet, otherIvals));
        }
        ivals.clear();
        for (SortedSet sortedSet : intersections) {
            if (sortedSet.size() == 1) {
                single.add((Integer)sortedSet.iterator().next());
                continue;
            }
            if (sortedSet.size() != 2) continue;
            ivals.add(sortedSet);
        }
        this.singles.put(t, single);
        this.intervals.put(t, ivals);
        return this.normalized(t);
    }

    private List<SortedSet<Integer>> deleteIntersectionByOtherIntervals(SortedSet<Integer> ival, List<SortedSet<Integer>> otherIvals) {
        if (otherIvals == null || otherIvals.isEmpty()) {
            return Collections.singletonList(ival);
        }
        ArrayList<SortedSet<Integer>> intersections = new ArrayList<SortedSet<Integer>>();
        List oIvals = otherIvals.stream().sorted(Comparator.comparingInt(SortedSet::first)).collect(Collectors.toList());
        Integer curFirst = ival.first();
        Integer curLast = ival.last();
        boolean recursive = false;
        for (SortedSet otherIval : oIvals) {
            if (!this.isOverlapping(curFirst, curLast, otherIval)) continue;
            if (curLast >= (Integer)otherIval.first() && curLast <= (Integer)otherIval.last() && (curLast = Integer.valueOf((Integer)otherIval.first() - 1)) < curFirst) break;
            if (curFirst < (Integer)otherIval.first() || curFirst > (Integer)otherIval.last()) continue;
            curFirst = (Integer)otherIval.last() + 1;
            if (curLast >= curFirst) continue;
            break;
        }
        for (SortedSet otherIval : oIvals) {
            if (!this.isOverlapping(curFirst, curLast, otherIval) || curFirst > (Integer)otherIval.first() || curLast < (Integer)otherIval.last()) continue;
            intersections.addAll(this.deleteIntersectionByOtherIntervals(this.constructSortedSet(curFirst, (Integer)otherIval.first() - 1), otherIvals));
            intersections.addAll(this.deleteIntersectionByOtherIntervals(this.constructSortedSet((Integer)otherIval.last() + 1, curLast), otherIvals));
            recursive = true;
            break;
        }
        if (!recursive) {
            intersections.add(this.constructSortedSet(curFirst, curLast));
        }
        return intersections;
    }

    private SortedSet<Integer> constructSortedSet(Integer ... integers) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (Integer integer : integers) {
            ts.add(integer);
        }
        return ts;
    }

    public static enum TYPE {
        SUCCESS,
        WARNING,
        FAILURE;

    }
}

