/*
 * Decompiled with CFR 0.152.
 */
package com.sos.inventory.model.report;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sos.inventory.model.common.IInventoryObject;
import com.sos.inventory.model.report.Frequency;
import com.sos.inventory.model.report.ReportOrder;
import com.sos.inventory.model.report.ReportPeriod;
import com.sos.inventory.model.report.TemplateId;
import com.sos.joc.model.common.IConfigurationObject;
import com.sos.joc.model.common.IReleaseObject;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"version", "title", "templateName", "frequencies", "hits", "controllerId", "monthFrom", "monthTo", "period", "sort"})
public class Report
implements IInventoryObject,
IConfigurationObject,
IReleaseObject {
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="inventory repository version")
    private String version = "1.7.1";
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="templateName")
    @JsonAlias(value={"templateId"})
    private TemplateId templateName;
    @JsonProperty(value="frequencies")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<Frequency> frequencies = null;
    @JsonProperty(value="hits")
    private Integer hits;
    @JsonProperty(value="controllerId")
    private String controllerId;
    @JsonProperty(value="monthFrom")
    private String monthFrom;
    @JsonProperty(value="monthTo")
    private String monthTo;
    @JsonProperty(value="period")
    private ReportPeriod period;
    @JsonProperty(value="sort")
    private ReportOrder sort = ReportOrder.fromValue("HIGHEST");

    public Report() {
    }

    public Report(String version, String title, TemplateId templateName, Set<Frequency> frequencies, Integer hits, String controllerId, String monthFrom, String monthTo, ReportPeriod period, ReportOrder sort) {
        this.version = version;
        this.title = title;
        this.templateName = templateName;
        this.frequencies = frequencies;
        this.hits = hits;
        this.controllerId = controllerId;
        this.monthFrom = monthFrom;
        this.monthTo = monthTo;
        this.period = period;
        this.sort = sort;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="templateName")
    public TemplateId getTemplateName() {
        return this.templateName;
    }

    @JsonProperty(value="templateName")
    public void setTemplateName(TemplateId templateName) {
        this.templateName = templateName;
    }

    @JsonProperty(value="templateId")
    public void setTemplateName(Integer templateId) {
        this.templateName = TemplateId.fromValue(templateId);
    }

    @JsonProperty(value="frequencies")
    public Set<Frequency> getFrequencies() {
        return this.frequencies;
    }

    @JsonProperty(value="frequencies")
    public void setFrequencies(Set<Frequency> frequencies) {
        this.frequencies = frequencies;
    }

    @JsonProperty(value="hits")
    public Integer getHits() {
        return this.hits;
    }

    @JsonProperty(value="hits")
    public void setHits(Integer hits) {
        this.hits = hits;
    }

    @JsonProperty(value="controllerId")
    public String getControllerId() {
        return this.controllerId;
    }

    @JsonProperty(value="controllerId")
    public void setControllerId(String controllerId) {
        this.controllerId = controllerId;
    }

    @JsonProperty(value="monthFrom")
    public String getMonthFrom() {
        return this.monthFrom;
    }

    @JsonProperty(value="monthFrom")
    public void setMonthFrom(String monthFrom) {
        this.monthFrom = monthFrom;
    }

    @JsonProperty(value="monthTo")
    public String getMonthTo() {
        return this.monthTo;
    }

    @JsonProperty(value="monthTo")
    public void setMonthTo(String monthTo) {
        this.monthTo = monthTo;
    }

    @JsonProperty(value="period")
    public ReportPeriod getPeriod() {
        return this.period;
    }

    @JsonProperty(value="period")
    public void setPeriod(ReportPeriod period) {
        this.period = period;
    }

    @JsonProperty(value="sort")
    public ReportOrder getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    public void setSort(ReportOrder sort) {
        this.sort = sort;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("version", (Object)this.version).append("title", (Object)this.title).append("templateName", (Object)this.templateName).append("frequencies", this.frequencies).append("hits", (Object)this.hits).append("controllerId", (Object)this.controllerId).append("monthFrom", (Object)this.monthFrom).append("monthTo", (Object)this.monthTo).append("period", (Object)this.period).append("sort", (Object)this.sort).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.hits).append((Object)this.period).append((Object)this.controllerId).append((Object)this.templateName).append((Object)this.monthFrom).append((Object)this.sort).append((Object)this.title).append((Object)this.version).append(this.frequencies).append((Object)this.monthTo).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Report)) {
            return false;
        }
        Report rhs = (Report)other;
        return new EqualsBuilder().append((Object)this.hits, (Object)rhs.hits).append((Object)this.period, (Object)rhs.period).append((Object)this.controllerId, (Object)rhs.controllerId).append((Object)this.templateName, (Object)rhs.templateName).append((Object)this.monthFrom, (Object)rhs.monthFrom).append((Object)this.sort, (Object)rhs.sort).append((Object)this.title, (Object)rhs.title).append((Object)this.version, (Object)rhs.version).append(this.frequencies, rhs.frequencies).append((Object)this.monthTo, (Object)rhs.monthTo).isEquals();
    }
}

