/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.cluster.common.state;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum JocClusterState {
    STARTED("STARTED"),
    RUNNING("RUNNING"),
    STOPPED("STOPPED"),
    RESTARTED("RESTARTED"),
    ALREADY_STARTED("ALREADY_STARTED"),
    ALREADY_RUNNING("ALREADY_RUNNING"),
    ALREADY_STOPPED("ALREADY_STOPPED"),
    SWITCH_MEMBER("SWITCH_MEMBER"),
    MISSING_CONFIGURATION("MISSING_CONFIGURATION"),
    MISSING_HANDLERS("MISSING_HANDLERS"),
    MISSING_LICENSE("MISSING_LICENSE"),
    ERROR("ERROR"),
    COMPLETED("COMPLETED"),
    UNCOMPLETED("UNCOMPLETED");

    private final String value;
    private static final Map<String, JocClusterState> CONSTANTS;

    private JocClusterState(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static JocClusterState fromValue(String value) {
        JocClusterState constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, JocClusterState>();
        for (JocClusterState c : JocClusterState.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

