/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.docu;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum MimeType {
    HTML("HTML"),
    XML("XML"),
    MD("MD");

    private final String value;
    private static final Map<String, MimeType> CONSTANTS;

    private MimeType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static MimeType fromValue(String value) {
        MimeType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, MimeType>();
        for (MimeType c : MimeType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

