/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.inventory.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ItemStateEnum {
    DEPLOYMENT_IS_NEWER("DEPLOYMENT_IS_NEWER"),
    RELEASE_IS_NEWER("RELEASE_IS_NEWER"),
    DRAFT_IS_NEWER("DRAFT_IS_NEWER"),
    DEPLOYMENT_NOT_EXIST("DEPLOYMENT_NOT_EXIST"),
    RELEASE_NOT_EXIST("RELEASE_NOT_EXIST"),
    DRAFT_NOT_EXIST("DRAFT_NOT_EXIST"),
    NO_CONFIGURATION_EXIST("NO_CONFIGURATION_EXIST");

    private final String value;
    private static final Map<String, ItemStateEnum> CONSTANTS;

    private ItemStateEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ItemStateEnum fromValue(String value) {
        ItemStateEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ItemStateEnum>();
        for (ItemStateEnum c : ItemStateEnum.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

