/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.common;

import com.sos.commons.util.common.SOSTimeout;
import java.nio.charset.Charset;

public class SOSCommandResult {
    private final StringBuilder stdOut;
    private final StringBuilder stdErr;
    private final Charset encoding;
    private final SOSTimeout timeout;
    private Throwable exception;
    private String command;
    private Integer exitCode;
    private boolean timeoutExeeded;

    public SOSCommandResult(String cmd) {
        this(cmd, null, null);
    }

    public SOSCommandResult(String cmd, Charset charset) {
        this(cmd, charset, null);
    }

    public SOSCommandResult(String cmd, SOSTimeout timeout) {
        this(cmd, null, timeout);
    }

    public SOSCommandResult(String cmd, Charset encoding, SOSTimeout timeout) {
        this.command = cmd;
        this.encoding = encoding;
        this.timeout = timeout;
        this.stdOut = new StringBuilder();
        this.stdErr = new StringBuilder();
    }

    public void setCommand(String val) {
        this.command = val;
    }

    public String getCommand() {
        return this.command;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public SOSTimeout getTimeout() {
        return this.timeout;
    }

    public Integer getExitCode() {
        if (this.exitCode == null) {
            return 0;
        }
        return this.exitCode;
    }

    public void setExitCode(Integer val) {
        this.exitCode = val;
    }

    public boolean isTimeoutExeeded() {
        return this.timeoutExeeded;
    }

    public void setTimeoutExeeded(boolean val) {
        this.timeoutExeeded = val;
    }

    public String getStdOut() {
        return this.stdOut.toString();
    }

    public void setStdOut(String val) {
        this.stdOut.append(val);
    }

    public boolean hasStdOut() {
        return this.stdOut.length() > 0;
    }

    public String getStdErr() {
        return this.stdErr.toString();
    }

    public void setStdErr(String val) {
        this.stdErr.append(val);
    }

    public boolean hasStdErr() {
        return this.stdErr.length() > 0;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable val) {
        this.exception = val;
    }

    public boolean hasError() {
        return this.hasError(true);
    }

    public boolean hasError(boolean checkStdError) {
        if (this.exception != null || this.timeoutExeeded) {
            return true;
        }
        if (this.getExitCode() > 0) {
            return true;
        }
        return checkStdError && this.stdErr.length() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[").append(this.command).append("]");
        sb.append("[exitCode=").append(this.exitCode).append("]");
        if (this.encoding != null) {
            sb.append("[encoding=").append(this.encoding).append("]");
        }
        if (this.timeout != null) {
            sb.append("[timeout=").append(this.timeout);
            if (this.timeoutExeeded) {
                sb.append(",timeoutExeeded=true");
            }
            sb.append("]");
        }
        sb.append("[std:out=").append(this.stdOut.toString().trim()).append("]");
        sb.append("[std:err=").append(this.stdErr.toString().trim()).append("]");
        if (this.exception != null) {
            sb.append("[exception=").append(this.exception.toString()).append("]");
        }
        return sb.toString();
    }
}

