/*
 * Decompiled with CFR 0.152.
 */
package js7.base.io.file.watch;

import cats.Functor;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenSpawn;
import cats.effect.kernel.Resource;
import com.typesafe.scalalogging.Logger;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.io.file.watch.BasicDirectoryWatch$;
import js7.base.io.file.watch.DirectoryEvent;
import js7.base.io.file.watch.DirectoryWatchEvent;
import js7.base.io.file.watch.DirectoryWatchEvent$;
import js7.base.io.file.watch.DirectoryWatchEvent$Overflow$;
import js7.base.io.file.watch.WatchOptions;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.thread.IOExecutor$env$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class BasicDirectoryWatch
implements Service,
StoppableByRequest,
Service.StoppableByRequest {
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    public final WatchOptions js7$base$io$file$watch$BasicDirectoryWatch$$options;
    private final WatchService watchService;

    public static <A> IO<A> repeatWhileIOException(WatchOptions watchOptions, IO<A> iO) {
        return BasicDirectoryWatch$.MODULE$.repeatWhileIOException(watchOptions, iO);
    }

    public static Resource<IO, BasicDirectoryWatch> resource(WatchOptions watchOptions) {
        return BasicDirectoryWatch$.MODULE$.resource(watchOptions);
    }

    public static FiniteDuration systemWatchDelay() {
        return BasicDirectoryWatch$.MODULE$.systemWatchDelay();
    }

    public BasicDirectoryWatch(WatchOptions options) {
        this.js7$base$io$file$watch$BasicDirectoryWatch$$options = options;
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        Logger LoggerImpl_this = BasicDirectoryWatch$.js7$base$io$file$watch$BasicDirectoryWatch$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("newWatchService {}", (Object)options.directory());
        }
        this.watchService = options.directory().getFileSystem().newWatchService();
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    @Override
    public IO<Service.Started> start() {
        return this.startService(this.untilStopRequested().$times$greater(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.start$$anonfun$1();
            return BoxedUnit.UNIT;
        })));
    }

    public Resource<IO, Stream<IO, Seq<DirectoryEvent>>> streamResource() {
        return this.directoryWatchResource().map((Function1 & Serializable)x$1 -> {
            WatchKey watchKey = x$1;
            Stream stream = StreamExtensions$.MODULE$.$plus$colon(Stream$.MODULE$.constant((Object)BoxesRunTime.boxToBoolean((boolean)false), Stream$.MODULE$.constant$default$2()), BoxesRunTime.boxToBoolean((boolean)true)).evalMap((Function1 & Serializable)isFirst -> this.$anonfun$1(BoxesRunTime.unboxToBoolean((Object)isFirst)));
            return stream.takeWhile((Function1 & Serializable)events -> !events.contains((Object)DirectoryWatchEvent$Overflow$.MODULE$), stream.takeWhile$default$2()).map((Function1 & Serializable)_$1 -> _$1);
        });
    }

    private Resource<IO, WatchKey> directoryWatchResource() {
        IO iO = this.failWhenStopRequested(BasicDirectoryWatch$.MODULE$.repeatWhileIOException(this.js7$base$io$file$watch$BasicDirectoryWatch$$options, IO$.MODULE$.apply(this::$anonfun$2)));
        return cats.effect.package$.MODULE$.Resource().make(CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)this::directoryWatchResource$$anonfun$1), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO)), (Function1 & Serializable)watchKey -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.directoryWatchResource$$anonfun$2$$anonfun$1((WatchKey)watchKey);
            return BoxedUnit.UNIT;
        }), (Functor)IO$.MODULE$.asyncForIO());
    }

    private IO<Seq<DirectoryWatchEvent>> poll() {
        return this.pollWatchKey().recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                if (throwable instanceof ClosedWatchServiceException) {
                    ClosedWatchServiceException t = (ClosedWatchServiceException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x2, Function1 function1) {
                Throwable throwable = x2;
                if (throwable instanceof ClosedWatchServiceException) {
                    ClosedWatchServiceException t = (ClosedWatchServiceException)throwable;
                    Logger LoggerImpl_this = BasicDirectoryWatch$.js7$base$io$file$watch$BasicDirectoryWatch$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        ClosedWatchServiceException closedWatchServiceException = (ClosedWatchServiceException)ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                        LoggerImpl_this.underlying().debug("{}", (Object)ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(closedWatchServiceException));
                    }
                    return package$.MODULE$.Nil();
                }
                return function1.apply((Object)x2);
            }
        });
    }

    private IO<Seq<DirectoryWatchEvent>> pollWatchKey() {
        return IOExecutor$env$.MODULE$.interruptibleVirtualThread(this::pollWatchKey$$anonfun$1);
    }

    private Seq<DirectoryWatchEvent> retrieveEvents(WatchKey watchKey) {
        Vector vector;
        try {
            vector = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(watchKey.pollEvents()).asScala().view().collect((PartialFunction)new Serializable(this){
                private final /* synthetic */ BasicDirectoryWatch $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(WatchEvent x2) {
                    WatchEvent o;
                    WatchEvent watchEvent = x2;
                    return watchEvent != null && (o = watchEvent).context() instanceof Path && BoxesRunTime.unboxToBoolean((Object)this.$outer.js7$base$io$file$watch$BasicDirectoryWatch$$options.isRelevantFile().apply(o.context()));
                }

                public final Object applyOrElse(WatchEvent x2, Function1 function1) {
                    WatchEvent o;
                    WatchEvent watchEvent = x2;
                    if (watchEvent != null && (o = watchEvent).context() instanceof Path && BoxesRunTime.unboxToBoolean((Object)this.$outer.js7$base$io$file$watch$BasicDirectoryWatch$$options.isRelevantFile().apply(o.context()))) {
                        return o;
                    }
                    return function1.apply((Object)x2);
                }
            })).map((Function1 & Serializable)watchEvent -> DirectoryWatchEvent$.MODULE$.fromJava((WatchEvent<Path>)watchEvent))).toVector();
        }
        finally {
            watchKey.reset();
        }
        return vector;
    }

    public String toString() {
        return "BasicDirectoryWatch(" + this.js7$base$io$file$watch$BasicDirectoryWatch$$options.directory() + ")";
    }

    private final void start$$anonfun$1() {
        Logger LoggerImpl_this = BasicDirectoryWatch$.js7$base$io$file$watch$BasicDirectoryWatch$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("watchService.close() \u2014 {}", (Object)this.js7$base$io$file$watch$BasicDirectoryWatch$$options.directory());
        }
        this.watchService.close();
    }

    private final IO $anonfun$1$$anonfun$1() {
        return IO$.MODULE$.sleep(this.js7$base$io$file$watch$BasicDirectoryWatch$$options.watchDelay());
    }

    private final /* synthetic */ IO $anonfun$1(boolean isFirst) {
        return (IO)MonixLikeExtensions$.MODULE$.raceFold(IO$.MODULE$.unlessA(isFirst, this::$anonfun$1$$anonfun$1).$times$greater(this.poll()), this.untilStopRequested().as((Object)package$.MODULE$.Nil()), (GenSpawn)IO$.MODULE$.asyncForIO());
    }

    private final WatchKey $anonfun$2() {
        block0: {
            Logger LoggerImpl_this = BasicDirectoryWatch$.js7$base$io$file$watch$BasicDirectoryWatch$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("register watchService {}, {} {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.js7$base$io$file$watch$BasicDirectoryWatch$$options.kinds(), Predef$.MODULE$.wrapRefArray((Object[])BasicDirectoryWatch$.js7$base$io$file$watch$BasicDirectoryWatch$$$modifiers).mkString(","), this.js7$base$io$file$watch$BasicDirectoryWatch$$options.directory()}), Object.class));
        }
        return this.js7$base$io$file$watch$BasicDirectoryWatch$$options.directory().register(this.watchService, (WatchEvent.Kind[])this.js7$base$io$file$watch$BasicDirectoryWatch$$options.kinds().toArray(ClassTag$.MODULE$.apply(WatchEvent.Kind.class)), BasicDirectoryWatch$.js7$base$io$file$watch$BasicDirectoryWatch$$$modifiers);
    }

    private final String directoryWatchResource$$anonfun$1() {
        return "Registering " + this.js7$base$io$file$watch$BasicDirectoryWatch$$options.directory() + " in WatchService";
    }

    private final void directoryWatchResource$$anonfun$2$$anonfun$1(WatchKey watchKey$1) {
        block3: {
            Logger LoggerImpl_this = BasicDirectoryWatch$.js7$base$io$file$watch$BasicDirectoryWatch$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("watchKey.cancel() {}", (Object)this.js7$base$io$file$watch$BasicDirectoryWatch$$options.directory());
            }
            try {
                watchKey$1.cancel();
            }
            catch (ClosedWatchServiceException t) {
                Logger LoggerImpl_this2 = BasicDirectoryWatch$.js7$base$io$file$watch$BasicDirectoryWatch$$$logger;
                if (!LoggerImpl_this2.underlying().isDebugEnabled()) break block3;
                ClosedWatchServiceException closedWatchServiceException = (ClosedWatchServiceException)ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                LoggerImpl_this2.underlying().debug("watchKey.cancel() => {}", (Object)ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(closedWatchServiceException));
            }
        }
    }

    private final Seq pollWatchKey$$anonfun$1() {
        Seq<DirectoryWatchEvent> result;
        block1: {
            WatchKey watchKey = this.watchService.poll(this.js7$base$io$file$watch$BasicDirectoryWatch$$options.pollTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (watchKey == null) {
                return package$.MODULE$.Nil();
            }
            WatchKey watchKey2 = watchKey;
            result = this.retrieveEvents(watchKey2);
            Logger LoggerImpl_this = BasicDirectoryWatch$.js7$base$io$file$watch$BasicDirectoryWatch$$$logger;
            if (!LoggerImpl_this.underlying().isTraceEnabled()) break block1;
            LoggerImpl_this.underlying().trace("WatchService.poll() {} => {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.js7$base$io$file$watch$BasicDirectoryWatch$$options.directory(), result.mkString(" ")}), Object.class));
        }
        return result;
    }
}

