/*
 * Decompiled with CFR 0.152.
 */
package js7.base.service;

import cats.FlatMap;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Resource;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import cats.syntax.FlatMapIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.UnsafeMemoizable$;
import js7.base.service.RestartAfterFailureService$;
import js7.base.service.Service;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.Allocated;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.CatsUtils$syntax$RichResource$;
import js7.base.utils.DelayConf;
import js7.base.utils.Delayer$extensions$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichAny$;
import js7.base.utils.ScalaUtils$syntax$RichF_$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import sourcecode.Enclosing$;

public final class RestartAfterFailureService<Svc extends Service>
implements Service {
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private final Option<DelayConf> startDelayConf;
    private final Option<DelayConf> runDelayConf;
    private final Resource<IO, Svc> serviceResource;
    private final Tag<Svc> evidence$1;
    private final String serviceName;
    private final AtomicReference<Option<Allocated<IO, Svc>>> currentAllocatedService;
    private volatile boolean stopping;
    private final Deferred<IO, BoxedUnit> untilStopRequested;
    private final IO stop;

    public static DelayConf defaultRestartConf() {
        return RestartAfterFailureService$.MODULE$.defaultRestartConf();
    }

    public static <Svc extends Service> Option<DelayConf> $lessinit$greater$default$1() {
        return RestartAfterFailureService$.MODULE$.$lessinit$greater$default$1();
    }

    public static <Svc extends Service> Option<DelayConf> $lessinit$greater$default$2() {
        return RestartAfterFailureService$.MODULE$.$lessinit$greater$default$2();
    }

    public RestartAfterFailureService(Option<DelayConf> startDelayConf, Option<DelayConf> runDelayConf, Resource<IO, Svc> serviceResource, Tag<Svc> evidence$1) {
        this.startDelayConf = startDelayConf;
        this.runDelayConf = runDelayConf;
        this.serviceResource = serviceResource;
        this.evidence$1 = evidence$1;
        Service.$init$(this);
        this.serviceName = ((Tag)Predef$.MODULE$.implicitly(evidence$1)).tag().toString();
        Option initial$proxy1 = package.option$.MODULE$.none();
        this.currentAllocatedService = new AtomicReference<Option>(initial$proxy1);
        this.stopping = false;
        this.untilStopRequested = cats.effect.package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        this.stop = (IO)UnsafeMemoizable$.MODULE$.memoize(IO$.MODULE$.defer(this::$init$$$anonfun$1), IO$.MODULE$.asyncForIO());
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public IO<BoxedUnit> stop() {
        return this.stop;
    }

    @Override
    public IO<Service.Started> start() {
        return this.startUnderlyingService().flatMap((Function1 & Serializable)service -> this.startService((IO)this.runUnderlyingService(service)).map((Function1 & Serializable)started -> started));
    }

    private IO<Svc> startUnderlyingService() {
        Resource resource = CatsUtils$syntax$.MODULE$.RichResource(this.serviceResource);
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichAny(CatsUtils$syntax$RichResource$.MODULE$.toAllocated$extension(resource, IO$.MODULE$.asyncForIO(), IO$.MODULE$.asyncForIO(), UnsafeMemoizable$.MODULE$.given_UnsafeMemoizable_F(IO$.MODULE$.asyncForIO()), this.evidence$1));
        return ((IO)ScalaUtils$syntax$RichAny$.MODULE$.pipeMaybe$extension(iO, this::startUnderlyingService$$anonfun$1, (Function2 & Serializable)(_$2, _$3) -> Delayer$extensions$.MODULE$.onFailureRestartWithDelayer(_$2, (DelayConf)_$3, (Function1<Throwable, IO<BoxedUnit>>)(Function1 & Serializable)t -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.startUnderlyingService$$anonfun$2$$anonfun$1$$anonfun$1((Throwable)t);
            return BoxedUnit.UNIT;
        }), (Function1<FiniteDuration, IO<BoxedUnit>>)(Function1 & Serializable)duration -> this.logDelay((FiniteDuration)duration), Enclosing$.MODULE$.apply("js7.base.service.RestartAfterFailureService#startUnderlyingService")))).flatTap((Function1 & Serializable)allocated -> this.setCurrentService((Allocated<IO, Svc>)allocated)).map((Function1 & Serializable)_$4 -> (Service)_$4.allocatedThing());
    }

    private IO<BoxedUnit> setCurrentService(Allocated<IO, Svc> allocated) {
        return IO$.MODULE$.defer(() -> this.setCurrentService$$anonfun$1(allocated));
    }

    private IO<BoxedUnit> runUnderlyingService(Svc service) {
        return (IO)this.runDelayConf.fold(() -> RestartAfterFailureService.runUnderlyingService$$anonfun$1(service), (Function1 & Serializable)delayConf -> delayConf.runIO((Function1 & Serializable)delayer -> {
            Service service = (Service)package.option$.MODULE$.catsSyntaxOptionId((Object)service);
            Option option = (Option)package.flatMap$.MODULE$.catsSyntaxFlatMapIdOps((Object)OptionIdOps$.MODULE$.some$extension((Object)service));
            return (IO)FlatMapIdOps$.MODULE$.tailRecM$extension((Object)option, (Function1 & Serializable)initialService -> {
                IO iO;
                Option option = initialService;
                if (option instanceof Some) {
                    Service initialService2 = (Service)((Some)option).value();
                    iO = IO$.MODULE$.pure((Object)initialService2);
                } else if (None$.MODULE$.equals(option)) {
                    iO = this.startUnderlyingService();
                } else {
                    throw new MatchError((Object)option);
                }
                IO service2 = iO;
                return service2.flatMap((Function1 & Serializable)service -> service.untilStopped().map((Function1 & Serializable)_$6 -> package$.MODULE$.Right().apply(_$6)).handleErrorWith((Function1 & Serializable)throwable -> {
                    Logger LoggerImpl_this = RestartAfterFailureService$.js7$base$service$RestartAfterFailureService$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                        Throwable throwable3 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                        LoggerImpl_this.underlying().debug("\ud83d\udca5 " + this.serviceName + " start failed: " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable2), ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable3));
                    }
                    if (this.stopping) {
                        return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, BoxedUnit.UNIT);
                    }
                    return ((IO)delayer.sleep((Function1 & Serializable)duration -> this.logDelay((FiniteDuration)duration), Enclosing$.MODULE$.apply("js7.base.service.RestartAfterFailureService#runUnderlyingService"))).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        if (this.stopping) {
                            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                        }
                        return package$.MODULE$.Left().apply((Object)None$.MODULE$);
                    });
                }));
            }, (FlatMap)IO$.MODULE$.asyncForIO());
        }));
    }

    private IO<BoxedUnit> logDelay(FiniteDuration duration) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.logDelay$$anonfun$1(duration);
            return BoxedUnit.UNIT;
        });
    }

    public Svc unsafeCurrentService() {
        return (Svc)((Service)((Allocated)this.currentAllocatedService.get().getOrElse(this::unsafeCurrentService$$anonfun$1)).allocatedThing());
    }

    public String toString() {
        return "RestartAfterFailureService(" + this.currentAllocatedService.get().fold(RestartAfterFailureService::toString$$anonfun$1, (Function1 & Serializable)_$7 -> _$7.allocatedThing().toString()) + ")";
    }

    private String myName() {
        return "RestartAfterFailureService[" + this.serviceName + "]";
    }

    private static final IO $init$$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private final IO $init$$$anonfun$1() {
        this.stopping = true;
        return ((IO)this.untilStopRequested.complete((Object)BoxedUnit.UNIT)).$times$greater((IO)this.currentAllocatedService.get().fold(RestartAfterFailureService::$init$$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$1 -> (IO)_$1.release()));
    }

    private final Option startUnderlyingService$$anonfun$1() {
        return this.startDelayConf;
    }

    private final void startUnderlyingService$$anonfun$2$$anonfun$1$$anonfun$1(Throwable t$1) {
        Logger LoggerImpl_this = RestartAfterFailureService$.js7$base$service$RestartAfterFailureService$$$logger;
        if (LoggerImpl_this.underlying().isErrorEnabled()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.serviceName;
            Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t$1);
            objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable);
            LoggerImpl_this.underlying().error("{} start failed: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
        }
        Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t$1);
        ScalaUtils$syntax$RichThrowable$.MODULE$.ifStackTrace$extension(throwable).foreach((Function1)(JProcedure1 & Serializable)st -> {
            Logger LoggerImpl_this = RestartAfterFailureService$.js7$base$service$RestartAfterFailureService$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t$1);
                LoggerImpl_this.underlying().debug(this.serviceName + " start failed: " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable), st);
                return;
            }
        });
    }

    private static final IO setCurrentService$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private final IO setCurrentService$$anonfun$1(Allocated allocated$1) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichF_(allocated$1.release());
        return ((IO)((Option)this.currentAllocatedService.getAndSet((Option<Allocated<IO, Svc>>)Some$.MODULE$.apply((Object)allocated$1))).fold(RestartAfterFailureService::setCurrentService$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$5 -> {
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichF_(_$5.release());
            return (IO)ScalaUtils$syntax$RichF_$.MODULE$.when$extension(iO, this.stopping, (Monoid<Object>)IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()));
        })).$times$greater((IO)ScalaUtils$syntax$RichF_$.MODULE$.when$extension(iO, this.stopping, (Monoid<Object>)IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit())));
    }

    private static final IO runUnderlyingService$$anonfun$1(Service service$1) {
        return service$1.untilStopped();
    }

    private final void logDelay$$anonfun$1(FiniteDuration duration$1) {
        Logger LoggerImpl_this = RestartAfterFailureService$.js7$base$service$RestartAfterFailureService$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("Due to failure, " + this.serviceName + " restarts " + (String)(ScalaTime$RichFiniteDuration$.MODULE$.isZero$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration$1)) ? "now" : "in " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration$1))));
            return;
        }
    }

    private final Allocated unsafeCurrentService$$anonfun$1() {
        throw new IllegalStateException(this.myName() + " not yet started");
    }

    private static final String toString$$anonfun$1() {
        return "not started";
    }
}

