/*
 * Decompiled with CFR 0.152.
 */
package js7.base.stream;

import cats.Apply;
import cats.Invariant$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.syntax.ApplyOps$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import izumi.reflect.Tag;
import java.io.Serializable;
import js7.base.catsutils.CatsDeadline;
import js7.base.catsutils.UnsafeMemoizable$;
import js7.base.monixutils.Latch;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.stream.IncreasingNumberSync;
import js7.base.stream.Numbered;
import js7.base.stream.Numbered$;
import js7.base.stream.StreamNumberedQueue$;
import js7.base.stream.StreamNumberedQueue$State$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.utils.Assertions$;
import js7.base.utils.BinarySearch$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEither$;
import js7.base.utils.UnsafeMutex;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public final class StreamNumberedQueue<V> {
    public final String js7$base$stream$StreamNumberedQueue$$vName;
    private final IncreasingNumberSync sync;
    private final UnsafeMutex<IO> mutex;
    private final Latch stopped;
    private volatile State _state;
    public final StreamNumberedQueue$State$ State$lzy1 = new StreamNumberedQueue$State$(this);

    public StreamNumberedQueue(Tag<V> evidence$1) {
        this.js7$base$stream$StreamNumberedQueue$$vName = ((Tag)Predef$.MODULE$.implicitly(evidence$1)).tag().toString();
        this.sync = new IncreasingNumberSync(0L, (Function1<Object, String>)(Function1 & Serializable)i -> StreamNumberedQueue.$init$$$anonfun$1(BoxesRunTime.unboxToLong((Object)i)));
        this.mutex = new UnsafeMutex(UnsafeMemoizable$.MODULE$.given_UnsafeMemoizable_F(IO$.MODULE$.asyncForIO()), IO$.MODULE$.asyncForIO());
        this.stopped = new Latch();
        this._state = this.State().apply(this.State().$lessinit$greater$default$1(), this.State().$lessinit$greater$default$2(), this.State().$lessinit$greater$default$3(), this.State().$lessinit$greater$default$4());
    }

    public IO<BoxedUnit> enqueue(Iterable<V> commands) {
        return this.mutex.lock(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.enqueue$$anonfun$1(commands);
            return BoxedUnit.UNIT;
        }));
    }

    public IO<BoxedUnit> enqueueNumbered(Iterable<Numbered<V>> commands) {
        return IO$.MODULE$.whenA(commands.nonEmpty(), () -> this.enqueueNumbered$$anonfun$1(commands));
    }

    public Stream<IO, Numbered<V>> stream() {
        return this.stream2(this._state.torn());
    }

    public Stream<IO, Numbered<V>> stream(long after) {
        return Stream$.MODULE$.suspend(() -> this.stream$$anonfun$1(after));
    }

    private Stream<IO, Numbered<V>> stream2(long after2) {
        return Stream$.MODULE$.unfoldChunkEval((Object)BoxesRunTime.boxToLong((long)after2), (Function1 & Serializable)after -> this.stream2$$anonfun$1(BoxesRunTime.unboxToLong((Object)after)));
    }

    public IO<Either<Problem, BoxedUnit>> release(long after) {
        return this.mutex.lock(IO$.MODULE$.apply(() -> this.release$$anonfun$1(after)));
    }

    public IO<Vector<Numbered<V>>> stop() {
        return this.mutex.lock(this.stopped.switch().$times$greater(IO$.MODULE$.apply(this::stop$$anonfun$1)));
    }

    private IO<Vector<Numbered<V>>> dequeueSelected(Function1<V, Object> predicate) {
        return this.mutex.lock(IO$.MODULE$.apply(() -> this.dequeueSelected$$anonfun$1(predicate)));
    }

    public String toString() {
        return "StreamNumberedQueue[" + this.js7$base$stream$StreamNumberedQueue$$vName + "]";
    }

    private final StreamNumberedQueue$State$ State() {
        return this.State$lzy1;
    }

    private static final /* synthetic */ String $init$$$anonfun$1(long i) {
        return "#" + i;
    }

    private final void enqueue$$anonfun$1(Iterable commands$1) {
        State s = this._state;
        ObjectRef queue = ObjectRef.create(s.queue());
        LongRef nextNumber = LongRef.create((long)s.nextNumber());
        LongRef lastNumber = LongRef.create((long)-1L);
        commands$1.foreach((Function1)(JProcedure1 & Serializable)command -> {
            queue$5.elem = (Vector)((Vector)queue$5.elem).$colon$plus(Numbered$.MODULE$.apply(nextNumber$5.elem, command));
            lastNumber$1.elem = nextNumber$5.elem++;
        });
        Vector vector = (Vector)queue.elem;
        long l = nextNumber.elem;
        long l2 = s.copy$default$1();
        boolean bl = s.copy$default$4();
        this._state = s.copy(l2, l, vector, bl);
        if (lastNumber.elem != -1L) {
            this.sync.onAdded(lastNumber.elem);
            return;
        }
    }

    private static final boolean v$proxy1$1(Numbered command$1, LongRef nextNumber$6) {
        return command$1.number() >= nextNumber$6.elem;
    }

    private final void enqueueNumbered$$anonfun$1$$anonfun$1(Iterable commands$3) {
        State s = this._state;
        ObjectRef queue = ObjectRef.create(s.queue());
        LongRef nextNumber = LongRef.create((long)s.nextNumber());
        LongRef lastNumber = LongRef.create((long)-1L);
        commands$3.foreach((Function1)(JProcedure1 & Serializable)command -> {
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)StreamNumberedQueue.v$proxy1$1(command, nextNumber)), "command.number >= nextNumber"), FullName$.MODULE$.apply("js7.base.stream.StreamNumberedQueue.enqueueNumbered"), FileName$.MODULE$.apply("StreamNumberedQueue.scala"), Line$.MODULE$.apply(47));
            queue$6.elem = (Vector)((Vector)queue$6.elem).$colon$plus(command);
            lastNumber$2.elem = command.number();
            nextNumber$7.elem = command.number() + 1L;
        });
        Vector vector = (Vector)queue.elem;
        long l = nextNumber.elem;
        long l2 = s.copy$default$1();
        boolean bl = s.copy$default$4();
        this._state = s.copy(l2, l, vector, bl);
        if (lastNumber.elem != -1L) {
            this.sync.onAdded(lastNumber.elem);
            return;
        }
    }

    private final IO enqueueNumbered$$anonfun$1(Iterable commands$2) {
        return this.mutex.lock(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.enqueueNumbered$$anonfun$1$$anonfun$1(commands$2);
            return BoxedUnit.UNIT;
        }));
    }

    private final Stream stream$$anonfun$1(long after$1) {
        Either either = ScalaUtils$syntax$.MODULE$.RichEither(this._state.checkAfter(after$1));
        BoxedUnit cfr_ignored_0 = (BoxedUnit)ScalaUtils$syntax$RichEither$.MODULE$.orThrow$extension(either);
        return this.stream2(after$1);
    }

    private final Either stream2$$anonfun$1$$anonfun$1(long after$2) {
        return this._state.readQueue(after$2);
    }

    private final /* synthetic */ IO stream2$$anonfun$1(long after) {
        return IO$.MODULE$.race(this.stopped.when(), this.sync.whenAvailable(after, (Option<CatsDeadline>)None$.MODULE$, this.sync.whenAvailable$default$3()).$times$greater(IO$.MODULE$.apply(() -> this.stream2$$anonfun$1$$anonfun$1(after)))).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = ((Left)either).value();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    return IO$.MODULE$.none();
                }
            }
            if (either instanceof Right) {
                Either either2 = (Either)((Right)either).value();
                if (either2 instanceof Left) {
                    Problem problem = (Problem)((Left)either2).value();
                    Problem problem2 = StreamNumberedQueue$.js7$base$stream$StreamNumberedQueue$$$StoppedProblem;
                    Problem problem3 = problem;
                    if (!(problem2 != null ? !((Object)problem2).equals(problem3) : problem3 != null)) {
                        return IO$.MODULE$.none();
                    }
                    Problem problem4 = problem;
                    return IO$.MODULE$.raiseError(problem4.throwable());
                }
                if (either2 instanceof Right) {
                    Vector values = (Vector)((Right)either2).value();
                    if (values.isEmpty()) {
                        Logger LoggerImpl_this = StreamNumberedQueue$.js7$base$stream$StreamNumberedQueue$$$logger;
                        if (LoggerImpl_this.underlying().isWarnEnabled()) {
                            LoggerImpl_this.underlying().warn("Internal: sync.whenAvailable({}) triggered but no command available - delay 1s", (Object)BoxesRunTime.boxToLong((long)after));
                        }
                        Chunk chunk = (Chunk)Predef$.MODULE$.ArrowAssoc((Object)Chunk$.MODULE$.empty());
                        return IO$.MODULE$.some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)chunk, (Object)BoxesRunTime.boxToLong((long)after))).delayBy((Duration)ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(1)));
                    }
                    Chunk chunk = (Chunk)Predef$.MODULE$.ArrowAssoc((Object)Chunk$.MODULE$.from((Iterable)values));
                    return IO$.MODULE$.some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)chunk, (Object)BoxesRunTime.boxToLong((long)((Numbered)values.last()).number())));
                }
            }
            throw new MatchError((Object)either);
        });
    }

    private final Either release$$anonfun$1(long after$4) {
        State s = this._state;
        if (s.stopped()) {
            return Checked$.MODULE$.unit();
        }
        return s.checkAfter(after$4).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Tuple2<Object, Object> tuple2 = s.search(after$4);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int index = tuple2._1$mcI$sp();
            boolean found = tuple2._2$mcZ$sp();
            Tuple2.mcIZ.sp sp2 = new Tuple2.mcIZ.sp(index, found);
            int index2 = sp2._1$mcI$sp();
            boolean found2 = sp2._2$mcZ$sp();
            Vector vector = s.queue().drop(index2 + ScalaUtils$syntax$RichBoolean$.MODULE$.toInt$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(found2)));
            long l = s.copy$default$2();
            boolean bl = s.copy$default$4();
            this._state = s.copy(after$4, l, vector, bl);
        });
    }

    private final Vector stop$$anonfun$1() {
        State s = this._state;
        Vector result = s.queue();
        this._state = s.stop();
        return result;
    }

    private final Vector dequeueSelected$$anonfun$1(Function1 predicate$1) {
        State s = this._state;
        Tuple2 tuple2 = s.queue().partition((Function1 & Serializable)numbered -> BoxesRunTime.unboxToBoolean((Object)predicate$1.apply(numbered.value())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector result = (Vector)tuple2._1();
        Vector remaining = (Vector)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)result, (Object)remaining);
        Vector result2 = (Vector)tuple22._1();
        Vector remaining2 = (Vector)tuple22._2();
        this._state = s.copy(s.copy$default$1(), s.copy$default$2(), remaining2, s.copy$default$4());
        return result2;
    }

    public static final /* synthetic */ long js7$base$stream$StreamNumberedQueue$State$$_$_$$anonfun$2(Numbered _$1) {
        return _$1.number();
    }

    public static final /* synthetic */ boolean js7$base$stream$StreamNumberedQueue$State$$_$requireValidNumber$$anonfun$1$$anonfun$1(long after$7, long _$2) {
        return _$2 < after$7;
    }

    public static final /* synthetic */ long js7$base$stream$StreamNumberedQueue$State$$_$beforeFirstIndex$$anonfun$1(Numbered _$3) {
        return _$3.number() - 1L;
    }

    public static final /* synthetic */ long js7$base$stream$StreamNumberedQueue$State$$_$lastIndex$$anonfun$1(Numbered _$4) {
        return _$4.number();
    }

    public static final /* synthetic */ long js7$base$stream$StreamNumberedQueue$State$$_$search$$anonfun$1(Numbered _$5) {
        return _$5.number();
    }

    public class State
    implements Product,
    Serializable {
        private final long torn;
        private final long nextNumber;
        private final Vector queue;
        private final boolean stopped;
        private final /* synthetic */ StreamNumberedQueue $outer;

        public State(StreamNumberedQueue $outer, long torn, long nextNumber, Vector<Numbered<V>> queue, boolean stopped) {
            this.torn = torn;
            this.nextNumber = nextNumber;
            this.queue = queue;
            this.stopped = stopped;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.torn()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.nextNumber()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queue()));
            n = Statics.mix((int)n, (int)(this.stopped() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            if (((State)object).js7$base$stream$StreamNumberedQueue$State$$$outer() != this.$outer) return false;
            State state = (State)object;
            if (this.torn() != state.torn()) return false;
            if (this.nextNumber() != state.nextNumber()) return false;
            if (this.stopped() != state.stopped()) return false;
            Vector vector = this.queue();
            Vector vector2 = state.queue();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "torn";
                }
                case 1: {
                    return "nextNumber";
                }
                case 2: {
                    return "queue";
                }
                case 3: {
                    return "stopped";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long torn() {
            return this.torn;
        }

        public long nextNumber() {
            return this.nextNumber;
        }

        public Vector<Numbered<V>> queue() {
            return this.queue;
        }

        public boolean stopped() {
            return this.stopped;
        }

        public State stop() {
            Vector vector = package$.MODULE$.Vector().empty();
            long l = this.copy$default$1();
            long l2 = this.copy$default$2();
            return this.copy(l, l2, vector, true);
        }

        public Either<Problem, Vector<Numbered<V>>> readQueue(long after) {
            if (this.stopped()) {
                return package$.MODULE$.Left().apply((Object)StreamNumberedQueue$.js7$base$stream$StreamNumberedQueue$$$StoppedProblem);
            }
            Tuple2<Object, Object> tuple2 = this.search(after);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int index = tuple2._1$mcI$sp();
            boolean found = tuple2._2$mcZ$sp();
            Tuple2.mcIZ.sp sp2 = new Tuple2.mcIZ.sp(index, found);
            int index2 = sp2._1$mcI$sp();
            boolean found2 = sp2._2$mcZ$sp();
            if (!found2 && after != this.torn()) {
                return package$.MODULE$.Left().apply((Object)this.unknownAfterProblem(after));
            }
            return package$.MODULE$.Right().apply((Object)this.queue().drop(index2 + ScalaUtils$syntax$RichBoolean$.MODULE$.toInt$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(found2))));
        }

        public IO<BoxedUnit> requireValidNumber(long after) {
            return IO$.MODULE$.defer(() -> this.requireValidNumber$$anonfun$1(after));
        }

        public Either<Problem, BoxedUnit> checkAfter(long after) {
            Either either = (Either)package.apply$.MODULE$.catsSyntaxApplyOps(this.notStopped());
            return (Either)ApplyOps$.MODULE$.$times$greater$extension((Object)either, ScalaUtils$syntax$RichBoolean$.MODULE$.$bang$bang$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.beforeFirstIndex() <= after && after <= this.lastIndex()), (Function0<Problem>)((Function0 & Serializable)() -> this.checkAfter$$anonfun$1(after))), (Apply)Invariant$.MODULE$.catsMonadErrorForEither());
        }

        public Problem unknownAfterProblem(long after) {
            return Problem$.MODULE$.pure("Unknown number: Numbered[" + this.$outer.js7$base$stream$StreamNumberedQueue$$vName + "]: #" + after + " (must be >=" + this.beforeFirstIndex() + " and <=" + this.lastIndex() + ")");
        }

        private long beforeFirstIndex() {
            return BoxesRunTime.unboxToLong((Object)this.queue().headOption().map(StreamNumberedQueue::js7$base$stream$StreamNumberedQueue$State$$_$beforeFirstIndex$$anonfun$1).getOrElse(this::beforeFirstIndex$$anonfun$2));
        }

        private long lastIndex() {
            return BoxesRunTime.unboxToLong((Object)this.queue().lastOption().map(StreamNumberedQueue::js7$base$stream$StreamNumberedQueue$State$$_$lastIndex$$anonfun$1).getOrElse(this::lastIndex$$anonfun$2));
        }

        public Either<Problem, State> notStopped() {
            if (this.stopped()) {
                return package$.MODULE$.Left().apply((Object)StreamNumberedQueue$.js7$base$stream$StreamNumberedQueue$$$StoppedProblem);
            }
            return package$.MODULE$.Right().apply((Object)this);
        }

        public Tuple2<Object, Object> search(long after) {
            return BinarySearch$.MODULE$.binarySearch(this.queue(), StreamNumberedQueue::js7$base$stream$StreamNumberedQueue$State$$_$search$$anonfun$1, BoxesRunTime.boxToLong((long)after), Ordering.Long$.MODULE$);
        }

        public State copy(long torn, long nextNumber, Vector<Numbered<V>> queue, boolean stopped) {
            return new State(this.$outer, torn, nextNumber, queue, stopped);
        }

        public long copy$default$1() {
            return this.torn();
        }

        public long copy$default$2() {
            return this.nextNumber();
        }

        public Vector<Numbered<V>> copy$default$3() {
            return this.queue();
        }

        public boolean copy$default$4() {
            return this.stopped();
        }

        public long _1() {
            return this.torn();
        }

        public long _2() {
            return this.nextNumber();
        }

        public Vector<Numbered<V>> _3() {
            return this.queue();
        }

        public boolean _4() {
            return this.stopped();
        }

        public final /* synthetic */ StreamNumberedQueue js7$base$stream$StreamNumberedQueue$State$$$outer() {
            return this.$outer;
        }

        private final Throwable requireValidNumber$$anonfun$1$$anonfun$2(long after$8) {
            return this.unknownAfterProblem(after$8).throwable();
        }

        private final IO requireValidNumber$$anonfun$1(long after$6) {
            Option last = this.queue().lastOption().map(StreamNumberedQueue::js7$base$stream$StreamNumberedQueue$State$$_$_$$anonfun$2);
            return IO$.MODULE$.raiseWhen(after$6 < this.torn() || last.exists((Function1)((JFunction1.mcZJ.sp & Serializable)arg_0 -> StreamNumberedQueue.js7$base$stream$StreamNumberedQueue$State$$_$requireValidNumber$$anonfun$1$$anonfun$1(after$6, arg_0))), () -> this.requireValidNumber$$anonfun$1$$anonfun$2(after$6));
        }

        private final Problem checkAfter$$anonfun$1(long after$9) {
            return Problem$.MODULE$.pure("Unknown number: Numbered[" + this.$outer.js7$base$stream$StreamNumberedQueue$$vName + "]: #" + after$9 + " (must be >=" + this.beforeFirstIndex() + " and <=" + this.lastIndex() + ")");
        }

        private final long beforeFirstIndex$$anonfun$2() {
            return this.torn();
        }

        private final long lastIndex$$anonfun$2() {
            return this.torn();
        }
    }
}

