/*
 * Decompiled with CFR 0.152.
 */
package js7.base.time;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import js7.base.time.AdmissionPeriod;
import js7.base.time.AdmissionPeriod$;
import js7.base.time.AdmissionPeriodCalculator$;
import js7.base.time.DailyPeriod;
import js7.base.time.JavaTime;
import js7.base.time.JavaTime$;
import js7.base.time.JavaTime$RichLocalDateTime$;
import js7.base.time.LocalInterval;
import js7.base.time.LocalInterval$;
import js7.base.time.MonthlyDatePeriod;
import js7.base.time.MonthlyLastDatePeriod;
import js7.base.time.MonthlyLastWeekdayPeriod;
import js7.base.time.MonthlyWeekdayPeriod;
import js7.base.time.SpecificDatePeriod;
import js7.base.time.WeekdayPeriod;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.View;
import scala.collection.View$;
import scala.concurrent.duration.FiniteDuration;

public interface AdmissionPeriodCalculator {
    public static ZoneOffset NoOffset() {
        return AdmissionPeriodCalculator$.MODULE$.NoOffset();
    }

    public static AdmissionPeriodCalculator apply(AdmissionPeriod admissionPeriod, FiniteDuration finiteDuration) {
        return AdmissionPeriodCalculator$.MODULE$.apply(admissionPeriod, finiteDuration);
    }

    public static long sinceStartOfWeek(long l) {
        return AdmissionPeriodCalculator$.MODULE$.sinceStartOfWeek(l);
    }

    public static long startOfWeek(LocalDateTime localDateTime) {
        return AdmissionPeriodCalculator$.MODULE$.startOfWeek(localDateTime);
    }

    public AdmissionPeriod admissionPeriod();

    public Duration dateOffset();

    public boolean hasAdmissionPeriodForDay(LocalDate var1);

    public boolean hasAdmissionPeriodStartForDay(LocalDate var1);

    public Option<LocalInterval> toLocalInterval(LocalDateTime var1);

    public LocalDateTime calendarPeriodStartWithoutDateOffset(LocalDateTime var1);

    public Option<LocalDateTime> nextCalendarPeriodStart(LocalDateTime var1);

    public static View findLocalIntervals$(AdmissionPeriodCalculator $this, LocalDateTime from, LocalDateTime until) {
        return $this.findLocalIntervals(from, until);
    }

    default public View<LocalInterval> findLocalIntervals(LocalDateTime from, LocalDateTime until) {
        return (View)((IterableOps)this.findLocalIntervals(from).takeWhile((Function1 & Serializable)_$1 -> _$1.startsBefore(until))).filterNot((Function1 & Serializable)_$2 -> _$2.endsBefore(from));
    }

    public static View findLocalIntervals$(AdmissionPeriodCalculator $this, LocalDateTime from) {
        return $this.findLocalIntervals(from);
    }

    default public View<LocalInterval> findLocalIntervals(LocalDateTime from) {
        Option<LocalInterval> first = this.toLocalInterval(from);
        return (View)View$.MODULE$.from(first).concat((IterableOnce)((IterableOps)View$.MODULE$.unfold((Object)from, (Function1 & Serializable)local -> this.nextCalendarPeriodStart((LocalDateTime)local).withFilter((Function1 & Serializable)next -> new JavaTime.RichLocalDateTime(JavaTime$.MODULE$.RichLocalDateTime((LocalDateTime)local)).$less(new JavaTime.RichLocalDateTime(JavaTime$.MODULE$.RichLocalDateTime((LocalDateTime)next)))).flatMap((Function1 & Serializable)next -> this.toLocalInterval((LocalDateTime)next).map((Function1 & Serializable)localInterval -> {
            LocalInterval localInterval2 = (LocalInterval)Predef$.MODULE$.ArrowAssoc(localInterval);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)localInterval2, next);
        })))).dropWhile((Function1 & Serializable)_$3 -> first.contains(_$3)));
    }

    public static final class DailyPeriodCalculator
    extends DayPeriodCalculator {
        private final DailyPeriod admissionPeriod;
        private final Duration dateOffset;

        public DailyPeriodCalculator(DailyPeriod admissionPeriod, Duration dateOffset) {
            this.admissionPeriod = admissionPeriod;
            this.dateOffset = dateOffset;
        }

        @Override
        public DailyPeriod admissionPeriod() {
            return this.admissionPeriod;
        }

        @Override
        public Duration dateOffset() {
            return this.dateOffset;
        }

        @Override
        public FiniteDuration duration() {
            return this.admissionPeriod().duration();
        }

        @Override
        public LocalDateTime calendarPeriodStartWithoutDateOffset(LocalDateTime local) {
            return LocalDateTime.of(local.toLocalDate(), LocalTime.MIDNIGHT);
        }

        @Override
        public Option<LocalDateTime> nextCalendarPeriodStart(LocalDateTime local) {
            return Some$.MODULE$.apply((Object)this.calendarPeriodStart(local).plusDays(1L));
        }

        @Override
        public LocalDateTime admissionPeriodStart(LocalDateTime local) {
            return LocalDateTime.of(local.toLocalDate(), LocalTime.ofSecondOfDay(Int$.MODULE$.int2long(this.admissionPeriod().secondOfDay())));
        }
    }

    public static abstract class DayPeriodCalculator
    implements AdmissionPeriodCalculator {
        public final LocalDateTime calendarPeriodStart(LocalDateTime local) {
            return this.calendarPeriodStartWithoutDateOffset(local.minus(this.dateOffset())).plus(this.dateOffset());
        }

        @Override
        public final boolean hasAdmissionPeriodForDay(LocalDate localDate) {
            LocalDateTime startOfDay = LocalDateTime.of(localDate, LocalTime.MIDNIGHT);
            LocalDateTime endOfDay = startOfDay.plusDays(1L);
            return this.toLocalInterval0(startOfDay).contains(startOfDay, endOfDay);
        }

        @Override
        public final boolean hasAdmissionPeriodStartForDay(LocalDate localDate) {
            LocalDate localDate2 = localDate;
            LocalDate localDate3 = this.admissionPeriodStart(LocalDateTime.of(localDate, LocalTime.MIDNIGHT)).toLocalDate();
            return !(localDate2 != null ? !((Object)localDate2).equals(localDate3) : localDate3 != null);
        }

        @Override
        public final Option<LocalInterval> toLocalInterval(LocalDateTime local) {
            return Some$.MODULE$.apply((Object)this.toLocalInterval0(local));
        }

        private LocalInterval toLocalInterval0(LocalDateTime local) {
            LocalInterval lastInterval = this.toLocalInterval1(JavaTime$RichLocalDateTime$.MODULE$.$minus$extension(JavaTime$.MODULE$.RichLocalDateTime(this.calendarPeriodStart(local)), AdmissionPeriodCalculator$.js7$base$time$AdmissionPeriodCalculator$$$JEpsilon));
            if (lastInterval.contains(local)) {
                return lastInterval;
            }
            return this.toLocalInterval1(local);
        }

        private LocalInterval toLocalInterval1(LocalDateTime local) {
            return LocalInterval$.MODULE$.apply(this.admissionPeriodStart(local), this.duration());
        }

        public abstract FiniteDuration duration();

        public abstract LocalDateTime admissionPeriodStart(LocalDateTime var1);

        public String toString() {
            return this.admissionPeriod().toString();
        }
    }

    public static final class MonthlyDatePeriodCalculator
    extends DayPeriodCalculator {
        private final MonthlyDatePeriod admissionPeriod;
        private final Duration dateOffset;

        public MonthlyDatePeriodCalculator(MonthlyDatePeriod admissionPeriod, Duration dateOffset) {
            this.admissionPeriod = admissionPeriod;
            this.dateOffset = dateOffset;
        }

        @Override
        public MonthlyDatePeriod admissionPeriod() {
            return this.admissionPeriod;
        }

        @Override
        public Duration dateOffset() {
            return this.dateOffset;
        }

        @Override
        public FiniteDuration duration() {
            return this.admissionPeriod().duration();
        }

        @Override
        public LocalDateTime calendarPeriodStartWithoutDateOffset(LocalDateTime local) {
            return AdmissionPeriodCalculator$.MODULE$.js7$base$time$AdmissionPeriodCalculator$$$startOfMonth(local);
        }

        @Override
        public Option<LocalDateTime> nextCalendarPeriodStart(LocalDateTime local) {
            return Some$.MODULE$.apply((Object)this.calendarPeriodStart(local).plusMonths(1L));
        }

        @Override
        public LocalDateTime admissionPeriodStart(LocalDateTime local) {
            LocalDateTime a = AdmissionPeriodCalculator$.MODULE$.js7$base$time$AdmissionPeriodCalculator$$$startOfMonth(local).plusSeconds(Int$.MODULE$.int2long(this.admissionPeriod().secondOfMonth()));
            Month month = a.getMonth();
            Month month2 = local.getMonth();
            if (!(month != null ? !month.equals(month2) : month2 != null)) {
                return a;
            }
            return AdmissionPeriodCalculator$.MODULE$.js7$base$time$AdmissionPeriodCalculator$$$endOfMonth(local).plusSeconds(Int$.MODULE$.int2long(this.admissionPeriod().secondOfDay()));
        }
    }

    public static final class MonthlyLastDatePeriodCalculator
    extends DayPeriodCalculator {
        private final MonthlyLastDatePeriod admissionPeriod;
        private final Duration dateOffset;

        public MonthlyLastDatePeriodCalculator(MonthlyLastDatePeriod admissionPeriod, Duration dateOffset) {
            this.admissionPeriod = admissionPeriod;
            this.dateOffset = dateOffset;
        }

        @Override
        public MonthlyLastDatePeriod admissionPeriod() {
            return this.admissionPeriod;
        }

        @Override
        public Duration dateOffset() {
            return this.dateOffset;
        }

        @Override
        public FiniteDuration duration() {
            return this.admissionPeriod().duration();
        }

        @Override
        public LocalDateTime calendarPeriodStartWithoutDateOffset(LocalDateTime local) {
            return AdmissionPeriodCalculator$.MODULE$.js7$base$time$AdmissionPeriodCalculator$$$startOfMonth(local);
        }

        @Override
        public Option<LocalDateTime> nextCalendarPeriodStart(LocalDateTime local) {
            return Some$.MODULE$.apply((Object)this.calendarPeriodStart(local).plusMonths(1L));
        }

        @Override
        public LocalDateTime admissionPeriodStart(LocalDateTime local) {
            return AdmissionPeriodCalculator$.MODULE$.js7$base$time$AdmissionPeriodCalculator$$$startOfMonth(local).plusMonths(1L).plusSeconds(Int$.MODULE$.int2long(this.admissionPeriod().lastSecondOfMonth()));
        }
    }

    public static final class MonthlyLastWeekdayPeriodCalculator
    extends DayPeriodCalculator {
        private final MonthlyLastWeekdayPeriod admissionPeriod;
        private final Duration dateOffset;

        public MonthlyLastWeekdayPeriodCalculator(MonthlyLastWeekdayPeriod admissionPeriod, Duration dateOffset) {
            this.admissionPeriod = admissionPeriod;
            this.dateOffset = dateOffset;
        }

        @Override
        public MonthlyLastWeekdayPeriod admissionPeriod() {
            return this.admissionPeriod;
        }

        @Override
        public Duration dateOffset() {
            return this.dateOffset;
        }

        @Override
        public FiniteDuration duration() {
            return this.admissionPeriod().duration();
        }

        @Override
        public LocalDateTime calendarPeriodStartWithoutDateOffset(LocalDateTime local) {
            return AdmissionPeriodCalculator$.MODULE$.js7$base$time$AdmissionPeriodCalculator$$$startOfMonth(local);
        }

        @Override
        public Option<LocalDateTime> nextCalendarPeriodStart(LocalDateTime local) {
            return Some$.MODULE$.apply((Object)this.calendarPeriodStart(local).plusMonths(1L));
        }

        @Override
        public LocalDateTime admissionPeriodStart(LocalDateTime local) {
            long endOfMonthSecond = AdmissionPeriodCalculator$.MODULE$.js7$base$time$AdmissionPeriodCalculator$$$endOfMonth(local).toEpochSecond(AdmissionPeriodCalculator$.MODULE$.NoOffset());
            long endOfMonthSinceMonday = AdmissionPeriodCalculator$.MODULE$.sinceStartOfWeek(endOfMonthSecond);
            int shiftWeek = ScalaUtils$syntax$RichBoolean$.MODULE$.toInt$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(endOfMonthSinceMonday / (long)AdmissionPeriod$.MODULE$.DaySeconds() < (long)this.admissionPeriod().dayOfWeek()));
            long second = endOfMonthSecond - endOfMonthSinceMonday + (long)((this.admissionPeriod().shiftWeeks() - shiftWeek) * AdmissionPeriod$.MODULE$.WeekSeconds()) + (long)this.admissionPeriod().secondOfWeek();
            return LocalDateTime.ofEpochSecond(second, 0, AdmissionPeriodCalculator$.MODULE$.NoOffset());
        }
    }

    public static final class MonthlyWeekdayPeriodCalculator
    extends DayPeriodCalculator {
        private final MonthlyWeekdayPeriod admissionPeriod;
        private final Duration dateOffset;

        public MonthlyWeekdayPeriodCalculator(MonthlyWeekdayPeriod admissionPeriod, Duration dateOffset) {
            this.admissionPeriod = admissionPeriod;
            this.dateOffset = dateOffset;
        }

        @Override
        public MonthlyWeekdayPeriod admissionPeriod() {
            return this.admissionPeriod;
        }

        @Override
        public Duration dateOffset() {
            return this.dateOffset;
        }

        @Override
        public FiniteDuration duration() {
            return this.admissionPeriod().duration();
        }

        @Override
        public LocalDateTime calendarPeriodStartWithoutDateOffset(LocalDateTime local) {
            return AdmissionPeriodCalculator$.MODULE$.js7$base$time$AdmissionPeriodCalculator$$$startOfMonth(local);
        }

        @Override
        public Option<LocalDateTime> nextCalendarPeriodStart(LocalDateTime local) {
            return Some$.MODULE$.apply((Object)this.calendarPeriodStart(local).plusMonths(1L));
        }

        @Override
        public LocalDateTime admissionPeriodStart(LocalDateTime local) {
            long startOfMonthSeconds = AdmissionPeriodCalculator$.MODULE$.js7$base$time$AdmissionPeriodCalculator$$$startOfMonth(local).toEpochSecond(AdmissionPeriodCalculator$.MODULE$.NoOffset());
            long startOfMonthSinceMonday = AdmissionPeriodCalculator$.MODULE$.sinceStartOfWeek(startOfMonthSeconds);
            int shiftWeek = startOfMonthSinceMonday / (long)AdmissionPeriod$.MODULE$.DaySeconds() > (long)this.admissionPeriod().dayOfWeek() ? AdmissionPeriod$.MODULE$.WeekSeconds() : 0;
            long seconds = startOfMonthSeconds - startOfMonthSinceMonday + (long)shiftWeek + (long)this.admissionPeriod().secondOfWeeks();
            return LocalDateTime.ofEpochSecond(seconds, 0, AdmissionPeriodCalculator$.MODULE$.NoOffset());
        }
    }

    public static final class SpecificDatePeriodCalculator
    extends DayPeriodCalculator {
        private final SpecificDatePeriod admissionPeriod;
        private final Duration dateOffset;
        private final LocalDateTime localDateTime;

        public SpecificDatePeriodCalculator(SpecificDatePeriod admissionPeriod, Duration dateOffset) {
            this.admissionPeriod = admissionPeriod;
            this.dateOffset = dateOffset;
            this.localDateTime = LocalDateTime.ofEpochSecond(admissionPeriod.secondsSinceLocalEpoch(), 0, AdmissionPeriodCalculator$.MODULE$.NoOffset());
        }

        @Override
        public SpecificDatePeriod admissionPeriod() {
            return this.admissionPeriod;
        }

        @Override
        public Duration dateOffset() {
            return this.dateOffset;
        }

        @Override
        public FiniteDuration duration() {
            return this.admissionPeriod().duration();
        }

        @Override
        public LocalDateTime calendarPeriodStartWithoutDateOffset(LocalDateTime ignore) {
            return this.localDateTime;
        }

        @Override
        public Option<LocalDateTime> nextCalendarPeriodStart(LocalDateTime local) {
            LocalDateTime next = JavaTime$RichLocalDateTime$.MODULE$.$plus$extension(JavaTime$.MODULE$.RichLocalDateTime(this.admissionPeriodStart(local)), this.dateOffset());
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(new JavaTime.RichLocalDateTime(JavaTime$.MODULE$.RichLocalDateTime(local)).$less$eq(new JavaTime.RichLocalDateTime(JavaTime$.MODULE$.RichLocalDateTime(next))));
            return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> AdmissionPeriodCalculator$.js7$base$time$AdmissionPeriodCalculator$SpecificDatePeriodCalculator$$_$nextCalendarPeriodStart$$anonfun$1(next));
        }

        @Override
        public LocalDateTime admissionPeriodStart(LocalDateTime local) {
            return this.localDateTime;
        }
    }

    public static final class WeekdayPeriodCalculator
    extends DayPeriodCalculator {
        private final WeekdayPeriod admissionPeriod;
        private final Duration dateOffset;

        public WeekdayPeriodCalculator(WeekdayPeriod admissionPeriod, Duration dateOffset) {
            this.admissionPeriod = admissionPeriod;
            this.dateOffset = dateOffset;
        }

        @Override
        public WeekdayPeriod admissionPeriod() {
            return this.admissionPeriod;
        }

        @Override
        public Duration dateOffset() {
            return this.dateOffset;
        }

        @Override
        public FiniteDuration duration() {
            return this.admissionPeriod().duration();
        }

        @Override
        public LocalDateTime calendarPeriodStartWithoutDateOffset(LocalDateTime local) {
            return LocalDateTime.of(local.toLocalDate().minusDays(Int$.MODULE$.int2long(local.get(ChronoField.DAY_OF_WEEK) - 1)), LocalTime.MIDNIGHT);
        }

        @Override
        public Option<LocalDateTime> nextCalendarPeriodStart(LocalDateTime local) {
            return Some$.MODULE$.apply((Object)this.calendarPeriodStart(local).plusDays(7L));
        }

        @Override
        public LocalDateTime admissionPeriodStart(LocalDateTime local) {
            return LocalDateTime.ofEpochSecond(AdmissionPeriodCalculator$.MODULE$.startOfWeek(local) + (long)this.admissionPeriod().secondOfWeek(), 0, AdmissionPeriodCalculator$.MODULE$.NoOffset());
        }
    }
}

