/*
 * Decompiled with CFR 0.152.
 */
package js7.base.utils;

import cats.Functor;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.effect.std.Mutex;
import cats.effect.std.Mutex$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.UnsafeMemoizable$;
import js7.base.log.BlockingSymbol;
import js7.base.log.LogLevel;
import js7.base.log.LogLevel$;
import js7.base.log.Slf4jUtils$syntax$;
import js7.base.log.Slf4jUtils$syntax$LevelLogger$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.AsyncLock$;
import js7.base.utils.Atomic$package$Atomic$extensions$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Arrays$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import sourcecode.Enclosing;

public interface AsyncLock {
    public static AsyncLock apply(boolean bl, Enclosing enclosing) {
        return AsyncLock$.MODULE$.apply(bl, enclosing);
    }

    public static AsyncLock apply(Enclosing enclosing) {
        return AsyncLock$.MODULE$.apply(enclosing);
    }

    public static AsyncLock apply(String string, IterableOnce<FiniteDuration> iterableOnce, boolean bl, boolean bl2) {
        return AsyncLock$.MODULE$.apply(string, iterableOnce, bl, bl2);
    }

    public static AsyncLock dontLog() {
        return AsyncLock$.MODULE$.dontLog();
    }

    public static IterableOnce<FiniteDuration> apply$default$2() {
        return AsyncLock$.MODULE$.apply$default$2();
    }

    public static boolean apply$default$3() {
        return AsyncLock$.MODULE$.apply$default$3();
    }

    public static boolean apply$default$4() {
        return AsyncLock$.MODULE$.apply$default$4();
    }

    public static IO lock$(AsyncLock $this, IO io, Enclosing src) {
        return $this.lock(io, src);
    }

    default public <A> IO<A> lock(IO<A> io, Enclosing src) {
        return this.lock((Function0<String>)((Function0 & Serializable)() -> AsyncLock.lock$$anonfun$1(src)), io);
    }

    public <A> IO<A> lock(Function0<String> var1, IO<A> var2);

    private static String lock$$anonfun$1(Enclosing src$1) {
        return src$1.value();
    }

    public static final class NoLogging
    implements AsyncLock {
        private final String name;
        private final IO<Mutex<IO>> mutex;

        public NoLogging(String name) {
            this.name = name;
            this.mutex = (IO)UnsafeMemoizable$.MODULE$.unsafeMemoize(Mutex$.MODULE$.apply((GenConcurrent)IO$.MODULE$.asyncForIO()), IO$.MODULE$.asyncForIO());
        }

        @Override
        public <A> IO<A> lock(Function0<String> acquirer, IO<A> io) {
            return this.mutex.flatMap(arg_0 -> AsyncLock$.js7$base$utils$AsyncLock$NoLogging$$_$lock$$anonfun$2(io, arg_0));
        }

        public String toString() {
            return "AsyncLock:" + this.name;
        }
    }

    public static final class WithLogging
    implements AsyncLock {
        private final String name;
        private final IterableOnce<FiniteDuration> logWorryDurations;
        private final boolean logMinor;
        private final IO<Mutex<IO>> mutex;
        private final AtomicInteger queueLength;

        public WithLogging(String name, IterableOnce<FiniteDuration> logWorryDurations, boolean logMinor) {
            this.name = name;
            this.logWorryDurations = logWorryDurations;
            this.logMinor = logMinor;
            this.mutex = (IO)UnsafeMemoizable$.MODULE$.unsafeMemoize(Mutex$.MODULE$.apply((GenConcurrent)IO$.MODULE$.asyncForIO()), IO$.MODULE$.asyncForIO());
            this.queueLength = new AtomicInteger(0);
        }

        public boolean isLocked() {
            return this.queueLength.get() > 0;
        }

        @Override
        public <A> IO<A> lock(Function0<String> acquirer, IO<A> body) {
            return this.mutex.flatMap((Function1 & Serializable)mutex -> (IO)this.logging(acquirer).use(arg_0 -> AsyncLock$.js7$base$utils$AsyncLock$WithLogging$$_$lock$$anonfun$3$$anonfun$1(mutex, body, arg_0), (MonadCancel)IO$.MODULE$.asyncForIO()));
        }

        private Resource<IO, IO<BoxedUnit>> logging(Function0<String> acquirer) {
            return CatsEffectExtensions$.MODULE$.defer(package$.MODULE$.Resource(), () -> this.logging$$anonfun$1(acquirer), (Sync)IO$.MODULE$.asyncForIO());
        }

        public String toString() {
            return "AsyncLock:" + this.name;
        }

        private final String nrString$lzyINIT1$1(LazyRef nrString$lzy1$1, int nr$1) {
            String string;
            LazyRef lazyRef = nrString$lzy1$1;
            synchronized (lazyRef) {
                string = (String)(nrString$lzy1$1.initialized() ? nrString$lzy1$1.value() : nrString$lzy1$1.initialize((Object)("\u2020" + nr$1)));
            }
            return string;
        }

        private final String nrString$1(LazyRef nrString$lzy1$2, int nr$2) {
            return (String)(nrString$lzy1$2.initialized() ? nrString$lzy1$2.value() : this.nrString$lzyINIT1$1(nrString$lzy1$2, nr$2));
        }

        private final String acquirer_$lzyINIT1$1(LazyRef acquirer_$lzy1$1, Function0 acquirer$2) {
            String string;
            LazyRef lazyRef = acquirer_$lzy1$1;
            synchronized (lazyRef) {
                string = (String)(acquirer_$lzy1$1.initialized() ? acquirer_$lzy1$1.value() : acquirer_$lzy1$1.initialize((Object)((String)acquirer$2.apply())));
            }
            return string;
        }

        private final String acquirer_$1(LazyRef acquirer_$lzy1$2, Function0 acquirer$4) {
            return (String)(acquirer_$lzy1$2.initialized() ? acquirer_$lzy1$2.value() : this.acquirer_$lzyINIT1$1(acquirer_$lzy1$2, acquirer$4));
        }

        private final void logBeforeAcquire$1$$anonfun$2$$anonfun$1(BooleanRef firstLogged$3, BlockingSymbol sym$3, Deadline since$3, LazyRef nrString$lzy1$5, int nr$5, LazyRef acquirer_$lzy1$5, Function0 acquirer$7) {
            if (!firstLogged$3.elem) {
                Logger LoggerImpl_this;
                if (this.logMinor && (LoggerImpl_this = AsyncLock$.js7$base$utils$AsyncLock$$$logger).underlying().isTraceEnabled()) {
                    LoggerImpl_this.underlying().trace("\u26aa\ufe0f{} {} is being acquired by {} ...", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.nrString$1(nrString$lzy1$5, nr$5), this.name, this.acquirer_$1(acquirer_$lzy1$5, acquirer$7)}), Object.class));
                }
                firstLogged$3.elem = true;
                return;
            }
            sym$3.onInfo();
            Logger LoggerImpl_this = AsyncLock$.js7$base$utils$AsyncLock$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("{}{} {}: {} is still waiting for {} ({} queued)...", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{sym$3, this.nrString$1(nrString$lzy1$5, nr$5), this.name, this.acquirer_$1(acquirer_$lzy1$5, acquirer$7), ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$3)))), this.queueLength}), Object.class));
                return;
            }
        }

        private final String message$proxy3$1(Deadline since$5, LazyRef nrString$lzy1$7, int nr$7) {
            return "\u25fc\ufe0f" + this.nrString$1(nrString$lzy1$7, nr$7) + " " + this.name + " acquisition canceled after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$5)))) + " \u2199";
        }

        private final String logBeforeAcquire$1$$anonfun$3$$anonfun$1(Deadline since$15, LazyRef nrString$lzy1$18, int nr$18) {
            return this.message$proxy3$1(since$15, nrString$lzy1$18, nr$18);
        }

        private final void logBeforeAcquire$1$$anonfun$3(BooleanRef acquired$2, BlockingSymbol sym$4, Deadline since$4, LazyRef nrString$lzy1$6, int nr$6) {
            if (!acquired$2.elem && sym$4.used()) {
                LogLevel level$proxy1 = sym$4.logLevel();
                Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(AsyncLock$.js7$base$utils$AsyncLock$$$logger.underlying()), level$proxy1, (Function0<String>)((Function0 & Serializable)() -> this.logBeforeAcquire$1$$anonfun$3$$anonfun$1(since$4, nrString$lzy1$6, nr$6)));
                return;
            }
        }

        private final IO logBeforeAcquire$1(BooleanRef firstLogged$1, BlockingSymbol sym$1, Deadline since$1, BooleanRef acquired$1, LazyRef nrString$lzy1$3, int nr$3, LazyRef acquirer_$lzy1$3, Function0 acquirer$5) {
            return CatsUtils$syntax$.MODULE$.whenItTakesLonger(IO$.MODULE$.never(), (IterableOnce<FiniteDuration>)((IterableOnce)ScalaUtils$syntax$RichBoolean$.MODULE$.thenView$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.logMinor), AsyncLock$::js7$base$utils$AsyncLock$WithLogging$$_$logBeforeAcquire$1$$anonfun$1).$plus$plus(this.logWorryDurations)), (Function1<FiniteDuration, IO<BoxedUnit>>)(Function1 & Serializable)_$2 -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.logBeforeAcquire$1$$anonfun$2$$anonfun$1(firstLogged$1, sym$1, since$1, nrString$lzy1$3, nr$3, acquirer_$lzy1$3, acquirer$5);
                return BoxedUnit.UNIT;
            })).onCancel(IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.logBeforeAcquire$1$$anonfun$3(acquired$1, sym$1, since$1, nrString$lzy1$3, nr$3);
                return BoxedUnit.UNIT;
            }));
        }

        private final String message$proxy4$1(Deadline since$8, LazyRef nrString$lzy1$10, int nr$10, LazyRef acquirer_$lzy1$8, Function0 acquirer$10) {
            return "\u2198 \ud83d\udfe2" + this.nrString$1(nrString$lzy1$10, nr$10) + " " + this.name + " acquired by " + this.acquirer_$1(acquirer_$lzy1$8, acquirer$10) + " \u00b7 " + this.queueLength + " queued \u00b7 " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$8)))) + " \u2198";
        }

        private final String logAfterAcquire$1$$anonfun$1$$anonfun$1(Deadline since$17, LazyRef nrString$lzy1$20, int nr$20, LazyRef acquirer_$lzy1$16, Function0 acquirer$18) {
            return this.message$proxy4$1(since$17, nrString$lzy1$20, nr$20, acquirer_$lzy1$16, acquirer$18);
        }

        private final void logAfterAcquire$1$$anonfun$1(BlockingSymbol sym$6, Deadline since$7, BooleanRef minorRequestLogged$2, LazyRef nrString$lzy1$9, int nr$9, LazyRef acquirer_$lzy1$7, Function0 acquirer$9) {
            if (sym$6.used()) {
                LogLevel level$proxy2 = sym$6.relievedLogLevel();
                Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(AsyncLock$.js7$base$utils$AsyncLock$$$logger.underlying()), level$proxy2, (Function0<String>)((Function0 & Serializable)() -> this.logAfterAcquire$1$$anonfun$1$$anonfun$1(since$7, nrString$lzy1$9, nr$9, acquirer_$lzy1$7, acquirer$9)));
                return;
            }
            if (this.logMinor) {
                minorRequestLogged$2.elem = true;
                Logger LoggerImpl_this = AsyncLock$.js7$base$utils$AsyncLock$$$logger;
                if (LoggerImpl_this.underlying().isTraceEnabled()) {
                    LoggerImpl_this.underlying().trace("\u2198 \u26aa\ufe0f{} {} acquired by {} \u00b7 {} queued \u00b7 {} \u2198", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.nrString$1(nrString$lzy1$9, nr$9), this.name, this.acquirer_$1(acquirer_$lzy1$7, acquirer$9), this.queueLength, ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$7))))}), Object.class));
                    return;
                }
                return;
            }
        }

        private final IO logAfterAcquire$1(BlockingSymbol sym$5, Deadline since$6, BooleanRef minorRequestLogged$1, LazyRef nrString$lzy1$8, int nr$8, LazyRef acquirer_$lzy1$6, Function0 acquirer$8) {
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.logAfterAcquire$1$$anonfun$1(sym$5, since$6, minorRequestLogged$1, nrString$lzy1$8, nr$8, acquirer_$lzy1$6, acquirer$8);
                return BoxedUnit.UNIT;
            });
        }

        private final String message$proxy6$1(Deadline since$11, LazyRef nrString$lzy1$13, int nr$13, LazyRef acquirer_$lzy1$11, Function0 acquirer$13) {
            return "\u2199 \u26aa\ufe0f" + this.nrString$1(nrString$lzy1$13, nr$13) + " " + this.name + " released by " + this.acquirer_$1(acquirer_$lzy1$11, acquirer$13) + " \u00b7 " + this.queueLength + " queued \u00b7 " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$11)))) + " \u2199";
        }

        private final String logRelease$1$$anonfun$1$$anonfun$1(Deadline since$19, LazyRef nrString$lzy1$22, int nr$22, LazyRef acquirer_$lzy1$18, Function0 acquirer$20) {
            return this.message$proxy6$1(since$19, nrString$lzy1$22, nr$22, acquirer_$lzy1$18, acquirer$20);
        }

        private final String message$proxy7$1(Deadline since$12, LazyRef nrString$lzy1$14, int nr$14, LazyRef acquirer_$lzy1$12, Function0 acquirer$14) {
            return "\u2199 \u25fc\ufe0f" + this.nrString$1(nrString$lzy1$14, nr$14) + " " + this.name + " released by " + this.acquirer_$1(acquirer_$lzy1$12, acquirer$14) + " \u00b7 Canceled \u00b7 " + this.queueLength + " queued \u00b7 " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$12)))) + " \u2199";
        }

        private final String logRelease$1$$anonfun$1$$anonfun$2(Deadline since$20, LazyRef nrString$lzy1$23, int nr$23, LazyRef acquirer_$lzy1$19, Function0 acquirer$21) {
            return this.message$proxy7$1(since$20, nrString$lzy1$23, nr$23, acquirer_$lzy1$19, acquirer$21);
        }

        private final String message$proxy8$1(Throwable t$1, LazyRef nrString$lzy1$15, int nr$15, LazyRef acquirer_$lzy1$13, Function0 acquirer$15) {
            Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t$1);
            return "\u2199 \ud83d\udca5" + this.nrString$1(nrString$lzy1$15, nr$15) + " " + this.name + " released by " + this.acquirer_$1(acquirer_$lzy1$13, acquirer$15) + " \u00b7 " + this.queueLength + " queued \u00b7 " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable) + " \u2199";
        }

        private final String logRelease$1$$anonfun$1$$anonfun$3(Throwable t$2, LazyRef nrString$lzy1$24, int nr$24, LazyRef acquirer_$lzy1$20, Function0 acquirer$22) {
            return this.message$proxy8$1(t$2, nrString$lzy1$24, nr$24, acquirer_$lzy1$20, acquirer$22);
        }

        private final void logRelease$1$$anonfun$1(BooleanRef minorRequestLogged$4, BlockingSymbol sym$8, Resource.ExitCase exitCase$1, Deadline since$10, LazyRef nrString$lzy1$12, int nr$12, LazyRef acquirer_$lzy1$10, Function0 acquirer$12) {
            if (minorRequestLogged$4.elem || sym$8.used()) {
                LogLevel logLevel = sym$8.used() ? sym$8.logLevel() : LogLevel$.Trace;
                Resource.ExitCase exitCase = exitCase$1;
                package$.MODULE$.Resource();
                if (Resource.ExitCase$.Succeeded$.MODULE$.equals(exitCase)) {
                    Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(AsyncLock$.js7$base$utils$AsyncLock$$$logger.underlying()), logLevel, (Function0<String>)((Function0 & Serializable)() -> this.logRelease$1$$anonfun$1$$anonfun$1(since$10, nrString$lzy1$12, nr$12, acquirer_$lzy1$10, acquirer$12)));
                    return;
                }
                package$.MODULE$.Resource();
                if (Resource.ExitCase$.Canceled$.MODULE$.equals(exitCase)) {
                    Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(AsyncLock$.js7$base$utils$AsyncLock$$$logger.underlying()), logLevel, (Function0<String>)((Function0 & Serializable)() -> this.logRelease$1$$anonfun$1$$anonfun$2(since$10, nrString$lzy1$12, nr$12, acquirer_$lzy1$10, acquirer$12)));
                    return;
                }
                if (exitCase instanceof Resource.ExitCase$.Errored) {
                    Throwable throwable;
                    package$.MODULE$.Resource();
                    Resource.ExitCase$.Errored errored = Resource.ExitCase$.Errored$.MODULE$.unapply((Resource.ExitCase$.Errored)exitCase);
                    Throwable t = throwable = errored._1();
                    LogLevel level$proxy3 = sym$8.logLevel();
                    Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(AsyncLock$.js7$base$utils$AsyncLock$$$logger.underlying()), level$proxy3, (Function0<String>)((Function0 & Serializable)() -> this.logRelease$1$$anonfun$1$$anonfun$3(t, nrString$lzy1$12, nr$12, acquirer_$lzy1$10, acquirer$12)));
                    return;
                }
                throw new MatchError((Object)exitCase);
            }
        }

        private final IO logRelease$1(BooleanRef minorRequestLogged$3, BlockingSymbol sym$7, Deadline since$9, LazyRef nrString$lzy1$11, int nr$11, LazyRef acquirer_$lzy1$9, Function0 acquirer$11, Resource.ExitCase exitCase) {
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.logRelease$1$$anonfun$1(minorRequestLogged$3, sym$7, exitCase, since$9, nrString$lzy1$11, nr$11, acquirer_$lzy1$9, acquirer$11);
                return BoxedUnit.UNIT;
            });
        }

        private final int logging$$anonfun$1$$anonfun$1() {
            return Atomic$package$Atomic$extensions$.MODULE$.$plus$eq(this.queueLength, 1);
        }

        private final int logging$$anonfun$1$$anonfun$2$$anonfun$1() {
            return Atomic$package$Atomic$extensions$.MODULE$.$minus$eq(this.queueLength, 1);
        }

        private final Resource logging$$anonfun$1(Function0 acquirer$3) {
            LazyRef lazyRef = new LazyRef();
            LazyRef lazyRef2 = new LazyRef();
            Deadline since = Deadline$.MODULE$.now();
            int nr = Atomic$package$Atomic$extensions$.MODULE$.$plus$eq(AsyncLock$.js7$base$utils$AsyncLock$$$waitCounter, 1);
            BlockingSymbol sym = new BlockingSymbol();
            BooleanRef minorRequestLogged = BooleanRef.create((boolean)false);
            BooleanRef acquired = BooleanRef.create((boolean)false);
            BooleanRef firstLogged = BooleanRef.create((!this.logMinor ? 1 : 0) != 0);
            return package$.MODULE$.Resource().makeCase((Object)IO$.MODULE$.apply(this::logging$$anonfun$1$$anonfun$1).$times$greater(this.logBeforeAcquire$1(firstLogged, sym, since, acquired, lazyRef, nr, lazyRef2, acquirer$3).start()), (Function2 & Serializable)(fiber, exitCase) -> IO$.MODULE$.apply(this::logging$$anonfun$1$$anonfun$2$$anonfun$1).$times$greater((IO)fiber.cancel()).$times$greater(this.logRelease$1(minorRequestLogged, sym, since, lazyRef, nr, lazyRef2, acquirer$3, (Resource.ExitCase)exitCase)), (Functor)IO$.MODULE$.asyncForIO()).map((Function1 & Serializable)fiber -> {
                acquired$3.elem = true;
                return ((IO)fiber.cancel()).$times$greater(this.logAfterAcquire$1(sym, since, minorRequestLogged, lazyRef, nr, lazyRef2, acquirer$3));
            });
        }
    }
}

