/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import cats.ApplicativeError;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Outcome;
import cats.effect.package$;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import cats.syntax.package;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream$;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ConcurrentModificationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.UnsafeMemoizable$;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.generic.Completed$package$Completed$;
import js7.base.log.CanBindCorrelId$;
import js7.base.log.CorrelId$;
import js7.base.log.Logger$syntax$;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.system.startup.Halt$;
import js7.base.utils.Assertions$;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.MVar;
import js7.base.utils.MVar$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichF_$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.cluster.ClusterWatchCounterpart;
import js7.cluster.ClusterWatchSynchronizer$;
import js7.cluster.watch.api.ClusterWatchConfirmation;
import js7.data.cluster.ClusterEvent;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterTiming;
import js7.data.cluster.ClusterWatchProblems$ClusterPassiveLostWhileFailedOverProblem$;
import js7.data.node.NodeId;
import org.apache.pekko.pattern.AskTimeoutException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.Enclosing;
import sourcecode.Enclosing$;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Name$;
import sourcecode.Text;
import sourcecode.Text$;

public final class ClusterWatchSynchronizer {
    private final NodeId ownId;
    private final ClusterWatchCounterpart clusterWatch;
    public final ClusterTiming js7$cluster$ClusterWatchSynchronizer$$timing;
    private final AtomicInteger suspendNesting;
    private final AsyncLock suspendNestingLock;
    private final SetOnce<Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>>> registerClusterWatchId;
    private final AtomicReference<Option<Heartbeat>> heartbeat;

    public ClusterWatchSynchronizer(NodeId ownId, ClusterWatchCounterpart clusterWatch, ClusterTiming timing) {
        this.ownId = ownId;
        this.clusterWatch = clusterWatch;
        this.js7$cluster$ClusterWatchSynchronizer$$timing = timing;
        this.suspendNesting = new AtomicInteger(0);
        this.suspendNestingLock = AsyncLock$.MODULE$.apply(Enclosing$.MODULE$.apply("js7.cluster.ClusterWatchSynchronizer#suspendNestingLock"));
        this.registerClusterWatchId = SetOnce$.MODULE$.apply(Tag$.MODULE$.apply(Function2.class, LightTypeTag$.MODULE$.parse(541520161, "\u0001\u0001\u0001\u000fscala.Function2\u0003\u0000\u0004\u0000\u0001.js7.cluster.watch.api.ClusterWatchConfirmation\u0001\u0001\u0001\u0000\u0004\u0000\u0001\rscala.Boolean\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u000ecats.effect.IO\u0001\u0000\u0001\u0001\u0001\u0011scala.util.Either\u0002\u0000\u0004\u0000\u0001\u0018js7.base.problem.Problem\u0001\u0001\u0002\u0000\u0004\u0000\u0001\nscala.Unit\u0001\u0001\u0002\u0001\u0002\u0001\u0002\u0001", "\u0000\u0006\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001.js7.cluster.watch.api.ClusterWatchConfirmation\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\rscala.Boolean\u0001\u0001\u0001\u0004\u0000\u0001\fscala.AnyVal\u0001\u0001\u0001\u0001\u0001\u000ecats.effect.IO\u0001\u0000\u0001\u0001\u0001\u0011scala.util.Either\u0002\u0000\u0004\u0000\u0001\u0018js7.base.problem.Problem\u0001\u0001\u0002\u0000\u0004\u0000\u0001\nscala.Unit\u0001\u0001\u0002\u0001\u0002\u0001\u0002\u0001\u0001\u0001\u0016cats.effect.IOPlatform\u0001\u0000\u0001\u0001\u0001\u0090\t\u0002\u0000\u0004\u0000\u0001\u0090\n\u0001\u0001\u0002\u0000\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0002\u0001\u0000\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0001\u0001\u0090\t\u0002\u0000\u0004\u0000\u0001\u0090\n\u0001\u0001\u0002\u0000\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0002\u0001\u0003\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\b\u0001\u0001\u0002\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0003\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0003\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 30)));
        Option initial$proxy1 = package.option$.MODULE$.none();
        this.heartbeat = new AtomicReference<Option>(initial$proxy1);
    }

    public IO<Either<Problem, Completed$package$Completed$>> start(IO<ClusterState.HasNodes> currentClusterState, Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>> registerClusterWatchId) {
        return Logger$syntax$.MODULE$.debugIO(ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger, IO$.MODULE$.defer(() -> this.start$$anonfun$1(registerClusterWatchId, currentClusterState)), Name$.MODULE$.apply("start"));
    }

    private IO<Either<Problem, Completed$package$Completed$>> askClusterWatch(ClusterState.HasNodes clusterState, Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>> registerClusterWatchId) {
        return Logger$syntax$.MODULE$.traceIO(ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger, IO$.MODULE$.defer(() -> this.askClusterWatch$$anonfun$1(clusterState, registerClusterWatchId)), Name$.MODULE$.apply("askClusterWatch"));
    }

    public IO<BoxedUnit> stop() {
        return this.stopHeartbeating(Enclosing$.MODULE$.apply("js7.cluster.ClusterWatchSynchronizer#stop"));
    }

    public IO<Either<Problem, Option<ClusterWatchConfirmation>>> applyEvent(ClusterEvent event, ClusterState.HasNodes updatedClusterState, boolean clusterWatchIdChangeAllowed, boolean forceWhenUntaught) {
        ClusterEvent clusterEvent = event;
        if (clusterEvent instanceof ClusterEvent.ClusterPassiveLost) {
            return this.suspendHeartbeat((IO<ClusterState>)IO$.MODULE$.pure((Object)updatedClusterState), this.suspendHeartbeat$default$2(), this.clusterWatch.applyEvent(event, updatedClusterState, clusterWatchIdChangeAllowed, forceWhenUntaught), Enclosing$.MODULE$.apply("js7.cluster.ClusterWatchSynchronizer#applyEvent"));
        }
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.clusterWatch.applyEvent(event, updatedClusterState, clusterWatchIdChangeAllowed, this.clusterWatch.applyEvent$default$4()));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatTapT$extension(iO, (Function1 & Serializable)_$4 -> IO$.MODULE$.whenA(event instanceof ClusterEvent.ClusterWatchRegistered, () -> this.applyEvent$$anonfun$1$$anonfun$1(updatedClusterState)).as(Checked$.MODULE$.unit()), IO$.MODULE$.asyncForIO());
    }

    public boolean applyEvent$default$3() {
        return false;
    }

    public boolean applyEvent$default$4() {
        return false;
    }

    public <A> IO<Either<Problem, A>> suspendHeartbeat(IO<ClusterState> getClusterState, boolean forEvent, IO<Either<Problem, A>> io, Enclosing enclosing) {
        return Logger$syntax$.MODULE$.traceIO(ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger, this.startNestedSuspension(enclosing).$times$greater(io.flatTap((Function1 & Serializable)ioResult -> this.endNestedSuspension((IO<BoxedUnit>)getClusterState.flatMap((Function1 & Serializable)x$1 -> {
            ClusterState clusterState = x$1;
            if (clusterState instanceof ClusterState.HasNodes) {
                ClusterState.HasNodes clusterState2 = (ClusterState.HasNodes)clusterState;
                NodeId nodeId = clusterState2.activeId();
                NodeId nodeId2 = this.ownId;
                if (!(nodeId != null ? !((Object)nodeId).equals(nodeId2) : nodeId2 != null)) {
                    Either either = ioResult;
                    Left left = scala.package$.MODULE$.Left().apply((Object)ClusterWatchProblems$ClusterPassiveLostWhileFailedOverProblem$.MODULE$);
                    if (either == null ? left != null : !either.equals(left)) {
                        return MonixLikeExtensions$.MODULE$.tapError(this.continueHeartbeating(clusterState2, this.registerClusterWatchId.orThrow(), forEvent), (PartialFunction<Throwable, IO<BoxedUnit>>)new Serializable(enclosing){
                            private final Enclosing enclosing$3;
                            {
                                this.enclosing$3 = enclosing$7;
                            }

                            public final boolean isDefinedAt(Throwable x2) {
                                Throwable throwable = x2;
                                return true;
                            }

                            public final Object applyOrElse(Throwable x2, Function1 function1) {
                                Throwable throwable = x2;
                                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                                    this.applyOrElse$$anonfun$1(x2);
                                    return BoxedUnit.UNIT;
                                });
                            }

                            private final void applyOrElse$$anonfun$1(Throwable x$1) {
                                com.typesafe.scalalogging.Logger LoggerImpl_this = ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger;
                                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                                    Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(x$1);
                                    Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(x$1);
                                    LoggerImpl_this.underlying().warn("suspendHeartbeat called by " + this.enclosing$3.value() + ": " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable), ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable2));
                                    return;
                                }
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$adapted$1(java.lang.Throwable )}, serializedLambda);
                            }
                        });
                    }
                }
            }
            return IO$.MODULE$.unit();
        }))).guaranteeCase((Function1 & Serializable)x$1 -> {
            Outcome outcome = x$1;
            if (outcome instanceof Outcome.Succeeded) {
                package$.MODULE$.Outcome();
                Outcome.Succeeded succeeded = Outcome.Succeeded$.MODULE$.unapply((Outcome.Succeeded)outcome);
                IO iO = (IO)succeeded._1();
                return IO$.MODULE$.unit();
            }
            return this.endNestedSuspension((IO<BoxedUnit>)IO$.MODULE$.unit());
        })), Name$.MODULE$.apply("suspendHeartbeat"));
    }

    public boolean suspendHeartbeat$default$2() {
        return false;
    }

    private IO<BoxedUnit> startNestedSuspension(Enclosing enclosing) {
        return this.suspendNestingLock.lock(IO$.MODULE$.defer(() -> this.startNestedSuspension$$anonfun$1(enclosing)), enclosing);
    }

    private IO<BoxedUnit> endNestedSuspension(IO<BoxedUnit> onZeroNesting) {
        return this.suspendNestingLock.lock(IO$.MODULE$.defer(() -> this.endNestedSuspension$$anonfun$1(onZeroNesting)), Enclosing$.MODULE$.apply("js7.cluster.ClusterWatchSynchronizer#endNestedSuspension"));
    }

    private IO<BoxedUnit> restartHeartbeat() {
        return this.suspendNestingLock.lock(IO$.MODULE$.defer(this::restartHeartbeat$$anonfun$1), Enclosing$.MODULE$.apply("js7.cluster.ClusterWatchSynchronizer#restartHeartbeat"));
    }

    private IO<BoxedUnit> continueHeartbeating(ClusterState.HasNodes clusterState, Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>> registerClusterWatchId, boolean forEvent) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.js7$cluster$ClusterWatchSynchronizer$$doACheckedHeartbeat(clusterState, registerClusterWatchId, false, this.js7$cluster$ClusterWatchSynchronizer$$doACheckedHeartbeat$default$4()));
        IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichF_(ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO, BoxedUnit.UNIT, IO$.MODULE$.asyncForIO()));
        return Logger$syntax$.MODULE$.traceIO(ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger, ((IO)ScalaUtils$syntax$RichF_$.MODULE$.when$extension(iO2, !forEvent && clusterState.setting().clusterWatchId().isDefined(), (Monoid<Object>)IO$.MODULE$.monoidForIO(Semigroup$.MODULE$.catsKernelMonoidForEither((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit())))).$times$greater(IO$.MODULE$.defer(() -> this.continueHeartbeating$$anonfun$1(clusterState, registerClusterWatchId))), Name$.MODULE$.apply("continueHeartbeating"));
    }

    private IO<Completed$package$Completed$> startHeartbeating(ClusterState.HasNodes clusterState, Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>> registerClusterWatchId) {
        return Logger$syntax$.MODULE$.traceIO(ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger, IO$.MODULE$.defer(() -> this.startHeartbeating$$anonfun$1(clusterState, registerClusterWatchId)), Name$.MODULE$.apply("startHeartbeating"));
    }

    private IO<BoxedUnit> stopHeartbeating(Enclosing enclosing) {
        return IO$.MODULE$.defer(() -> this.stopHeartbeating$$anonfun$1(enclosing));
    }

    private void changeClusterState(ClusterState.HasNodes clusterState) {
        this.loop$1(clusterState, this.heartbeat.get());
    }

    public boolean isHeartbeating() {
        return this.heartbeat.get().isDefined();
    }

    public IO<Either<Problem, Option<ClusterWatchConfirmation>>> js7$cluster$ClusterWatchSynchronizer$$doACheckedHeartbeat(ClusterState.HasNodes clusterState, Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>> registerClusterWatchId, boolean clusterWatchIdChangeAllowed, boolean alreadyLocked) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(CatsEffectExtensions$.MODULE$.catchIntoChecked(this.clusterWatch.checkClusterState(clusterState, clusterWatchIdChangeAllowed, true)));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)x$1 -> {
            ClusterWatchConfirmation clusterWatchConfirmation;
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, None$.MODULE$);
            }
            if (option instanceof Some && (clusterWatchConfirmation = (ClusterWatchConfirmation)((Some)option).value()) != null) {
                ClusterWatchConfirmation confirmation = clusterWatchConfirmation;
                if (clusterState.setting().clusterWatchId().contains((Object)confirmation.clusterWatchId())) {
                    return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, Some$.MODULE$.apply((Object)confirmation));
                }
                if (clusterWatchIdChangeAllowed) {
                    IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(registerClusterWatchId.apply((Object)confirmation, (Object)BoxesRunTime.boxToBoolean((boolean)alreadyLocked)));
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        ClusterWatchSynchronizer.doACheckedHeartbeat$$anonfun$1$$anonfun$1(alreadyLocked);
                        return BoxedUnit.UNIT;
                    }).$times$greater((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO, () -> ClusterWatchSynchronizer.doACheckedHeartbeat$$anonfun$1$$anonfun$2(confirmation), IO$.MODULE$.asyncForIO()));
                }
                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> ClusterWatchSynchronizer.doACheckedHeartbeat$$anonfun$1$$anonfun$3(confirmation)), Problem$.MODULE$.apply$default$2()));
            }
            throw new MatchError((Object)option);
        }, IO$.MODULE$.asyncForIO());
    }

    public boolean js7$cluster$ClusterWatchSynchronizer$$doACheckedHeartbeat$default$4() {
        return false;
    }

    private final IO start$$anonfun$1(Function2 registerClusterWatchId$1, IO currentClusterState$1) {
        this.registerClusterWatchId.$colon$eq((Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>>)registerClusterWatchId$1);
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(currentClusterState$1.flatMap((Function1 & Serializable)clusterState -> {
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichF_(this.askClusterWatch((ClusterState.HasNodes)clusterState, (Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>>)registerClusterWatchId$1));
            return (IO)ScalaUtils$syntax$RichF_$.MODULE$.when$extension(iO, clusterState.setting().clusterWatchId().isDefined(), (Monoid<Object>)IO$.MODULE$.monoidForIO(Semigroup$.MODULE$.catsKernelMonoidForEither(Completed$package$Completed$.MODULE$.CompletedMonoid())));
        }));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$1 -> currentClusterState$1.flatMap((Function1 & Serializable)_$2 -> this.startHeartbeating((ClusterState.HasNodes)_$2, (Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>>)registerClusterWatchId$1).map((Function1 & Serializable)value -> scala.package$.MODULE$.Right().apply(value))), IO$.MODULE$.asyncForIO());
    }

    private final boolean v$proxy1$1(ClusterState.HasNodes clusterState$2) {
        NodeId nodeId = clusterState$2.activeId();
        NodeId nodeId2 = this.ownId;
        return !(nodeId != null ? !((Object)nodeId).equals(nodeId2) : nodeId2 != null);
    }

    private final IO askClusterWatch$$anonfun$1(ClusterState.HasNodes clusterState$1, Function2 registerClusterWatchId$5) {
        boolean logAsInfo;
        block0: {
            com.typesafe.scalalogging.Logger LoggerImpl_this;
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1(clusterState$1)), "clusterState.activeId == ownId"), FullName$.MODULE$.apply("js7.cluster.ClusterWatchSynchronizer.askClusterWatch"), FileName$.MODULE$.apply("ClusterWatchSynchronizer.scala"), Line$.MODULE$.apply(64));
            logAsInfo = clusterState$1 instanceof ClusterState.HasNodes;
            if (!logAsInfo || !(LoggerImpl_this = ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger).underlying().isInfoEnabled()) break block0;
            LoggerImpl_this.underlying().info("Asking ClusterWatch");
        }
        return this.js7$cluster$ClusterWatchSynchronizer$$doACheckedHeartbeat(clusterState$1, (Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>>)registerClusterWatchId$5, true, true).map((Function1 & Serializable)_$3 -> _$3.map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return Completed$package$Completed$.MODULE$;
            }
            if (option instanceof Some) {
                com.typesafe.scalalogging.Logger LoggerImpl_this;
                ClusterWatchConfirmation confirm = (ClusterWatchConfirmation)((Some)option).value();
                if (logAsInfo && (LoggerImpl_this = ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger).underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("{} agreed that this node is the active cluster node", (Object)confirm.confirmer());
                }
                return Completed$package$Completed$.MODULE$;
            }
            throw new MatchError((Object)option);
        }));
    }

    private final void applyEvent$$anonfun$1$$anonfun$1$$anonfun$1(ClusterState.HasNodes updatedClusterState$3) {
        this.changeClusterState(updatedClusterState$3);
    }

    private final IO applyEvent$$anonfun$1$$anonfun$1(ClusterState.HasNodes updatedClusterState$2) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.applyEvent$$anonfun$1$$anonfun$1$$anonfun$1(updatedClusterState$2);
            return BoxedUnit.UNIT;
        });
    }

    private final boolean v$proxy2$1() {
        return !this.isHeartbeating();
    }

    private final IO startNestedSuspension$$anonfun$1(Enclosing enclosing$4) {
        if (this.suspendNesting.getAndIncrement() == 0) {
            return this.stopHeartbeating(enclosing$4);
        }
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy2$1()), "!isHeartbeating"), FullName$.MODULE$.apply("js7.cluster.ClusterWatchSynchronizer.startNestedSuspension"), FileName$.MODULE$.apply("ClusterWatchSynchronizer.scala"), Line$.MODULE$.apply(140));
        return IO$.MODULE$.unit();
    }

    private final boolean v$proxy3$1() {
        return !this.isHeartbeating();
    }

    private static final IO endNestedSuspension$$anonfun$1$$anonfun$1(IO onZeroNesting$2) {
        return onZeroNesting$2;
    }

    private final IO endNestedSuspension$$anonfun$1(IO onZeroNesting$1) {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy3$1()), "!isHeartbeating"), FullName$.MODULE$.apply("js7.cluster.ClusterWatchSynchronizer.endNestedSuspension"), FileName$.MODULE$.apply("ClusterWatchSynchronizer.scala"), Line$.MODULE$.apply(146));
        return IO$.MODULE$.whenA(this.suspendNesting.decrementAndGet() == 0, () -> ClusterWatchSynchronizer.endNestedSuspension$$anonfun$1$$anonfun$1(onZeroNesting$1));
    }

    private final boolean v$proxy4$1() {
        return !this.isHeartbeating();
    }

    private final IO restartHeartbeat$$anonfun$1() {
        if (this.suspendNesting.getAndIncrement() == 0) {
            return this.stopHeartbeating(Enclosing$.MODULE$.apply("js7.cluster.ClusterWatchSynchronizer#restartHeartbeat"));
        }
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy4$1()), "!isHeartbeating"), FullName$.MODULE$.apply("js7.cluster.ClusterWatchSynchronizer.restartHeartbeat"), FileName$.MODULE$.apply("ClusterWatchSynchronizer.scala"), Line$.MODULE$.apply(156));
        return IO$.MODULE$.unit();
    }

    private static final IO continueHeartbeating$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private final IO continueHeartbeating$$anonfun$1(ClusterState.HasNodes clusterState$3, Function2 registerClusterWatchId$6) {
        Heartbeat h = new Heartbeat(this, clusterState$3, (Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>>)registerClusterWatchId$6);
        return ((IO)this.heartbeat.getAndSet((Option<Heartbeat>)Some$.MODULE$.apply((Object)h)).fold(ClusterWatchSynchronizer::continueHeartbeating$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$5 -> _$5.stop(Enclosing$.MODULE$.apply("js7.cluster.ClusterWatchSynchronizer#continueHeartbeating")))).$times$greater(h.start().void());
    }

    private static final IO startHeartbeating$$anonfun$1$$anonfun$1() {
        return CatsEffectExtensions$.MODULE$.inline$completedIO();
    }

    private final IO startHeartbeating$$anonfun$1(ClusterState.HasNodes clusterState$4, Function2 registerClusterWatchId$7) {
        Heartbeat h = new Heartbeat(this, clusterState$4, (Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>>)registerClusterWatchId$7);
        return ((IO)this.heartbeat.getAndSet((Option<Heartbeat>)Some$.MODULE$.apply((Object)h)).fold(ClusterWatchSynchronizer::startHeartbeating$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$6 -> _$6.stop(Enclosing$.MODULE$.apply("js7.cluster.ClusterWatchSynchronizer#startHeartbeating")).as((Object)Completed$package$Completed$.MODULE$))).$times$greater(h.start());
    }

    private static final IO stopHeartbeating$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private final IO stopHeartbeating$$anonfun$1(Enclosing enclosing$5) {
        block0: {
            com.typesafe.scalalogging.Logger LoggerImpl_this = ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger;
            if (!LoggerImpl_this.underlying().isTraceEnabled()) break block0;
            LoggerImpl_this.underlying().trace("stopHeartbeating called by {}", (Object)enclosing$5.value());
        }
        return (IO)this.heartbeat.getAndSet((Option<Heartbeat>)None$.MODULE$).fold(ClusterWatchSynchronizer::stopHeartbeating$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$7 -> _$7.stop(enclosing$5));
    }

    private final void loop$1(ClusterState.HasNodes clusterState$5, Option maybeHeartbeat) {
        Option<Heartbeat> option;
        block2: {
            while (true) {
                if (None$.MODULE$.equals(option = maybeHeartbeat)) {
                    return;
                }
                if (!(option instanceof Some)) break block2;
                Heartbeat h = (Heartbeat)((Some)option).value();
                h.changeClusterState(clusterState$5);
                Option<Heartbeat> h2 = this.heartbeat.get();
                if (h2 == maybeHeartbeat) break;
                maybeHeartbeat = h2;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final Object js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$start$$anonfun$2$$anonfun$1() {
        return Logger$syntax$.MODULE$.debugIO$default$3(ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger);
    }

    public static final /* synthetic */ IO js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$start$$anonfun$2$$anonfun$2$$anonfun$1(MVar _$8) {
        return (IO)_$8.tryRead();
    }

    public static final /* synthetic */ void js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$start$$anonfun$2$$anonfun$2$$anonfun$2(Option maybe) {
        if (maybe.isEmpty()) {
            com.typesafe.scalalogging.Logger LoggerImpl_this = ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error("Heartbeat stopped by itself");
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ IO js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$start$$anonfun$2$$anonfun$3$$anonfun$1(Fiber fiber$1, MVar _$9) {
        return (IO)_$9.tryPut(fiber$1);
    }

    private static final IO start$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1(Fiber fiber$3) {
        return ((IO)fiber$3.cancel()).$times$greater(IO$.MODULE$.raiseError((Throwable)new ConcurrentModificationException("Tried to start Cluster heartbeating twice")));
    }

    public static /* bridge */ /* synthetic */ IO js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$start$$anonfun$2$$anonfun$3$$anonfun$adapted$1(Fiber fiber$4, Object ok) {
        return IO$.MODULE$.whenA(!BoxesRunTime.unboxToBoolean((Object)ok), () -> ClusterWatchSynchronizer.start$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1(fiber$4));
    }

    public static final /* synthetic */ IO js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$stop$$anonfun$1(MVar _$10) {
        return (IO)_$10.tryPut(BoxedUnit.UNIT);
    }

    public static final /* synthetic */ IO js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$stop$$anonfun$3(MVar _$12) {
        return (IO)_$12.tryTake();
    }

    private static final IO stop$$anonfun$4$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    public static final /* synthetic */ IO js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$stop$$anonfun$4(Option _$13) {
        return (IO)_$13.fold(ClusterWatchSynchronizer::stop$$anonfun$4$$anonfun$1, (Function1 & Serializable)_$14 -> (IO)CatsEffectExtensions$.MODULE$.joinStd(_$14, IO$.MODULE$.asyncForIO()));
    }

    public static final /* synthetic */ IO js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$sendHeartbeats$$anonfun$1(MVar _$15) {
        return (IO)_$15.read();
    }

    public static final /* synthetic */ IO js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$sendHeartbeats$$anonfun$2$$anonfun$1(Throwable t) {
        block2: {
            Throwable throwable;
            com.typesafe.scalalogging.Logger LoggerImpl_this = ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger;
            if (!LoggerImpl_this.underlying().isWarnEnabled()) break block2;
            Logger logger = LoggerImpl_this.underlying();
            Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
            String string = "sendHeartbeats: " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable2);
            if (t instanceof AskTimeoutException) {
                throwable = null;
            } else {
                Throwable throwable3 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                throwable = ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable3);
            }
            logger.warn(string, throwable);
        }
        return IO$.MODULE$.raiseError(t);
    }

    public static final /* synthetic */ IO js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$sendHeartbeats$$anonfun$3(MVar _$17) {
        return (IO)_$17.read();
    }

    public static final /* synthetic */ IO js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$doAHeartbeat$$anonfun$1(MVar _$18) {
        return (IO)_$18.tryRead();
    }

    public static final /* synthetic */ IO js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$doAHeartbeat$$anonfun$2$$anonfun$1(MVar _$19) {
        return (IO)_$19.read();
    }

    public static final Completed$package$Completed$ js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$doAHeartbeat$$anonfun$2$$anonfun$2$$anonfun$1() {
        block0: {
            com.typesafe.scalalogging.Logger LoggerImpl_this = ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger;
            if (!LoggerImpl_this.underlying().isTraceEnabled()) break block0;
            LoggerImpl_this.underlying().trace("\u25fc\ufe0f doACheckedHeartbeat canceled due to `stopping`");
        }
        return Completed$package$Completed$.MODULE$;
    }

    public static final /* synthetic */ IO js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$doAHeartbeat$$anonfun$2$$anonfun$2$$anonfun$2(MVar _$20) {
        return (IO)_$20.tryRead();
    }

    public static final /* synthetic */ Completed$package$Completed$ js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$doAHeartbeat$$anonfun$2$$anonfun$2$$anonfun$3(Problem problem$1, Option x$1) {
        Option option = x$1;
        if (option instanceof Some) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object object = ((Some)option).value();
            if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                return Completed$package$Completed$.MODULE$;
            }
        }
        if (None$.MODULE$.equals(option)) {
            throw Halt$.MODULE$.haltJava("\ud83d\udd25 HALT because ClusterWatch heartbeat failed: " + problem$1, true, Halt$.MODULE$.haltJava$default$3());
        }
        throw new MatchError((Object)option);
    }

    private static final void doACheckedHeartbeat$$anonfun$1$$anonfun$1(boolean alreadyLocked$2) {
        com.typesafe.scalalogging.Logger LoggerImpl_this = ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("doACheckedHeartbeat: registerClusterWatchId(alreadyLocked={})", (Object)BoxesRunTime.boxToBoolean((boolean)alreadyLocked$2));
            return;
        }
    }

    private static final Some doACheckedHeartbeat$$anonfun$1$$anonfun$2(ClusterWatchConfirmation confirmation$1) {
        return Some$.MODULE$.apply((Object)confirmation$1);
    }

    private static final String doACheckedHeartbeat$$anonfun$1$$anonfun$3(ClusterWatchConfirmation confirmation$2) {
        return "New " + confirmation$2.clusterWatchId() + " cannot be registered now";
    }

    public final class Heartbeat {
        private final Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>> registerClusterWatchId;
        private volatile ClusterState.HasNodes clusterState;
        private final int nr;
        private final IO<MVar<IO, BoxedUnit>> stopping;
        private final IO<MVar<IO, Fiber<IO, Throwable, BoxedUnit>>> heartbeat;
        private final /* synthetic */ ClusterWatchSynchronizer $outer;

        public Heartbeat(ClusterWatchSynchronizer $outer, ClusterState.HasNodes initialClusterState, Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>> registerClusterWatchId) {
            this.registerClusterWatchId = registerClusterWatchId;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.clusterState = initialClusterState;
            this.nr = BoxesRunTime.unboxToInt((Object)ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$heartbeatSessionNr.next());
            this.stopping = (IO)UnsafeMemoizable$.MODULE$.unsafeMemoize(MVar$.MODULE$.empty(IO$.MODULE$.asyncForIO()), IO$.MODULE$.asyncForIO());
            this.heartbeat = (IO)UnsafeMemoizable$.MODULE$.unsafeMemoize(MVar$.MODULE$.empty(IO$.MODULE$.asyncForIO()), IO$.MODULE$.asyncForIO());
        }

        public IO<Completed$package$Completed$> start() {
            return CorrelId$.MODULE$.bindNew(this::start$$anonfun$2, CanBindCorrelId$.MODULE$.io());
        }

        public IO<BoxedUnit> stop(Enclosing enclosing) {
            return Logger$syntax$.MODULE$.traceIO(ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger, "Heartbeat (" + this.nr + ") stop, called by " + enclosing.value(), Logger$syntax$.MODULE$.traceIO$default$3(ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(this.stopping.flatMap(ClusterWatchSynchronizer::js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$stop$$anonfun$1).flatMap((Function1 & Serializable)_$11 -> this.stop$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)_$11))).flatMap(ClusterWatchSynchronizer::js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$stop$$anonfun$3).flatMap(ClusterWatchSynchronizer::js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$stop$$anonfun$4), enclosing));
        }

        public void changeClusterState(ClusterState.HasNodes clusterState) {
            this.clusterState = clusterState;
        }

        private IO<BoxedUnit> sendHeartbeats() {
            return ((IO)StreamExtensions$.MODULE$.interruptWhenF(StreamExtensions$.MODULE$.interruptWhenF(StreamExtensions$.MODULE$.prependOne(Stream$.MODULE$.fixedRate(this.$outer.js7$cluster$ClusterWatchSynchronizer$$timing.clusterWatchHeartbeat(), (GenTemporal)IO$.MODULE$.asyncForIO()), BoxedUnit.UNIT), this.stopping.flatMap(ClusterWatchSynchronizer::js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$sendHeartbeats$$anonfun$1), (ApplicativeError)IO$.MODULE$.asyncForIO()).evalMap((Function1 & Serializable)_$16 -> this.doAHeartbeat().handleErrorWith(ClusterWatchSynchronizer::js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$sendHeartbeats$$anonfun$2$$anonfun$1)), this.stopping.flatMap(ClusterWatchSynchronizer::js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$sendHeartbeats$$anonfun$3), (ApplicativeError)IO$.MODULE$.asyncForIO()).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain()).as((Object)BoxedUnit.UNIT);
        }

        private IO<Completed$package$Completed$> doAHeartbeat() {
            return this.stopping.flatMap(ClusterWatchSynchronizer::js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$doAHeartbeat$$anonfun$1).flatMap((Function1 & Serializable)x$12 -> {
                Option option = x$12;
                if (option instanceof Some) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = ((Some)option).value();
                    if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                        return CatsEffectExtensions$.MODULE$.inline$completedIO();
                    }
                }
                if (None$.MODULE$.equals(option)) {
                    ClusterState.HasNodes clusterState = this.clusterState;
                    return IO$.MODULE$.race(this.stopping.flatMap(ClusterWatchSynchronizer::js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$doAHeartbeat$$anonfun$2$$anonfun$1), this.$outer.js7$cluster$ClusterWatchSynchronizer$$doACheckedHeartbeat(clusterState, this.registerClusterWatchId, true, this.$outer.js7$cluster$ClusterWatchSynchronizer$$doACheckedHeartbeat$default$4())).flatMap((Function1 & Serializable)x$1 -> {
                        Either either = x$1;
                        if (either instanceof Left) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            Object object = ((Left)either).value();
                            if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                                return IO$.MODULE$.apply(ClusterWatchSynchronizer::js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$doAHeartbeat$$anonfun$2$$anonfun$2$$anonfun$1);
                            }
                        }
                        if (either instanceof Right) {
                            Either either2 = (Either)((Right)either).value();
                            if (either2 instanceof Left) {
                                Problem problem = (Problem)((Left)either2).value();
                                return this.stopping.flatMap(ClusterWatchSynchronizer::js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$doAHeartbeat$$anonfun$2$$anonfun$2$$anonfun$2).map(arg_0 -> ClusterWatchSynchronizer.js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$doAHeartbeat$$anonfun$2$$anonfun$2$$anonfun$3(problem, arg_0));
                            }
                            if (either2 instanceof Right) {
                                return IO$.MODULE$.pure((Object)Completed$package$Completed$.MODULE$);
                            }
                        }
                        throw new MatchError((Object)either);
                    });
                }
                throw new MatchError((Object)option);
            });
        }

        public final /* synthetic */ ClusterWatchSynchronizer js7$cluster$ClusterWatchSynchronizer$Heartbeat$$$outer() {
            return this.$outer;
        }

        private final IO start$$anonfun$2() {
            return Logger$syntax$.MODULE$.debugIO(ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger, "Heartbeat (" + this.nr + ") fiber", ClusterWatchSynchronizer::js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$start$$anonfun$2$$anonfun$1, this.sendHeartbeats().guaranteeCase((Function1 & Serializable)x$1 -> {
                Outcome outcome = x$1;
                if (outcome instanceof Outcome.Errored) {
                    Throwable throwable;
                    package$.MODULE$.Outcome();
                    Outcome.Errored errored = Outcome.Errored$.MODULE$.unapply((Outcome.Errored)outcome);
                    Throwable t = throwable = (Throwable)errored._1();
                    com.typesafe.scalalogging.Logger LoggerImpl_this = ClusterWatchSynchronizer$.js7$cluster$ClusterWatchSynchronizer$$$logger;
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                        Throwable throwable3 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                        LoggerImpl_this.underlying().warn("Sending heartbeat to ClusterWatch failed: " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable2), ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable3));
                    }
                    Throwable throwable4 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                    throw Halt$.MODULE$.haltJava("\ud83d\udd25 HALT after sending heartbeat to ClusterWatch failed: " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable4), true, Halt$.MODULE$.haltJava$default$3());
                }
                if (outcome instanceof Outcome.Canceled) {
                    package$.MODULE$.Outcome();
                    if (Outcome.Canceled$.MODULE$.unapply((Outcome.Canceled)outcome)) {
                        return IO$.MODULE$.unit();
                    }
                }
                if (outcome instanceof Outcome.Succeeded) {
                    package$.MODULE$.Outcome();
                    Outcome.Succeeded succeeded = Outcome.Succeeded$.MODULE$.unapply((Outcome.Succeeded)outcome);
                    IO iO = (IO)succeeded._1();
                    return this.stopping.flatMap(ClusterWatchSynchronizer::js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$start$$anonfun$2$$anonfun$2$$anonfun$1).map((Function1)((JProcedure1 & Serializable)ClusterWatchSynchronizer::js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$start$$anonfun$2$$anonfun$2$$anonfun$2));
                }
                throw new MatchError((Object)outcome);
            })).start().flatTap((Function1 & Serializable)fiber -> this.heartbeat.flatMap(arg_0 -> ClusterWatchSynchronizer.js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$start$$anonfun$2$$anonfun$3$$anonfun$1(fiber, arg_0)).flatMap(arg_0 -> ClusterWatchSynchronizer.js7$cluster$ClusterWatchSynchronizer$Heartbeat$$_$start$$anonfun$2$$anonfun$3$$anonfun$adapted$1(fiber, arg_0))).as((Object)Completed$package$Completed$.MODULE$);
        }

        private final /* synthetic */ IO stop$$anonfun$2(boolean _$11) {
            return this.heartbeat;
        }
    }
}

