/*
 * Decompiled with CFR 0.152.
 */
package js7.common.concurrent;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import scala.Predef$;
import scala.concurrent.ExecutionContext;

public final class ThrottledExecutionContext
implements ExecutionContext {
    private final ExecutionContext delegate;
    private final Semaphore semaphore;
    private final ConcurrentLinkedQueue<Runnable> queue;

    public ThrottledExecutionContext(int throttle, ExecutionContext delegate) {
        this.delegate = delegate;
        ExecutionContext.$init$((ExecutionContext)this);
        Predef$.MODULE$.require(throttle >= 1);
        this.semaphore = new Semaphore(throttle);
        this.queue = new ConcurrentLinkedQueue();
    }

    public void reportFailure(Throwable throwable) {
        this.delegate.reportFailure(throwable);
    }

    public void execute(Runnable runnable) {
        if (!this.enqueueIfThrottled(runnable)) {
            this.delegate.execute(new Runnable(runnable, this){
                private final Runnable runnable$1;
                private final /* synthetic */ ThrottledExecutionContext $outer;
                {
                    this.runnable$1 = runnable$3;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    this.$outer.js7$common$concurrent$ThrottledExecutionContext$$executeThisAndQueued(this.runnable$1);
                }
            });
            return;
        }
    }

    public void js7$common$concurrent$ThrottledExecutionContext$$executeThisAndQueued(Runnable runnable) {
        this.delegate.execute(new Runnable(runnable, this){
            private final Runnable runnable$2;
            private final /* synthetic */ ThrottledExecutionContext $outer;
            {
                this.runnable$2 = runnable$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.runnable$2.run();
                Runnable runnable = this.$outer.js7$common$concurrent$ThrottledExecutionContext$$tryDequeue();
                if (runnable == null) {
                    return;
                }
                Runnable next = runnable;
                this.$outer.js7$common$concurrent$ThrottledExecutionContext$$executeThisAndQueued(next);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean enqueueIfThrottled(Runnable runnable) {
        ThrottledExecutionContext throttledExecutionContext = this;
        synchronized (throttledExecutionContext) {
            if (this.semaphore.tryAcquire()) return false;
            this.queue.add(runnable);
            if (!true) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Runnable js7$common$concurrent$ThrottledExecutionContext$$tryDequeue() {
        void var2_3;
        ThrottledExecutionContext throttledExecutionContext = this;
        synchronized (throttledExecutionContext) {
            void var3_2;
            Runnable next = this.queue.poll();
            if (next == null) {
                this.semaphore.release();
            }
            var2_3 = var3_2;
        }
        return var2_3;
    }
}

