/*
 * Decompiled with CFR 0.152.
 */
package js7.controller;

import cats.Applicative;
import cats.UnorderedFoldable$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.unsafe.IORuntime;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import fs2.Stream;
import fs2.Stream$;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.auth.SimpleUser;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.crypt.SignedString;
import js7.base.eventbus.StandardEventBus;
import js7.base.generic.Completed$package$Completed$;
import js7.base.log.CorrelId$;
import js7.base.log.Logger$syntax$;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.problem.Problems$ShuttingDownProblem$;
import js7.base.service.MainService;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.thread.CatsBlocking$syntax$;
import js7.base.thread.Futures$implicits$;
import js7.base.thread.Futures$implicits$SuccessFuture$;
import js7.base.time.AlarmClock;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.WaitForCondition$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.ProgramTermination;
import js7.base.utils.ProgramTermination$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.web.Uri;
import js7.cluster.ClusterNode;
import js7.cluster.watch.ClusterWatchService;
import js7.common.pekkohttp.web.PekkoWebServer;
import js7.common.pekkohttp.web.session.SessionRegister;
import js7.common.pekkohttp.web.session.SimpleSession;
import js7.controller.ControllerOrderKeeper;
import js7.controller.ControllerOrderKeeper$Command$Execute$;
import js7.controller.ControllerOrderKeeper$Command$VerifiedUpdateItemsCmd$;
import js7.controller.OrderApi;
import js7.controller.RunningController$;
import js7.controller.RunningController$OrderKeeperStarted$;
import js7.controller.RunningController$TestWiring$;
import js7.controller.command.ControllerCommandExecutor;
import js7.controller.configuration.ControllerConfiguration;
import js7.controller.item.ItemUpdater;
import js7.controller.problems.package$ControllerIsShuttingDownProblem$;
import js7.core.command.CommandExecutor;
import js7.core.command.CommandMeta;
import js7.core.command.CommandMeta$;
import js7.data.Problems$ClusterNodeIsNotActiveProblem$;
import js7.data.Problems$PassiveClusterNodeShutdownNotAllowedProblem$;
import js7.data.agent.AgentPath;
import js7.data.cluster.ClusterState;
import js7.data.controller.ControllerCommand;
import js7.data.controller.ControllerCommand$AddOrder$;
import js7.data.controller.ControllerCommand$ClusterAppointNodes$;
import js7.data.controller.ControllerCommand$Response$Accepted$;
import js7.data.controller.ControllerCommand$ShutDown$;
import js7.data.controller.ControllerState;
import js7.data.controller.VerifiedUpdateItems;
import js7.data.controller.VerifiedUpdateItems$;
import js7.data.crypt.SignedItemVerifier;
import js7.data.item.ItemOperation;
import js7.data.item.ItemOperation$AddOrChangeSimple$;
import js7.data.item.SignableItem;
import js7.data.item.UnsignedSimpleItem;
import js7.data.node.NodeId;
import js7.data.order.FreshOrder;
import js7.journal.EventIdGenerator;
import js7.journal.JournalActor;
import js7.journal.JournalActor$Input$GetJournalActorState$;
import js7.journal.watch.StrictEventWatch;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import sourcecode.Enclosing;
import sourcecode.Enclosing$;
import sourcecode.FileName;
import sourcecode.FileName$;
import sourcecode.Line;
import sourcecode.Line$;
import sourcecode.Name$;

public final class RunningController
implements Service,
MainService,
StoppableByRequest,
Service.StoppableByRequest {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RunningController.class.getDeclaredField("localUri$lzy1"));
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private final StrictEventWatch eventWatch;
    private final PekkoWebServer webServer;
    private final long recoveredEventId;
    private final OrderApi orderApi;
    private final IO controllerState;
    private final ControllerCommandExecutor commandExecutor;
    private final ItemUpdater itemUpdater;
    private final Future<BoxedUnit> whenReady;
    private final Future terminated;
    private final Function1 clusterWatchServiceFor;
    private final SessionRegister sessionRegister;
    private final ControllerConfiguration conf;
    private final StandardEventBus testEventBus;
    private final ActorSystem actorSystem;
    private final IORuntime ioRuntime;
    private volatile Object localUri$lzy1;
    private final IO untilTerminated;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RunningController$.class.getDeclaredField("logger$lzy1"));

    public static ProgramTermination blockingRun(ControllerConfiguration controllerConfiguration, FiniteDuration finiteDuration, Function1<RunningController, BoxedUnit> function1) {
        return RunningController$.MODULE$.blockingRun(controllerConfiguration, finiteDuration, function1);
    }

    public static <F> Resource<F, IORuntime> ioRuntimeResource(ControllerConfiguration controllerConfiguration, Sync<F> sync) {
        return RunningController$.MODULE$.ioRuntimeResource(controllerConfiguration, sync);
    }

    public static Resource<IO, RunningController> resource(ControllerConfiguration controllerConfiguration, TestWiring testWiring, IORuntime iORuntime) {
        return RunningController$.MODULE$.resource(controllerConfiguration, testWiring, iORuntime);
    }

    public static TestWiring resource$default$2() {
        return RunningController$.MODULE$.resource$default$2();
    }

    public RunningController(StrictEventWatch eventWatch, PekkoWebServer webServer, long recoveredEventId, OrderApi orderApi, IO<ControllerState> controllerState, ControllerCommandExecutor commandExecutor, ItemUpdater itemUpdater, Future<BoxedUnit> whenReady, Future<ProgramTermination> terminated, Function1<AgentPath, IO<Either<Problem, ClusterWatchService>>> clusterWatchServiceFor, SessionRegister<SimpleSession> sessionRegister, ControllerConfiguration conf, StandardEventBus<Object> testEventBus, ActorSystem actorSystem, IORuntime ioRuntime) {
        this.eventWatch = eventWatch;
        this.webServer = webServer;
        this.recoveredEventId = recoveredEventId;
        this.orderApi = orderApi;
        this.controllerState = controllerState;
        this.commandExecutor = commandExecutor;
        this.itemUpdater = itemUpdater;
        this.whenReady = whenReady;
        this.terminated = terminated;
        this.clusterWatchServiceFor = clusterWatchServiceFor;
        this.sessionRegister = sessionRegister;
        this.conf = conf;
        this.testEventBus = testEventBus;
        this.actorSystem = actorSystem;
        this.ioRuntime = ioRuntime;
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        this.untilTerminated = CatsEffectExtensions$.MODULE$.fromFutureDummyCancelable(IO$.MODULE$, IO$.MODULE$.pure(terminated));
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    public StrictEventWatch eventWatch() {
        return this.eventWatch;
    }

    public PekkoWebServer webServer() {
        return this.webServer;
    }

    public long recoveredEventId() {
        return this.recoveredEventId;
    }

    public OrderApi orderApi() {
        return this.orderApi;
    }

    public IO<ControllerState> controllerState() {
        return this.controllerState;
    }

    public Future<ProgramTermination> terminated() {
        return this.terminated;
    }

    public Function1<AgentPath, IO<Either<Problem, ClusterWatchService>>> clusterWatchServiceFor() {
        return this.clusterWatchServiceFor;
    }

    public SessionRegister<SimpleSession> sessionRegister() {
        return this.sessionRegister;
    }

    public ControllerConfiguration conf() {
        return this.conf;
    }

    public StandardEventBus<Object> testEventBus() {
        return this.testEventBus;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public IORuntime ioRuntime() {
        return this.ioRuntime;
    }

    public Uri localUri() {
        Object object = this.localUri$lzy1;
        if (object instanceof Uri) {
            return (Uri)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Uri)this.localUri$lzyINIT1();
    }

    private Object localUri$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.localUri$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Uri uri = null;
                    try {
                        uri = this.webServer().localUri();
                        object2 = uri == null ? LazyVals.NullValue$.MODULE$ : uri;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.localUri$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return uri;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public IO<ProgramTermination> untilTerminated() {
        return this.untilTerminated;
    }

    @Override
    public IO<Service.Started> start() {
        return this.startService(this.untilStopRequested().$times$greater(this.shutdown(ControllerCommand$ShutDown$.MODULE$.apply(ControllerCommand$ShutDown$.MODULE$.$lessinit$greater$default$1(), ControllerCommand$ShutDown$.MODULE$.$lessinit$greater$default$2(), ControllerCommand$ShutDown$.MODULE$.$lessinit$greater$default$3(), ControllerCommand$ShutDown$.MODULE$.$lessinit$greater$default$4())).void()));
    }

    public IO<ProgramTermination> shutdown(ControllerCommand.ShutDown cmd) {
        return IO$.MODULE$.defer(() -> this.shutdown$$anonfun$1(cmd));
    }

    private IO<Either<Problem, ControllerCommand.Response>> executeCommandAsSystemUser(ControllerCommand command) {
        return this.sessionRegister().systemSession().flatMap((Function1 & Serializable)checkedSession -> ((IO)package.traverse$.MODULE$.toTraverseOps(checkedSession, UnorderedFoldable$.MODULE$.catsTraverseForEither()).traverse((Function1 & Serializable)session -> this.executeCommand(command, CommandMeta$.MODULE$.apply(session.currentUser())), (Applicative)IO$.MODULE$.asyncForIO())).map((Function1 & Serializable)checkedChecked -> checkedChecked.flatten((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    private IO<Either<Problem, ControllerCommand.Response>> executeCommand(ControllerCommand command, CommandMeta meta) {
        Logger logger = RunningController$.MODULE$.js7$controller$RunningController$$$logger();
        return Logger$syntax$.MODULE$.debugIO(logger, "executeCommand " + command.toShortString(), () -> RunningController.executeCommand$$anonfun$1(logger), this.commandExecutor.executeCommand(command, meta)).evalOn(this.ioRuntime().compute());
    }

    public IO<Either<Problem, Completed$package$Completed$>> updateUnsignedSimpleItemsAsSystemUser(Seq<UnsignedSimpleItem> items) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.sessionRegister().systemUser());
        return ((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$2 -> this.updateUnsignedSimpleItems((SimpleUser)_$2, items), IO$.MODULE$.asyncForIO())).evalOn(this.ioRuntime().compute());
    }

    private IO<Either<Problem, Completed$package$Completed$>> updateUnsignedSimpleItems(SimpleUser user, Seq<UnsignedSimpleItem> items) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(VerifiedUpdateItems$.MODULE$.fromOperations((Stream<IO, ItemOperation>)Stream$.MODULE$.iterable(items).map((Function1 & Serializable)item -> ItemOperation$AddOrChangeSimple$.MODULE$.apply((UnsignedSimpleItem)item)), (Function1<SignedString, Either<Problem, SignedItemVerifier.Verified<SignableItem>>>)(Function1 & Serializable)_$3 -> package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("updateUnsignedSimpleItems and verify?")), user));
        return ((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)verifiedUpdateItems -> this.itemUpdater.updateItems((VerifiedUpdateItems)verifiedUpdateItems), IO$.MODULE$.asyncForIO())).evalOn(this.ioRuntime().compute());
    }

    public IO<Either<Problem, Completed$package$Completed$>> updateItemsAsSystemUser(Stream<IO, ItemOperation> operations) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.sessionRegister().systemUser());
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$4 -> this.updateItems((SimpleUser)_$4, operations), IO$.MODULE$.asyncForIO());
    }

    private IO<Either<Problem, Completed$package$Completed$>> updateItems(SimpleUser user, Stream<IO, ItemOperation> operations) {
        SignedItemVerifier<SignableItem> signedItemVerifier = this.itemUpdater.signedItemVerifier();
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(VerifiedUpdateItems$.MODULE$.fromOperations(operations, (Function1<SignedString, Either<Problem, SignedItemVerifier.Verified<SignableItem>>>)(Function1 & Serializable)signedString -> signedItemVerifier.verify((SignedString)signedString), user));
        return ((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)verifiedUpdateItems -> this.itemUpdater.updateItems((VerifiedUpdateItems)verifiedUpdateItems), IO$.MODULE$.asyncForIO())).evalOn(this.ioRuntime().compute());
    }

    public IO<Either<Problem, BoxedUnit>> addOrder(FreshOrder order) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.executeCommandAsSystemUser(ControllerCommand$AddOrder$.MODULE$.apply(order)));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.mapT$extension(iO, (Function1 & Serializable)response -> ScalaUtils$syntax$RichBoolean$.MODULE$.$bang$bang$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(!response.ignoredBecauseDuplicate()), (Function0<Problem>)((Function0 & Serializable)() -> RunningController.addOrder$$anonfun$1$$anonfun$1(order))), IO$.MODULE$.asyncForIO());
    }

    public void waitUntilReady(Enclosing x$1, FileName x$2, Line x$3) {
        CatsBlocking$syntax$.MODULE$.await(CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(this.untilReady(), x$1), (Duration)ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(99)), Tag$.MODULE$.apply(Void.TYPE, LightTypeTag$.MODULE$.parse(1202990665, "\u0004\u0000\u0001\nscala.Unit\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\nscala.Unit\u0001\u0001\u0001\u0004\u0000\u0001\fscala.AnyVal\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30)), this.ioRuntime(), x$1, x$2, x$3);
    }

    public IO<BoxedUnit> untilReady() {
        return CatsEffectExtensions$.MODULE$.fromFutureDummyCancelable(IO$.MODULE$, IO$.MODULE$.apply(this::untilReady$$anonfun$1));
    }

    public IO<ClusterState> clusterState() {
        return this.controllerState().map((Function1 & Serializable)_$5 -> _$5.clusterState());
    }

    public JournalActor.Output.JournalActorState journalActorState() {
        ActorSelection actorSel = this.actorSystem().actorSelection("user/Journal");
        FiniteDuration finiteDuration = ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(10));
        FiniteDuration finiteDuration2 = ScalaTime$DurationRichInt$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichInt(10));
        WaitForCondition$.MODULE$.waitForCondition(finiteDuration, finiteDuration2, (Function0<Object>)((Function0 & Serializable)() -> RunningController.journalActorState$$anonfun$1(actorSel)), WaitForCondition$.MODULE$.waitForCondition$default$4(finiteDuration, finiteDuration2, (Function0<Object>)((Function0 & Serializable)() -> RunningController.journalActorState$$anonfun$2(actorSel))));
        Future future = Futures$implicits$.MODULE$.SuccessFuture(actorSel.resolveOne(ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(99))));
        ActorRef actor = (ActorRef)Futures$implicits$SuccessFuture$.MODULE$.await$extension(future, ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(99)), Tag$.MODULE$.apply(ActorRef.class, LightTypeTag$.MODULE$.parse(-1030473022, "\u0004\u0000\u0001\u001forg.apache.pekko.actor.ActorRef\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001forg.apache.pekko.actor.ActorRef\u0001\u0001\u0002\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0001\u0001\u0014java.lang.Comparable\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 30)), Enclosing$.MODULE$.apply("js7.controller.RunningController#journalActorState actor"), FileName$.MODULE$.apply("RunningController.scala"), Line$.MODULE$.apply(192));
        ActorRef actorRef = org.apache.pekko.pattern.package$.MODULE$.ask(actor);
        JournalActor$Input$GetJournalActorState$ journalActor$Input$GetJournalActorState$ = JournalActor$Input$GetJournalActorState$.MODULE$;
        Future future2 = Futures$implicits$.MODULE$.SuccessFuture(AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)journalActor$Input$GetJournalActorState$, Timeout$.MODULE$.apply(ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(99))), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)journalActor$Input$GetJournalActorState$)).mapTo(ClassTag$.MODULE$.apply(JournalActor.Output.JournalActorState.class)));
        return (JournalActor.Output.JournalActorState)Futures$implicits$SuccessFuture$.MODULE$.await$extension(future2, ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(99)), Tag$.MODULE$.apply(JournalActor.Output.JournalActorState.class, LightTypeTag$.MODULE$.parse(1428621773, "\u0004\u0000\u00013js7.journal.JournalActor$.Output$.JournalActorState\u0001\u0002\u0003\u0000\u0000 js7.journal.JournalActor$.Output\u0001\u0002\u0003\u0000\u0000\u0018js7.journal.JournalActor\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u00013js7.journal.JournalActor$.Output$.JournalActorState\u0001\u0002\u0003\u0000\u0000 js7.journal.JournalActor$.Output\u0001\u0002\u0003\u0000\u0000\u0018js7.journal.JournalActor\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0001\u0003\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 30)), Enclosing$.MODULE$.apply("js7.controller.RunningController#journalActorState"), FileName$.MODULE$.apply("RunningController.scala"), Line$.MODULE$.apply(195));
    }

    private final IO shutdown$$anonfun$1(ControllerCommand.ShutDown cmd$1) {
        if (this.terminated().isCompleted()) {
            return this.untilTerminated();
        }
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.executeCommandAsSystemUser(cmd$1));
        IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO, BoxedUnit.UNIT, IO$.MODULE$.asyncForIO()));
        return Logger$syntax$.MODULE$.debugIO(RunningController$.MODULE$.js7$controller$RunningController$$$logger(), ((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapLeftCase$extension(iO2, new Serializable(){

            public final boolean isDefinedAt(Problem x2) {
                Problem problem = x2;
                if (((Object)package$ControllerIsShuttingDownProblem$.MODULE$).equals(problem)) {
                    Problem problem2 = problem;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Problem x2, Function1 function1) {
                Problem problem = x2;
                if (((Object)package$ControllerIsShuttingDownProblem$.MODULE$).equals(problem)) {
                    Problem problem2 = problem;
                    Logger LoggerImpl_this = RunningController$.MODULE$.js7$controller$RunningController$$$logger();
                    if (LoggerImpl_this.underlying().isInfoEnabled()) {
                        LoggerImpl_this.underlying().info(problem2.toString());
                    }
                    return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, BoxedUnit.UNIT);
                }
                return function1.apply((Object)x2);
            }
        }, IO$.MODULE$.asyncForIO())).map((Function1)(JProcedure1 & Serializable)_$1 -> {
            Either either = Checked$.MODULE$.Ops(_$1);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Checked$Ops$.MODULE$.orThrow$extension(either);
        }).$times$greater(this.untilTerminated()), Name$.MODULE$.apply("shutdown"));
    }

    private static final Object executeCommand$$anonfun$1(Logger logger$1$1) {
        return Logger$syntax$.MODULE$.debugIO$default$3(logger$1$1);
    }

    private static final String addOrder$$anonfun$1$$anonfun$1$$anonfun$1(FreshOrder order$3) {
        return "Duplicate OrderId '" + order$3.id() + "'";
    }

    private static final Problem addOrder$$anonfun$1$$anonfun$1(FreshOrder order$2) {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> RunningController.addOrder$$anonfun$1$$anonfun$1$$anonfun$1(order$2)), Problem$.MODULE$.apply$default$2());
    }

    private final Future untilReady$$anonfun$1() {
        return this.whenReady;
    }

    private static final ActorRef condition$1$1$$anonfun$1(ActorSelection actorSel$2) {
        Future future = Futures$implicits$.MODULE$.SuccessFuture(actorSel$2.resolveOne(ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(99))));
        return (ActorRef)Futures$implicits$SuccessFuture$.MODULE$.await$extension(future, ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(99)), Tag$.MODULE$.apply(ActorRef.class, LightTypeTag$.MODULE$.parse(-1030473022, "\u0004\u0000\u0001\u001forg.apache.pekko.actor.ActorRef\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001forg.apache.pekko.actor.ActorRef\u0001\u0001\u0002\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0001\u0001\u0014java.lang.Comparable\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 30)), Enclosing$.MODULE$.apply("js7.controller.RunningController#journalActorState condition$1"), FileName$.MODULE$.apply("RunningController.scala"), Line$.MODULE$.apply(191));
    }

    private static final boolean condition$1$1(ActorSelection actorSel$1) {
        return Try$.MODULE$.apply(() -> RunningController.condition$1$1$$anonfun$1(actorSel$1)).isSuccess();
    }

    private static final boolean journalActorState$$anonfun$1(ActorSelection actorSel$3) {
        return RunningController.condition$1$1(actorSel$3);
    }

    private static final boolean journalActorState$$anonfun$2(ActorSelection actorSel$4) {
        return RunningController.condition$1$1(actorSel$4);
    }

    public static class MyCommandExecutor
    implements CommandExecutor<ControllerCommand> {
        private final ClusterNode<ControllerState> clusterNode;
        private final IO<Either<Problem, ActorRef>> orderKeeperActor;
        private final Timeout timeout;

        public MyCommandExecutor(ClusterNode<ControllerState> clusterNode, IO<Either<Problem, ActorRef>> orderKeeperActor, Timeout timeout) {
            this.clusterNode = clusterNode;
            this.orderKeeperActor = orderKeeperActor;
            this.timeout = timeout;
        }

        @Override
        public IO<Either<Problem, ControllerCommand.Response>> executeCommand(ControllerCommand command, CommandMeta meta) {
            IO iO;
            ControllerCommand controllerCommand = command;
            if (controllerCommand instanceof ControllerCommand.ShutDown) {
                ControllerCommand.ShutDown command2 = (ControllerCommand.ShutDown)controllerCommand;
                Logger LoggerImpl_this = RunningController$.MODULE$.js7$controller$RunningController$$$logger();
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("\u2757 {}", (Object)command2);
                }
                if (command2.clusterAction().nonEmpty() && !this.clusterNode.isWorkingNode()) {
                    iO = IO$.MODULE$.pure((Object)package$.MODULE$.Left().apply((Object)Problems$PassiveClusterNodeShutdownNotAllowedProblem$.MODULE$));
                } else {
                    if (command2.dontNotifyActiveNode() && this.clusterNode.isPassive()) {
                        this.clusterNode.dontNotifyActiveNodeAboutShutdown();
                    }
                    iO = this.clusterNode.stopRecovery(ProgramTermination$.MODULE$.apply(command2.restart())).$greater$greater(() -> this.executeCommand$$anonfun$2(command2, meta));
                }
            } else if (controllerCommand instanceof ControllerCommand.ClusterAppointNodes) {
                ControllerCommand.ClusterAppointNodes clusterAppointNodes = ControllerCommand$ClusterAppointNodes$.MODULE$.unapply((ControllerCommand.ClusterAppointNodes)controllerCommand);
                Map<NodeId, Uri> map = clusterAppointNodes._1();
                NodeId nodeId = clusterAppointNodes._2();
                Map<NodeId, Uri> idToUri = map;
                NodeId activeId = nodeId;
                IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(this::executeCommand$$anonfun$3));
                IO iO3 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO2, arg_0 -> RunningController$.js7$controller$RunningController$MyCommandExecutor$$_$executeCommand$$anonfun$4(idToUri, activeId, arg_0), IO$.MODULE$.asyncForIO()));
                iO = (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO3, RunningController$::js7$controller$RunningController$MyCommandExecutor$$_$executeCommand$$anonfun$5, IO$.MODULE$.asyncForIO());
            } else {
                IO iO4 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.orderKeeperActor);
                iO = (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO4, (Function1 & Serializable)actor -> MonixLikeExtensions$.MODULE$.deferFuture(IO$.MODULE$, () -> this.executeCommand$$anonfun$6$$anonfun$1(actor, command, meta)), IO$.MODULE$.asyncForIO());
            }
            return iO.map(RunningController$::js7$controller$RunningController$MyCommandExecutor$$_$executeCommand$$anonfun$7);
        }

        private final Future executeCommand$$anonfun$2$$anonfun$1$$anonfun$1(ActorRef actor$2, ControllerCommand.ShutDown command$3, CommandMeta meta$1) {
            ActorRef actorRef = org.apache.pekko.pattern.package$.MODULE$.ask(actor$2);
            ControllerOrderKeeper.Command.Execute execute = ControllerOrderKeeper$Command$Execute$.MODULE$.apply(command$3, meta$1, CorrelId$.MODULE$.current());
            return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)execute, this.timeout, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)execute)).mapTo(ClassTag$.MODULE$.apply(Either.class));
        }

        private final IO executeCommand$$anonfun$2(ControllerCommand.ShutDown command$4, CommandMeta meta$2) {
            return this.orderKeeperActor.flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Problem problem = (Problem)((Left)either).value();
                    if (((Object)Problems$ClusterNodeIsNotActiveProblem$.MODULE$).equals(problem) || ((Object)Problems$ShuttingDownProblem$.MODULE$).equals(problem)) {
                        return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, ControllerCommand$Response$Accepted$.MODULE$);
                    }
                    Problem problem2 = problem;
                    return IO$.MODULE$.pure((Object)package$.MODULE$.Left().apply((Object)problem2));
                }
                if (either instanceof Right) {
                    ActorRef actor = (ActorRef)((Right)either).value();
                    return MonixLikeExtensions$.MODULE$.deferFuture(IO$.MODULE$, () -> this.executeCommand$$anonfun$2$$anonfun$1$$anonfun$1(actor, command$4, meta$2));
                }
                throw new MatchError((Object)either);
            });
        }

        private final Either executeCommand$$anonfun$3() {
            return this.clusterNode.workingClusterNode();
        }

        private final Future executeCommand$$anonfun$6$$anonfun$1(ActorRef actor$3, ControllerCommand command$6, CommandMeta meta$4) {
            ActorRef actorRef = org.apache.pekko.pattern.package$.MODULE$.ask(actor$3);
            ControllerOrderKeeper.Command.Execute execute = ControllerOrderKeeper$Command$Execute$.MODULE$.apply(command$6, meta$4, CorrelId$.MODULE$.current());
            return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)execute, this.timeout, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)execute)).mapTo(ClassTag$.MODULE$.apply(Either.class));
        }
    }

    public static class MyItemUpdater
    implements ItemUpdater {
        private final SignedItemVerifier signedItemVerifier;
        private final IO<Either<Problem, ActorRef>> orderKeeperActor;
        private final Timeout timeout;

        public MyItemUpdater(SignedItemVerifier<SignableItem> signedItemVerifier, IO<Either<Problem, ActorRef>> orderKeeperActor, Timeout timeout) {
            this.signedItemVerifier = signedItemVerifier;
            this.orderKeeperActor = orderKeeperActor;
            this.timeout = timeout;
        }

        @Override
        public SignedItemVerifier<SignableItem> signedItemVerifier() {
            return this.signedItemVerifier;
        }

        @Override
        public IO<Either<Problem, Completed$package$Completed$>> updateItems(VerifiedUpdateItems verifiedUpdateItems) {
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.orderKeeperActor);
            return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)actor -> MonixLikeExtensions$.MODULE$.deferFuture(IO$.MODULE$, () -> this.updateItems$$anonfun$3$$anonfun$1(actor, verifiedUpdateItems)), IO$.MODULE$.asyncForIO());
        }

        private final Future updateItems$$anonfun$3$$anonfun$1(ActorRef actor$4, VerifiedUpdateItems verifiedUpdateItems$1) {
            ActorRef actorRef = org.apache.pekko.pattern.package$.MODULE$.ask(actor$4);
            ControllerOrderKeeper.Command.VerifiedUpdateItemsCmd verifiedUpdateItemsCmd = ControllerOrderKeeper$Command$VerifiedUpdateItemsCmd$.MODULE$.apply(verifiedUpdateItems$1);
            return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)verifiedUpdateItemsCmd, this.timeout, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)verifiedUpdateItemsCmd)).mapTo(ClassTag$.MODULE$.apply(Either.class));
        }
    }

    public static class OrderKeeperStarted
    implements Product,
    Serializable {
        private final ActorRef actor;
        private final Future termination;

        public static OrderKeeperStarted apply(ActorRef actorRef, Future<ProgramTermination> future) {
            return RunningController$OrderKeeperStarted$.MODULE$.apply(actorRef, future);
        }

        public static OrderKeeperStarted fromProduct(Product product) {
            return RunningController$OrderKeeperStarted$.MODULE$.fromProduct(product);
        }

        public static OrderKeeperStarted unapply(OrderKeeperStarted orderKeeperStarted) {
            return RunningController$OrderKeeperStarted$.MODULE$.unapply(orderKeeperStarted);
        }

        public OrderKeeperStarted(ActorRef actor, Future<ProgramTermination> termination) {
            this.actor = actor;
            this.termination = termination;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OrderKeeperStarted)) return false;
            OrderKeeperStarted orderKeeperStarted = (OrderKeeperStarted)object;
            ActorRef actorRef = this.actor();
            ActorRef actorRef2 = orderKeeperStarted.actor();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            Future<ProgramTermination> future = this.termination();
            Future<ProgramTermination> future2 = orderKeeperStarted.termination();
            if (future == null) {
                if (future2 != null) {
                    return false;
                }
            } else if (!future.equals(future2)) return false;
            if (!orderKeeperStarted.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OrderKeeperStarted;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "OrderKeeperStarted";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "actor";
            }
            if (1 == n2) {
                return "termination";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef actor() {
            return this.actor;
        }

        public Future<ProgramTermination> termination() {
            return this.termination;
        }

        public OrderKeeperStarted copy(ActorRef actor, Future<ProgramTermination> termination) {
            return new OrderKeeperStarted(actor, termination);
        }

        public ActorRef copy$default$1() {
            return this.actor();
        }

        public Future<ProgramTermination> copy$default$2() {
            return this.termination();
        }

        public ActorRef _1() {
            return this.actor();
        }

        public Future<ProgramTermination> _2() {
            return this.termination();
        }
    }

    public static final class TestWiring
    implements Product,
    Serializable {
        private final Option alarmClock;
        private final Option eventIdGenerator;

        public static TestWiring apply(Option<AlarmClock> option, Option<EventIdGenerator> option2) {
            return RunningController$TestWiring$.MODULE$.apply(option, option2);
        }

        public static TestWiring empty() {
            return RunningController$TestWiring$.MODULE$.empty();
        }

        public static TestWiring fromProduct(Product product) {
            return RunningController$TestWiring$.MODULE$.fromProduct(product);
        }

        public static TestWiring unapply(TestWiring testWiring) {
            return RunningController$TestWiring$.MODULE$.unapply(testWiring);
        }

        public static Option<AlarmClock> $lessinit$greater$default$1() {
            return RunningController$TestWiring$.MODULE$.$lessinit$greater$default$1();
        }

        public static Option<EventIdGenerator> $lessinit$greater$default$2() {
            return RunningController$TestWiring$.MODULE$.$lessinit$greater$default$2();
        }

        public TestWiring(Option<AlarmClock> alarmClock, Option<EventIdGenerator> eventIdGenerator) {
            this.alarmClock = alarmClock;
            this.eventIdGenerator = eventIdGenerator;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TestWiring)) return false;
            TestWiring testWiring = (TestWiring)object;
            Option<AlarmClock> option = this.alarmClock();
            Option<AlarmClock> option2 = testWiring.alarmClock();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<EventIdGenerator> option3 = this.eventIdGenerator();
            Option<EventIdGenerator> option4 = testWiring.eventIdGenerator();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TestWiring;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "TestWiring";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "alarmClock";
            }
            if (1 == n2) {
                return "eventIdGenerator";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<AlarmClock> alarmClock() {
            return this.alarmClock;
        }

        public Option<EventIdGenerator> eventIdGenerator() {
            return this.eventIdGenerator;
        }

        public TestWiring copy(Option<AlarmClock> alarmClock, Option<EventIdGenerator> eventIdGenerator) {
            return new TestWiring(alarmClock, eventIdGenerator);
        }

        public Option<AlarmClock> copy$default$1() {
            return this.alarmClock();
        }

        public Option<EventIdGenerator> copy$default$2() {
            return this.eventIdGenerator();
        }

        public Option<AlarmClock> _1() {
            return this.alarmClock();
        }

        public Option<EventIdGenerator> _2() {
            return this.eventIdGenerator();
        }
    }
}

