/*
 * Decompiled with CFR 0.152.
 */
package js7.core.item;

import java.io.Serializable;
import java.nio.file.Path;
import js7.base.io.file.FileUtils$syntax$;
import js7.base.io.file.FileUtils$syntax$RichPath$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$RichCheckedIterable$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$Combined$;
import js7.base.utils.Collections$implicits$;
import js7.base.utils.Collections$implicits$RichIterable$;
import js7.common.files.DirectoryReader$;
import js7.core.item.InventoryItemFile;
import js7.core.item.InventoryItemFile$;
import js7.core.item.ItemReader;
import js7.core.item.ItemSource;
import js7.core.item.ItemSource$;
import js7.data.item.InventoryItem;
import js7.data.item.InventoryItemKey;
import js7.data.item.InventoryItemPath;
import js7.data.item.VersionId$;
import js7.data.item.VersionedItemId;
import js7.data.item.VersionedItemPath;
import js7.data.item.VersionedItemPath$;
import js7.data.item.VersionedItemPath$ImplicitItemPath$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class TypedSourceReader {
    private final Path directory;
    private final Map<InventoryItemPath.Companion<? extends InventoryItemPath>, ItemReader> companionToReader;
    private final Seq<InventoryItemPath.Companion<? extends InventoryItemPath>> itemPathCompanions;

    public TypedSourceReader(Path directory, Iterable<ItemReader> readers) {
        this.directory = directory;
        Iterable iterable = Collections$implicits$.MODULE$.RichIterable(readers);
        this.companionToReader = Collections$implicits$RichIterable$.MODULE$.toKeyedMap$extension(iterable, (Function1 & Serializable)_$1 -> _$1.itemPathCompanion());
        this.itemPathCompanions = ((IterableOnceOps)readers.map((Function1 & Serializable)_$2 -> _$2.companion().Path())).toSeq();
    }

    public Either<Problem, Seq<InventoryItem>> readCompleteDirectory() {
        return this.readItems(DirectoryReader$.MODULE$.files(this.directory, DirectoryReader$.MODULE$.files$default$2()));
    }

    public Either<Problem, Seq<InventoryItem>> readItems(Seq<Path> files) {
        Seq checkedTypedFiles = (Seq)files.map((Function1 & Serializable)file -> this.toTypedFile((Path)file));
        Either<Problem, Seq<InventoryItemFile>> either = InventoryItemFile$.MODULE$.checkUniqueness((Seq<InventoryItemFile>)((Seq)checkedTypedFiles.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Either x2) {
                Either either = x2;
                if (either instanceof Right) {
                    InventoryItemFile o = (InventoryItemFile)((Right)either).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x2, Function1 function1) {
                Either either = x2;
                if (either instanceof Right) {
                    InventoryItemFile o = (InventoryItemFile)((Right)either).value();
                    return o;
                }
                return function1.apply((Object)x2);
            }
        })));
        if (either instanceof Left) {
            Problem problem = (Problem)((Left)either).value();
            return package$.MODULE$.Left().apply((Object)Problem$Combined$.MODULE$.apply((scala.collection.immutable.Iterable<Problem>)((scala.collection.immutable.Iterable)((SeqOps)checkedTypedFiles.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Either x2) {
                    Either either = x2;
                    if (either instanceof Left) {
                        Problem p = (Problem)((Left)either).value();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Either x2, Function1 function1) {
                    Either either = x2;
                    if (either instanceof Left) {
                        Problem p = (Problem)((Left)either).value();
                        return p;
                    }
                    return function1.apply((Object)x2);
                }
            })).$colon$plus((Object)problem))));
        }
        if (either instanceof Right) {
            IterableOnce iterableOnce = Checked$.MODULE$.RichCheckedIterable(checkedTypedFiles);
            return Checked$RichCheckedIterable$.MODULE$.traverseAndCombineProblems$extension(iterableOnce, (Function1 & Serializable)typedFile -> this.toCheckedItem(this.readTypedSource((InventoryItemFile)typedFile)));
        }
        throw new MatchError(either);
    }

    private Either<Problem, InventoryItemFile> toTypedFile(Path file) {
        return InventoryItemFile$.MODULE$.checked(this.directory, file, (Iterable<InventoryItemPath.Companion<? extends InventoryItemPath>>)this.itemPathCompanions);
    }

    private ItemSource readTypedSource(InventoryItemFile itemFile) {
        return ItemSource$.MODULE$.apply(FileUtils$syntax$RichPath$.MODULE$.byteArray$extension(FileUtils$syntax$.MODULE$.RichPath(itemFile.file())), itemFile.path(), itemFile.sourceType());
    }

    private Either<Problem, InventoryItem> toCheckedItem(ItemSource o) {
        VersionedItemId versionedItemId;
        InventoryItemPath inventoryItemPath = o.path();
        if (inventoryItemPath instanceof VersionedItemPath) {
            VersionedItemPath path = (VersionedItemPath)inventoryItemPath;
            VersionedItemPath versionedItemPath = VersionedItemPath$.MODULE$.ImplicitItemPath(path);
            versionedItemId = VersionedItemPath$ImplicitItemPath$.MODULE$.$tilde$extension(versionedItemPath, VersionId$.MODULE$.Anonymous());
        } else if (inventoryItemPath instanceof InventoryItemKey) {
            VersionedItemId key;
            versionedItemId = key = (VersionedItemId)((Object)inventoryItemPath);
        } else {
            throw new MatchError((Object)inventoryItemPath);
        }
        VersionedItemId key = versionedItemId;
        ItemReader itemReader = (ItemReader)this.companionToReader.apply(o.path().companion());
        return itemReader.readUntyped(key, o.byteArray(), o.sourceType());
    }
}

