/*
 * Decompiled with CFR 0.152.
 */
package js7.data.controller;

import io.circe.Codec;
import io.circe.Decoder;
import io.circe.Encoder;
import java.io.Serializable;
import js7.base.circeutils.typed.TypedJsonCodec;
import js7.base.log.CorrelIdWrapped;
import js7.base.time.Timestamp;
import js7.base.utils.Big;
import js7.base.web.Uri;
import js7.data.agent.AgentPath;
import js7.data.board.BoardPath;
import js7.data.board.NoticeId;
import js7.data.command.CancellationMode;
import js7.data.command.CommonCommand;
import js7.data.command.CommonCommand$Companion$CommonBatch$;
import js7.data.command.SuspensionMode;
import js7.data.controller.ControllerCommand$;
import js7.data.controller.ControllerCommand$AddOrder$;
import js7.data.controller.ControllerCommand$AddOrders$;
import js7.data.controller.ControllerCommand$AddOrdersResponse$;
import js7.data.controller.ControllerCommand$AnswerOrderPrompt$;
import js7.data.controller.ControllerCommand$Batch$;
import js7.data.controller.ControllerCommand$CancelOrders$;
import js7.data.controller.ControllerCommand$ClusterAppointNodes$;
import js7.data.controller.ControllerCommand$ClusterSwitchOver$;
import js7.data.controller.ControllerCommand$ConfirmClusterNodeLoss$;
import js7.data.controller.ControllerCommand$ControlWorkflow$;
import js7.data.controller.ControllerCommand$ControlWorkflowPath$;
import js7.data.controller.ControllerCommand$DeleteNotice$;
import js7.data.controller.ControllerCommand$DeleteOrdersWhenTerminated$;
import js7.data.controller.ControllerCommand$EmergencyStop$;
import js7.data.controller.ControllerCommand$GoOrder$;
import js7.data.controller.ControllerCommand$NoOperation$;
import js7.data.controller.ControllerCommand$PostNotice$;
import js7.data.controller.ControllerCommand$ReleaseEvents$;
import js7.data.controller.ControllerCommand$ResetAgent$;
import js7.data.controller.ControllerCommand$ResetSubagent$;
import js7.data.controller.ControllerCommand$Response$;
import js7.data.controller.ControllerCommand$ResumeOrder$;
import js7.data.controller.ControllerCommand$ResumeOrders$;
import js7.data.controller.ControllerCommand$ShutDown$;
import js7.data.controller.ControllerCommand$ShutDown$ClusterAction$;
import js7.data.controller.ControllerCommand$SuspendOrders$;
import js7.data.controller.ControllerCommand$TransferOrders$;
import js7.data.item.VersionedItemId;
import js7.data.node.NodeId;
import js7.data.order.FreshOrder;
import js7.data.order.OrderEvent;
import js7.data.order.OrderId;
import js7.data.subagent.SubagentId;
import js7.data.workflow.WorkflowPath;
import js7.data.workflow.position.Label;
import js7.data.workflow.position.Position;
import scala.Option;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface ControllerCommand
extends CommonCommand {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ControllerCommand$.class.getDeclaredField("CommonBatch$lzy1"));

    public static CommonCommand$Companion$CommonBatch$ CommonBatch() {
        return ControllerCommand$.MODULE$.CommonBatch();
    }

    public static TypedJsonCodec<ControllerCommand> jsonCodec() {
        return ControllerCommand$.MODULE$.jsonCodec();
    }

    public static int ordinal(ControllerCommand controllerCommand) {
        return ControllerCommand$.MODULE$.ordinal(controllerCommand);
    }

    public static final class AddOrder
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final FreshOrder order;

        public static AddOrder apply(FreshOrder freshOrder) {
            return ControllerCommand$AddOrder$.MODULE$.apply(freshOrder);
        }

        public static AddOrder fromProduct(Product product) {
            return ControllerCommand$AddOrder$.MODULE$.fromProduct(product);
        }

        public static AddOrder unapply(AddOrder addOrder) {
            return ControllerCommand$AddOrder$.MODULE$.unapply(addOrder);
        }

        public AddOrder(FreshOrder order) {
            this.order = order;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AddOrder)) return false;
            AddOrder addOrder = (AddOrder)object;
            FreshOrder freshOrder = this.order();
            FreshOrder freshOrder2 = addOrder.order();
            if (freshOrder != null) {
                if (!((Object)freshOrder).equals(freshOrder2)) return false;
                return true;
            }
            if (freshOrder2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AddOrder;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "AddOrder";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "order";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public FreshOrder order() {
            return this.order;
        }

        @Override
        public String toShortString() {
            return "AddOrder(" + this.order().id() + ", " + this.order().workflowPath() + ")";
        }

        public AddOrder copy(FreshOrder order) {
            return new AddOrder(order);
        }

        public FreshOrder copy$default$1() {
            return this.order();
        }

        public FreshOrder _1() {
            return this.order();
        }
    }

    public static final class AddOrders
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final Seq orders;

        public static ControllerCommand$AddOrdersResponse$ Response() {
            return ControllerCommand$AddOrders$.MODULE$.Response();
        }

        public static AddOrders apply(Seq<FreshOrder> seq) {
            return ControllerCommand$AddOrders$.MODULE$.apply(seq);
        }

        public static AddOrders fromProduct(Product product) {
            return ControllerCommand$AddOrders$.MODULE$.fromProduct(product);
        }

        public static AddOrders unapply(AddOrders addOrders) {
            return ControllerCommand$AddOrders$.MODULE$.unapply(addOrders);
        }

        public AddOrders(Seq<FreshOrder> orders) {
            this.orders = orders;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AddOrders)) return false;
            AddOrders addOrders = (AddOrders)object;
            Seq<FreshOrder> seq = this.orders();
            Seq<FreshOrder> seq2 = addOrders.orders();
            if (seq != null) {
                if (!seq.equals(seq2)) return false;
                return true;
            }
            if (seq2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AddOrders;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "AddOrders";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "orders";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<FreshOrder> orders() {
            return this.orders;
        }

        @Override
        public String toShortString() {
            return "AddOrders(" + this.orders().size() + " orders, " + ((IterableOnceOps)((IterableOps)this.orders().take(1)).map(ControllerCommand$::js7$data$controller$ControllerCommand$AddOrders$$_$toShortString$$anonfun$1)).mkString() + " ...)";
        }

        public AddOrders copy(Seq<FreshOrder> orders) {
            return new AddOrders(orders);
        }

        public Seq<FreshOrder> copy$default$1() {
            return this.orders();
        }

        public Seq<FreshOrder> _1() {
            return this.orders();
        }
    }

    public static final class AddOrdersResponse
    implements Response,
    Product,
    Serializable {
        private final long eventId;

        public static AddOrdersResponse apply(long l) {
            return ControllerCommand$AddOrdersResponse$.MODULE$.apply(l);
        }

        public static AddOrdersResponse fromProduct(Product product) {
            return ControllerCommand$AddOrdersResponse$.MODULE$.fromProduct(product);
        }

        public static Codec.AsObject<AddOrdersResponse> jsonCodec() {
            return ControllerCommand$AddOrdersResponse$.MODULE$.jsonCodec();
        }

        public static AddOrdersResponse unapply(AddOrdersResponse addOrdersResponse) {
            return ControllerCommand$AddOrdersResponse$.MODULE$.unapply(addOrdersResponse);
        }

        public AddOrdersResponse(long eventId) {
            this.eventId = eventId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.eventId()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AddOrdersResponse)) return false;
            AddOrdersResponse addOrdersResponse = (AddOrdersResponse)object;
            if (this.eventId() != addOrdersResponse.eventId()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AddOrdersResponse;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "AddOrdersResponse";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "eventId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long eventId() {
            return this.eventId;
        }

        public AddOrdersResponse copy(long eventId) {
            return new AddOrdersResponse(eventId);
        }

        public long copy$default$1() {
            return this.eventId();
        }

        public long _1() {
            return this.eventId();
        }
    }

    public static final class AnswerOrderPrompt
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final OrderId orderId;

        public static AnswerOrderPrompt apply(OrderId orderId) {
            return ControllerCommand$AnswerOrderPrompt$.MODULE$.apply(orderId);
        }

        public static AnswerOrderPrompt fromProduct(Product product) {
            return ControllerCommand$AnswerOrderPrompt$.MODULE$.fromProduct(product);
        }

        public static AnswerOrderPrompt unapply(AnswerOrderPrompt answerOrderPrompt) {
            return ControllerCommand$AnswerOrderPrompt$.MODULE$.unapply(answerOrderPrompt);
        }

        public AnswerOrderPrompt(OrderId orderId) {
            this.orderId = orderId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AnswerOrderPrompt)) return false;
            AnswerOrderPrompt answerOrderPrompt = (AnswerOrderPrompt)object;
            OrderId orderId = this.orderId();
            OrderId orderId2 = answerOrderPrompt.orderId();
            if (orderId != null) {
                if (!((Object)orderId).equals(orderId2)) return false;
                return true;
            }
            if (orderId2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AnswerOrderPrompt;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "AnswerOrderPrompt";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "orderId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public OrderId orderId() {
            return this.orderId;
        }

        public AnswerOrderPrompt copy(OrderId orderId) {
            return new AnswerOrderPrompt(orderId);
        }

        public OrderId copy$default$1() {
            return this.orderId();
        }

        public OrderId _1() {
            return this.orderId();
        }
    }

    public static final class Batch
    implements CommonCommand,
    ControllerCommand,
    CommonCommand.Companion.CommonBatch,
    Big,
    Product,
    Serializable {
        private final Seq commands;

        public static Batch apply(Seq<CorrelIdWrapped<ControllerCommand>> seq) {
            return ControllerCommand$Batch$.MODULE$.apply(seq);
        }

        public static Batch fromProduct(Product product) {
            return ControllerCommand$Batch$.MODULE$.fromProduct(product);
        }

        public static Batch unapply(Batch batch) {
            return ControllerCommand$Batch$.MODULE$.unapply(batch);
        }

        public Batch(Seq<CorrelIdWrapped<ControllerCommand>> commands) {
            this.commands = commands;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Batch)) return false;
            Batch batch = (Batch)object;
            Seq<CorrelIdWrapped<ControllerCommand>> seq = this.commands();
            Seq<CorrelIdWrapped<ControllerCommand>> seq2 = batch.commands();
            if (seq != null) {
                if (!seq.equals(seq2)) return false;
                return true;
            }
            if (seq2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Batch;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Batch";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "commands";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<CorrelIdWrapped<ControllerCommand>> commands() {
            return this.commands;
        }

        public Batch copy(Seq<CorrelIdWrapped<ControllerCommand>> commands) {
            return new Batch(commands);
        }

        public Seq<CorrelIdWrapped<ControllerCommand>> copy$default$1() {
            return this.commands();
        }

        public Seq<CorrelIdWrapped<ControllerCommand>> _1() {
            return this.commands();
        }

        @Override
        public final /* synthetic */ CommonCommand.Companion js7$data$command$CommonCommand$Companion$CommonBatch$$$outer() {
            return ControllerCommand$.MODULE$;
        }
    }

    public static final class CancelOrders
    implements CommonCommand,
    ControllerCommand,
    Big,
    Product,
    Serializable {
        private final Iterable orderIds;
        private final CancellationMode mode;

        public static CancelOrders apply(Iterable<OrderId> iterable, CancellationMode cancellationMode) {
            return ControllerCommand$CancelOrders$.MODULE$.apply(iterable, cancellationMode);
        }

        public static CancelOrders fromProduct(Product product) {
            return ControllerCommand$CancelOrders$.MODULE$.fromProduct(product);
        }

        public static Decoder<CancelOrders> jsonDecoder() {
            return ControllerCommand$CancelOrders$.MODULE$.jsonDecoder();
        }

        public static Encoder.AsObject<CancelOrders> jsonEncoder() {
            return ControllerCommand$CancelOrders$.MODULE$.jsonEncoder();
        }

        public static CancelOrders unapply(CancelOrders cancelOrders) {
            return ControllerCommand$CancelOrders$.MODULE$.unapply(cancelOrders);
        }

        public static CancellationMode $lessinit$greater$default$2() {
            return ControllerCommand$CancelOrders$.MODULE$.$lessinit$greater$default$2();
        }

        public CancelOrders(Iterable<OrderId> orderIds, CancellationMode mode) {
            this.orderIds = orderIds;
            this.mode = mode;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CancelOrders)) return false;
            CancelOrders cancelOrders = (CancelOrders)object;
            Iterable<OrderId> iterable = this.orderIds();
            Iterable<OrderId> iterable2 = cancelOrders.orderIds();
            if (iterable == null) {
                if (iterable2 != null) {
                    return false;
                }
            } else if (!iterable.equals(iterable2)) return false;
            CancellationMode cancellationMode = this.mode();
            CancellationMode cancellationMode2 = cancelOrders.mode();
            if (cancellationMode == null) {
                if (cancellationMode2 == null) return true;
                return false;
            } else {
                if (!cancellationMode.equals(cancellationMode2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CancelOrders;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CancelOrders";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "orderIds";
            }
            if (1 == n2) {
                return "mode";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Iterable<OrderId> orderIds() {
            return this.orderIds;
        }

        public CancellationMode mode() {
            return this.mode;
        }

        @Override
        public String toShortString() {
            return "CancelOrders(" + this.orderIds().size() + " orders, " + ((IterableOnceOps)((IterableOps)this.orderIds().take(3)).map(ControllerCommand$::js7$data$controller$ControllerCommand$CancelOrders$$_$toShortString$$anonfun$2)).mkString() + " ...)";
        }

        public CancelOrders copy(Iterable<OrderId> orderIds, CancellationMode mode) {
            return new CancelOrders(orderIds, mode);
        }

        public Iterable<OrderId> copy$default$1() {
            return this.orderIds();
        }

        public CancellationMode copy$default$2() {
            return this.mode();
        }

        public Iterable<OrderId> _1() {
            return this.orderIds();
        }

        public CancellationMode _2() {
            return this.mode();
        }
    }

    public static final class ClusterAppointNodes
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final Map idToUri;
        private final NodeId activeId;

        public static ClusterAppointNodes apply(Map<NodeId, Uri> map, NodeId nodeId) {
            return ControllerCommand$ClusterAppointNodes$.MODULE$.apply(map, nodeId);
        }

        public static ClusterAppointNodes fromProduct(Product product) {
            return ControllerCommand$ClusterAppointNodes$.MODULE$.fromProduct(product);
        }

        public static ClusterAppointNodes unapply(ClusterAppointNodes clusterAppointNodes) {
            return ControllerCommand$ClusterAppointNodes$.MODULE$.unapply(clusterAppointNodes);
        }

        public ClusterAppointNodes(Map<NodeId, Uri> idToUri, NodeId activeId) {
            this.idToUri = idToUri;
            this.activeId = activeId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ClusterAppointNodes)) return false;
            ClusterAppointNodes clusterAppointNodes = (ClusterAppointNodes)object;
            Map<NodeId, Uri> map = this.idToUri();
            Map<NodeId, Uri> map2 = clusterAppointNodes.idToUri();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            NodeId nodeId = this.activeId();
            NodeId nodeId2 = clusterAppointNodes.activeId();
            if (nodeId == null) {
                if (nodeId2 == null) return true;
                return false;
            } else {
                if (!((Object)nodeId).equals(nodeId2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ClusterAppointNodes;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ClusterAppointNodes";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "idToUri";
            }
            if (1 == n2) {
                return "activeId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<NodeId, Uri> idToUri() {
            return this.idToUri;
        }

        public NodeId activeId() {
            return this.activeId;
        }

        public ClusterAppointNodes copy(Map<NodeId, Uri> idToUri, NodeId activeId) {
            return new ClusterAppointNodes(idToUri, activeId);
        }

        public Map<NodeId, Uri> copy$default$1() {
            return this.idToUri();
        }

        public NodeId copy$default$2() {
            return this.activeId();
        }

        public Map<NodeId, Uri> _1() {
            return this.idToUri();
        }

        public NodeId _2() {
            return this.activeId();
        }
    }

    public static final class ClusterSwitchOver
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final Option agentPath;

        public static ClusterSwitchOver apply(Option<AgentPath> option) {
            return ControllerCommand$ClusterSwitchOver$.MODULE$.apply(option);
        }

        public static ClusterSwitchOver fromProduct(Product product) {
            return ControllerCommand$ClusterSwitchOver$.MODULE$.fromProduct(product);
        }

        public static ClusterSwitchOver unapply(ClusterSwitchOver clusterSwitchOver) {
            return ControllerCommand$ClusterSwitchOver$.MODULE$.unapply(clusterSwitchOver);
        }

        public static Option<AgentPath> $lessinit$greater$default$1() {
            return ControllerCommand$ClusterSwitchOver$.MODULE$.$lessinit$greater$default$1();
        }

        public ClusterSwitchOver(Option<AgentPath> agentPath) {
            this.agentPath = agentPath;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ClusterSwitchOver)) return false;
            ClusterSwitchOver clusterSwitchOver = (ClusterSwitchOver)object;
            Option<AgentPath> option = this.agentPath();
            Option<AgentPath> option2 = clusterSwitchOver.agentPath();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ClusterSwitchOver;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ClusterSwitchOver";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "agentPath";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<AgentPath> agentPath() {
            return this.agentPath;
        }

        public ClusterSwitchOver copy(Option<AgentPath> agentPath) {
            return new ClusterSwitchOver(agentPath);
        }

        public Option<AgentPath> copy$default$1() {
            return this.agentPath();
        }

        public Option<AgentPath> _1() {
            return this.agentPath();
        }
    }

    public static final class ConfirmClusterNodeLoss
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final AgentPath agentPath;
        private final NodeId lostNodeId;
        private final String confirmer;

        public static ConfirmClusterNodeLoss apply(AgentPath agentPath, NodeId nodeId, String string) {
            return ControllerCommand$ConfirmClusterNodeLoss$.MODULE$.apply(agentPath, nodeId, string);
        }

        public static ConfirmClusterNodeLoss fromProduct(Product product) {
            return ControllerCommand$ConfirmClusterNodeLoss$.MODULE$.fromProduct(product);
        }

        public static ConfirmClusterNodeLoss unapply(ConfirmClusterNodeLoss confirmClusterNodeLoss) {
            return ControllerCommand$ConfirmClusterNodeLoss$.MODULE$.unapply(confirmClusterNodeLoss);
        }

        public ConfirmClusterNodeLoss(AgentPath agentPath, NodeId lostNodeId, String confirmer) {
            this.agentPath = agentPath;
            this.lostNodeId = lostNodeId;
            this.confirmer = confirmer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConfirmClusterNodeLoss)) return false;
            ConfirmClusterNodeLoss confirmClusterNodeLoss = (ConfirmClusterNodeLoss)object;
            AgentPath agentPath = this.agentPath();
            AgentPath agentPath2 = confirmClusterNodeLoss.agentPath();
            if (agentPath == null) {
                if (agentPath2 != null) {
                    return false;
                }
            } else if (!((Object)agentPath).equals(agentPath2)) return false;
            NodeId nodeId = this.lostNodeId();
            NodeId nodeId2 = confirmClusterNodeLoss.lostNodeId();
            if (nodeId == null) {
                if (nodeId2 != null) {
                    return false;
                }
            } else if (!((Object)nodeId).equals(nodeId2)) return false;
            String string = this.confirmer();
            String string2 = confirmClusterNodeLoss.confirmer();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ConfirmClusterNodeLoss;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ConfirmClusterNodeLoss";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "agentPath";
                }
                case 1: {
                    return "lostNodeId";
                }
                case 2: {
                    return "confirmer";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public AgentPath agentPath() {
            return this.agentPath;
        }

        public NodeId lostNodeId() {
            return this.lostNodeId;
        }

        public String confirmer() {
            return this.confirmer;
        }

        public ConfirmClusterNodeLoss copy(AgentPath agentPath, NodeId lostNodeId, String confirmer) {
            return new ConfirmClusterNodeLoss(agentPath, lostNodeId, confirmer);
        }

        public AgentPath copy$default$1() {
            return this.agentPath();
        }

        public NodeId copy$default$2() {
            return this.lostNodeId();
        }

        public String copy$default$3() {
            return this.confirmer();
        }

        public AgentPath _1() {
            return this.agentPath();
        }

        public NodeId _2() {
            return this.lostNodeId();
        }

        public String _3() {
            return this.confirmer();
        }
    }

    public static final class ControlWorkflow
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final VersionedItemId workflowId;
        private final Set addBreakpoints;
        private final Set removeBreakpoints;

        public static ControlWorkflow apply(VersionedItemId<WorkflowPath> versionedItemId, Set<Position> set, Set<Position> set2) {
            return ControllerCommand$ControlWorkflow$.MODULE$.apply(versionedItemId, set, set2);
        }

        public static ControlWorkflow fromProduct(Product product) {
            return ControllerCommand$ControlWorkflow$.MODULE$.fromProduct(product);
        }

        public static ControlWorkflow unapply(ControlWorkflow controlWorkflow) {
            return ControllerCommand$ControlWorkflow$.MODULE$.unapply(controlWorkflow);
        }

        public static Set<Position> $lessinit$greater$default$2() {
            return ControllerCommand$ControlWorkflow$.MODULE$.$lessinit$greater$default$2();
        }

        public static Set<Position> $lessinit$greater$default$3() {
            return ControllerCommand$ControlWorkflow$.MODULE$.$lessinit$greater$default$3();
        }

        public ControlWorkflow(VersionedItemId<WorkflowPath> workflowId, Set<Position> addBreakpoints, Set<Position> removeBreakpoints) {
            this.workflowId = workflowId;
            this.addBreakpoints = addBreakpoints;
            this.removeBreakpoints = removeBreakpoints;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ControlWorkflow)) return false;
            ControlWorkflow controlWorkflow = (ControlWorkflow)object;
            VersionedItemId<WorkflowPath> versionedItemId = this.workflowId();
            VersionedItemId<WorkflowPath> versionedItemId2 = controlWorkflow.workflowId();
            if (versionedItemId == null) {
                if (versionedItemId2 != null) {
                    return false;
                }
            } else if (!((Object)versionedItemId).equals(versionedItemId2)) return false;
            Set<Position> set = this.addBreakpoints();
            Set<Position> set2 = controlWorkflow.addBreakpoints();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<Position> set3 = this.removeBreakpoints();
            Set<Position> set4 = controlWorkflow.removeBreakpoints();
            if (set3 == null) {
                if (set4 == null) return true;
                return false;
            } else {
                if (!set3.equals(set4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ControlWorkflow;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ControlWorkflow";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "workflowId";
                }
                case 1: {
                    return "addBreakpoints";
                }
                case 2: {
                    return "removeBreakpoints";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public VersionedItemId<WorkflowPath> workflowId() {
            return this.workflowId;
        }

        public Set<Position> addBreakpoints() {
            return this.addBreakpoints;
        }

        public Set<Position> removeBreakpoints() {
            return this.removeBreakpoints;
        }

        public ControlWorkflow copy(VersionedItemId<WorkflowPath> workflowId, Set<Position> addBreakpoints, Set<Position> removeBreakpoints) {
            return new ControlWorkflow(workflowId, addBreakpoints, removeBreakpoints);
        }

        public VersionedItemId<WorkflowPath> copy$default$1() {
            return this.workflowId();
        }

        public Set<Position> copy$default$2() {
            return this.addBreakpoints();
        }

        public Set<Position> copy$default$3() {
            return this.removeBreakpoints();
        }

        public VersionedItemId<WorkflowPath> _1() {
            return this.workflowId();
        }

        public Set<Position> _2() {
            return this.addBreakpoints();
        }

        public Set<Position> _3() {
            return this.removeBreakpoints();
        }
    }

    public static final class ControlWorkflowPath
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final WorkflowPath workflowPath;
        private final Option suspend;
        private final Map skip;

        public static ControlWorkflowPath apply(WorkflowPath workflowPath, Option<Object> option, Map<Label, Object> map) {
            return ControllerCommand$ControlWorkflowPath$.MODULE$.apply(workflowPath, option, map);
        }

        public static ControlWorkflowPath fromProduct(Product product) {
            return ControllerCommand$ControlWorkflowPath$.MODULE$.fromProduct(product);
        }

        public static ControlWorkflowPath unapply(ControlWorkflowPath controlWorkflowPath) {
            return ControllerCommand$ControlWorkflowPath$.MODULE$.unapply(controlWorkflowPath);
        }

        public static Option<Object> $lessinit$greater$default$2() {
            return ControllerCommand$ControlWorkflowPath$.MODULE$.$lessinit$greater$default$2();
        }

        public static Map<Label, Object> $lessinit$greater$default$3() {
            return ControllerCommand$ControlWorkflowPath$.MODULE$.$lessinit$greater$default$3();
        }

        public ControlWorkflowPath(WorkflowPath workflowPath, Option<Object> suspend, Map<Label, Object> skip) {
            this.workflowPath = workflowPath;
            this.suspend = suspend;
            this.skip = skip;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ControlWorkflowPath)) return false;
            ControlWorkflowPath controlWorkflowPath = (ControlWorkflowPath)object;
            WorkflowPath workflowPath = this.workflowPath();
            WorkflowPath workflowPath2 = controlWorkflowPath.workflowPath();
            if (workflowPath == null) {
                if (workflowPath2 != null) {
                    return false;
                }
            } else if (!((Object)workflowPath).equals(workflowPath2)) return false;
            Option<Object> option = this.suspend();
            Option<Object> option2 = controlWorkflowPath.suspend();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Map<Label, Object> map = this.skip();
            Map<Label, Object> map2 = controlWorkflowPath.skip();
            if (map == null) {
                if (map2 == null) return true;
                return false;
            } else {
                if (!map.equals(map2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ControlWorkflowPath;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ControlWorkflowPath";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "workflowPath";
                }
                case 1: {
                    return "suspend";
                }
                case 2: {
                    return "skip";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public WorkflowPath workflowPath() {
            return this.workflowPath;
        }

        public Option<Object> suspend() {
            return this.suspend;
        }

        public Map<Label, Object> skip() {
            return this.skip;
        }

        public ControlWorkflowPath copy(WorkflowPath workflowPath, Option<Object> suspend, Map<Label, Object> skip) {
            return new ControlWorkflowPath(workflowPath, suspend, skip);
        }

        public WorkflowPath copy$default$1() {
            return this.workflowPath();
        }

        public Option<Object> copy$default$2() {
            return this.suspend();
        }

        public Map<Label, Object> copy$default$3() {
            return this.skip();
        }

        public WorkflowPath _1() {
            return this.workflowPath();
        }

        public Option<Object> _2() {
            return this.suspend();
        }

        public Map<Label, Object> _3() {
            return this.skip();
        }
    }

    public static final class DeleteNotice
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final BoardPath boardPath;
        private final NoticeId noticeId;

        public static DeleteNotice apply(BoardPath boardPath, NoticeId noticeId) {
            return ControllerCommand$DeleteNotice$.MODULE$.apply(boardPath, noticeId);
        }

        public static DeleteNotice fromProduct(Product product) {
            return ControllerCommand$DeleteNotice$.MODULE$.fromProduct(product);
        }

        public static DeleteNotice unapply(DeleteNotice deleteNotice) {
            return ControllerCommand$DeleteNotice$.MODULE$.unapply(deleteNotice);
        }

        public DeleteNotice(BoardPath boardPath, NoticeId noticeId) {
            this.boardPath = boardPath;
            this.noticeId = noticeId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DeleteNotice)) return false;
            DeleteNotice deleteNotice = (DeleteNotice)object;
            BoardPath boardPath = this.boardPath();
            BoardPath boardPath2 = deleteNotice.boardPath();
            if (boardPath == null) {
                if (boardPath2 != null) {
                    return false;
                }
            } else if (!((Object)boardPath).equals(boardPath2)) return false;
            NoticeId noticeId = this.noticeId();
            NoticeId noticeId2 = deleteNotice.noticeId();
            if (noticeId == null) {
                if (noticeId2 == null) return true;
                return false;
            } else {
                if (!((Object)noticeId).equals(noticeId2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DeleteNotice;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DeleteNotice";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "boardPath";
            }
            if (1 == n2) {
                return "noticeId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BoardPath boardPath() {
            return this.boardPath;
        }

        public NoticeId noticeId() {
            return this.noticeId;
        }

        @Override
        public String toShortString() {
            return "DeleteNotice(" + this.boardPath() + ", " + this.noticeId() + ")";
        }

        public DeleteNotice copy(BoardPath boardPath, NoticeId noticeId) {
            return new DeleteNotice(boardPath, noticeId);
        }

        public BoardPath copy$default$1() {
            return this.boardPath();
        }

        public NoticeId copy$default$2() {
            return this.noticeId();
        }

        public BoardPath _1() {
            return this.boardPath();
        }

        public NoticeId _2() {
            return this.noticeId();
        }
    }

    public static final class DeleteOrdersWhenTerminated
    implements CommonCommand,
    ControllerCommand,
    Big,
    Product,
    Serializable {
        private final Iterable orderIds;

        public static DeleteOrdersWhenTerminated apply(Iterable<OrderId> iterable) {
            return ControllerCommand$DeleteOrdersWhenTerminated$.MODULE$.apply(iterable);
        }

        public static DeleteOrdersWhenTerminated fromProduct(Product product) {
            return ControllerCommand$DeleteOrdersWhenTerminated$.MODULE$.fromProduct(product);
        }

        public static DeleteOrdersWhenTerminated unapply(DeleteOrdersWhenTerminated deleteOrdersWhenTerminated) {
            return ControllerCommand$DeleteOrdersWhenTerminated$.MODULE$.unapply(deleteOrdersWhenTerminated);
        }

        public DeleteOrdersWhenTerminated(Iterable<OrderId> orderIds) {
            this.orderIds = orderIds;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DeleteOrdersWhenTerminated)) return false;
            DeleteOrdersWhenTerminated deleteOrdersWhenTerminated = (DeleteOrdersWhenTerminated)object;
            Iterable<OrderId> iterable = this.orderIds();
            Iterable<OrderId> iterable2 = deleteOrdersWhenTerminated.orderIds();
            if (iterable != null) {
                if (!iterable.equals(iterable2)) return false;
                return true;
            }
            if (iterable2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DeleteOrdersWhenTerminated;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DeleteOrdersWhenTerminated";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "orderIds";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Iterable<OrderId> orderIds() {
            return this.orderIds;
        }

        @Override
        public String toShortString() {
            return "DeleteOrdersWhenTerminated(" + this.orderIds().size() + " orders, " + ((IterableOnceOps)((IterableOps)this.orderIds().take(3)).map(ControllerCommand$::js7$data$controller$ControllerCommand$DeleteOrdersWhenTerminated$$_$toShortString$$anonfun$3)).mkString() + " ...)";
        }

        public DeleteOrdersWhenTerminated copy(Iterable<OrderId> orderIds) {
            return new DeleteOrdersWhenTerminated(orderIds);
        }

        public Iterable<OrderId> copy$default$1() {
            return this.orderIds();
        }

        public Iterable<OrderId> _1() {
            return this.orderIds();
        }
    }

    public static final class EmergencyStop
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final boolean restart;

        public static EmergencyStop apply(boolean bl) {
            return ControllerCommand$EmergencyStop$.MODULE$.apply(bl);
        }

        public static EmergencyStop fromProduct(Product product) {
            return ControllerCommand$EmergencyStop$.MODULE$.fromProduct(product);
        }

        public static Decoder<EmergencyStop> jsonDecoder() {
            return ControllerCommand$EmergencyStop$.MODULE$.jsonDecoder();
        }

        public static Encoder.AsObject<EmergencyStop> jsonEncoder() {
            return ControllerCommand$EmergencyStop$.MODULE$.jsonEncoder();
        }

        public static EmergencyStop unapply(EmergencyStop emergencyStop) {
            return ControllerCommand$EmergencyStop$.MODULE$.unapply(emergencyStop);
        }

        public static boolean $lessinit$greater$default$1() {
            return ControllerCommand$EmergencyStop$.MODULE$.$lessinit$greater$default$1();
        }

        public EmergencyStop(boolean restart) {
            this.restart = restart;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.restart() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EmergencyStop)) return false;
            EmergencyStop emergencyStop = (EmergencyStop)object;
            if (this.restart() != emergencyStop.restart()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof EmergencyStop;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "EmergencyStop";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToBoolean((boolean)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "restart";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean restart() {
            return this.restart;
        }

        public EmergencyStop copy(boolean restart) {
            return new EmergencyStop(restart);
        }

        public boolean copy$default$1() {
            return this.restart();
        }

        public boolean _1() {
            return this.restart();
        }
    }

    public static final class GoOrder
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final OrderId orderId;
        private final Position position;

        public static GoOrder apply(OrderId orderId, Position position) {
            return ControllerCommand$GoOrder$.MODULE$.apply(orderId, position);
        }

        public static GoOrder fromProduct(Product product) {
            return ControllerCommand$GoOrder$.MODULE$.fromProduct(product);
        }

        public static GoOrder unapply(GoOrder goOrder) {
            return ControllerCommand$GoOrder$.MODULE$.unapply(goOrder);
        }

        public GoOrder(OrderId orderId, Position position) {
            this.orderId = orderId;
            this.position = position;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GoOrder)) return false;
            GoOrder goOrder = (GoOrder)object;
            OrderId orderId = this.orderId();
            OrderId orderId2 = goOrder.orderId();
            if (orderId == null) {
                if (orderId2 != null) {
                    return false;
                }
            } else if (!((Object)orderId).equals(orderId2)) return false;
            Position position = this.position();
            Position position2 = goOrder.position();
            if (position == null) {
                if (position2 == null) return true;
                return false;
            } else {
                if (!((Object)position).equals(position2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GoOrder;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "GoOrder";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "orderId";
            }
            if (1 == n2) {
                return "position";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public OrderId orderId() {
            return this.orderId;
        }

        public Position position() {
            return this.position;
        }

        public GoOrder copy(OrderId orderId, Position position) {
            return new GoOrder(orderId, position);
        }

        public OrderId copy$default$1() {
            return this.orderId();
        }

        public Position copy$default$2() {
            return this.position();
        }

        public OrderId _1() {
            return this.orderId();
        }

        public Position _2() {
            return this.position();
        }
    }

    public static final class NoOperation
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final Option duration;

        public static NoOperation apply(Option<FiniteDuration> option) {
            return ControllerCommand$NoOperation$.MODULE$.apply(option);
        }

        public static NoOperation fromProduct(Product product) {
            return ControllerCommand$NoOperation$.MODULE$.fromProduct(product);
        }

        public static NoOperation unapply(NoOperation noOperation) {
            return ControllerCommand$NoOperation$.MODULE$.unapply(noOperation);
        }

        public static Option<FiniteDuration> $lessinit$greater$default$1() {
            return ControllerCommand$NoOperation$.MODULE$.$lessinit$greater$default$1();
        }

        public NoOperation(Option<FiniteDuration> duration) {
            this.duration = duration;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NoOperation)) return false;
            NoOperation noOperation = (NoOperation)object;
            Option<FiniteDuration> option = this.duration();
            Option<FiniteDuration> option2 = noOperation.duration();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NoOperation;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NoOperation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "duration";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<FiniteDuration> duration() {
            return this.duration;
        }

        public NoOperation copy(Option<FiniteDuration> duration) {
            return new NoOperation(duration);
        }

        public Option<FiniteDuration> copy$default$1() {
            return this.duration();
        }

        public Option<FiniteDuration> _1() {
            return this.duration();
        }
    }

    public static final class PostNotice
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final BoardPath boardPath;
        private final NoticeId noticeId;
        private final Option endOfLife;

        public static PostNotice apply(BoardPath boardPath, NoticeId noticeId, Option<Timestamp> option) {
            return ControllerCommand$PostNotice$.MODULE$.apply(boardPath, noticeId, option);
        }

        public static PostNotice fromProduct(Product product) {
            return ControllerCommand$PostNotice$.MODULE$.fromProduct(product);
        }

        public static PostNotice unapply(PostNotice postNotice) {
            return ControllerCommand$PostNotice$.MODULE$.unapply(postNotice);
        }

        public static Option<Timestamp> $lessinit$greater$default$3() {
            return ControllerCommand$PostNotice$.MODULE$.$lessinit$greater$default$3();
        }

        public PostNotice(BoardPath boardPath, NoticeId noticeId, Option<Timestamp> endOfLife) {
            this.boardPath = boardPath;
            this.noticeId = noticeId;
            this.endOfLife = endOfLife;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PostNotice)) return false;
            PostNotice postNotice = (PostNotice)object;
            BoardPath boardPath = this.boardPath();
            BoardPath boardPath2 = postNotice.boardPath();
            if (boardPath == null) {
                if (boardPath2 != null) {
                    return false;
                }
            } else if (!((Object)boardPath).equals(boardPath2)) return false;
            NoticeId noticeId = this.noticeId();
            NoticeId noticeId2 = postNotice.noticeId();
            if (noticeId == null) {
                if (noticeId2 != null) {
                    return false;
                }
            } else if (!((Object)noticeId).equals(noticeId2)) return false;
            Option<Timestamp> option = this.endOfLife();
            Option<Timestamp> option2 = postNotice.endOfLife();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PostNotice;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PostNotice";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "boardPath";
                }
                case 1: {
                    return "noticeId";
                }
                case 2: {
                    return "endOfLife";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BoardPath boardPath() {
            return this.boardPath;
        }

        public NoticeId noticeId() {
            return this.noticeId;
        }

        public Option<Timestamp> endOfLife() {
            return this.endOfLife;
        }

        @Override
        public String toShortString() {
            return "PostNotice(" + this.boardPath() + ", " + this.noticeId() + "})";
        }

        public PostNotice copy(BoardPath boardPath, NoticeId noticeId, Option<Timestamp> endOfLife) {
            return new PostNotice(boardPath, noticeId, endOfLife);
        }

        public BoardPath copy$default$1() {
            return this.boardPath();
        }

        public NoticeId copy$default$2() {
            return this.noticeId();
        }

        public Option<Timestamp> copy$default$3() {
            return this.endOfLife();
        }

        public BoardPath _1() {
            return this.boardPath();
        }

        public NoticeId _2() {
            return this.noticeId();
        }

        public Option<Timestamp> _3() {
            return this.endOfLife();
        }
    }

    public static final class ReleaseEvents
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final long untilEventId;

        public static ReleaseEvents apply(long l) {
            return ControllerCommand$ReleaseEvents$.MODULE$.apply(l);
        }

        public static ReleaseEvents fromProduct(Product product) {
            return ControllerCommand$ReleaseEvents$.MODULE$.fromProduct(product);
        }

        public static ReleaseEvents unapply(ReleaseEvents releaseEvents) {
            return ControllerCommand$ReleaseEvents$.MODULE$.unapply(releaseEvents);
        }

        public ReleaseEvents(long untilEventId) {
            this.untilEventId = untilEventId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.untilEventId()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReleaseEvents)) return false;
            ReleaseEvents releaseEvents = (ReleaseEvents)object;
            if (this.untilEventId() != releaseEvents.untilEventId()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReleaseEvents;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ReleaseEvents";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "untilEventId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long untilEventId() {
            return this.untilEventId;
        }

        public ReleaseEvents copy(long untilEventId) {
            return new ReleaseEvents(untilEventId);
        }

        public long copy$default$1() {
            return this.untilEventId();
        }

        public long _1() {
            return this.untilEventId();
        }
    }

    public static final class ResetAgent
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final AgentPath agentPath;
        private final boolean force;

        public static ResetAgent apply(AgentPath agentPath, boolean bl) {
            return ControllerCommand$ResetAgent$.MODULE$.apply(agentPath, bl);
        }

        public static ResetAgent fromProduct(Product product) {
            return ControllerCommand$ResetAgent$.MODULE$.fromProduct(product);
        }

        public static ResetAgent unapply(ResetAgent resetAgent) {
            return ControllerCommand$ResetAgent$.MODULE$.unapply(resetAgent);
        }

        public static boolean $lessinit$greater$default$2() {
            return ControllerCommand$ResetAgent$.MODULE$.$lessinit$greater$default$2();
        }

        public ResetAgent(AgentPath agentPath, boolean force) {
            this.agentPath = agentPath;
            this.force = force;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.agentPath()));
            n = Statics.mix((int)n, (int)(this.force() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResetAgent)) return false;
            ResetAgent resetAgent = (ResetAgent)object;
            if (this.force() != resetAgent.force()) return false;
            AgentPath agentPath = this.agentPath();
            AgentPath agentPath2 = resetAgent.agentPath();
            if (agentPath != null) {
                if (!((Object)agentPath).equals(agentPath2)) return false;
                return true;
            }
            if (agentPath2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ResetAgent;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ResetAgent";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "agentPath";
            }
            if (1 == n2) {
                return "force";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public AgentPath agentPath() {
            return this.agentPath;
        }

        public boolean force() {
            return this.force;
        }

        public ResetAgent copy(AgentPath agentPath, boolean force) {
            return new ResetAgent(agentPath, force);
        }

        public AgentPath copy$default$1() {
            return this.agentPath();
        }

        public boolean copy$default$2() {
            return this.force();
        }

        public AgentPath _1() {
            return this.agentPath();
        }

        public boolean _2() {
            return this.force();
        }
    }

    public static final class ResetSubagent
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final SubagentId subagentId;
        private final boolean force;

        public static ResetSubagent apply(SubagentId subagentId, boolean bl) {
            return ControllerCommand$ResetSubagent$.MODULE$.apply(subagentId, bl);
        }

        public static ResetSubagent fromProduct(Product product) {
            return ControllerCommand$ResetSubagent$.MODULE$.fromProduct(product);
        }

        public static ResetSubagent unapply(ResetSubagent resetSubagent) {
            return ControllerCommand$ResetSubagent$.MODULE$.unapply(resetSubagent);
        }

        public static boolean $lessinit$greater$default$2() {
            return ControllerCommand$ResetSubagent$.MODULE$.$lessinit$greater$default$2();
        }

        public ResetSubagent(SubagentId subagentId, boolean force) {
            this.subagentId = subagentId;
            this.force = force;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.subagentId()));
            n = Statics.mix((int)n, (int)(this.force() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResetSubagent)) return false;
            ResetSubagent resetSubagent = (ResetSubagent)object;
            if (this.force() != resetSubagent.force()) return false;
            SubagentId subagentId = this.subagentId();
            SubagentId subagentId2 = resetSubagent.subagentId();
            if (subagentId != null) {
                if (!((Object)subagentId).equals(subagentId2)) return false;
                return true;
            }
            if (subagentId2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ResetSubagent;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ResetSubagent";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "subagentId";
            }
            if (1 == n2) {
                return "force";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SubagentId subagentId() {
            return this.subagentId;
        }

        public boolean force() {
            return this.force;
        }

        public ResetSubagent copy(SubagentId subagentId, boolean force) {
            return new ResetSubagent(subagentId, force);
        }

        public SubagentId copy$default$1() {
            return this.subagentId();
        }

        public boolean copy$default$2() {
            return this.force();
        }

        public SubagentId _1() {
            return this.subagentId();
        }

        public boolean _2() {
            return this.force();
        }
    }

    public static interface Response {
        public static TypedJsonCodec<Response> ResponseJsonCodec() {
            return ControllerCommand$Response$.MODULE$.ResponseJsonCodec();
        }

        public static int ordinal(Response response) {
            return ControllerCommand$Response$.MODULE$.ordinal(response);
        }
    }

    public static final class ResumeOrder
    implements CommonCommand,
    ControllerCommand,
    Big,
    Product,
    Serializable {
        private final OrderId orderId;
        private final Option position;
        private final Seq historyOperations;
        private final boolean asSucceeded;

        public static ResumeOrder apply(OrderId orderId, Option<Position> option, Seq<OrderEvent.OrderResumed.HistoryOperation> seq, boolean bl) {
            return ControllerCommand$ResumeOrder$.MODULE$.apply(orderId, option, seq, bl);
        }

        public static ResumeOrder fromProduct(Product product) {
            return ControllerCommand$ResumeOrder$.MODULE$.fromProduct(product);
        }

        public static ResumeOrder unapply(ResumeOrder resumeOrder) {
            return ControllerCommand$ResumeOrder$.MODULE$.unapply(resumeOrder);
        }

        public static Option<Position> $lessinit$greater$default$2() {
            return ControllerCommand$ResumeOrder$.MODULE$.$lessinit$greater$default$2();
        }

        public static Seq<OrderEvent.OrderResumed.HistoryOperation> $lessinit$greater$default$3() {
            return ControllerCommand$ResumeOrder$.MODULE$.$lessinit$greater$default$3();
        }

        public static boolean $lessinit$greater$default$4() {
            return ControllerCommand$ResumeOrder$.MODULE$.$lessinit$greater$default$4();
        }

        public ResumeOrder(OrderId orderId, Option<Position> position, Seq<OrderEvent.OrderResumed.HistoryOperation> historyOperations, boolean asSucceeded) {
            this.orderId = orderId;
            this.position = position;
            this.historyOperations = historyOperations;
            this.asSucceeded = asSucceeded;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.orderId()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.position()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.historyOperations()));
            n = Statics.mix((int)n, (int)(this.asSucceeded() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResumeOrder)) return false;
            ResumeOrder resumeOrder = (ResumeOrder)object;
            if (this.asSucceeded() != resumeOrder.asSucceeded()) return false;
            OrderId orderId = this.orderId();
            OrderId orderId2 = resumeOrder.orderId();
            if (orderId == null) {
                if (orderId2 != null) {
                    return false;
                }
            } else if (!((Object)orderId).equals(orderId2)) return false;
            Option<Position> option = this.position();
            Option<Position> option2 = resumeOrder.position();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Seq<OrderEvent.OrderResumed.HistoryOperation> seq = this.historyOperations();
            Seq<OrderEvent.OrderResumed.HistoryOperation> seq2 = resumeOrder.historyOperations();
            if (seq == null) {
                if (seq2 == null) return true;
                return false;
            } else {
                if (!seq.equals(seq2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ResumeOrder;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ResumeOrder";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "orderId";
                }
                case 1: {
                    return "position";
                }
                case 2: {
                    return "historyOperations";
                }
                case 3: {
                    return "asSucceeded";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public OrderId orderId() {
            return this.orderId;
        }

        public Option<Position> position() {
            return this.position;
        }

        public Seq<OrderEvent.OrderResumed.HistoryOperation> historyOperations() {
            return this.historyOperations;
        }

        public boolean asSucceeded() {
            return this.asSucceeded;
        }

        public ResumeOrder copy(OrderId orderId, Option<Position> position, Seq<OrderEvent.OrderResumed.HistoryOperation> historyOperations, boolean asSucceeded) {
            return new ResumeOrder(orderId, position, historyOperations, asSucceeded);
        }

        public OrderId copy$default$1() {
            return this.orderId();
        }

        public Option<Position> copy$default$2() {
            return this.position();
        }

        public Seq<OrderEvent.OrderResumed.HistoryOperation> copy$default$3() {
            return this.historyOperations();
        }

        public boolean copy$default$4() {
            return this.asSucceeded();
        }

        public OrderId _1() {
            return this.orderId();
        }

        public Option<Position> _2() {
            return this.position();
        }

        public Seq<OrderEvent.OrderResumed.HistoryOperation> _3() {
            return this.historyOperations();
        }

        public boolean _4() {
            return this.asSucceeded();
        }
    }

    public static final class ResumeOrders
    implements CommonCommand,
    ControllerCommand,
    Big,
    Product,
    Serializable {
        private final Iterable orderIds;
        private final boolean asSucceeded;

        public static ResumeOrders apply(Iterable<OrderId> iterable, boolean bl) {
            return ControllerCommand$ResumeOrders$.MODULE$.apply(iterable, bl);
        }

        public static ResumeOrders fromProduct(Product product) {
            return ControllerCommand$ResumeOrders$.MODULE$.fromProduct(product);
        }

        public static ResumeOrders unapply(ResumeOrders resumeOrders) {
            return ControllerCommand$ResumeOrders$.MODULE$.unapply(resumeOrders);
        }

        public static boolean $lessinit$greater$default$2() {
            return ControllerCommand$ResumeOrders$.MODULE$.$lessinit$greater$default$2();
        }

        public ResumeOrders(Iterable<OrderId> orderIds, boolean asSucceeded) {
            this.orderIds = orderIds;
            this.asSucceeded = asSucceeded;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.orderIds()));
            n = Statics.mix((int)n, (int)(this.asSucceeded() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResumeOrders)) return false;
            ResumeOrders resumeOrders = (ResumeOrders)object;
            if (this.asSucceeded() != resumeOrders.asSucceeded()) return false;
            Iterable<OrderId> iterable = this.orderIds();
            Iterable<OrderId> iterable2 = resumeOrders.orderIds();
            if (iterable != null) {
                if (!iterable.equals(iterable2)) return false;
                return true;
            }
            if (iterable2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ResumeOrders;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ResumeOrders";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "orderIds";
            }
            if (1 == n2) {
                return "asSucceeded";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Iterable<OrderId> orderIds() {
            return this.orderIds;
        }

        public boolean asSucceeded() {
            return this.asSucceeded;
        }

        public ResumeOrders copy(Iterable<OrderId> orderIds, boolean asSucceeded) {
            return new ResumeOrders(orderIds, asSucceeded);
        }

        public Iterable<OrderId> copy$default$1() {
            return this.orderIds();
        }

        public boolean copy$default$2() {
            return this.asSucceeded();
        }

        public Iterable<OrderId> _1() {
            return this.orderIds();
        }

        public boolean _2() {
            return this.asSucceeded();
        }
    }

    public static final class ShutDown
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final boolean restart;
        private final Option clusterAction;
        private final boolean suppressSnapshot;
        private final boolean dontNotifyActiveNode;

        public static ShutDown apply(boolean bl, Option<ClusterAction> option, boolean bl2, boolean bl3) {
            return ControllerCommand$ShutDown$.MODULE$.apply(bl, option, bl2, bl3);
        }

        public static ShutDown fromProduct(Product product) {
            return ControllerCommand$ShutDown$.MODULE$.fromProduct(product);
        }

        public static Decoder<ShutDown> jsonDecoder() {
            return ControllerCommand$ShutDown$.MODULE$.jsonDecoder();
        }

        public static Encoder.AsObject<ShutDown> jsonEncoder() {
            return ControllerCommand$ShutDown$.MODULE$.jsonEncoder();
        }

        public static ShutDown unapply(ShutDown shutDown) {
            return ControllerCommand$ShutDown$.MODULE$.unapply(shutDown);
        }

        public static boolean $lessinit$greater$default$1() {
            return ControllerCommand$ShutDown$.MODULE$.$lessinit$greater$default$1();
        }

        public static Option<ClusterAction> $lessinit$greater$default$2() {
            return ControllerCommand$ShutDown$.MODULE$.$lessinit$greater$default$2();
        }

        public static boolean $lessinit$greater$default$3() {
            return ControllerCommand$ShutDown$.MODULE$.$lessinit$greater$default$3();
        }

        public static boolean $lessinit$greater$default$4() {
            return ControllerCommand$ShutDown$.MODULE$.$lessinit$greater$default$4();
        }

        public ShutDown(boolean restart, Option<ClusterAction> clusterAction, boolean suppressSnapshot, boolean dontNotifyActiveNode) {
            this.restart = restart;
            this.clusterAction = clusterAction;
            this.suppressSnapshot = suppressSnapshot;
            this.dontNotifyActiveNode = dontNotifyActiveNode;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.restart() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.clusterAction()));
            n = Statics.mix((int)n, (int)(this.suppressSnapshot() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.dontNotifyActiveNode() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ShutDown)) return false;
            ShutDown shutDown = (ShutDown)object;
            if (this.restart() != shutDown.restart()) return false;
            if (this.suppressSnapshot() != shutDown.suppressSnapshot()) return false;
            if (this.dontNotifyActiveNode() != shutDown.dontNotifyActiveNode()) return false;
            Option<ClusterAction> option = this.clusterAction();
            Option<ClusterAction> option2 = shutDown.clusterAction();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ShutDown;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ShutDown";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "restart";
                }
                case 1: {
                    return "clusterAction";
                }
                case 2: {
                    return "suppressSnapshot";
                }
                case 3: {
                    return "dontNotifyActiveNode";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean restart() {
            return this.restart;
        }

        public Option<ClusterAction> clusterAction() {
            return this.clusterAction;
        }

        public boolean suppressSnapshot() {
            return this.suppressSnapshot;
        }

        public boolean dontNotifyActiveNode() {
            return this.dontNotifyActiveNode;
        }

        public ShutDown copy(boolean restart, Option<ClusterAction> clusterAction, boolean suppressSnapshot, boolean dontNotifyActiveNode) {
            return new ShutDown(restart, clusterAction, suppressSnapshot, dontNotifyActiveNode);
        }

        public boolean copy$default$1() {
            return this.restart();
        }

        public Option<ClusterAction> copy$default$2() {
            return this.clusterAction();
        }

        public boolean copy$default$3() {
            return this.suppressSnapshot();
        }

        public boolean copy$default$4() {
            return this.dontNotifyActiveNode();
        }

        public boolean _1() {
            return this.restart();
        }

        public Option<ClusterAction> _2() {
            return this.clusterAction();
        }

        public boolean _3() {
            return this.suppressSnapshot();
        }

        public boolean _4() {
            return this.dontNotifyActiveNode();
        }

        public static interface ClusterAction {
            public static TypedJsonCodec<ClusterAction> jsonCodec() {
                return ControllerCommand$ShutDown$ClusterAction$.MODULE$.jsonCodec();
            }

            public static int ordinal(ClusterAction clusterAction) {
                return ControllerCommand$ShutDown$ClusterAction$.MODULE$.ordinal(clusterAction);
            }
        }
    }

    public static final class SuspendOrders
    implements CommonCommand,
    ControllerCommand,
    Big,
    Product,
    Serializable {
        private final Iterable orderIds;
        private final SuspensionMode mode;

        public static SuspendOrders apply(Iterable<OrderId> iterable, SuspensionMode suspensionMode) {
            return ControllerCommand$SuspendOrders$.MODULE$.apply(iterable, suspensionMode);
        }

        public static SuspendOrders fromProduct(Product product) {
            return ControllerCommand$SuspendOrders$.MODULE$.fromProduct(product);
        }

        public static SuspendOrders unapply(SuspendOrders suspendOrders) {
            return ControllerCommand$SuspendOrders$.MODULE$.unapply(suspendOrders);
        }

        public static SuspensionMode $lessinit$greater$default$2() {
            return ControllerCommand$SuspendOrders$.MODULE$.$lessinit$greater$default$2();
        }

        public SuspendOrders(Iterable<OrderId> orderIds, SuspensionMode mode) {
            this.orderIds = orderIds;
            this.mode = mode;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SuspendOrders)) return false;
            SuspendOrders suspendOrders = (SuspendOrders)object;
            Iterable<OrderId> iterable = this.orderIds();
            Iterable<OrderId> iterable2 = suspendOrders.orderIds();
            if (iterable == null) {
                if (iterable2 != null) {
                    return false;
                }
            } else if (!iterable.equals(iterable2)) return false;
            SuspensionMode suspensionMode = this.mode();
            SuspensionMode suspensionMode2 = suspendOrders.mode();
            if (suspensionMode == null) {
                if (suspensionMode2 == null) return true;
                return false;
            } else {
                if (!((Object)suspensionMode).equals(suspensionMode2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SuspendOrders;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SuspendOrders";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "orderIds";
            }
            if (1 == n2) {
                return "mode";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Iterable<OrderId> orderIds() {
            return this.orderIds;
        }

        public SuspensionMode mode() {
            return this.mode;
        }

        public SuspendOrders copy(Iterable<OrderId> orderIds, SuspensionMode mode) {
            return new SuspendOrders(orderIds, mode);
        }

        public Iterable<OrderId> copy$default$1() {
            return this.orderIds();
        }

        public SuspensionMode copy$default$2() {
            return this.mode();
        }

        public Iterable<OrderId> _1() {
            return this.orderIds();
        }

        public SuspensionMode _2() {
            return this.mode();
        }
    }

    public static final class TransferOrders
    implements CommonCommand,
    ControllerCommand,
    Product,
    Serializable {
        private final VersionedItemId workflowId;

        public static TransferOrders apply(VersionedItemId<WorkflowPath> versionedItemId) {
            return ControllerCommand$TransferOrders$.MODULE$.apply(versionedItemId);
        }

        public static TransferOrders fromProduct(Product product) {
            return ControllerCommand$TransferOrders$.MODULE$.fromProduct(product);
        }

        public static TransferOrders unapply(TransferOrders transferOrders) {
            return ControllerCommand$TransferOrders$.MODULE$.unapply(transferOrders);
        }

        public TransferOrders(VersionedItemId<WorkflowPath> workflowId) {
            this.workflowId = workflowId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TransferOrders)) return false;
            TransferOrders transferOrders = (TransferOrders)object;
            VersionedItemId<WorkflowPath> versionedItemId = this.workflowId();
            VersionedItemId<WorkflowPath> versionedItemId2 = transferOrders.workflowId();
            if (versionedItemId != null) {
                if (!((Object)versionedItemId).equals(versionedItemId2)) return false;
                return true;
            }
            if (versionedItemId2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TransferOrders;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TransferOrders";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "workflowId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public VersionedItemId<WorkflowPath> workflowId() {
            return this.workflowId;
        }

        public TransferOrders copy(VersionedItemId<WorkflowPath> workflowId) {
            return new TransferOrders(workflowId);
        }

        public VersionedItemId<WorkflowPath> copy$default$1() {
            return this.workflowId();
        }

        public VersionedItemId<WorkflowPath> _1() {
            return this.workflowId();
        }
    }
}

