/*
 * Decompiled with CFR 0.152.
 */
package js7.data.state;

import cats.Applicative;
import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.syntax.package;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.Timestamp;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichPartialFunction$;
import js7.base.utils.ScalaUtils$syntax$RichScalaUtilsMap$;
import js7.data.agent.AgentPath;
import js7.data.board.BoardPath;
import js7.data.board.BoardState;
import js7.data.board.BoardState$;
import js7.data.controller.ControllerId;
import js7.data.event.ItemContainer;
import js7.data.item.InventoryItemKey;
import js7.data.item.InventoryItemState;
import js7.data.item.UnsignedItemKey;
import js7.data.item.UnsignedItemState;
import js7.data.item.UnsignedSimpleItem;
import js7.data.item.UnsignedSimpleItemPath;
import js7.data.item.VersionedItemId;
import js7.data.job.JobKey;
import js7.data.job.JobResource;
import js7.data.job.JobResource$;
import js7.data.job.JobResourcePath;
import js7.data.lock.LockPath;
import js7.data.lock.LockState;
import js7.data.lock.LockState$;
import js7.data.order.Order;
import js7.data.order.Order$FailedInFork$;
import js7.data.order.Order$Ready$;
import js7.data.order.OrderEvent;
import js7.data.order.OrderId;
import js7.data.value.expression.Scope;
import js7.data.value.expression.Scope$;
import js7.data.value.expression.scopes.JobResourceScope$;
import js7.data.value.expression.scopes.NowScope$;
import js7.data.value.expression.scopes.OrderScopes;
import js7.data.value.expression.scopes.OrderScopes$;
import js7.data.workflow.Instruction;
import js7.data.workflow.Workflow;
import js7.data.workflow.WorkflowControl$;
import js7.data.workflow.WorkflowPath;
import js7.data.workflow.WorkflowPathControl;
import js7.data.workflow.WorkflowPathControl$;
import js7.data.workflow.WorkflowPathControlPath;
import js7.data.workflow.WorkflowPathControlPath$;
import js7.data.workflow.instructions.BoardInstruction;
import js7.data.workflow.instructions.End;
import js7.data.workflow.instructions.executable.WorkflowJob;
import js7.data.workflow.package$WorkflowControlId$;
import js7.data.workflow.position.Label;
import js7.data.workflow.position.WorkflowPosition;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.MapView;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyBoolean;
import scala.util.Either;
import scala.util.Left;

public interface StateView
extends ItemContainer {
    public boolean isAgent();

    public static Option maybeAgentPath$(StateView $this) {
        return $this.maybeAgentPath();
    }

    default public Option<AgentPath> maybeAgentPath() {
        return None$.MODULE$;
    }

    public ControllerId controllerId();

    public PartialFunction<OrderId, Order<Order.State>> idToOrder();

    public Iterable<Order<Order.State>> orders();

    public static int slowProcessingOrderCount$(StateView $this, AgentPath agentPath) {
        return $this.slowProcessingOrderCount(agentPath);
    }

    default public int slowProcessingOrderCount(AgentPath agentPath) {
        return this.orders().iterator().filter((Function1 & Serializable)_$1 -> _$1.attached().contains((Object)agentPath)).count((Function1 & Serializable)_$2 -> _$2.isState(ClassTag$.MODULE$.apply(Order.Processing.class)));
    }

    public static int jobToOrderCount$(StateView $this, JobKey jobKey) {
        return $this.jobToOrderCount(jobKey);
    }

    default public int jobToOrderCount(JobKey jobKey) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.idToWorkflow());
        return BoxesRunTime.unboxToInt((Object)ScalaUtils$syntax$RichPartialFunction$.MODULE$.get$extension(partialFunction, jobKey.workflowId()).fold(StateView::jobToOrderCount$$anonfun$1, (Function1 & Serializable)workflow -> this.orders().view().count((Function1 & Serializable)order -> {
            if (!(order.state() instanceof Order.Processing)) return false;
            VersionedItemId<WorkflowPath> versionedItemId = order.workflowId();
            VersionedItemId<WorkflowPath> versionedItemId2 = jobKey.workflowId();
            if (versionedItemId == null) {
                if (versionedItemId2 != null) {
                    return false;
                }
            } else if (!((Object)versionedItemId).equals(versionedItemId2)) return false;
            if (!workflow.positionToJobKey(order.position()).contains((Object)jobKey)) return false;
            return true;
        })));
    }

    public PartialFunction<VersionedItemId<WorkflowPath>, Workflow> idToWorkflow();

    public Either<Problem, VersionedItemId<WorkflowPath>> workflowPathToId(WorkflowPath var1);

    public static MapView pathToWorkflowPathControl$(StateView $this) {
        return $this.pathToWorkflowPathControl();
    }

    default public MapView<WorkflowPathControlPath, WorkflowPathControl> pathToWorkflowPathControl() {
        return this.keyTo(WorkflowPathControl$.MODULE$).mapValues((Function1 & Serializable)_$3 -> (WorkflowPathControl)_$3.item());
    }

    public MapView<UnsignedItemKey, UnsignedItemState> keyToUnsignedItemState();

    public static MapView keyTo$(StateView $this, InventoryItemState.Companion A) {
        return $this.keyTo(A);
    }

    default public <A extends InventoryItemState> MapView<InventoryItemKey, A> keyTo(InventoryItemState.Companion<A> A) {
        return this.keyToUnsignedItemState().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                UnsignedItemState v = (UnsignedItemState)tuple2._2();
                return v.companion() == A;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static MapView pathToUnsignedSimple$(StateView $this, UnsignedSimpleItem.Companion A) {
        return $this.pathToUnsignedSimple(A);
    }

    default public <A extends UnsignedSimpleItem> MapView<UnsignedSimpleItemPath, A> pathToUnsignedSimple(UnsignedSimpleItem.Companion<A> A) {
        return this.keyToUnsignedItemState().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                UnsignedItemState v = (UnsignedItemState)tuple2._2();
                return v.item().companion() == A;
            }
            throw new MatchError((Object)tuple2);
        }).mapValues((Function1 & Serializable)_$4 -> _$4.item());
    }

    public static Set availableNotices$(StateView $this, Iterable expectedSeq) {
        return $this.availableNotices((Iterable<OrderEvent.OrderNoticesExpected.Expected>)expectedSeq);
    }

    default public Set<BoardPath> availableNotices(Iterable<OrderEvent.OrderNoticesExpected.Expected> expectedSeq) {
        return ((IterableOnceOps)expectedSeq.collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ StateView $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(OrderEvent.OrderNoticesExpected.Expected x2) {
                OrderEvent.OrderNoticesExpected.Expected expected;
                OrderEvent.OrderNoticesExpected.Expected x3 = expected = x2;
                return this.$outer.keyTo(BoardState$.MODULE$).get((Object)x3.boardPath()).exists(arg_0 -> StateView.js7$data$state$StateView$$anon$1$$_$isDefinedAt$$anonfun$1(x3, arg_0));
            }

            public final Object applyOrElse(OrderEvent.OrderNoticesExpected.Expected x2, Function1 function1) {
                OrderEvent.OrderNoticesExpected.Expected expected;
                OrderEvent.OrderNoticesExpected.Expected x3 = expected = x2;
                if (this.$outer.keyTo(BoardState$.MODULE$).get((Object)x3.boardPath()).exists(arg_0 -> StateView.js7$data$state$StateView$$anon$1$$_$applyOrElse$$anonfun$1(x3, arg_0))) {
                    return x3.boardPath();
                }
                return function1.apply((Object)x2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{js7$data$state$StateView$$anon$1$$_$isDefinedAt$$anonfun$1(js7.data.order.OrderEvent$OrderNoticesExpected$Expected js7.data.board.BoardState ), js7$data$state$StateView$$anon$1$$_$applyOrElse$$anonfun$1(js7.data.order.OrderEvent$OrderNoticesExpected$Expected js7.data.board.BoardState )}, serializedLambda);
            }
        })).toSet();
    }

    public static Either workflowPositionToBoardState$(StateView $this, WorkflowPosition workflowPosition) {
        return $this.workflowPositionToBoardState(workflowPosition);
    }

    default public Either<Problem, BoardState> workflowPositionToBoardState(WorkflowPosition workflowPosition) {
        return this.workflowPositionToBoardPath(workflowPosition).flatMap((Function1 & Serializable)boardPath -> {
            PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.keyTo(BoardState$.MODULE$));
            return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, boardPath, Tag$.MODULE$.apply(BoardPath.class, LightTypeTag$.MODULE$.parse(1326589135, "\u0004\u0000\u0001\u0018js7.data.board.BoardPath\u0001\u0001", "\u0000\u0007\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0018js7.data.board.BoardPath\u0001\u0001\n\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.item.SimpleItemPath\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.UnsignedItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001$js7.data.item.UnsignedSimpleItemPath\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.UnsignedItemKey\u0001\u0001\u0004\u0000\u0001\u0090\f\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0002\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0006\u0004\u0000\u0001\u0090\f\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\n\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001", 30))).map((Function1 & Serializable)boardState -> boardState);
        });
    }

    public static Either workflowPositionToBoardPath$(StateView $this, WorkflowPosition workflowPosition) {
        return $this.workflowPositionToBoardPath(workflowPosition);
    }

    default public Either<Problem, BoardPath> workflowPositionToBoardPath(WorkflowPosition workflowPosition) {
        return this.instruction_(workflowPosition, ClassTag$.MODULE$.apply(BoardInstruction.class)).flatMap((Function1 & Serializable)_$6 -> {
            SeqOps seqOps;
            Seq seq = _$6.referencedBoardPaths().toSeq();
            if (seq != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq), 1) == 0) {
                BoardPath boardPath;
                BoardPath boardPath2 = boardPath = (BoardPath)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                return package$.MODULE$.Right().apply((Object)boardPath2);
            }
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("Legacy orderIdToBoardState, but instruction has multiple BoardPaths"));
        });
    }

    public static boolean isOrderProcessable$(StateView $this, Order order) {
        return $this.isOrderProcessable(order);
    }

    default public boolean isOrderProcessable(Order<Order.State> order) {
        return order.isProcessable() && !this.isOrderAtStopPosition(order) && !this.isOrderAtBreakpoint(order) && !this.isWorkflowSuspended(order.workflowPath());
    }

    public static boolean isOrderAtStopPosition$(StateView $this, Order order) {
        return $this.isOrderAtStopPosition(order);
    }

    default public boolean isOrderAtStopPosition(Order<Order.State> order) {
        return order.stopPositions().nonEmpty() && ((Workflow)this.idToWorkflow().apply(order.workflowId())).isOrderAtStopPosition(order);
    }

    public static boolean isOrderAtBreakpoint$(StateView $this, Order order) {
        return $this.isOrderAtBreakpoint(order);
    }

    default public boolean isOrderAtBreakpoint(Order<Order.State> order) {
        return order.isState(ClassTag$.MODULE$.apply(Order.IsFreshOrReady.class)) && order.isSuspendibleNow() && !order.isResumed() && this.keyTo(WorkflowControl$.MODULE$).get(package$WorkflowControlId$.MODULE$.apply(order.workflowId())).exists((Function1 & Serializable)_$7 -> _$7.breakpoints().contains((Object)order.position().normalized()));
    }

    public static Either workflowJob$(StateView $this, WorkflowPosition workflowPosition) {
        return $this.workflowJob(workflowPosition);
    }

    default public Either<Problem, WorkflowJob> workflowJob(WorkflowPosition workflowPosition) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.idToWorkflow());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, workflowPosition.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).flatMap((Function1 & Serializable)workflow -> workflow.checkedWorkflowJob(workflowPosition.position()).map((Function1 & Serializable)job -> job));
    }

    private Either<Problem, WorkflowJob> keyToJob(JobKey jobKey) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.idToWorkflow());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, jobKey.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).flatMap((Function1 & Serializable)_$8 -> {
            Map map = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(_$8.keyToJob());
            return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(map, jobKey, Tag$.MODULE$.apply(JobKey.class, LightTypeTag$.MODULE$.parse(-228237535, "\u0004\u0000\u0001\u0013js7.data.job.JobKey\u0001\u0001", "\u0000\u0000\u0000", 30)));
        });
    }

    public static Either orderIdToBoardState$(StateView $this, OrderId orderId) {
        return $this.orderIdToBoardState(orderId);
    }

    default public Either<Problem, BoardState> orderIdToBoardState(OrderId orderId) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.idToOrder());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, orderId, Tag$.MODULE$.apply(OrderId.class, LightTypeTag$.MODULE$.parse(-414890029, "\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))).flatMap((Function1 & Serializable)order -> this.instruction_(order.workflowPosition(), ClassTag$.MODULE$.apply(BoardInstruction.class)).flatMap((Function1 & Serializable)instr -> {
            Left left;
            SeqOps seqOps;
            Vector vector = instr.referencedBoardPaths().toVector();
            if (vector != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Vector().unapplySeq((SeqOps)vector), 1) == 0) {
                BoardPath boardPath2;
                BoardPath o = boardPath2 = (BoardPath)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                left = package$.MODULE$.Right().apply((Object)o);
            } else {
                left = package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("Legacy orderIdToBoardState, but instruction has multiple BoardPaths"));
            }
            return left.flatMap((Function1 & Serializable)boardPath -> {
                PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.keyTo(BoardState$.MODULE$));
                return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, boardPath, Tag$.MODULE$.apply(BoardPath.class, LightTypeTag$.MODULE$.parse(1326589135, "\u0004\u0000\u0001\u0018js7.data.board.BoardPath\u0001\u0001", "\u0000\u0007\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0018js7.data.board.BoardPath\u0001\u0001\n\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.item.SimpleItemPath\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.UnsignedItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001$js7.data.item.UnsignedSimpleItemPath\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.UnsignedItemKey\u0001\u0001\u0004\u0000\u0001\u0090\f\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0002\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0006\u0004\u0000\u0001\u0090\f\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\n\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001", 30))).map((Function1 & Serializable)boardState -> boardState);
            });
        }));
    }

    public static Instruction instruction$(StateView $this, WorkflowPosition workflowPosition) {
        return $this.instruction(workflowPosition);
    }

    default public Instruction instruction(WorkflowPosition workflowPosition) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.idToWorkflow());
        Either either = Checked$.MODULE$.Ops(ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, workflowPosition.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))));
        return ((Workflow)Checked$Ops$.MODULE$.orThrow$extension(either)).instruction(workflowPosition.position());
    }

    public static Either instruction_$(StateView $this, WorkflowPosition workflowPosition, ClassTag evidence$1) {
        return $this.instruction_(workflowPosition, evidence$1);
    }

    default public <A extends Instruction> Either<Problem, A> instruction_(WorkflowPosition workflowPosition, ClassTag<A> evidence$1) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.idToWorkflow());
        Either either = Checked$.MODULE$.Ops(ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, workflowPosition.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))));
        return ((Workflow)Checked$Ops$.MODULE$.orThrow$extension(either)).instruction_(workflowPosition.position(), evidence$1);
    }

    public static Either workflowPositionToLabel$(StateView $this, WorkflowPosition workflowPosition) {
        return $this.workflowPositionToLabel(workflowPosition);
    }

    default public Either<Problem, Option<Label>> workflowPositionToLabel(WorkflowPosition workflowPosition) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.idToWorkflow());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, workflowPosition.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).flatMap((Function1 & Serializable)workflow -> workflow.labeledInstruction(workflowPosition.position()).map((Function1 & Serializable)labeled -> labeled.maybeLabel()));
    }

    public static boolean childOrderEnded$(StateView $this, Order order, Order parent) {
        return $this.childOrderEnded(order, parent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean childOrderEnded(Order<Order.State> order, Order<Order.Forked> parent) {
        LazyBoolean lazyBoolean = new LazyBoolean();
        if (!order.isDetachedOrAttached()) return false;
        Option<Order.AttachedState> option = order.attachedState();
        Option<Order.AttachedState> option2 = parent.attachedState();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (order.state() == Order$FailedInFork$.MODULE$) return true;
        if (!this.endReached$1(lazyBoolean, order, parent)) return false;
        return true;
    }

    public static boolean isSuspendedOrStopped$(StateView $this, Order order) {
        return $this.isSuspendedOrStopped(order);
    }

    default public boolean isSuspendedOrStopped(Order<Order.State> order) {
        return order.isSuspendedOrStopped() || this.isWorkflowSuspended(order.workflowPath());
    }

    public static boolean isWorkflowSuspended$(StateView $this, WorkflowPath workflowPath) {
        return $this.isWorkflowSuspended(workflowPath);
    }

    default public boolean isWorkflowSuspended(WorkflowPath workflowPath) {
        return this.keyTo(WorkflowPathControl$.MODULE$).get((Object)WorkflowPathControlPath$.MODULE$.apply(workflowPath)).exists((Function1 & Serializable)_$9 -> ((WorkflowPathControl)_$9.item()).suspended());
    }

    public static Either toPureOrderScope$(StateView $this, Order order) {
        return $this.toPureOrderScope(order);
    }

    default public Either<Problem, Scope> toPureOrderScope(Order<Order.State> order) {
        return this.toOrderScopes(order).map((Function1 & Serializable)orderScopes -> orderScopes.pureOrderScope());
    }

    public static Either toImpureOrderExecutingScope$(StateView $this, Order order, Timestamp now) {
        return $this.toImpureOrderExecutingScope(order, now);
    }

    default public Either<Problem, Scope> toImpureOrderExecutingScope(Order<Order.State> order, Timestamp now) {
        return this.toOrderScopes(order).map((Function1 & Serializable)orderScopes -> {
            Scope nowScope = NowScope$.MODULE$.apply(now);
            return (Scope)package.semigroup$.MODULE$.catsSyntaxSemigroup(package.semigroup$.MODULE$.catsSyntaxSemigroup((Object)orderScopes.pureOrderScope(), Scope$.MODULE$.given_Monoid_Scope()).$bar$plus$bar((Object)nowScope), Scope$.MODULE$.given_Monoid_Scope()).$bar$plus$bar((Object)JobResourceScope$.MODULE$.apply((PartialFunction<JobResourcePath, JobResource>)this.keyTo(JobResource$.MODULE$), (Scope)package.semigroup$.MODULE$.catsSyntaxSemigroup((Object)orderScopes.variablelessOrderScope(), Scope$.MODULE$.given_Monoid_Scope()).$bar$plus$bar((Object)nowScope)));
        });
    }

    public static Either toOrderScopes$(StateView $this, Order order) {
        return $this.toOrderScopes(order);
    }

    default public Either<Problem, OrderScopes> toOrderScopes(Order<Order.State> order) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.idToWorkflow());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, order.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).map((Function1 & Serializable)w -> OrderScopes$.MODULE$.apply(order, (Workflow)w, this.controllerId()));
    }

    public static Either foreachLockDemand$(StateView $this, Seq demands, Function2 op) {
        return $this.foreachLockDemand((Seq<OrderEvent.LockDemand>)demands, op);
    }

    default public <A> Either<Problem, Seq<A>> foreachLockDemand(Seq<OrderEvent.LockDemand> demands, Function2<LockState, Option<Object>, Either<Problem, A>> op) {
        return (Either)package.traverse$.MODULE$.toTraverseOps(demands, UnorderedFoldable$.MODULE$.catsTraverseForSeq()).traverse((Function1 & Serializable)demand -> {
            PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.keyTo(LockState$.MODULE$));
            return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, demand.lockPath(), Tag$.MODULE$.apply(LockPath.class, LightTypeTag$.MODULE$.parse(876090908, "\u0004\u0000\u0001\u0016js7.data.lock.LockPath\u0001\u0001", "\u0000\u0007\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.UnsignedItemKey\u0001\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0016js7.data.lock.LockPath\u0001\u0001\n\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.item.SimpleItemPath\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.UnsignedItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001$js7.data.item.UnsignedSimpleItemPath\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0002\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\f\u0001\u0001\u0006\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\n\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 30))).flatMap((Function1 & Serializable)_$10 -> (Either)op.apply(_$10, demand.count()));
        }, (Applicative)Invariant$.MODULE$.catsMonadErrorForEither());
    }

    public static Either foreachLock$(StateView $this, Seq lockPaths, Function1 op) {
        return $this.foreachLock((Seq<LockPath>)lockPaths, op);
    }

    default public <A> Either<Problem, Seq<A>> foreachLock(Seq<LockPath> lockPaths, Function1<LockState, Either<Problem, A>> op) {
        return (Either)package.traverse$.MODULE$.toTraverseOps(lockPaths, UnorderedFoldable$.MODULE$.catsTraverseForSeq()).traverse((Function1 & Serializable)lockPath -> {
            PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.keyTo(LockState$.MODULE$));
            return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, lockPath, Tag$.MODULE$.apply(LockPath.class, LightTypeTag$.MODULE$.parse(876090908, "\u0004\u0000\u0001\u0016js7.data.lock.LockPath\u0001\u0001", "\u0000\u0007\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.UnsignedItemKey\u0001\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0016js7.data.lock.LockPath\u0001\u0001\n\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.item.SimpleItemPath\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.UnsignedItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001$js7.data.item.UnsignedSimpleItemPath\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0002\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\f\u0001\u0001\u0006\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\n\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 30))).flatMap(op);
        }, (Applicative)Invariant$.MODULE$.catsMonadErrorForEither());
    }

    private static int jobToOrderCount$$anonfun$1() {
        return 0;
    }

    public static /* synthetic */ boolean js7$data$state$StateView$$anon$1$$_$isDefinedAt$$anonfun$1(OrderEvent.OrderNoticesExpected.Expected x$1, BoardState _$5) {
        return _$5.containsNotice(x$1.noticeId());
    }

    public static /* synthetic */ boolean js7$data$state$StateView$$anon$1$$_$applyOrElse$$anonfun$1(OrderEvent.OrderNoticesExpected.Expected x$2, BoardState _$5) {
        return _$5.containsNotice(x$2.noticeId());
    }

    /*
     * Unable to fully structure code
     */
    private boolean endReached$lzyINIT1$1(LazyBoolean endReached$lzy1$1, Order order$2, Order parent$1) {
        var4_4 = endReached$lzy1$1;
        synchronized (var4_4) {
            block6: {
                block5: {
                    if (!endReached$lzy1$1.initialized()) break block5;
                    v0 = endReached$lzy1$1.value();
                    break block6;
                }
                v1 = order$2.state();
                var6_5 = Order$Ready$.MODULE$;
                if (v1 != null ? v1.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
                if (order$2.position().parent().contains((Object)parent$1.position()) && this.instruction(order$2.workflowPosition()) instanceof End) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                v0 = endReached$lzy1$1.initialize(v2);
            }
            var5_6 = v0;
        }
        return var5_6;
    }

    private boolean endReached$1(LazyBoolean endReached$lzy1$2, Order order$3, Order parent$2) {
        if (endReached$lzy1$2.initialized()) {
            return endReached$lzy1$2.value();
        }
        return this.endReached$lzyINIT1$1(endReached$lzy1$2, order$3, parent$2);
    }
}

