/*
 * Decompiled with CFR 0.152.
 */
package js7.data.value;

import java.io.Serializable;
import js7.data.value.BooleanValue;
import js7.data.value.BooleanValue$;
import js7.data.value.ListValue;
import js7.data.value.ListValue$;
import js7.data.value.NumberValue;
import js7.data.value.NumberValue$;
import js7.data.value.StringValue;
import js7.data.value.StringValue$;
import js7.data.value.Value;
import js7.data.value.expression.Expression;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ValuePrinter$
implements Serializable {
    private static final boolean preferSingleOverDoubleQuotes;
    private static final Set<Object> quotedChars;
    public static final ValuePrinter$ MODULE$;

    private ValuePrinter$() {
    }

    static {
        MODULE$ = new ValuePrinter$();
        preferSingleOverDoubleQuotes = true;
        quotedChars = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'\"', '$', '\n'}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ValuePrinter$.class);
    }

    public String nameToExpressionToString(Map<String, Expression> nameToExpr) {
        StringBuilder sb = new StringBuilder();
        this.appendNameToExpression(sb, nameToExpr);
        return sb.toString();
    }

    public void appendNameToExpression(StringBuilder sb, Map<String, Expression> nameToExpr) {
        sb.append('{');
        nameToExpr.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Expression expr = (Expression)tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Expression expr = (Expression)tuple2._2();
                if (BoxesRunTime.unboxToChar((Object)sb.last()) != '{') {
                    sb.append(", ");
                }
                MODULE$.appendQuoted(sb, name);
                sb.append(": ");
                return sb.append(expr.toString());
            }
            throw new MatchError((Object)tuple2);
        });
        sb.append('}');
    }

    public void appendValue(StringBuilder sb, Value value) {
        Value value2 = value;
        if (value2 instanceof BooleanValue) {
            boolean bl;
            BooleanValue booleanValue = BooleanValue$.MODULE$.unapply((BooleanValue)value2);
            boolean bool = bl = booleanValue._1();
            sb.append(bool);
            return;
        }
        if (value2 instanceof NumberValue) {
            BigDecimal bigDecimal;
            NumberValue numberValue = NumberValue$.MODULE$.unapply((NumberValue)value2);
            BigDecimal number = bigDecimal = numberValue._1();
            sb.append((Object)number);
            return;
        }
        if (value2 instanceof StringValue) {
            String string;
            StringValue stringValue = StringValue$.MODULE$.unapply((StringValue)value2);
            String string2 = string = stringValue._1();
            this.appendQuoted(sb, string2);
            return;
        }
        if (value2 instanceof ListValue) {
            Vector<Value> vector;
            ListValue listValue = ListValue$.MODULE$.unapply((ListValue)value2);
            Vector<Value> values = vector = listValue._1();
            sb.append('[');
            Iterator it = values.iterator();
            if (it.hasNext()) {
                this.appendValue(sb, (Value)it.next());
                while (it.hasNext()) {
                    sb.append(", ");
                    this.appendValue(sb, (Value)it.next());
                }
            }
            sb.append(']');
            return;
        }
        sb.append("???");
    }

    public String quoteString(String string) {
        StringBuilder sb = new StringBuilder(string.length() + 10);
        this.appendQuoted(sb, string);
        return sb.toString();
    }

    public void appendQuoted(StringBuilder sb, String string) {
        if (string.isEmpty()) {
            sb.append("\"\"");
            return;
        }
        if (!StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(string), '\'') && (preferSingleOverDoubleQuotes || StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(string), quotedChars)) && !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(string), '\r')) {
            sb.append('\'');
            sb.append(string);
            sb.append('\'');
            return;
        }
        sb.append('\"');
        this.appendQuotedContent(sb, string);
        sb.append('\"');
    }

    public void appendQuotedContent(StringBuilder sb, String string) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string))) {
            StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(string), (Function1 & Serializable)x$1 -> ValuePrinter$.appendQuotedContent$$anonfun$1(sb, BoxesRunTime.unboxToChar((Object)x$1)));
            return;
        }
    }

    private static final /* synthetic */ StringBuilder appendQuotedContent$$anonfun$1(StringBuilder sb$2, char x$1) {
        char c = x$1;
        switch (c) {
            case '\\': {
                return sb$2.append("\\\\");
            }
            case '\"': {
                return sb$2.append("\\\"");
            }
            case '$': {
                return sb$2.append("\\$");
            }
            case '\r': {
                return sb$2.append("\\r");
            }
            case '\n': {
                return sb$2.append("\\n");
            }
            case '\t': {
                return sb$2.append("\\t");
            }
        }
        char c2 = c;
        return sb$2.append(c2);
    }
}

