/*
 * Decompiled with CFR 0.152.
 */
package js7.journal;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.unsafe.IORuntime;
import com.typesafe.scalalogging.Logger;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.catsutils.CatsEffectUtils$;
import js7.base.circeutils.typed.TypedJsonCodec$;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.generic.Accepted;
import js7.base.generic.Accepted$;
import js7.base.log.CanBindCorrelId$;
import js7.base.log.CorrelId;
import js7.base.log.CorrelId$;
import js7.base.monixlike.FutureCancelable;
import js7.base.monixlike.FutureCancelable$;
import js7.base.monixlike.StandardFutureCancelable;
import js7.base.problem.Problem;
import js7.base.problem.ProblemException$;
import js7.base.thread.Futures$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.Stopwatch$;
import js7.base.utils.Assertions$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEither$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.StackTraces$;
import js7.base.utils.StackTraces$StackTraceThrowable$;
import js7.common.pekkoutils.ReceiveLoggingActor;
import js7.data.event.Event;
import js7.data.event.EventId$;
import js7.data.event.JournaledState;
import js7.data.event.KeyedEvent;
import js7.data.event.SnapshotableState;
import js7.data.event.Stamped;
import js7.journal.CommitOptions;
import js7.journal.CommitOptions$;
import js7.journal.JournalActor;
import js7.journal.JournalActor$Input$Store$;
import js7.journal.JournalActor$Output$Accepted$;
import js7.journal.JournalActor$Output$Stored$;
import js7.journal.JournalingActor$;
import js7.journal.JournalingActor$Deferred$;
import js7.journal.JournalingActor$EventsCallback$;
import js7.journal.JournalingActor$Persist$;
import js7.journal.JournalingActor$PersistAcceptEarly$;
import js7.journal.JournalingActor$Timestamped$;
import js7.journal.configuration.JournalConf;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Stash;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public interface JournalingActor<S extends JournaledState<S>, E extends Event>
extends Stash,
ActorLogging,
ReceiveLoggingActor {
    public static void $init$(JournalingActor $this) {
        $this.js7$journal$JournalingActor$$stashingCount_$eq(0);
        $this.js7$journal$JournalingActor$_setter_$js7$journal$JournalingActor$$persistStatistics_$eq($this.new PersistStatistics());
        $this.js7$journal$JournalingActor$$_persistedEventId_$eq(EventId$.MODULE$.BeforeFirst());
        $this.js7$journal$JournalingActor$_setter_$js7$journal$JournalingActor$$journalingTimer_$eq(new AtomicReference<FutureCancelable>(FutureCancelable$.MODULE$.empty()));
        $this.become("receive", (PartialFunction<Object, BoxedUnit>)$this.receive());
    }

    public /* synthetic */ void js7$journal$JournalingActor$$super$become(String var1, PartialFunction var2);

    public /* synthetic */ void js7$journal$JournalingActor$$super$postStop();

    public /* synthetic */ void js7$journal$JournalingActor$$super$stash();

    public ActorRef journalActor();

    public JournalConf journalConf();

    public IORuntime ioRuntime();

    public static IORuntime js7$journal$JournalingActor$$given_IORuntime$(JournalingActor $this) {
        return $this.js7$journal$JournalingActor$$given_IORuntime();
    }

    default public IORuntime js7$journal$JournalingActor$$given_IORuntime() {
        return this.ioRuntime();
    }

    public int js7$journal$JournalingActor$$stashingCount();

    public void js7$journal$JournalingActor$$stashingCount_$eq(int var1);

    public PersistStatistics js7$journal$JournalingActor$$persistStatistics();

    public void js7$journal$JournalingActor$_setter_$js7$journal$JournalingActor$$persistStatistics_$eq(PersistStatistics var1);

    public long js7$journal$JournalingActor$$_persistedEventId();

    public void js7$journal$JournalingActor$$_persistedEventId_$eq(long var1);

    public AtomicReference<FutureCancelable> js7$journal$JournalingActor$$journalingTimer();

    public void js7$journal$JournalingActor$_setter_$js7$journal$JournalingActor$$journalingTimer_$eq(AtomicReference var1);

    public static long persistedEventId$(JournalingActor $this) {
        return $this.persistedEventId();
    }

    default public long persistedEventId() {
        return this.js7$journal$JournalingActor$$_persistedEventId();
    }

    public static void persistedEventId_$eq$(JournalingActor $this, long eventId) {
        $this.persistedEventId_$eq(eventId);
    }

    default public void persistedEventId_$eq(long eventId) {
        this.js7$journal$JournalingActor$$_persistedEventId_$eq(eventId);
    }

    public static void become$(JournalingActor $this, String stateName, PartialFunction receive) {
        $this.become(stateName, (PartialFunction<Object, BoxedUnit>)receive);
    }

    @Override
    default public void become(String stateName, PartialFunction<Object, BoxedUnit> receive) {
        this.js7$journal$JournalingActor$$super$become(stateName, this.journaling().orElse(receive));
    }

    public static void postStop$(JournalingActor $this) {
        $this.postStop();
    }

    @Override
    default public void postStop() {
        this.js7$journal$JournalingActor$$journalingTimer().get().cancelAndForget();
        this.js7$journal$JournalingActor$$super$postStop();
    }

    public static IO persistKeyedEventIO$(JournalingActor $this, KeyedEvent keyedEvent, boolean async, Function2 callback) {
        return $this.persistKeyedEventIO(keyedEvent, async, callback);
    }

    default public <A> IO<Either<Problem, A>> persistKeyedEventIO(KeyedEvent<E> keyedEvent, boolean async, Function2<Stamped<KeyedEvent<E>>, S, A> callback) {
        return CatsEffectUtils$.MODULE$.promiseIO((JProcedure1 & Serializable)promise -> this.self().$bang(this.js7$journal$JournalingActor$$Persist().apply(keyedEvent, async, callback, promise), this.self()));
    }

    public static boolean persistKeyedEventIO$default$2$(JournalingActor $this) {
        return $this.persistKeyedEventIO$default$2();
    }

    default public boolean persistKeyedEventIO$default$2() {
        return false;
    }

    public static IO persistKeyedEventAcceptEarlyIO$(JournalingActor $this, Seq keyedEvents, Option timestampMillis, CommitOptions options) {
        return $this.persistKeyedEventAcceptEarlyIO(keyedEvents, (Option<Object>)timestampMillis, options);
    }

    default public <EE extends E> IO<Either<Problem, Accepted>> persistKeyedEventAcceptEarlyIO(Seq<KeyedEvent<EE>> keyedEvents, Option<Object> timestampMillis, CommitOptions options) {
        return CatsEffectUtils$.MODULE$.promiseIO((JProcedure1 & Serializable)promise -> this.self().$bang((Object)this.js7$journal$JournalingActor$$PersistAcceptEarly().apply(keyedEvents, timestampMillis, options, (Promise<Either<Problem, Accepted>>)promise), this.self()));
    }

    public static Option persistKeyedEventAcceptEarlyIO$default$2$(JournalingActor $this) {
        return $this.persistKeyedEventAcceptEarlyIO$default$2();
    }

    default public <EE extends E> Option<Object> persistKeyedEventAcceptEarlyIO$default$2() {
        return None$.MODULE$;
    }

    public static CommitOptions persistKeyedEventAcceptEarlyIO$default$3$(JournalingActor $this) {
        return $this.persistKeyedEventAcceptEarlyIO$default$3();
    }

    default public <EE extends E> CommitOptions persistKeyedEventAcceptEarlyIO$default$3() {
        return CommitOptions$.MODULE$.default();
    }

    public static Future persistKeyedEvent$(JournalingActor $this, KeyedEvent keyedEvent, Option timestampMillis, boolean async, Function2 callback) {
        return $this.persistKeyedEvent(keyedEvent, (Option<Object>)timestampMillis, async, callback);
    }

    default public <EE extends E, A> Future<A> persistKeyedEvent(KeyedEvent<EE> keyedEvent, Option<Object> timestampMillis, boolean async, Function2<Stamped<KeyedEvent<EE>>, S, A> callback) {
        Timestamped<EE> timestamped = this.Timestamped(keyedEvent, timestampMillis);
        List list = package$.MODULE$.Nil().$colon$colon(timestamped);
        CommitOptions commitOptions = this.persistKeyedEvents$default$2();
        return this.persistKeyedEvents((Seq<Timestamped<EE>>)list, commitOptions, async, (Function2<Seq<Stamped<KeyedEvent<EE>>>, S, A>)(Function2 & Serializable)(events, journaledState) -> {
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)JournalingActor.v$proxy1$1(events)), "events.sizeIs == 1"), FullName$.MODULE$.apply("js7.journal.JournalingActor.persistKeyedEvent"), FileName$.MODULE$.apply("JournalingActor.scala"), Line$.MODULE$.apply(84));
            return callback.apply(events.head(), journaledState);
        });
    }

    public static Option persistKeyedEvent$default$2$(JournalingActor $this) {
        return $this.persistKeyedEvent$default$2();
    }

    default public <EE extends E, A> Option<Object> persistKeyedEvent$default$2() {
        return None$.MODULE$;
    }

    public static boolean persistKeyedEvent$default$3$(JournalingActor $this) {
        return $this.persistKeyedEvent$default$3();
    }

    default public boolean persistKeyedEvent$default$3() {
        return false;
    }

    public static Future persistKeyedEvents$(JournalingActor $this, Seq timestamped, CommitOptions options, boolean async, Function2 callback) {
        return $this.persistKeyedEvents(timestamped, options, async, callback);
    }

    default public <EE extends E, A> Future<A> persistKeyedEvents(Seq<Timestamped<EE>> timestamped, CommitOptions options, boolean async, Function2<Seq<Stamped<KeyedEvent<EE>>>, S, A> callback) {
        return this.persistKeyedEventsReturnChecked2(timestamped, options, async, this.persistKeyedEventsReturnChecked2$default$4(), callback).map((Function1 & Serializable)_$1 -> {
            Either either = ScalaUtils$syntax$.MODULE$.RichEither(_$1);
            return ScalaUtils$syntax$RichEither$.MODULE$.orThrow$extension(either);
        }, this.ioRuntime().compute());
    }

    public static CommitOptions persistKeyedEvents$default$2$(JournalingActor $this) {
        return $this.persistKeyedEvents$default$2();
    }

    default public <EE extends E, A> CommitOptions persistKeyedEvents$default$2() {
        return CommitOptions$.MODULE$.default();
    }

    public static boolean persistKeyedEvents$default$3$(JournalingActor $this) {
        return $this.persistKeyedEvents$default$3();
    }

    default public boolean persistKeyedEvents$default$3() {
        return false;
    }

    public static Future persistKeyedEventsReturnChecked$(JournalingActor $this, Seq timestamped, CommitOptions options, boolean async, Function2 callback) {
        return $this.persistKeyedEventsReturnChecked(timestamped, options, async, callback);
    }

    default public <EE extends E, A> Future<Either<Problem, A>> persistKeyedEventsReturnChecked(Seq<Timestamped<EE>> timestamped, CommitOptions options, boolean async, Function2<Seq<Stamped<KeyedEvent<EE>>>, S, A> callback) {
        return this.persistKeyedEventsReturnChecked2(timestamped, options, async, true, callback);
    }

    public static CommitOptions persistKeyedEventsReturnChecked$default$2$(JournalingActor $this) {
        return $this.persistKeyedEventsReturnChecked$default$2();
    }

    default public <EE extends E, A> CommitOptions persistKeyedEventsReturnChecked$default$2() {
        return CommitOptions$.MODULE$.default();
    }

    public static boolean persistKeyedEventsReturnChecked$default$3$(JournalingActor $this) {
        return $this.persistKeyedEventsReturnChecked$default$3();
    }

    default public boolean persistKeyedEventsReturnChecked$default$3() {
        return false;
    }

    private <EE extends E, A> Future<Either<Problem, A>> persistKeyedEventsReturnChecked2(Seq<Timestamped<EE>> timestamped, CommitOptions options, boolean async, boolean dontCrashActorOnFailure, Function2<Seq<Stamped<KeyedEvent<EE>>>, S, A> callback) {
        return Futures$.MODULE$.promiseFuture((JProcedure1 & Serializable)promise -> {
            this.js7$journal$JournalingActor$$start(async, (Function0<String>)((Function0 & Serializable)() -> JournalingActor.persistKeyedEventsReturnChecked2$$anonfun$1$$anonfun$1(timestamped)));
            if (JournalingActor$.js7$journal$JournalingActor$$$TraceLog && JournalingActor$.js7$journal$JournalingActor$$$logger.underlying().isTraceEnabled()) {
                timestamped.foreach((Function1)(JProcedure1 & Serializable)t -> {
                    Logger LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger;
                    if (LoggerImpl_this.underlying().isTraceEnabled()) {
                        LoggerImpl_this.underlying().trace("\u00bb{}\u00ab Store {} <-: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.toString(), t.keyedEvent().key(), TypedJsonCodec$.MODULE$.typeName(t.keyedEvent().event().getClass())}), Object.class));
                        return;
                    }
                });
            }
            CorrelId correlId = CorrelId$.MODULE$.current();
            Deadline deadline = Deadline$.MODULE$.now();
            EventsCallback eventsCallback = this.js7$journal$JournalingActor$$EventsCallback().apply(CorrelId$.MODULE$.current(), async, (JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Either either = x$1;
                if (either instanceof Left) {
                    Problem problem = (Problem)((Left)either).value();
                    if (!dontCrashActorOnFailure) {
                        Logger LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger;
                        if (LoggerImpl_this.underlying().isErrorEnabled()) {
                            LoggerImpl_this.underlying().error("\u00bb{}\u00ab Event could not be stored: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.toString(), problem}), Object.class));
                        }
                        ((IterableOnceOps)timestamped.map((Function1 & Serializable)_$3 -> _$3.keyedEvent())).foreach((Function1)(JProcedure1 & Serializable)stamped -> {
                            Logger LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger;
                            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                                LoggerImpl_this.underlying().error(stamped.toString());
                                return;
                            }
                        });
                        Throwable throwable = StackTraces$.MODULE$.StackTraceThrowable(problem.throwable());
                        throw StackTraces$StackTraceThrowable$.MODULE$.appendCurrentStackTrace$extension(throwable);
                    }
                    Logger LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("\u00bb{}\u00ab \ud83d\udca5 {}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.toString(), problem, this.js7$journal$JournalingActor$$stashingCountRemaining()}), Object.class));
                    }
                    promise.complete((Try)Success$.MODULE$.apply((Object)package$.MODULE$.Left().apply((Object)problem)));
                    return;
                }
                if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                    Success success;
                    Seq stampedSeq = (Seq)tuple2._1();
                    JournaledState journaledState = (JournaledState)tuple2._2();
                    Promise promise = promise;
                    try {
                        success = Success$.MODULE$.apply((Object)package$.MODULE$.Right().apply(callback.apply((Object)stampedSeq, (Object)journaledState)));
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable t = throwable3 = (Throwable)option.get();
                            Logger LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger;
                            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                                Throwable throwable4 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                                LoggerImpl_this.underlying().error("\u00bb" + this.toString() + "\u00ab " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable4) + "\n" + ("persistKeyedEvents(" + timestamped.map((Function1 & Serializable)_$4 -> _$4.keyedEvent()) + ")"), t);
                            }
                            throw t;
                        }
                        throw throwable;
                    }
                    Success success2 = success;
                    Promise promise2 = promise;
                    promise = null;
                    Success success3 = success2;
                    success2 = null;
                    promise2.complete((Try)success3);
                    return;
                }
                throw new MatchError((Object)either);
            });
            boolean bl = JournalActor$Input$Store$.MODULE$.$lessinit$greater$default$6();
            this.journalActor().forward((Object)JournalActor$Input$Store$.MODULE$.apply(correlId, (Seq<JournalActor.Timestamped>)timestamped, this.self(), options, deadline, bl, eventsCallback), this.context());
        });
    }

    private <EE extends E, A> CommitOptions persistKeyedEventsReturnChecked2$default$2() {
        return CommitOptions$.MODULE$.default();
    }

    private boolean persistKeyedEventsReturnChecked2$default$3() {
        return false;
    }

    private boolean persistKeyedEventsReturnChecked2$default$4() {
        return false;
    }

    public static void defer$(JournalingActor $this, Function0 callback) {
        $this.defer((Function0<BoxedUnit>)callback);
    }

    default public void defer(Function0<BoxedUnit> callback) {
        this.defer_(false, callback);
    }

    public static void deferAsync$(JournalingActor $this, Function0 callback) {
        $this.deferAsync((Function0<BoxedUnit>)callback);
    }

    default public void deferAsync(Function0<BoxedUnit> callback) {
        this.defer_(true, callback);
    }

    private void defer_(boolean async, Function0<BoxedUnit> callback) {
        this.js7$journal$JournalingActor$$start(async, (Function0<String>)((Function0 & Serializable)JournalingActor::defer_$$anonfun$1));
        CorrelId correlId = CorrelId$.MODULE$.current();
        CommitOptions commitOptions = CommitOptions$.MODULE$.default();
        Deadline deadline = Deadline$.MODULE$.now();
        Deferred deferred = this.js7$journal$JournalingActor$$Deferred().apply(CorrelId$.MODULE$.current(), async, (Function1<Either<Problem, Accepted>, BoxedUnit>)(JProcedure1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Problem problem = (Problem)((Left)either).value();
                Throwable throwable = StackTraces$.MODULE$.StackTraceThrowable(problem.throwable());
                throw StackTraces$StackTraceThrowable$.MODULE$.appendCurrentStackTrace$extension(throwable);
            }
            if (either instanceof Right && Accepted$.MODULE$.equals(((Right)either).value())) {
                callback.apply$mcV$sp();
                return;
            }
            throw new MatchError((Object)either);
        });
        boolean bl = JournalActor$Input$Store$.MODULE$.$lessinit$greater$default$6();
        this.journalActor().forward((Object)JournalActor$Input$Store$.MODULE$.apply(correlId, (Seq<JournalActor.Timestamped>)package$.MODULE$.Nil(), this.self(), commitOptions, deadline, bl, deferred), this.context());
    }

    public static void js7$journal$JournalingActor$$start$(JournalingActor $this, boolean async, Function0 firstName) {
        $this.js7$journal$JournalingActor$$start(async, (Function0<String>)firstName);
    }

    default public void js7$journal$JournalingActor$$start(boolean async, Function0<String> firstName) {
        if (this.js7$journal$JournalingActor$$stashingCount() == JournalingActor$.js7$journal$JournalingActor$$$Inhibited) {
            throw new IllegalStateException("Journaling is inhibited");
        }
        if (!async) {
            this.beginStashing(firstName);
            return;
        }
    }

    public static PartialFunction journaling$(JournalingActor $this) {
        return $this.journaling();
    }

    default public PartialFunction<Object, BoxedUnit> journaling() {
        return new Serializable(this){
            private final /* synthetic */ JournalingActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x2) {
                JournalActor.Output.Accepted accepted;
                JournalActor.CallersItem callersItem;
                Object object = x2;
                if (object instanceof Persist && ((Persist)object).js7$journal$JournalingActor$Persist$$$outer() == this.$outer) {
                    Persist<A> persist = this.$outer.js7$journal$JournalingActor$$Persist().unapply((Persist)object);
                    KeyedEvent<E> keyedEvent = persist._1();
                    boolean bl = persist._2();
                    Function2<Stamped<KeyedEvent<E>>, S, A> function2 = persist._3();
                    Promise<Either<Problem, A>> promise = persist._4();
                    KeyedEvent<E> keyedEvent2 = keyedEvent;
                    boolean async = bl;
                    Function2<Stamped<KeyedEvent<E>>, S, A> callback = function2;
                    Promise<Either<Problem, A>> promise2 = promise;
                    return true;
                }
                if (object instanceof PersistAcceptEarly && ((PersistAcceptEarly)object).js7$journal$JournalingActor$PersistAcceptEarly$$$outer() == this.$outer) {
                    PersistAcceptEarly persistAcceptEarly = this.$outer.js7$journal$JournalingActor$$PersistAcceptEarly().unapply((PersistAcceptEarly)object);
                    Seq<KeyedEvent<E>> seq = persistAcceptEarly._1();
                    Option<Object> option = persistAcceptEarly._2();
                    CommitOptions commitOptions = persistAcceptEarly._3();
                    Promise<Either<Problem, Accepted>> promise = persistAcceptEarly._4();
                    Seq<KeyedEvent<E>> keyedEvents = seq;
                    Option<Object> timestampMillis = option;
                    CommitOptions options = commitOptions;
                    Promise<Either<Problem, Accepted>> promise3 = promise;
                    return true;
                }
                if (object instanceof JournalActor.Output.Stored) {
                    JournalActor.Output.Stored<S> stored = JournalActor$Output$Stored$.MODULE$.unapply((JournalActor.Output.Stored)object);
                    Either<Problem, Seq<Stamped<KeyedEvent<Event>>>> either = stored._1();
                    S s = stored._2();
                    JournalActor.CallersItem callersItem2 = stored._3();
                    Either<Problem, Seq<Stamped<KeyedEvent<Event>>>> stampedSeqChecked = either;
                    SnapshotableState journaledState = (SnapshotableState)s;
                    if (callersItem2 instanceof Item) {
                        Item item = (Item)callersItem2;
                        return true;
                    }
                }
                if (object instanceof JournalActor.Output.Accepted && (callersItem = (accepted = JournalActor$Output$Accepted$.MODULE$.unapply((JournalActor.Output.Accepted)object))._1()) instanceof Item) {
                    Item item = (Item)callersItem;
                    return true;
                }
                Object msg = object;
                return this.$outer.js7$journal$JournalingActor$$stashingCount() > 0;
            }

            public final Object applyOrElse(Object x2, Function1 function1) {
                JournalActor.Output.Accepted accepted;
                JournalActor.CallersItem callersItem;
                Object object = x2;
                if (object instanceof Persist && ((Persist)object).js7$journal$JournalingActor$Persist$$$outer() == this.$outer) {
                    Persist<A> persist = this.$outer.js7$journal$JournalingActor$$Persist().unapply((Persist)object);
                    KeyedEvent<E> keyedEvent = persist._1();
                    boolean bl = persist._2();
                    Function2<Stamped<KeyedEvent<E>>, S, A> function2 = persist._3();
                    Promise<Either<Problem, A>> promise = persist._4();
                    KeyedEvent<E> keyedEvent2 = keyedEvent;
                    boolean async = bl;
                    Function2<Stamped<KeyedEvent<E>>, S, A> callback = function2;
                    Promise<Either<Problem, A>> promise2 = promise;
                    promise2.completeWith(this.$outer.persistKeyedEvent(keyedEvent2, this.$outer.persistKeyedEvent$default$2(), async, (arg_0, arg_1) -> JournalingActor.js7$journal$JournalingActor$$anon$1$$_$applyOrElse$$anonfun$1(callback, arg_0, arg_1)));
                    return BoxedUnit.UNIT;
                }
                if (object instanceof PersistAcceptEarly && ((PersistAcceptEarly)object).js7$journal$JournalingActor$PersistAcceptEarly$$$outer() == this.$outer) {
                    PersistAcceptEarly persistAcceptEarly = this.$outer.js7$journal$JournalingActor$$PersistAcceptEarly().unapply((PersistAcceptEarly)object);
                    Seq<KeyedEvent<E>> seq = persistAcceptEarly._1();
                    Option<Object> option = persistAcceptEarly._2();
                    CommitOptions commitOptions = persistAcceptEarly._3();
                    Promise<Either<Problem, Accepted>> promise = persistAcceptEarly._4();
                    Seq<KeyedEvent<E>> keyedEvents = seq;
                    Option<Object> timestampMillis = option;
                    CommitOptions options = commitOptions;
                    Promise<Either<Problem, Accepted>> promise3 = promise;
                    this.$outer.js7$journal$JournalingActor$$start(true, (Function0<String>)((Function0 & Serializable)JournalingActor::js7$journal$JournalingActor$$anon$1$$_$applyOrElse$$anonfun$2));
                    Seq timestamped = (Seq)keyedEvents.map((Function1 & Serializable)_$5 -> this.$outer.Timestamped(_$5, timestampMillis));
                    this.$outer.journalActor().forward((Object)JournalActor$Input$Store$.MODULE$.apply(CorrelId$.MODULE$.current(), (Seq<JournalActor.Timestamped>)timestamped, this.$outer.self(), options, Deadline$.MODULE$.now(), true, this.$outer.js7$journal$JournalingActor$$Deferred().apply(CorrelId$.MODULE$.current(), true, (Function1<Either<Problem, Accepted>, BoxedUnit>)((JProcedure1 & Serializable)arg_0 -> JournalingActor.js7$journal$JournalingActor$$anon$1$$_$applyOrElse$$anonfun$3(promise3, arg_0)))), this.$outer.context());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof JournalActor.Output.Stored) {
                    JournalActor.Output.Stored<S> stored = JournalActor$Output$Stored$.MODULE$.unapply((JournalActor.Output.Stored)object);
                    Either<Problem, Seq<Stamped<KeyedEvent<Event>>>> either = stored._1();
                    S s = stored._2();
                    JournalActor.CallersItem callersItem2 = stored._3();
                    Either<Problem, Seq<Stamped<KeyedEvent<Event>>>> stampedSeqChecked = either;
                    SnapshotableState journaledState = (SnapshotableState)s;
                    if (callersItem2 instanceof Item) {
                        Item item = (Item)callersItem2;
                        return item.correlId().bind((Function0 & Serializable)() -> {
                            this.applyOrElse$$anonfun$4(item, stampedSeqChecked, journaledState);
                            return BoxedUnit.UNIT;
                        }, CanBindCorrelId$.MODULE$.forUnit());
                    }
                }
                if (object instanceof JournalActor.Output.Accepted && (callersItem = (accepted = JournalActor$Output$Accepted$.MODULE$.unapply((JournalActor.Output.Accepted)object))._1()) instanceof Item) {
                    Item item;
                    Item item2 = (Item)callersItem;
                    if (!item2.async()) {
                        this.$outer.js7$journal$JournalingActor$$endStashing((Seq<Stamped<KeyedEvent<Event>>>)package$.MODULE$.Nil());
                    }
                    if (!((item = item2) instanceof Deferred) || ((Deferred)item).js7$journal$JournalingActor$Deferred$$$outer() != this.$outer) {
                        throw scala.sys.package$.MODULE$.error("JournalActor.Output.Accepted message does not match item '" + item2 + "'");
                    }
                    Deferred deferred = this.$outer.js7$journal$JournalingActor$$Deferred().unapply((Deferred)item);
                    CorrelId correlId = deferred._1();
                    boolean bl = deferred._2();
                    Function1<Either<Problem, Accepted>, BoxedUnit> function12 = deferred._3();
                    CorrelId correlId2 = correlId;
                    Function1<Either<Problem, Accepted>, BoxedUnit> callback = function12;
                    correlId2.bind((Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$5(callback);
                        return BoxedUnit.UNIT;
                    }, CanBindCorrelId$.MODULE$.forUnit());
                    return BoxedUnit.UNIT;
                }
                Object msg = object;
                if (this.$outer.js7$journal$JournalingActor$$stashingCount() > 0) {
                    Logger LoggerImpl_this;
                    if (JournalingActor$.js7$journal$JournalingActor$$$TraceLog && (LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger).underlying().isTraceEnabled()) {
                        LoggerImpl_this.underlying().trace("\u00bb{}\u00ab \ud83d\udfe0 Still waiting for event commit: stash {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.$outer.toString(), msg}), Object.class));
                    }
                    this.$outer.js7$journal$JournalingActor$$super$stash();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x2);
            }

            private final void applyOrElse$$anonfun$4(Item item$1, Either stampedSeqChecked$1, SnapshotableState journaledState$1) {
                Either either;
                if (!item$1.async()) {
                    this.$outer.js7$journal$JournalingActor$$endStashing((Seq<Stamped<KeyedEvent<Event>>>)((Seq)stampedSeqChecked$1.getOrElse(JournalingActor::js7$journal$JournalingActor$$anon$1$$_$applyOrElse$$anonfun$4$$anonfun$1)));
                }
                if ((either = stampedSeqChecked$1) instanceof Left) {
                    Problem problem = (Problem)((Left)either).value();
                    Item item = item$1;
                    if (item instanceof EventsCallback && ((EventsCallback)item).js7$journal$JournalingActor$EventsCallback$$$outer() == this.$outer) {
                        EventsCallback eventsCallback = (EventsCallback)item;
                        eventsCallback.callback().apply((Object)package$.MODULE$.Left().apply((Object)problem));
                        return;
                    }
                    if (item instanceof Deferred && ((Deferred)item).js7$journal$JournalingActor$Deferred$$$outer() == this.$outer) {
                        Deferred deferred = (Deferred)item;
                        deferred.callback().apply((Object)package$.MODULE$.Left().apply((Object)problem));
                        return;
                    }
                    throw scala.sys.package$.MODULE$.error("JournalActor.Output.Stored(" + problem + ") \u00b7 Message does not match item '" + item$1 + "'");
                }
                if (either instanceof Right) {
                    Seq stampedSeq = (Seq)((Right)either).value();
                    this.$outer.js7$journal$JournalingActor$$persistStatistics().onStored(stampedSeq.size());
                    stampedSeq.lastOption().foreach((Function1)(JProcedure1 & Serializable)last -> this.$outer.js7$journal$JournalingActor$$_persistedEventId_$eq(last.eventId()));
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)stampedSeq, (Object)item$1);
                    if (tuple2 != null) {
                        Item item = (Item)tuple2._2();
                        if (item instanceof EventsCallback && ((EventsCallback)item).js7$journal$JournalingActor$EventsCallback$$$outer() == this.$outer) {
                            EventsCallback eventsCallback = (EventsCallback)item;
                            if (JournalingActor$.js7$journal$JournalingActor$$$TraceLog && JournalingActor$.js7$journal$JournalingActor$$$logger.underlying().isTraceEnabled()) {
                                stampedSeq.foreach((Function1)(JProcedure1 & Serializable)st -> {
                                    Logger LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger;
                                    if (LoggerImpl_this.underlying().isTraceEnabled()) {
                                        LoggerImpl_this.underlying().trace("\u00bb{}\u00ab Stored {} {} <-: {}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.$outer.toString(), EventId$.MODULE$.toString(st.eventId()), ((KeyedEvent)st.value()).key(), TypedJsonCodec$.MODULE$.typeName(((KeyedEvent)st.value()).event().getClass()), this.$outer.js7$journal$JournalingActor$$stashingCountRemaining()}), Object.class));
                                        return;
                                    }
                                });
                            }
                            eventsCallback.callback().apply((Object)package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)stampedSeq, (Object)journaledState$1)));
                            return;
                        }
                        Nil$ nil$ = package$.MODULE$.Nil();
                        Object object = tuple2._1();
                        if (!(nil$ != null ? !nil$.equals(object) : object != null)) {
                            if (item instanceof Deferred && ((Deferred)item).js7$journal$JournalingActor$Deferred$$$outer() == this.$outer) {
                                Logger LoggerImpl_this;
                                Deferred deferred = (Deferred)item;
                                if (JournalingActor$.js7$journal$JournalingActor$$$TraceLog && (LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger).underlying().isTraceEnabled()) {
                                    LoggerImpl_this.underlying().trace("\u00bb{}\u00ab Stored (no event){}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.$outer.toString(), this.$outer.js7$journal$JournalingActor$$stashingCountRemaining()}), Object.class));
                                }
                                deferred.callback().apply((Object)package$.MODULE$.Right().apply((Object)Accepted$.MODULE$));
                                return;
                            }
                        }
                    }
                    throw scala.sys.package$.MODULE$.error("JournalActor.Output.Stored(" + stampedSeq.length() + "\u00d7) message does not match item '" + item$1 + "'");
                }
                throw new MatchError((Object)either);
            }

            private final void applyOrElse$$anonfun$5(Function1 callback$7) {
                Logger LoggerImpl_this;
                if (JournalingActor$.js7$journal$JournalingActor$$$TraceLog && (LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger).underlying().isTraceEnabled()) {
                    LoggerImpl_this.underlying().trace("\u00bb{}\u00ab Stored (events are written, not flushed){}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.$outer.toString(), this.$outer.js7$journal$JournalingActor$$stashingCountRemaining()}), Object.class));
                }
                callback$7.apply((Object)package$.MODULE$.Right().apply((Object)Accepted$.MODULE$));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{js7$journal$JournalingActor$$anon$1$$_$applyOrElse$$anonfun$1(scala.Function2 js7.data.event.Stamped js7.data.event.JournaledState ), js7$journal$JournalingActor$$anon$1$$_$applyOrElse$$anonfun$2(), $anonfun$3(scala.Option js7.data.event.KeyedEvent ), js7$journal$JournalingActor$$anon$1$$_$applyOrElse$$anonfun$3(scala.concurrent.Promise scala.util.Either ), applyOrElse$$anonfun$adapted$1(js7.journal.JournalingActor$Item scala.util.Either js7.data.event.SnapshotableState ), applyOrElse$$anonfun$adapted$2(scala.Function1 ), js7$journal$JournalingActor$$anon$1$$_$applyOrElse$$anonfun$4$$anonfun$1(), applyOrElse$$anonfun$4$$anonfun$2(js7.data.event.Stamped ), applyOrElse$$anonfun$4$$anonfun$3(js7.data.event.Stamped )}, serializedLambda);
            }
        };
    }

    private void beginStashing(Function0<String> firstName) {
        this.js7$journal$JournalingActor$$stashingCount_$eq(this.js7$journal$JournalingActor$$stashingCount() + 1);
        if (this.js7$journal$JournalingActor$$stashingCount() == 1) {
            this.js7$journal$JournalingActor$$persistStatistics().beginStashing((String)firstName.apply());
            this.logBecome("journaling");
            this.context().become(this.journaling(), false);
            if (this.journalConf().persistWarnDurations().nonEmpty()) {
                Logger LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    Deadline since = Deadline$.MODULE$.now();
                    Stream stream = Stream$.MODULE$.PureOps(Stream$.MODULE$.iterable(this.journalConf().persistWarnDurations()));
                    StandardFutureCancelable timer = FutureCancelable$.MODULE$.apply((Function0<Future<BoxedUnit>>)((IO)StreamExtensions$.MODULE$.repeatLast(Stream.PureOps$.MODULE$.covary$extension(stream)).evalMap((Function1 & Serializable)finiteDelay -> IO$.MODULE$.sleep(finiteDelay)).foreach((Function1 & Serializable)_$6 -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        this.$anonfun$5$$anonfun$1(since);
                        return BoxedUnit.UNIT;
                    })).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain()).unsafeRunCancelable(this.js7$journal$JournalingActor$$given_IORuntime()));
                    this.js7$journal$JournalingActor$$journalingTimer().getAndSet(timer).cancelAndForget();
                    return;
                }
                return;
            }
            return;
        }
    }

    public static void js7$journal$JournalingActor$$endStashing$(JournalingActor $this, Seq stamped) {
        $this.js7$journal$JournalingActor$$endStashing((Seq<Stamped<KeyedEvent<Event>>>)stamped);
    }

    default public void js7$journal$JournalingActor$$endStashing(Seq<Stamped<KeyedEvent<Event>>> stamped) {
        if (this.js7$journal$JournalingActor$$stashingCount() == 0) {
            String msg = "Journal Stored message received (duplicate? stash in callback?) but stashingCount=" + this.js7$journal$JournalingActor$$stashingCount() + ": " + stamped;
            Logger LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error("\u00bb{}\u00ab {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.toString(), msg}), Object.class));
            }
            throw new RuntimeException(msg);
        }
        this.js7$journal$JournalingActor$$stashingCount_$eq(this.js7$journal$JournalingActor$$stashingCount() - 1);
        if (this.js7$journal$JournalingActor$$stashingCount() == 0) {
            Logger LoggerImpl_this;
            this.js7$journal$JournalingActor$$journalingTimer().get().cancelAndForget();
            this.unstashAll();
            this.js7$journal$JournalingActor$$persistStatistics().endStashing();
            if (JournalingActor$.js7$journal$JournalingActor$$$TraceLog && (LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger).underlying().isTraceEnabled()) {
                LoggerImpl_this.underlying().trace("\u00bb{}\u00ab unbecome", (Object)this.toString());
            }
            this.context().unbecome();
            return;
        }
    }

    public static String js7$journal$JournalingActor$$stashingCountRemaining$(JournalingActor $this) {
        return $this.js7$journal$JournalingActor$$stashingCountRemaining();
    }

    default public String js7$journal$JournalingActor$$stashingCountRemaining() {
        return ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.js7$journal$JournalingActor$$stashingCount() > 0), (Function0<String>)((Function0 & Serializable)this::stashingCountRemaining$$anonfun$1));
    }

    public static Seq toTimestamped$(JournalingActor $this, Iterable keyEvents) {
        return $this.toTimestamped(keyEvents);
    }

    default public <EE extends E> Seq<Timestamped<EE>> toTimestamped(Iterable<KeyedEvent<EE>> keyEvents) {
        return ((IterableOnceOps)keyEvents.view().map((Function1 & Serializable)e -> this.Timestamped((KeyedEvent)e, this.Timestamped$default$2()))).toVector();
    }

    public static Timestamped Timestamped$(JournalingActor $this, KeyedEvent keyedEvent, Option timestampMillis) {
        return $this.Timestamped(keyedEvent, (Option<Object>)timestampMillis);
    }

    default public <EE extends E> Timestamped<EE> Timestamped(KeyedEvent<EE> keyedEvent, Option<Object> timestampMillis) {
        return JournalingActor$Timestamped$.MODULE$.apply(keyedEvent, timestampMillis);
    }

    public static Option Timestamped$default$2$(JournalingActor $this) {
        return $this.Timestamped$default$2();
    }

    default public <EE extends E> Option<Object> Timestamped$default$2() {
        return None$.MODULE$;
    }

    public static JournalingActor$EventsCallback$ js7$journal$JournalingActor$$EventsCallback$(JournalingActor $this) {
        return $this.js7$journal$JournalingActor$$EventsCallback();
    }

    default public JournalingActor$EventsCallback$ js7$journal$JournalingActor$$EventsCallback() {
        return new JournalingActor$EventsCallback$(this);
    }

    public static JournalingActor$Deferred$ js7$journal$JournalingActor$$Deferred$(JournalingActor $this) {
        return $this.js7$journal$JournalingActor$$Deferred();
    }

    default public JournalingActor$Deferred$ js7$journal$JournalingActor$$Deferred() {
        return new JournalingActor$Deferred$(this);
    }

    public static JournalingActor$Persist$ js7$journal$JournalingActor$$Persist$(JournalingActor $this) {
        return $this.js7$journal$JournalingActor$$Persist();
    }

    default public JournalingActor$Persist$ js7$journal$JournalingActor$$Persist() {
        return new JournalingActor$Persist$(this);
    }

    public static JournalingActor$PersistAcceptEarly$ js7$journal$JournalingActor$$PersistAcceptEarly$(JournalingActor $this) {
        return $this.js7$journal$JournalingActor$$PersistAcceptEarly();
    }

    default public JournalingActor$PersistAcceptEarly$ js7$journal$JournalingActor$$PersistAcceptEarly() {
        return new JournalingActor$PersistAcceptEarly$(this);
    }

    private static boolean v$proxy1$1(Seq events$1) {
        return IterableOps.SizeCompareOps$.MODULE$.$eq$eq$extension(events$1.sizeIs(), 1);
    }

    private static String persistKeyedEventsReturnChecked2$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "empty";
    }

    private static String persistKeyedEventsReturnChecked2$$anonfun$1$$anonfun$1(Seq timestamped$3) {
        return (String)timestamped$3.headOption().fold(JournalingActor::persistKeyedEventsReturnChecked2$$anonfun$1$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$2 -> ScalaUtils$syntax$.MODULE$.RichJavaClass(_$2.keyedEvent().event().getClass()).simpleScalaName());
    }

    private static String defer_$$anonfun$1() {
        return "defer";
    }

    public static /* synthetic */ Either js7$journal$JournalingActor$$anon$1$$_$applyOrElse$$anonfun$1(Function2 callback$6, Stamped stampedEvents, JournaledState state) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply(callback$6.apply((Object)stampedEvents, (Object)state));
        }
        catch (Throwable throwable) {
            Option<Problem> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = ProblemException$.MODULE$.unapply(throwable2)).isEmpty()) {
                Problem problem;
                Problem problem2 = problem = (Problem)option.get();
                right = package$.MODULE$.Left().apply((Object)problem2);
            }
            if (throwable2 != null) {
                Throwable t = throwable2;
                Throwable throwable3 = StackTraces$.MODULE$.StackTraceThrowable(t);
                throw StackTraces$StackTraceThrowable$.MODULE$.appendCurrentStackTrace$extension(throwable3);
            }
            throw throwable;
        }
        return right;
    }

    public static String js7$journal$JournalingActor$$anon$1$$_$applyOrElse$$anonfun$2() {
        return "persistKeyedEventAcceptEarlyIO";
    }

    public static /* synthetic */ void js7$journal$JournalingActor$$anon$1$$_$applyOrElse$$anonfun$3(Promise promise$2, Either checked) {
        promise$2.success((Object)checked);
    }

    public static Seq js7$journal$JournalingActor$$anon$1$$_$applyOrElse$$anonfun$4$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private void $anonfun$5$$anonfun$1(Deadline since$4) {
        Logger LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger;
        if (LoggerImpl_this.underlying().isWarnEnabled()) {
            LoggerImpl_this.underlying().warn("\u00bb{}\u00ab \ud83d\udfe0 Still persisting for {} ({} persist operations in progress)", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.toString(), ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$4)))), BoxesRunTime.boxToInteger((int)this.js7$journal$JournalingActor$$stashingCount())}), Object.class));
            return;
        }
    }

    private String stashingCountRemaining$$anonfun$1() {
        return ", " + this.js7$journal$JournalingActor$$stashingCount() + " remaining";
    }

    public static String js7$journal$JournalingActor$EventsCallback$$_$toString$$anonfun$1() {
        return "async";
    }

    public static String js7$journal$JournalingActor$Deferred$$_$toString$$anonfun$2() {
        return "async";
    }

    public class Deferred
    implements Item,
    Product,
    Serializable {
        private final CorrelId correlId;
        private final boolean async;
        private final Function1 callback;
        private final /* synthetic */ JournalingActor $outer;

        public Deferred(JournalingActor $outer, CorrelId correlId, boolean async, Function1<Either<Problem, Accepted>, BoxedUnit> callback) {
            this.correlId = correlId;
            this.async = async;
            this.callback = callback;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.correlId()));
            n = Statics.mix((int)n, (int)(this.async() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.callback()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Deferred)) return false;
            if (((Deferred)object).js7$journal$JournalingActor$Deferred$$$outer() != this.$outer) return false;
            Deferred deferred = (Deferred)object;
            if (this.async() != deferred.async()) return false;
            CorrelId correlId = this.correlId();
            CorrelId correlId2 = deferred.correlId();
            if (correlId == null) {
                if (correlId2 != null) {
                    return false;
                }
            } else if (!correlId.equals(correlId2)) return false;
            Function1<Either<Problem, Accepted>, BoxedUnit> function1 = this.callback();
            Function1<Either<Problem, Accepted>, BoxedUnit> function12 = deferred.callback();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!deferred.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Deferred;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Deferred";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "correlId";
                }
                case 1: {
                    return "async";
                }
                case 2: {
                    return "callback";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public CorrelId correlId() {
            return this.correlId;
        }

        @Override
        public boolean async() {
            return this.async;
        }

        public Function1<Either<Problem, Accepted>, BoxedUnit> callback() {
            return this.callback;
        }

        public String toString() {
            return "Deferred(" + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.async()), (Function0<String>)((Function0 & Serializable)JournalingActor::js7$journal$JournalingActor$Deferred$$_$toString$$anonfun$2)) + ")";
        }

        public Deferred copy(CorrelId correlId, boolean async, Function1<Either<Problem, Accepted>, BoxedUnit> callback) {
            return new Deferred(this.$outer, correlId, async, callback);
        }

        public CorrelId copy$default$1() {
            return this.correlId();
        }

        public boolean copy$default$2() {
            return this.async();
        }

        public Function1<Either<Problem, Accepted>, BoxedUnit> copy$default$3() {
            return this.callback();
        }

        public CorrelId _1() {
            return this.correlId();
        }

        public boolean _2() {
            return this.async();
        }

        public Function1<Either<Problem, Accepted>, BoxedUnit> _3() {
            return this.callback();
        }

        public final /* synthetic */ JournalingActor js7$journal$JournalingActor$Deferred$$$outer() {
            return this.$outer;
        }
    }

    public class EventsCallback
    implements Item,
    Product,
    Serializable {
        private final CorrelId correlId;
        private final boolean async;
        private final Function1 callback;
        private final /* synthetic */ JournalingActor $outer;

        public EventsCallback(JournalingActor $outer, CorrelId correlId, boolean async, Function1<Either<Problem, Tuple2<Seq<Stamped<KeyedEvent<E>>>, S>>, BoxedUnit> callback) {
            this.correlId = correlId;
            this.async = async;
            this.callback = callback;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.correlId()));
            n = Statics.mix((int)n, (int)(this.async() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.callback()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EventsCallback)) return false;
            if (((EventsCallback)object).js7$journal$JournalingActor$EventsCallback$$$outer() != this.$outer) return false;
            EventsCallback eventsCallback = (EventsCallback)object;
            if (this.async() != eventsCallback.async()) return false;
            CorrelId correlId = this.correlId();
            CorrelId correlId2 = eventsCallback.correlId();
            if (correlId == null) {
                if (correlId2 != null) {
                    return false;
                }
            } else if (!correlId.equals(correlId2)) return false;
            Function1 function1 = this.callback();
            Function1 function12 = eventsCallback.callback();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!eventsCallback.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof EventsCallback;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "EventsCallback";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "correlId";
                }
                case 1: {
                    return "async";
                }
                case 2: {
                    return "callback";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public CorrelId correlId() {
            return this.correlId;
        }

        @Override
        public boolean async() {
            return this.async;
        }

        public Function1<Either<Problem, Tuple2<Seq<Stamped<KeyedEvent<E>>>, S>>, BoxedUnit> callback() {
            return this.callback;
        }

        public String toString() {
            return "EventsCallback(" + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.async()), (Function0<String>)((Function0 & Serializable)JournalingActor::js7$journal$JournalingActor$EventsCallback$$_$toString$$anonfun$1)) + ")";
        }

        public EventsCallback copy(CorrelId correlId, boolean async, Function1<Either<Problem, Tuple2<Seq<Stamped<KeyedEvent<E>>>, S>>, BoxedUnit> callback) {
            return new EventsCallback(this.$outer, correlId, async, callback);
        }

        public CorrelId copy$default$1() {
            return this.correlId();
        }

        public boolean copy$default$2() {
            return this.async();
        }

        public Function1<Either<Problem, Tuple2<Seq<Stamped<KeyedEvent<E>>>, S>>, BoxedUnit> copy$default$3() {
            return this.callback();
        }

        public CorrelId _1() {
            return this.correlId();
        }

        public boolean _2() {
            return this.async();
        }

        public Function1<Either<Problem, Tuple2<Seq<Stamped<KeyedEvent<E>>>, S>>, BoxedUnit> _3() {
            return this.callback();
        }

        public final /* synthetic */ JournalingActor js7$journal$JournalingActor$EventsCallback$$$outer() {
            return this.$outer;
        }
    }

    public static interface Item
    extends JournalActor.CallersItem {
        public boolean async();

        public CorrelId correlId();
    }

    public class Persist<A>
    implements Product,
    Serializable {
        private final KeyedEvent keyedEvent;
        private final boolean async;
        private final Function2 callback;
        private final Promise promise;
        private final /* synthetic */ JournalingActor $outer;

        public Persist(JournalingActor $outer, KeyedEvent<E> keyedEvent, boolean async, Function2<Stamped<KeyedEvent<E>>, S, A> callback, Promise<Either<Problem, A>> promise) {
            this.keyedEvent = keyedEvent;
            this.async = async;
            this.callback = callback;
            this.promise = promise;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.keyedEvent()));
            n = Statics.mix((int)n, (int)(this.async() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.callback()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.promise()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Persist)) return false;
            if (((Persist)object).js7$journal$JournalingActor$Persist$$$outer() != this.$outer) return false;
            Persist persist = (Persist)object;
            if (this.async() != persist.async()) return false;
            KeyedEvent keyedEvent = this.keyedEvent();
            KeyedEvent keyedEvent2 = persist.keyedEvent();
            if (keyedEvent == null) {
                if (keyedEvent2 != null) {
                    return false;
                }
            } else if (!((Object)keyedEvent).equals(keyedEvent2)) return false;
            Function2 function2 = this.callback();
            Function2 function22 = persist.callback();
            if (function2 == null) {
                if (function22 != null) {
                    return false;
                }
            } else if (!function2.equals(function22)) return false;
            Promise<Either<Problem, A>> promise = this.promise();
            Promise<Either<Problem, A>> promise2 = persist.promise();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!persist.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Persist;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Persist";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "keyedEvent";
                }
                case 1: {
                    return "async";
                }
                case 2: {
                    return "callback";
                }
                case 3: {
                    return "promise";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public KeyedEvent<E> keyedEvent() {
            return this.keyedEvent;
        }

        public boolean async() {
            return this.async;
        }

        public Function2<Stamped<KeyedEvent<E>>, S, A> callback() {
            return this.callback;
        }

        public Promise<Either<Problem, A>> promise() {
            return this.promise;
        }

        public <A> Persist<A> copy(KeyedEvent<E> keyedEvent, boolean async, Function2<Stamped<KeyedEvent<E>>, S, A> callback, Promise<Either<Problem, A>> promise) {
            return new Persist<A>(this.$outer, keyedEvent, async, callback, promise);
        }

        public <A> KeyedEvent<E> copy$default$1() {
            return this.keyedEvent();
        }

        public boolean copy$default$2() {
            return this.async();
        }

        public <A> Function2<Stamped<KeyedEvent<E>>, S, A> copy$default$3() {
            return this.callback();
        }

        public <A> Promise<Either<Problem, A>> copy$default$4() {
            return this.promise();
        }

        public KeyedEvent<E> _1() {
            return this.keyedEvent();
        }

        public boolean _2() {
            return this.async();
        }

        public Function2<Stamped<KeyedEvent<E>>, S, A> _3() {
            return this.callback();
        }

        public Promise<Either<Problem, A>> _4() {
            return this.promise();
        }

        public final /* synthetic */ JournalingActor js7$journal$JournalingActor$Persist$$$outer() {
            return this.$outer;
        }
    }

    public class PersistAcceptEarly
    implements Product,
    Serializable {
        private final Seq keyedEvents;
        private final Option timestampMillis;
        private final CommitOptions options;
        private final Promise promise;
        private final /* synthetic */ JournalingActor $outer;

        public PersistAcceptEarly(JournalingActor $outer, Seq<KeyedEvent<E>> keyedEvents, Option<Object> timestampMillis, CommitOptions options, Promise<Either<Problem, Accepted>> promise) {
            this.keyedEvents = keyedEvents;
            this.timestampMillis = timestampMillis;
            this.options = options;
            this.promise = promise;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PersistAcceptEarly)) return false;
            if (((PersistAcceptEarly)object).js7$journal$JournalingActor$PersistAcceptEarly$$$outer() != this.$outer) return false;
            PersistAcceptEarly persistAcceptEarly = (PersistAcceptEarly)object;
            Seq seq = this.keyedEvents();
            Seq seq2 = persistAcceptEarly.keyedEvents();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Option<Object> option = this.timestampMillis();
            Option<Object> option2 = persistAcceptEarly.timestampMillis();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            CommitOptions commitOptions = this.options();
            CommitOptions commitOptions2 = persistAcceptEarly.options();
            if (commitOptions == null) {
                if (commitOptions2 != null) {
                    return false;
                }
            } else if (!((Object)commitOptions).equals(commitOptions2)) return false;
            Promise<Either<Problem, Accepted>> promise = this.promise();
            Promise<Either<Problem, Accepted>> promise2 = persistAcceptEarly.promise();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!persistAcceptEarly.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PersistAcceptEarly;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "PersistAcceptEarly";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "keyedEvents";
                }
                case 1: {
                    return "timestampMillis";
                }
                case 2: {
                    return "options";
                }
                case 3: {
                    return "promise";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<KeyedEvent<E>> keyedEvents() {
            return this.keyedEvents;
        }

        public Option<Object> timestampMillis() {
            return this.timestampMillis;
        }

        public CommitOptions options() {
            return this.options;
        }

        public Promise<Either<Problem, Accepted>> promise() {
            return this.promise;
        }

        public PersistAcceptEarly copy(Seq<KeyedEvent<E>> keyedEvents, Option<Object> timestampMillis, CommitOptions options, Promise<Either<Problem, Accepted>> promise) {
            return new PersistAcceptEarly(this.$outer, keyedEvents, timestampMillis, options, promise);
        }

        public Seq<KeyedEvent<E>> copy$default$1() {
            return this.keyedEvents();
        }

        public Option<Object> copy$default$2() {
            return this.timestampMillis();
        }

        public CommitOptions copy$default$3() {
            return this.options();
        }

        public Promise<Either<Problem, Accepted>> copy$default$4() {
            return this.promise();
        }

        public Seq<KeyedEvent<E>> _1() {
            return this.keyedEvents();
        }

        public Option<Object> _2() {
            return this.timestampMillis();
        }

        public CommitOptions _3() {
            return this.options();
        }

        public Promise<Either<Problem, Accepted>> _4() {
            return this.promise();
        }

        public final /* synthetic */ JournalingActor js7$journal$JournalingActor$PersistAcceptEarly$$$outer() {
            return this.$outer;
        }
    }

    public class PersistStatistics {
        private Deadline persistStartedAt;
        private int persistCount;
        private int eventCount;
        private String firstName;

        public PersistStatistics() {
            if (JournalingActor.this == null) {
                throw new NullPointerException();
            }
            this.persistStartedAt = Deadline$.MODULE$.now();
            this.persistCount = 0;
            this.eventCount = 0;
            this.firstName = "";
        }

        public void beginStashing(String firstName) {
            this.firstName = firstName;
            this.persistStartedAt = Deadline$.MODULE$.now();
            this.eventCount = 0;
            this.persistCount = 0;
        }

        public void onStored(int eventCount) {
            ++this.persistCount;
            this.eventCount += eventCount;
        }

        public void endStashing() {
            FiniteDuration duration = ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(this.persistStartedAt));
            if (duration.$greater$eq((Object)JournalingActor$.js7$journal$JournalingActor$$$BigStoreThreshold)) {
                Logger LoggerImpl_this = JournalingActor$.js7$journal$JournalingActor$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("\u00bb" + JournalingActor.this.toString() + "\u00ab Long persist completed (" + this.persistCount + "\u00d7, " + this.firstName + " ...) - " + Stopwatch$.MODULE$.itemsPerSecondString(duration, Int$.MODULE$.int2long(this.eventCount), "events"));
                    return;
                }
                return;
            }
        }

        public final /* synthetic */ JournalingActor js7$journal$JournalingActor$PersistStatistics$$$outer() {
            return JournalingActor.this;
        }
    }

    public static final class Timestamped<E extends Event>
    implements JournalActor.Timestamped,
    Product,
    Serializable {
        private final KeyedEvent keyedEvent;
        private final Option timestampMillis;

        public static <E extends Event> Timestamped<E> apply(KeyedEvent<E> keyedEvent, Option<Object> option) {
            return JournalingActor$Timestamped$.MODULE$.apply(keyedEvent, option);
        }

        public static Timestamped<?> fromProduct(Product product) {
            return JournalingActor$Timestamped$.MODULE$.fromProduct(product);
        }

        public static <E extends Event> Timestamped<E> unapply(Timestamped<E> timestamped) {
            return JournalingActor$Timestamped$.MODULE$.unapply(timestamped);
        }

        public static <E extends Event> Option<Object> $lessinit$greater$default$2() {
            return JournalingActor$Timestamped$.MODULE$.$lessinit$greater$default$2();
        }

        public Timestamped(KeyedEvent<E> keyedEvent, Option<Object> timestampMillis) {
            this.keyedEvent = keyedEvent;
            this.timestampMillis = timestampMillis;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Timestamped)) return false;
            Timestamped timestamped = (Timestamped)object;
            KeyedEvent<E> keyedEvent = this.keyedEvent();
            KeyedEvent<E> keyedEvent2 = timestamped.keyedEvent();
            if (keyedEvent == null) {
                if (keyedEvent2 != null) {
                    return false;
                }
            } else if (!((Object)keyedEvent).equals(keyedEvent2)) return false;
            Option<Object> option = this.timestampMillis();
            Option<Object> option2 = timestamped.timestampMillis();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Timestamped;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Timestamped";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "keyedEvent";
            }
            if (1 == n2) {
                return "timestampMillis";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public KeyedEvent<E> keyedEvent() {
            return this.keyedEvent;
        }

        @Override
        public Option<Object> timestampMillis() {
            return this.timestampMillis;
        }

        public <E extends Event> Timestamped<E> copy(KeyedEvent<E> keyedEvent, Option<Object> timestampMillis) {
            return new Timestamped<E>(keyedEvent, timestampMillis);
        }

        public <E extends Event> KeyedEvent<E> copy$default$1() {
            return this.keyedEvent();
        }

        public <E extends Event> Option<Object> copy$default$2() {
            return this.timestampMillis();
        }

        public KeyedEvent<E> _1() {
            return this.keyedEvent();
        }

        public Option<Object> _2() {
            return this.timestampMillis();
        }
    }
}

