/*
 * Decompiled with CFR 0.152.
 */
package js7.journal;

import cats.Applicative;
import cats.UnorderedFoldable$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Resource;
import cats.effect.std.Semaphore;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicLong;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.log.CorrelId$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.stream.IncreasingNumberSync;
import js7.base.utils.Assertions$;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.Atomic$package$Atomic$extensions$;
import js7.base.utils.BinarySearch$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.CloseableIterator;
import js7.base.utils.CloseableIterator$;
import js7.base.utils.LockKeeper;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichAny$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.Tests$;
import js7.data.event.Event;
import js7.data.event.EventId$;
import js7.data.event.JournalId;
import js7.data.event.JournalId$;
import js7.data.event.JournalInfo;
import js7.data.event.JournalInfo$;
import js7.data.event.JournalPosition;
import js7.data.event.JournaledState;
import js7.data.event.KeyedEvent;
import js7.data.event.Stamped;
import js7.journal.CommitOptions;
import js7.journal.CommitOptions$;
import js7.journal.EventIdGenerator;
import js7.journal.MemoryJournal$;
import js7.journal.MemoryJournal$EventQueue$;
import js7.journal.log.JournalLogger;
import js7.journal.state.Journal;
import js7.journal.state.ReadableStateJournal;
import js7.journal.watch.EventWatch;
import js7.journal.watch.RealEventWatch;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IndexedSeqOps;
import scala.collection.IndexedSeqView;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import sourcecode.Enclosing;
import sourcecode.Enclosing$;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public final class MemoryJournal<S extends JournaledState<S>>
implements Journal<S> {
    private IO state;
    private LockKeeper js7$journal$state$Journal$$keyLockKeeper;
    private final int size;
    private final String waitingFor;
    private final EventIdGenerator eventIdGenerator;
    private final Semaphore<IO> semaphore;
    private final JournaledState.Companion S;
    private final JournalId journalId;
    private final AsyncLock stateLock;
    private final AsyncLock queueLock;
    public volatile EventQueue js7$journal$MemoryJournal$$queue;
    private volatile S _state;
    private volatile boolean eventWatchStopped;
    private final AtomicLong _eventCount;
    private final JournalLogger journalLogger;
    private final IO whenNoFailoverByOtherNode;
    private final RealEventWatch eventWatch;
    public final MemoryJournal$EventQueue$ EventQueue$lzy1;

    public static <S extends JournaledState<S>> Resource<IO, MemoryJournal<S>> resource(S s, int n, String string, Set<String> set, EventIdGenerator eventIdGenerator, JournaledState.Companion<S> companion) {
        return MemoryJournal$.MODULE$.resource(s, n, string, set, eventIdGenerator, companion);
    }

    public static <S extends JournaledState<S>> IO<MemoryJournal<S>> start(S s, int n, String string, Set<String> set, EventIdGenerator eventIdGenerator, JournaledState.Companion<S> companion) {
        return MemoryJournal$.MODULE$.start(s, n, string, set, eventIdGenerator, companion);
    }

    public static <S extends JournaledState<S>> String resource$default$3() {
        return MemoryJournal$.MODULE$.resource$default$3();
    }

    public static <S extends JournaledState<S>> String start$default$3() {
        return MemoryJournal$.MODULE$.start$default$3();
    }

    public static <S extends JournaledState<S>> Set<String> resource$default$4() {
        return MemoryJournal$.MODULE$.resource$default$4();
    }

    public static <S extends JournaledState<S>> Set<String> start$default$4() {
        return MemoryJournal$.MODULE$.start$default$4();
    }

    public static <S extends JournaledState<S>> EventIdGenerator resource$default$5() {
        return MemoryJournal$.MODULE$.resource$default$5();
    }

    public static <S extends JournaledState<S>> EventIdGenerator start$default$5() {
        return MemoryJournal$.MODULE$.start$default$5();
    }

    public MemoryJournal(S initial, int size, String waitingFor, Set<String> infoLogEvents, EventIdGenerator eventIdGenerator, Semaphore<IO> semaphore, JournaledState.Companion<S> S) {
        this.size = size;
        this.waitingFor = waitingFor;
        this.eventIdGenerator = eventIdGenerator;
        this.semaphore = semaphore;
        this.S = S;
        this.EventQueue$lzy1 = new MemoryJournal$EventQueue$(this);
        ReadableStateJournal.$init$(this);
        Journal.$init$(this);
        this.journalId = JournalId$.MODULE$.random();
        this.stateLock = AsyncLock$.MODULE$.dontLog();
        this.queueLock = AsyncLock$.MODULE$.dontLog();
        this.js7$journal$MemoryJournal$$queue = this.EventQueue().apply(EventId$.MODULE$.BeforeFirst(), EventId$.MODULE$.BeforeFirst(), (Vector<Stamped<KeyedEvent<Event>>>)package$.MODULE$.Vector().empty());
        this._state = initial;
        this.eventWatchStopped = false;
        this._eventCount = new AtomicLong(0L);
        this.journalLogger = new JournalLogger("memory", infoLogEvents, true);
        this.whenNoFailoverByOtherNode = IO$.MODULE$.unit();
        this.eventWatch = new EventWatch(this){
            public static final long OFFSET$0;
            private IO started;
            private volatile Object js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1;
            private final boolean isActiveNode;
            private final /* synthetic */ MemoryJournal $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                EventWatch.$init$(this);
                RealEventWatch.$init$(this);
                this.isActiveNode = true;
                Statics.releaseFence();
            }

            static {
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1"));
            }

            public IO started() {
                return this.started;
            }

            public void js7$journal$watch$EventWatch$_setter_$started_$eq(IO x$0) {
                this.started = x$0;
            }

            public IncreasingNumberSync js7$journal$watch$RealEventWatch$$committedEventIdSync() {
                Object object = this.js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1;
                if (object instanceof IncreasingNumberSync) {
                    return (IncreasingNumberSync)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (IncreasingNumberSync)this.js7$journal$watch$RealEventWatch$$committedEventIdSync$lzyINIT1();
            }

            private Object js7$journal$watch$RealEventWatch$$committedEventIdSync$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            IncreasingNumberSync increasingNumberSync = null;
                            try {
                                increasingNumberSync = RealEventWatch.js7$journal$watch$RealEventWatch$$committedEventIdSync$(this);
                                object2 = increasingNumberSync == null ? LazyVals.NullValue$.MODULE$ : increasingNumberSync;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return increasingNumberSync;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public boolean isActiveNode() {
                return this.isActiveNode;
            }

            public Option eventsAfter(long after) {
                return this.$outer.js7$journal$MemoryJournal$$eventsAfter_(after).map(MemoryJournal::js7$journal$MemoryJournal$$anon$1$$_$eventsAfter$$anonfun$1);
            }

            public JournalInfo journalInfo() {
                EventQueue q = this.$outer.js7$journal$MemoryJournal$$queue;
                return JournalInfo$.MODULE$.apply(q.lastEventId(), q.tornEventId(), (Seq<JournalPosition>)package$.MODULE$.Nil());
            }

            public long tornEventId() {
                return this.$outer.js7$journal$MemoryJournal$$queue.tornEventId();
            }

            public String toString() {
                return "MemoryJournal.EventWatch";
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{js7$journal$MemoryJournal$$anon$1$$_$eventsAfter$$anonfun$1(scala.collection.Iterator )}, serializedLambda);
            }
        };
        Statics.releaseFence();
    }

    @Override
    public final IO state() {
        return this.state;
    }

    @Override
    public void js7$journal$state$ReadableStateJournal$_setter_$state_$eq(IO x$0) {
        this.state = x$0;
    }

    @Override
    public LockKeeper js7$journal$state$Journal$$keyLockKeeper() {
        return this.js7$journal$state$Journal$$keyLockKeeper;
    }

    @Override
    public void js7$journal$state$Journal$_setter_$js7$journal$state$Journal$$keyLockKeeper_$eq(LockKeeper x$0) {
        this.js7$journal$state$Journal$$keyLockKeeper = x$0;
    }

    public int size() {
        return this.size;
    }

    @Override
    public JournaledState.Companion<S> S() {
        return this.S;
    }

    @Override
    public JournalId journalId() {
        return this.journalId;
    }

    @Override
    public boolean isHalted() {
        return false;
    }

    public boolean isEmpty() {
        return this.js7$journal$MemoryJournal$$queue.events().isEmpty();
    }

    @Override
    public IO<BoxedUnit> whenNoFailoverByOtherNode() {
        return this.whenNoFailoverByOtherNode;
    }

    @Override
    public RealEventWatch eventWatch() {
        return this.eventWatch;
    }

    @Override
    public S unsafeCurrentState() {
        return this._state;
    }

    @Override
    public <E extends Event> IO<Either<Problem, Tuple2<Stamped<KeyedEvent<E>>, S>>> persistKeyedEvent(KeyedEvent<E> keyedEvent, CommitOptions options, Enclosing enclosing) {
        return this.persistKeyedEvents((Seq<KeyedEvent<E>>)package$.MODULE$.Nil().$colon$colon(keyedEvent), this.persistKeyedEvents$default$2()).map((Function1 & Serializable)_$1 -> _$1.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Seq events = (Seq)tuple2._1();
                JournaledState s = (JournaledState)tuple2._2();
                Stamped stamped = (Stamped)Predef$.MODULE$.ArrowAssoc(events.head());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)stamped, (Object)s);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    @Override
    public <E extends Event> CommitOptions persistKeyedEvent$default$2() {
        return CommitOptions$.MODULE$.default();
    }

    @Override
    public <E extends Event> IO<Either<Problem, Tuple2<Seq<Stamped<KeyedEvent<E>>>, S>>> persistKeyedEvents(Seq<KeyedEvent<E>> keyedEvents, CommitOptions options) {
        return this.persist((Function1 & Serializable)_$2 -> package$.MODULE$.Right().apply((Object)keyedEvents));
    }

    @Override
    public <E extends Event> CommitOptions persistKeyedEvents$default$2() {
        return CommitOptions$.MODULE$.default();
    }

    @Override
    public <E extends Event> IO<Either<Problem, BoxedUnit>> persistKeyedEventsLater(Seq<KeyedEvent<E>> keyedEvents, CommitOptions options) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.persistKeyedEvents(keyedEvents, options));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO, BoxedUnit.UNIT, IO$.MODULE$.asyncForIO());
    }

    @Override
    public <E extends Event> CommitOptions persistKeyedEventsLater$default$2() {
        return CommitOptions$.MODULE$.default();
    }

    @Override
    public <E extends Event> IO<Either<Problem, Tuple2<Seq<Stamped<KeyedEvent<E>>>, S>>> persistWithOptions(CommitOptions options, Function1<S, Either<Problem, Seq<KeyedEvent<E>>>> stateToEvents) {
        return this.stateLock.lock(IO$.MODULE$.defer(() -> this.persistWithOptions$$anonfun$1(stateToEvents)), Enclosing$.MODULE$.apply("js7.journal.MemoryJournal#persistWithOptions"));
    }

    @Override
    public <E extends Event> CommitOptions persistWithOptions$default$1() {
        return CommitOptions$.MODULE$.default();
    }

    private <E extends Event> IO<BoxedUnit> enqueue(Seq<Stamped<KeyedEvent<E>>> stampedEvents, S state) {
        return IO$.MODULE$.whenA(stampedEvents.nonEmpty(), () -> this.enqueue$$anonfun$1(stampedEvents, state));
    }

    private void log(long eventNumber, Seq<Stamped<KeyedEvent<Event>>> stampedEvents, Deadline since) {
        this.journalLogger.logCommitted((IndexedSeqView<JournalLogger.Loggable>)((IndexedSeqOps)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JournalLogger.SimpleLoggable[]{new JournalLogger.SimpleLoggable(CorrelId$.MODULE$.current(), eventNumber, stampedEvents, false, since, true)}))).view(), this.journalLogger.logCommitted$default$2());
    }

    public IO<Either<Problem, BoxedUnit>> releaseEvents(long untilEventId) {
        return this.queueLock.lock(IO$.MODULE$.defer(() -> this.releaseEvents$$anonfun$1(untilEventId)), Enclosing$.MODULE$.apply("js7.journal.MemoryJournal#releaseEvents"));
    }

    public Option<Iterator<Stamped<KeyedEvent<Event>>>> js7$journal$MemoryJournal$$eventsAfter_(long after) {
        EventQueue q = this.js7$journal$MemoryJournal$$queue;
        if (after < q.tornEventId()) {
            return None$.MODULE$;
        }
        Tuple2<Object, Object> tuple2 = q.search(after);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int index = tuple2._1$mcI$sp();
        boolean found = tuple2._2$mcZ$sp();
        Tuple2.mcIZ.sp sp2 = new Tuple2.mcIZ.sp(index, found);
        int index2 = sp2._1$mcI$sp();
        boolean found2 = sp2._2$mcZ$sp();
        if (!found2 && after != q.tornEventId()) {
            return None$.MODULE$;
        }
        if (this.eventWatchStopped) {
            return Some$.MODULE$.apply((Object)package$.MODULE$.Iterator().empty());
        }
        return Some$.MODULE$.apply((Object)q.events().drop(index2 + ScalaUtils$syntax$RichBoolean$.MODULE$.toInt$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(found2))).iterator());
    }

    public void suppressLogging(boolean supress) {
        this.journalLogger.suppress(supress);
    }

    public void stopEventWatch() {
        this.eventWatchStopped = true;
    }

    public int queueLength() {
        return this.js7$journal$MemoryJournal$$queue.events().size();
    }

    public IO<Object> semaphoreCount() {
        return ((IO)this.semaphore.count()).flatTap((Function1 & Serializable)n -> this.semaphoreCount$$anonfun$1(BoxesRunTime.unboxToLong((Object)n)));
    }

    private final MemoryJournal$EventQueue$ EventQueue() {
        return this.EventQueue$lzy1;
    }

    public static final /* synthetic */ CloseableIterator js7$journal$MemoryJournal$$anon$1$$_$eventsAfter$$anonfun$1(Iterator baseIterator) {
        return CloseableIterator$.MODULE$.fromIterator(baseIterator);
    }

    private final String persistWithOptions$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1() {
        return this.waitingFor;
    }

    private final IO persistWithOptions$$anonfun$1(Function1 stateToEvents$1) {
        S state = this._state;
        return (IO)package.traverse$.MODULE$.toTraverseOps((Object)((Either)stateToEvents$1.apply(state)).flatMap((Function1 & Serializable)keyedEvents -> state.applyEvents(keyedEvents).map((Function1 & Serializable)updated -> {
            Seq stampedEvents = (Seq)keyedEvents.map((Function1 & Serializable)_$3 -> this.eventIdGenerator.stamp(_$3, this.eventIdGenerator.stamp$default$2()));
            return Tuple2$.MODULE$.apply(updated, (Object)stampedEvents);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                JournaledState updated = (JournaledState)tuple2._1();
                Seq stampedEvents = (Seq)tuple2._2();
                int acq = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(stampedEvents.length()), this.size());
                IO iO = (IO)this.semaphore.acquireN(Int$.MODULE$.int2long(acq));
                Seq seq = (Seq)Predef$.MODULE$.ArrowAssoc((Object)stampedEvents);
                return CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)this::persistWithOptions$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO)).$times$greater(this.enqueue(stampedEvents, updated)).as((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seq, (Object)updated));
            }
            throw new MatchError((Object)tuple2);
        })), UnorderedFoldable$.MODULE$.catsTraverseForEither()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IO$.MODULE$.asyncForIO());
    }

    private final void enqueue$$anonfun$1$$anonfun$1(Seq stampedEvents$2, JournaledState state$3, Deadline since$1) {
        EventQueue q = this.js7$journal$MemoryJournal$$queue;
        long eventId = ((Stamped)stampedEvents$2.last()).eventId();
        EventQueue eventQueue = q;
        Vector vector = (Vector)q.events().$plus$plus((IterableOnce)stampedEvents$2);
        long l = eventQueue.copy$default$1();
        q = eventQueue.copy(l, eventId, (Vector<Stamped<KeyedEvent<Event>>>)vector);
        this._state = state$3.withEventId(eventId);
        long n = Atomic$package$Atomic$extensions$.MODULE$.$plus$eq(this._eventCount, Int$.MODULE$.int2long(stampedEvents$2.length()));
        this.log(n, (Seq<Stamped<KeyedEvent<Event>>>)stampedEvents$2, since$1);
        this.eventWatch().onEventsCommitted(eventId);
        this.js7$journal$MemoryJournal$$queue = q;
    }

    private final IO enqueue$$anonfun$1(Seq stampedEvents$1, JournaledState state$2) {
        Deadline since = Deadline$.MODULE$.now();
        return this.queueLock.lock(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.enqueue$$anonfun$1$$anonfun$1(stampedEvents$1, state$2, since);
            return BoxedUnit.UNIT;
        }), Enclosing$.MODULE$.apply("js7.journal.MemoryJournal#enqueue"));
    }

    private static final boolean v$proxy1$1(long available$1) {
        return available$1 >= 0L;
    }

    private static final boolean releaseEvents$$anonfun$1$$anonfun$2() {
        return Tests$.MODULE$.isTest() && false;
    }

    private final void releaseEvents$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(long cnt$1) {
        if (cnt$1 > (long)this.size()) {
            String msg = "MemoryJournal: Semaphore is greater than queue size: " + cnt$1 + " > " + this.size() + " ";
            Logger LoggerImpl_this = MemoryJournal$.js7$journal$MemoryJournal$$$logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error(msg);
            }
            throw new IllegalStateException(msg);
        }
    }

    private final /* synthetic */ IO releaseEvents$$anonfun$1$$anonfun$3$$anonfun$1(long cnt) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.releaseEvents$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(cnt);
            return BoxedUnit.UNIT;
        });
    }

    private final IO releaseEvents$$anonfun$1(long untilEventId$1) {
        EventQueue q = this.js7$journal$MemoryJournal$$queue;
        Tuple2<Object, Object> tuple2 = this.js7$journal$MemoryJournal$$queue.search(untilEventId$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int index = tuple2._1$mcI$sp();
        boolean found = tuple2._2$mcZ$sp();
        Tuple2.mcIZ.sp sp2 = new Tuple2.mcIZ.sp(index, found);
        int index2 = sp2._1$mcI$sp();
        boolean found2 = sp2._2$mcZ$sp();
        if (!found2) {
            return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("Unknown EventId: " + EventId$.MODULE$.toString(untilEventId$1)));
        }
        int n = index2 + 1;
        Vector vector = q.events().drop(n);
        long l = q.copy$default$2();
        this.js7$journal$MemoryJournal$$queue = q.copy(untilEventId$1, l, (Vector<Stamped<KeyedEvent<Event>>>)vector);
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichAny(((IO)this.semaphore.releaseN(Int$.MODULE$.int2long(n))).$times$greater(((IO)this.semaphore.available()).map((Function1)(JFunction1.mcVJ.sp & Serializable)available -> Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)MemoryJournal.v$proxy1$1(available)), "available >= 0"), FullName$.MODULE$.apply("js7.journal.MemoryJournal.releaseEvents"), FileName$.MODULE$.apply("MemoryJournal.scala"), Line$.MODULE$.apply(160)))));
        return ((IO)ScalaUtils$syntax$RichAny$.MODULE$.pipeIf$extension(iO, (Function0<Object>)((Function0 & Serializable)MemoryJournal::releaseEvents$$anonfun$1$$anonfun$2), (Function1 & Serializable)_$4 -> _$4.$less$times(((IO)this.semaphore.count()).flatTap((Function1 & Serializable)cnt -> this.releaseEvents$$anonfun$1$$anonfun$3$$anonfun$1(BoxesRunTime.unboxToLong((Object)cnt)))))).as(Checked$.MODULE$.unit());
    }

    private final boolean v$proxy2$1(long n$2) {
        return n$2 <= (long)this.size();
    }

    private final void semaphoreCount$$anonfun$1$$anonfun$1(long n$1) {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy2$1(n$1)), "n <= size"), FullName$.MODULE$.apply("js7.journal.MemoryJournal.semaphoreCount"), FileName$.MODULE$.apply("MemoryJournal.scala"), Line$.MODULE$.apply(196));
    }

    private final /* synthetic */ IO semaphoreCount$$anonfun$1(long n) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.semaphoreCount$$anonfun$1$$anonfun$1(n);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long js7$journal$MemoryJournal$EventQueue$$_$search$$anonfun$1(Stamped _$5) {
        return _$5.eventId();
    }

    public class EventQueue
    implements Product,
    Serializable {
        private final long tornEventId;
        private final long lastEventId;
        private final Vector events;
        private final /* synthetic */ MemoryJournal $outer;

        public EventQueue(MemoryJournal $outer, long tornEventId, long lastEventId, Vector<Stamped<KeyedEvent<Event>>> events) {
            this.tornEventId = tornEventId;
            this.lastEventId = lastEventId;
            this.events = events;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.tornEventId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lastEventId()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.events()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EventQueue)) return false;
            if (((EventQueue)object).js7$journal$MemoryJournal$EventQueue$$$outer() != this.$outer) return false;
            EventQueue eventQueue = (EventQueue)object;
            if (this.tornEventId() != eventQueue.tornEventId()) return false;
            if (this.lastEventId() != eventQueue.lastEventId()) return false;
            Vector<Stamped<KeyedEvent<Event>>> vector = this.events();
            Vector<Stamped<KeyedEvent<Event>>> vector2 = eventQueue.events();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            if (!eventQueue.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof EventQueue;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "EventQueue";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "tornEventId";
                }
                case 1: {
                    return "lastEventId";
                }
                case 2: {
                    return "events";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long tornEventId() {
            return this.tornEventId;
        }

        public long lastEventId() {
            return this.lastEventId;
        }

        public Vector<Stamped<KeyedEvent<Event>>> events() {
            return this.events;
        }

        public Tuple2<Object, Object> search(long after) {
            return BinarySearch$.MODULE$.binarySearch(this.events(), MemoryJournal::js7$journal$MemoryJournal$EventQueue$$_$search$$anonfun$1, BoxesRunTime.boxToLong((long)after), Ordering.Long$.MODULE$);
        }

        public EventQueue copy(long tornEventId, long lastEventId, Vector<Stamped<KeyedEvent<Event>>> events) {
            return new EventQueue(this.$outer, tornEventId, lastEventId, events);
        }

        public long copy$default$1() {
            return this.tornEventId();
        }

        public long copy$default$2() {
            return this.lastEventId();
        }

        public Vector<Stamped<KeyedEvent<Event>>> copy$default$3() {
            return this.events();
        }

        public long _1() {
            return this.tornEventId();
        }

        public long _2() {
            return this.lastEventId();
        }

        public Vector<Stamped<KeyedEvent<Event>>> _3() {
            return this.events();
        }

        public final /* synthetic */ MemoryJournal js7$journal$MemoryJournal$EventQueue$$$outer() {
            return this.$outer;
        }
    }
}

