/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.recover;

import com.typesafe.scalalogging.Logger;
import io.circe.Json;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.utils.ScalaUtils$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichString$;
import js7.data.cluster.ClusterState;
import js7.data.event.Event;
import js7.data.event.JournalHeader;
import js7.data.event.JournalHeader$;
import js7.data.event.JournalId;
import js7.data.event.JournalSeparators$;
import js7.data.event.JournalState;
import js7.data.event.KeyedEvent;
import js7.data.event.SnapshotableState;
import js7.data.event.SnapshotableStateBuilder;
import js7.data.event.Stamped;
import js7.journal.recover.FileSnapshotableStateBuilder$;
import js7.journal.recover.FileSnapshotableStateBuilder$transaction$;
import js7.journal.recover.JournalProgress;
import js7.journal.recover.JournalProgress$AfterHeader$;
import js7.journal.recover.JournalProgress$AfterSnapshotSection$;
import js7.journal.recover.JournalProgress$InCommittedEventsSection$;
import js7.journal.recover.JournalProgress$InSnapshotSection$;
import js7.journal.recover.JournalProgress$InTransaction$;
import js7.journal.recover.JournalProgress$Initial$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Try$;

public final class FileSnapshotableStateBuilder<S extends SnapshotableState<S>> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FileSnapshotableStateBuilder.class.getDeclaredField("transaction$lzy1"));
    private final Path journalFileForInfo;
    private final Option<JournalId> expectedJournalId;
    private final SnapshotableState.Companion<S> S;
    private final SnapshotableStateBuilder<S> builder;
    private JournalProgress _progress;
    private volatile Object transaction$lzy1;

    public FileSnapshotableStateBuilder(Path journalFileForInfo, Option<JournalId> expectedJournalId, Function0<SnapshotableStateBuilder<S>> newBuilder, SnapshotableState.Companion<S> S) {
        this.journalFileForInfo = journalFileForInfo;
        this.expectedJournalId = expectedJournalId;
        this.S = S;
        this.builder = (SnapshotableStateBuilder)newBuilder.apply();
        this._progress = JournalProgress$Initial$.MODULE$;
    }

    public FileSnapshotableStateBuilder(Path journalFileForInfo, Option<JournalId> expectedJournalId, SnapshotableState.Companion<S> S) {
        this(journalFileForInfo, expectedJournalId, FileSnapshotableStateBuilder.FileSnapshotableStateBuilder$superArg$1(journalFileForInfo, expectedJournalId, S), S);
    }

    private final FileSnapshotableStateBuilder$transaction$ transaction() {
        Object object = this.transaction$lzy1;
        if (object instanceof FileSnapshotableStateBuilder$transaction$) {
            return (FileSnapshotableStateBuilder$transaction$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (FileSnapshotableStateBuilder$transaction$)this.transaction$lzyINIT1();
    }

    private Object transaction$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.transaction$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FileSnapshotableStateBuilder$transaction$ fileSnapshotableStateBuilder$transaction$ = null;
                    try {
                        fileSnapshotableStateBuilder$transaction$ = new FileSnapshotableStateBuilder$transaction$();
                        object2 = fileSnapshotableStateBuilder$transaction$ == null ? LazyVals.NullValue$.MODULE$ : fileSnapshotableStateBuilder$transaction$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.transaction$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return fileSnapshotableStateBuilder$transaction$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void startWithState(JournalProgress progress, Option<JournalHeader> journalHeader, long eventId, long totalEventCount, S state) {
        this._progress = progress;
        this.builder.initializeState(journalHeader, eventId, totalEventCount, state);
    }

    public void put(Object journalRecord) {
        JournalProgress journalProgress = this._progress;
        if (JournalProgress$Initial$.MODULE$.equals(journalProgress)) {
            Object object = journalRecord;
            if (object instanceof JournalHeader) {
                JournalHeader journalHeader = (JournalHeader)object;
                Logger LoggerImpl_this = FileSnapshotableStateBuilder$.js7$journal$recover$FileSnapshotableStateBuilder$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug(journalHeader.toString());
                }
                Either either = Checked$.MODULE$.Ops(JournalHeader$.MODULE$.checkedHeader(journalHeader, this.journalFileForInfo, this.expectedJournalId, this.S));
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Checked$Ops$.MODULE$.orThrow$extension(either);
                this.builder.addSnapshotObject(journalHeader);
                this._progress = JournalProgress$AfterHeader$.MODULE$;
                return;
            }
            String string = ScalaUtils$syntax$.MODULE$.RichString(journalRecord.toString());
            throw new IllegalArgumentException("Not a valid JS7 journal file: " + this.journalFileForInfo + ". Expected a JournalHeader" + (" instead of " + ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$extension(string, 100, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$2$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$3$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$4$extension(string)) + ":"));
        }
        if (JournalProgress$AfterHeader$.MODULE$.equals(journalProgress)) {
            Object object = journalRecord;
            Json json = JournalSeparators$.MODULE$.SnapshotHeader();
            if (object == null ? json != null : !object.equals(json)) {
                throw new IllegalArgumentException("Missing SnapshotHeader in journal file");
            }
            this._progress = JournalProgress$InSnapshotSection$.MODULE$;
            return;
        }
        if (JournalProgress$InSnapshotSection$.MODULE$.equals(journalProgress)) {
            Object object = journalRecord;
            Json json = JournalSeparators$.MODULE$.SnapshotFooter();
            Object object2 = object;
            if (!(json != null ? !json.equals(object2) : object2 != null)) {
                this.builder.onAllSnapshotsAdded();
                this._progress = JournalProgress$AfterSnapshotSection$.MODULE$;
                return;
            }
            this.builder.addSnapshotObject(journalRecord);
            return;
        }
        if (JournalProgress$AfterSnapshotSection$.MODULE$.equals(journalProgress)) {
            Object object = journalRecord;
            Json json = JournalSeparators$.MODULE$.EventHeader();
            if (object == null ? json != null : !object.equals(json)) {
                throw new IllegalArgumentException("Missing EventHeader in journal file");
            }
            this._progress = JournalProgress$InCommittedEventsSection$.MODULE$;
            return;
        }
        if (JournalProgress$InCommittedEventsSection$.MODULE$.equals(journalProgress)) {
            Object object = journalRecord;
            Json json = JournalSeparators$.MODULE$.Transaction();
            Object object3 = object;
            if (!(json != null ? !json.equals(object3) : object3 != null)) {
                this.transaction().begin();
                this._progress = JournalProgress$InTransaction$.MODULE$;
                return;
            }
            this.builder.addEvent((Stamped)ScalaUtils$.MODULE$.cast(journalRecord, ClassTag$.MODULE$.apply(Stamped.class)));
            return;
        }
        if (JournalProgress$InTransaction$.MODULE$.equals(journalProgress)) {
            Object object = journalRecord;
            Json json = JournalSeparators$.MODULE$.Commit();
            Object object4 = object;
            if (!(json != null ? !json.equals(object4) : object4 != null)) {
                this._progress = JournalProgress$InCommittedEventsSection$.MODULE$;
                this.transaction().buffer().foreach((Function1)(JProcedure1 & Serializable)stamped -> this.builder.addEvent((Stamped<KeyedEvent<Event>>)stamped));
                this.transaction().clear();
                return;
            }
            this.transaction().add((Stamped)ScalaUtils$.MODULE$.cast(journalRecord, ClassTag$.MODULE$.apply(Stamped.class)));
            return;
        }
        throw new MatchError((Object)journalProgress);
    }

    public void rollbackToEventSection() {
        JournalProgress journalProgress = this._progress;
        if (JournalProgress$InCommittedEventsSection$.MODULE$.equals(journalProgress)) {
            return;
        }
        if (JournalProgress$InTransaction$.MODULE$.equals(journalProgress)) {
            this.rollback();
            return;
        }
        throw new IllegalStateException("rollbackToEventSection() but progress=" + this._progress);
    }

    private void rollback() {
        this.transaction().clear();
        this._progress = JournalProgress$InCommittedEventsSection$.MODULE$;
    }

    public JournalProgress journalProgress() {
        return this._progress;
    }

    public Option<JournalHeader> fileJournalHeader() {
        return this.builder.fileJournalHeader();
    }

    public Option<JournalHeader> nextJournalHeader() {
        return this.builder.nextJournalHeader();
    }

    public long eventId() {
        return this.builder.eventId();
    }

    public S result() {
        return this.builder.result();
    }

    public JournalState journalState() {
        return this.builder.journalState();
    }

    public ClusterState clusterState() {
        return this.builder.clusterState();
    }

    public void logStatistics() {
        this.builder.logStatistics((Option<Object>)Try$.MODULE$.apply(this::logStatistics$$anonfun$1).toOption());
    }

    private static <S extends SnapshotableState<S>> Function0<SnapshotableStateBuilder<S>> FileSnapshotableStateBuilder$superArg$1(Path journalFileForInfo, Option<JournalId> expectedJournalId, SnapshotableState.Companion<S> S) {
        return (Function0 & Serializable)() -> S.newBuilder();
    }

    private final long logStatistics$$anonfun$1() {
        return Files.size(this.journalFileForInfo);
    }
}

