/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.watch;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.common.jsonseq.PositionAnd;
import js7.common.jsonseq.PositionAnd$;
import js7.data.event.JournalId;
import js7.journal.data.JournalLocation;
import js7.journal.watch.ClosedException;
import js7.journal.watch.FileEventIterator;
import js7.journal.watch.FileEventIteratorPool$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public final class FileEventIteratorPool {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FileEventIteratorPool.class.getDeclaredField("firstEventPosition$lzy1"));
    public final JournalLocation js7$journal$watch$FileEventIteratorPool$$journalLocation;
    public final JournalId js7$journal$watch$FileEventIteratorPool$$expectedJournalId;
    public final Path js7$journal$watch$FileEventIteratorPool$$journalFile;
    public final long js7$journal$watch$FileEventIteratorPool$$fileEventId;
    public final Function0<Object> js7$journal$watch$FileEventIteratorPool$$committedLength;
    public final ArrayBuffer<FileEventIterator> js7$journal$watch$FileEventIteratorPool$$freeIterators;
    public final ArrayBuffer<FileEventIterator> js7$journal$watch$FileEventIteratorPool$$lentIterators;
    private final AtomicBoolean closed;
    private volatile Object firstEventPosition$lzy1;

    public FileEventIteratorPool(JournalLocation journalLocation, JournalId expectedJournalId, Path journalFile, long fileEventId, Function0<Object> committedLength) {
        this.js7$journal$watch$FileEventIteratorPool$$journalLocation = journalLocation;
        this.js7$journal$watch$FileEventIteratorPool$$expectedJournalId = expectedJournalId;
        this.js7$journal$watch$FileEventIteratorPool$$journalFile = journalFile;
        this.js7$journal$watch$FileEventIteratorPool$$fileEventId = fileEventId;
        this.js7$journal$watch$FileEventIteratorPool$$committedLength = committedLength;
        this.js7$journal$watch$FileEventIteratorPool$$freeIterators = ArrayBuffer$.MODULE$.empty();
        this.js7$journal$watch$FileEventIteratorPool$$lentIterators = ArrayBuffer$.MODULE$.empty();
        this.closed = new AtomicBoolean(false);
    }

    public void close() {
        FileEventIteratorPool fileEventIteratorPool = this;
        synchronized (fileEventIteratorPool) {
            if (!this.closed.getAndSet(true)) {
                Logger LoggerImpl_this;
                Tuple2 tuple2;
                FileEventIteratorPool fileEventIteratorPool2 = this;
                synchronized (fileEventIteratorPool2) {
                    tuple2 = Tuple2$.MODULE$.apply((Object)this.js7$journal$watch$FileEventIteratorPool$$freeIterators.toSet(), (Object)this.js7$journal$watch$FileEventIteratorPool$$lentIterators.toSet());
                }
                Tuple2 tuple22 = tuple2;
                if (!(tuple22 instanceof Tuple2)) {
                    throw new MatchError((Object)tuple22);
                }
                Tuple2 tuple23 = tuple22;
                Set availables = (Set)tuple23._1();
                Set lent = (Set)tuple23._2();
                Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)availables, (Object)lent);
                Set availables2 = (Set)tuple24._1();
                Set lent2 = (Set)tuple24._2();
                if (lent2.nonEmpty() && (LoggerImpl_this = FileEventIteratorPool$.js7$journal$watch$FileEventIteratorPool$$$logger).underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("Close '{}' while {}\u00d7 opened", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.toString(), BoxesRunTime.boxToInteger((int)lent2.size())}), Object.class));
                }
                availables2.$plus$plus((IterableOnce)lent2).foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.close());
                v1 = BoxedUnit.UNIT;
            } else {
                v1 = BoxedUnit.UNIT;
            }
        }
    }

    public long firstEventPosition() {
        Object object = this.firstEventPosition$lzy1;
        if (object instanceof Long) {
            return BoxesRunTime.unboxToLong((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToLong(null);
        }
        return BoxesRunTime.unboxToLong((Object)this.firstEventPosition$lzyINIT1());
    }

    private Object firstEventPosition$lzyINIT1() {
        Object object;
        block14: {
            while (true) {
                if ((object = this.firstEventPosition$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Long l = null;
                    try {
                        FileEventIterator iterator = this.borrowIterator();
                        try {
                            try {
                                long l2 = iterator.firstEventPosition();
                            }
                            catch (Throwable throwable) {
                                Option option;
                                Throwable throwable2 = throwable;
                                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                    Throwable throwable3;
                                    Throwable t = throwable3 = (Throwable)option.get();
                                    iterator.close();
                                    throw t;
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            this.returnIterator(iterator);
                        }
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.firstEventPosition$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block14;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public FileEventIterator borrowIterator() {
        if (this.closed.get()) {
            throw new ClosedException(this.js7$journal$watch$FileEventIteratorPool$$journalFile);
        }
        return (FileEventIterator)this.tryBorrowIterator().getOrElse(this::borrowIterator$$anonfun$1);
    }

    private Option<FileEventIterator> tryBorrowIterator() {
        Option option;
        FileEventIteratorPool fileEventIteratorPool = this;
        synchronized (fileEventIteratorPool) {
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(this.js7$journal$watch$FileEventIteratorPool$$freeIterators.nonEmpty());
            option = ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, this::tryBorrowIterator$$anonfun$1);
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    private FileEventIterator newIterator() {
        void var2_3;
        FileEventIteratorPool fileEventIteratorPool = this;
        synchronized (fileEventIteratorPool) {
            void var3_2;
            if (this.closed.get()) {
                throw new ClosedException(this.js7$journal$watch$FileEventIteratorPool$$journalFile);
            }
            FileEventIterator result = new FileEventIterator(this){
                private final int number;
                private final /* synthetic */ FileEventIteratorPool $outer;
                {
                    block1: {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super($outer.js7$journal$watch$FileEventIteratorPool$$journalLocation.S(), $outer.js7$journal$watch$FileEventIteratorPool$$journalFile, $outer.js7$journal$watch$FileEventIteratorPool$$expectedJournalId, $outer.js7$journal$watch$FileEventIteratorPool$$fileEventId, $outer.js7$journal$watch$FileEventIteratorPool$$committedLength);
                        this.number = $outer.js7$journal$watch$FileEventIteratorPool$$lentIterators.size() + 1;
                        Logger LoggerImpl_this = FileEventIteratorPool$.js7$journal$watch$FileEventIteratorPool$$$logger;
                        if (!LoggerImpl_this.underlying().isDebugEnabled()) break block1;
                        LoggerImpl_this.underlying().debug("Opened {}", (Object)this.toString());
                    }
                }

                public void close() {
                    $anon$1 var1_1 = this;
                    synchronized (var1_1) {
                        this.$outer.js7$journal$watch$FileEventIteratorPool$$freeIterators.$minus$eq((Object)this);
                        ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.$outer.js7$journal$watch$FileEventIteratorPool$$lentIterators.$minus$eq((Object)this);
                    }
                    super.close();
                    Logger LoggerImpl_this = FileEventIteratorPool$.js7$journal$watch$FileEventIteratorPool$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("Closed {}", (Object)this.toString());
                        return;
                    }
                }

                public String toString() {
                    return super.toString() + "#" + this.number;
                }
            };
            this.js7$journal$watch$FileEventIteratorPool$$lentIterators.$plus$eq((Object)result);
            var2_3 = var3_2;
        }
        return var2_3;
    }

    public void returnIterator(FileEventIterator iterator) {
        LazyRef lazyRef = new LazyRef();
        FileEventIteratorPool fileEventIteratorPool = this;
        synchronized (fileEventIteratorPool) {
            if (!iterator.isClosed()) {
                this.js7$journal$watch$FileEventIteratorPool$$freeIterators.$plus$eq((Object)iterator);
            }
            ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.js7$journal$watch$FileEventIteratorPool$$lentIterators.$minus$eq((Object)iterator);
        }
    }

    public String toString() {
        return "FileEventIteratorPool(" + this.js7$journal$watch$FileEventIteratorPool$$journalFile.getFileName() + ")";
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isLent() {
        return this.js7$journal$watch$FileEventIteratorPool$$lentIterators.nonEmpty();
    }

    public int freeIteratorsCount() {
        return this.js7$journal$watch$FileEventIteratorPool$$freeIterators.size();
    }

    public int lentIteratorsCount() {
        return this.js7$journal$watch$FileEventIteratorPool$$lentIterators.size();
    }

    private final FileEventIterator borrowIterator$$anonfun$1() {
        return this.newIterator();
    }

    private final FileEventIterator a$proxy1$1() {
        FileEventIterator iterator = (FileEventIterator)this.js7$journal$watch$FileEventIteratorPool$$freeIterators.remove(this.js7$journal$watch$FileEventIteratorPool$$freeIterators.size() - 1);
        this.js7$journal$watch$FileEventIteratorPool$$lentIterators.$plus$eq((Object)iterator);
        return iterator;
    }

    private final FileEventIterator tryBorrowIterator$$anonfun$1() {
        return this.a$proxy1$1();
    }

    private static final Tuple2 $2$$lzyINIT1$1(LazyRef $2$$lzy1$1, FileEventIterator iterator$1) {
        Tuple2 tuple2;
        LazyRef lazyRef = $2$$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if ($2$$lzy1$1.initialized()) {
                object = $2$$lzy1$1.value();
            } else {
                PositionAnd<Object> positionAnd = iterator$1.positionAndEventId();
                if (positionAnd == null) {
                    throw new MatchError(positionAnd);
                }
                PositionAnd<Object> positionAnd2 = PositionAnd$.MODULE$.unapply(positionAnd);
                long l = positionAnd2._1();
                long l2 = BoxesRunTime.unboxToLong((Object)positionAnd2._2());
                long position = l;
                long eventId = l2;
                object = $2$$lzy1$1.initialize((Object)new Tuple2.mcJJ.sp(position, eventId));
            }
            tuple2 = (Tuple2)object;
        }
        return tuple2;
    }

    private static final Tuple2 $2$$1(LazyRef $2$$lzy1$2, FileEventIterator iterator$2) {
        return (Tuple2)($2$$lzy1$2.initialized() ? $2$$lzy1$2.value() : FileEventIteratorPool.$2$$lzyINIT1$1($2$$lzy1$2, iterator$2));
    }

    private static final long position$1(LazyRef $2$$lzy1$3, FileEventIterator iterator$3) {
        return FileEventIteratorPool.$2$$1($2$$lzy1$3, iterator$3)._1$mcJ$sp();
    }

    private static final long eventId$1(LazyRef $2$$lzy1$4, FileEventIterator iterator$4) {
        return FileEventIteratorPool.$2$$1($2$$lzy1$4, iterator$4)._2$mcJ$sp();
    }
}

