/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.write;

import cats.effect.unsafe.IORuntime;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Path;
import js7.base.log.Logger$;
import js7.base.utils.Assertions$;
import js7.common.jsonseq.PositionAnd;
import js7.common.jsonseq.PositionAnd$;
import js7.data.event.Event;
import js7.data.event.JournalId;
import js7.data.event.JournaledState;
import js7.data.event.KeyedEvent;
import js7.data.event.Stamped;
import js7.journal.data.JournalLocation;
import js7.journal.watch.JournalingObserver;
import js7.journal.write.EventJournalWriter$;
import js7.journal.write.EventStatisticsCounter;
import js7.journal.write.JournalWriter;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public final class EventJournalWriter
extends JournalWriter {
    private final Path file;
    private final JournalId journalId;
    private final Option<JournalingObserver> observer;
    private final Option simulateSync;
    private final IORuntime ioRuntime;
    private final Logger logger;
    private final EventStatisticsCounter statistics;
    private boolean _eventWritten;

    public static EventJournalWriter forTest(JournalLocation journalLocation, long l, JournalId journalId, Option<JournalingObserver> option, boolean bl, IORuntime iORuntime) {
        return EventJournalWriter$.MODULE$.forTest(journalLocation, l, journalId, option, bl, iORuntime);
    }

    public static Option<JournalingObserver> forTest$default$4() {
        return EventJournalWriter$.MODULE$.forTest$default$4();
    }

    public static boolean forTest$default$5() {
        return EventJournalWriter$.MODULE$.forTest$default$5();
    }

    public static boolean $lessinit$greater$default$7() {
        return EventJournalWriter$.MODULE$.$lessinit$greater$default$7();
    }

    public static int $lessinit$greater$default$8() {
        return EventJournalWriter$.MODULE$.$lessinit$greater$default$8();
    }

    public EventJournalWriter(JournaledState.HasEventCodec S, Path file, long after, JournalId journalId, Option<JournalingObserver> observer, Option<FiniteDuration> simulateSync, boolean withoutSnapshots, int initialEventCount, IORuntime ioRuntime) {
        this.file = file;
        this.journalId = journalId;
        this.observer = observer;
        this.simulateSync = simulateSync;
        this.ioRuntime = ioRuntime;
        super(S, after, !withoutSnapshots);
        this.logger = Logger$.MODULE$.withPrefix(this.getClass(), file.getFileName().toString());
        this.statistics = new EventStatisticsCounter(initialEventCount);
        this._eventWritten = false;
    }

    @Override
    public Path file() {
        return this.file;
    }

    @Override
    public Option<FiniteDuration> simulateSync() {
        return this.simulateSync;
    }

    @Override
    public IORuntime ioRuntime() {
        return this.ioRuntime;
    }

    @Override
    public EventStatisticsCounter statistics() {
        return this.statistics;
    }

    public void closeProperly(boolean sync) {
        try {
            if (this.eventsStarted()) {
                this.endEventSection(sync);
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        super.close();
        this.observer.foreach((Function1)(JProcedure1 & Serializable)o -> o.onJournalingEnded(this.jsonWriter().fileLength()));
        this.statistics().debugString().foreach((Function1)(JProcedure1 & Serializable)o -> {
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug(o);
                return;
            }
        });
    }

    public void onJournalingStarted(long fileLengthBeforeEvents) {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1(fileLengthBeforeEvents)), "fileLengthBeforeEvents <= jsonWriter.fileLength"), FullName$.MODULE$.apply("js7.journal.write.EventJournalWriter.onJournalingStarted"), FileName$.MODULE$.apply("EventJournalWriter.scala"), Line$.MODULE$.apply(50));
        this.observer.foreach((Function1)(JProcedure1 & Serializable)o -> {
            PositionAnd<Object> firstEventPositionAndFileEventId = PositionAnd$.MODULE$.apply(fileLengthBeforeEvents, BoxesRunTime.boxToLong((long)this.lastWrittenEventId()));
            o.onJournalingStarted(this.file(), this.journalId, firstEventPositionAndFileEventId, firstEventPositionAndFileEventId, true);
            o.onFileWritten(this.jsonWriter().fileLength());
        });
    }

    public long onJournalingStarted$default$1() {
        return this.jsonWriter().fileLength();
    }

    public void writeEvents(Seq<Stamped<KeyedEvent<Event>>> stampedEvents, boolean transaction) {
        boolean ta;
        if (!this.eventsStarted()) {
            throw new IllegalStateException();
        }
        this._eventWritten = true;
        this.statistics().countEventsToBeCommitted(stampedEvents.size());
        boolean bl = ta = transaction && IterableOps.SizeCompareOps$.MODULE$.$greater$extension(stampedEvents.lengthIs(), 1);
        if (ta) {
            this.jsonWriter().write(EventJournalWriter$.js7$journal$write$EventJournalWriter$$$TransactionByteArray);
        }
        this.writeEvents_(stampedEvents);
        if (ta) {
            this.jsonWriter().write(EventJournalWriter$.js7$journal$write$EventJournalWriter$$$CommitByteArray);
            return;
        }
    }

    public boolean writeEvents$default$2() {
        return false;
    }

    public void endEventSection(boolean sync) {
        if (!this.eventsStarted()) {
            throw new IllegalStateException();
        }
        this.flush(sync);
        this.notifyObserver();
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Journal finished, {} written ({})", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.fileSizeString(), this.statistics()}), Object.class));
            return;
        }
    }

    @Override
    public void flush(boolean sync) {
        super.flush(sync);
        this.observer.foreach((Function1)(JProcedure1 & Serializable)r -> r.onFileWritten(this.jsonWriter().fileLength()));
    }

    public void notifyObserver() {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy2$1()), "isFlushed"), FullName$.MODULE$.apply("js7.journal.write.EventJournalWriter.notifyObserver"), FileName$.MODULE$.apply("EventJournalWriter.scala"), Line$.MODULE$.apply(91));
        this.observer.foreach((Function1)(JProcedure1 & Serializable)r -> r.onFileWritten(this.jsonWriter().fileLength()));
    }

    public void onCommitted(PositionAnd<Object> lengthAndEventId, int n) {
        this.observer.foreach((Function1)(JProcedure1 & Serializable)r -> r.onEventsCommitted(lengthAndEventId, n));
    }

    public boolean isEventWritten() {
        return this._eventWritten;
    }

    public PositionAnd<Object> fileLengthAndEventId() {
        return PositionAnd$.MODULE$.apply(this.fileLength(), BoxesRunTime.boxToLong((long)this.lastWrittenEventId()));
    }

    public String toString() {
        return "EventJournalWriter(" + this.file().getFileName() + ")";
    }

    private final boolean v$proxy1$1(long fileLengthBeforeEvents$1) {
        return fileLengthBeforeEvents$1 <= this.jsonWriter().fileLength();
    }

    private final boolean v$proxy2$1() {
        return this.isFlushed();
    }

    public static final class SerializationException
    extends RuntimeException {
        public SerializationException(Throwable cause) {
            super("JSON serialization error", cause);
        }
    }
}

