/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher.forwindows;

import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import js7.base.io.file.FileUtils$syntax$;
import js7.base.io.file.FileUtils$syntax$RichPath$;
import js7.base.io.process.Js7Process;
import js7.base.io.process.ReturnCode;
import js7.base.io.process.ReturnCode$;
import js7.base.log.Logger$;
import js7.base.problem.Problem;
import js7.base.utils.AutoClosing$;
import js7.launcher.forwindows.PROFILEINFO;
import js7.launcher.forwindows.Redirection;
import js7.launcher.forwindows.Redirection$;
import js7.launcher.forwindows.WindowsApi$;
import js7.launcher.forwindows.WindowsCommandLineConversion$;
import js7.launcher.forwindows.WindowsLogon;
import js7.launcher.forwindows.WindowsProcess;
import js7.launcher.forwindows.WindowsProcess$LoggedOn$;
import js7.launcher.forwindows.WindowsProcess$StartWindowsProcess$;
import js7.launcher.forwindows.WindowsUserName;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.io.Codec;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class WindowsProcess$
implements Serializable {
    private static final ReturnCode TerminateProcessReturnCode;
    public static final Logger js7$launcher$forwindows$WindowsProcess$$$logger;
    public static final WindowsProcess$StartWindowsProcess$ StartWindowsProcess;
    public static final WindowsProcess$LoggedOn$ js7$launcher$forwindows$WindowsProcess$$$LoggedOn;
    private static final Set<Object> AllowedUserNameCharacters;
    public static final WindowsProcess$ MODULE$;

    private WindowsProcess$() {
    }

    static {
        MODULE$ = new WindowsProcess$();
        TerminateProcessReturnCode = ReturnCode$.MODULE$.apply(999999999);
        js7$launcher$forwindows$WindowsProcess$$$logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(WindowsProcess$.class));
        AllowedUserNameCharacters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'_', '.', '-', ',', ' ', '@'}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WindowsProcess$.class);
    }

    public ReturnCode TerminateProcessReturnCode() {
        return TerminateProcessReturnCode;
    }

    public Either<Problem, Js7Process> startWithWindowsLogon(WindowsProcess.StartWindowsProcess startWindowsProcess, Option<WindowsLogon> maybeLogon) {
        return this.argsToCommandLine((Seq<String>)startWindowsProcess.args().toIndexedSeq()).map((Function1 & Serializable)commandLine -> {
            Redirection inRedirection = this.redirectToHandle(-10, startWindowsProcess.stdinRedirect());
            Redirection outRedirection = this.redirectToHandle(-11, startWindowsProcess.stdoutRedirect());
            Redirection errRedirection = this.redirectToHandle(-12, startWindowsProcess.stderrRedirect());
            WinBase.STARTUPINFO startupInfo = new WinBase.STARTUPINFO();
            startupInfo.dwFlags |= 0x100;
            startupInfo.hStdInput = inRedirection.startupInfoHandle();
            startupInfo.hStdOutput = outRedirection.startupInfoHandle();
            startupInfo.hStdError = errRedirection.startupInfoHandle();
            String application = (String)startWindowsProcess.args().head();
            int creationFlags = 1024;
            WindowsProcess.LoggedOn loggedOn = WindowsProcess$LoggedOn$.MODULE$.logon(maybeLogon);
            scala.collection.immutable.Map env = (scala.collection.immutable.Map)maybeLogon.fold(WindowsProcess$::$anonfun$1, (Function1 & Serializable)logon -> {
                if (logon.withUserProfile()) {
                    return WindowsApi$.MODULE$.usersEnvironment(loggedOn.userToken());
                }
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"USERNAME");
                return (scala.collection.immutable.Map)((MapOps)WindowsApi$.MODULE$.usersEnvironment(null).$plus$plus((IterableOnce)Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)logon.userName().withoutDomain())))).$plus$plus((IterableOnce)logon.userName().domain().orElse(WindowsProcess$::$anonfun$2$$anonfun$1).map((Function1 & Serializable)_$1 -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"USERDOMAIN");
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$1);
                }));
            });
            String workingDirectory = WindowsApi$.MODULE$.windowsDirectory().getRoot().toString();
            WinBase.PROCESS_INFORMATION processInformation = new WinBase.PROCESS_INFORMATION();
            WindowsApi$.MODULE$.call("CreateProcessAsUser", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{application, commandLine, "directory=" + workingDirectory}), (Function0<Object>)((Function0 & Serializable)() -> this.startWithWindowsLogon$$anonfun$1$$anonfun$1(loggedOn, application, commandLine, creationFlags, env, startWindowsProcess, workingDirectory, startupInfo, processInformation)));
            inRedirection.releaseStartupInfoHandle();
            outRedirection.releaseStartupInfoHandle();
            errRedirection.releaseStartupInfoHandle();
            Kernel32Util.closeHandle((WinNT.HANDLE)processInformation.hThread);
            processInformation.hThread = WinBase.INVALID_HANDLE_VALUE;
            return new WindowsProcess(processInformation, inRedirection, outRedirection, errRedirection, loggedOn);
        });
    }

    public Option<WindowsLogon> startWithWindowsLogon$default$2() {
        return None$.MODULE$;
    }

    public WinNT.HANDLE js7$launcher$forwindows$WindowsProcess$$$loadUserProfile(WinNT.HANDLE userToken, WindowsUserName user) {
        PROFILEINFO profileInfo = (PROFILEINFO)Structure.newInstance(PROFILEINFO.class);
        profileInfo.dwSize = profileInfo.size();
        profileInfo.userName = new WString(user.string());
        profileInfo.write();
        WindowsApi$.MODULE$.call("LoadUserProfile", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]), (Function0<Object>)((Function0 & Serializable)() -> WindowsProcess$.loadUserProfile$$anonfun$1(userToken, profileInfo)));
        profileInfo.read();
        return profileInfo.hProfile;
    }

    private Redirection redirectToHandle(int stdFile, ProcessBuilder.Redirect redirect) {
        ProcessBuilder.Redirect.Type type = redirect.type();
        ProcessBuilder.Redirect.Type type2 = ProcessBuilder.Redirect.Type.INHERIT;
        ProcessBuilder.Redirect.Type type3 = type;
        if (!(type2 != null ? !((Object)((Object)type2)).equals((Object)type3) : type3 != null)) {
            return new Redirection(WindowsApi$.MODULE$.kernel32().GetStdHandle(stdFile), false, WinBase.INVALID_HANDLE_VALUE);
        }
        ProcessBuilder.Redirect.Type type4 = ProcessBuilder.Redirect.Type.PIPE;
        ProcessBuilder.Redirect.Type type5 = type;
        if (!(type4 != null ? !((Object)((Object)type4)).equals((Object)type5) : type5 != null)) {
            int n = stdFile;
            switch (n) {
                case -10: {
                    return Redirection$.MODULE$.newStdinPipeRedirection();
                }
                case -12: 
                case -11: {
                    return Redirection$.MODULE$.newStdouterrPipeRedirection();
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        ProcessBuilder.Redirect.Type type6 = ProcessBuilder.Redirect.Type.WRITE;
        ProcessBuilder.Redirect.Type type7 = type;
        if (!(type6 != null ? !((Object)((Object)type6)).equals((Object)type7) : type7 != null)) {
            return Redirection$.MODULE$.forDirectFile(redirect.file());
        }
        ProcessBuilder.Redirect.Type t = type;
        throw new IllegalArgumentException("Unsupported Redirect " + t);
    }

    public int js7$launcher$forwindows$WindowsProcess$$$getExitCodeProcess(WinNT.HANDLE hProcess) {
        IntByReference ref;
        block0: {
            ref = new IntByReference();
            WindowsApi$.MODULE$.call("GetExitCodeProcess", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]), (Function0<Object>)((Function0 & Serializable)() -> WindowsProcess$.getExitCodeProcess$$anonfun$1(hProcess, ref)));
            Logger LoggerImpl_this = js7$launcher$forwindows$WindowsProcess$$$logger;
            if (!LoggerImpl_this.underlying().isTraceEnabled()) break block0;
            LoggerImpl_this.underlying().trace("GetExitCodeProcess => {}", (Object)BoxesRunTime.boxToInteger((int)ref.getValue()));
        }
        return ref.getValue();
    }

    public Path makeFileExecutableForUser(Path file, WindowsUserName user) {
        return this.grantFileAccess(file, this.injectableUserName(user) + ":RX");
    }

    public Path makeFileAppendableForUser(Path file, WindowsUserName user) {
        return this.grantFileAccess(file, this.injectableUserName(user) + ":M");
    }

    public String injectableUserName(WindowsUserName user) {
        String name = user.string();
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name)) && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(name), (Function1 & Serializable)c -> this.injectableUserName$$anonfun$1(BoxesRunTime.unboxToChar((Object)c))), () -> WindowsProcess$.injectableUserName$$anonfun$2(name));
        return name;
    }

    private Path grantFileAccess(Path file, String grant) {
        this.execute(FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(WindowsApi$.MODULE$.windowsDirectory()), "System32\\icacls.exe"), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\"" + file.toString() + '\"', "/q", "/grant", grant}));
        return file;
    }

    public Vector<String> execute(Path executable, Seq<String> args) {
        Vector vector;
        Logger LoggerImpl_this = js7$launcher$forwindows$WindowsProcess$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug(executable.toString() + args.mkString(" [", ", ", "]"));
        }
        String string = executable.toString();
        Process process = new ProcessBuilder((String[])Arrays$.MODULE$.seqToArray((Seq)args.$plus$colon((Object)string), String.class)).redirectErrorStream(true).start();
        process.getOutputStream().close();
        Codec commandCodec = new Codec(Charset.forName("cp850"));
        try {
            vector = (Vector)AutoClosing$.MODULE$.autoClosing(process.getInputStream(), (Function1 & Serializable)in -> Source$.MODULE$.fromInputStream(in, commandCodec).getLines().toVector());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                vector = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"error message not readable: " + t}));
            }
            throw throwable;
        }
        Vector lines = vector;
        int returnCode = process.waitFor();
        if (returnCode != 0) {
            throw new RuntimeException("Windows command failed: " + executable + " => " + lines.mkString(" / "));
        }
        return lines;
    }

    public Either<Problem, String> argsToCommandLine(Seq<String> args) {
        return WindowsCommandLineConversion$.MODULE$.argsToCommandLine(args);
    }

    private static final scala.collection.immutable.Map $anonfun$1() {
        return scala.sys.package$.MODULE$.env();
    }

    private static final Option $anonfun$2$$anonfun$1() {
        return scala.sys.package$.MODULE$.env().get((Object)"USERDOMAIN");
    }

    private final boolean startWithWindowsLogon$$anonfun$1$$anonfun$1(WindowsProcess.LoggedOn loggedOn$3, String application$1, String commandLine$1, int creationFlags$1, scala.collection.immutable.Map env$1, WindowsProcess.StartWindowsProcess startWindowsProcess$2, String workingDirectory$1, WinBase.STARTUPINFO startupInfo$1, WinBase.PROCESS_INFORMATION processInformation$1) {
        return WindowsApi$.MODULE$.advapi32().CreateProcessAsUser(loggedOn$3.userToken(), application$1, commandLine$1, null, null, true, creationFlags$1, Advapi32Util.getEnvironmentBlock((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)env$1.removedAll((IterableOnce)startWindowsProcess$2.additionalEnv().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x2) {
                Tuple2 tuple2 = x2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    if (None$.MODULE$.equals(tuple2._2())) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x2, Function1 function1) {
                Tuple2 tuple2 = x2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    if (None$.MODULE$.equals(tuple2._2())) {
                        return k;
                    }
                }
                return function1.apply((Object)x2);
            }
        })).concat((IterableOnce)startWindowsProcess$2.additionalEnv().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x2) {
                Tuple2 tuple2 = x2;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    String k = (String)tuple2._1();
                    if (option instanceof Some) {
                        String v = (String)((Some)option).value();
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x2, Function1 function1) {
                Tuple2 tuple2 = x2;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    String k = (String)tuple2._1();
                    if (option instanceof Some) {
                        String v = (String)((Some)option).value();
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v);
                    }
                }
                return function1.apply((Object)x2);
            }
        }))).asJava()), workingDirectory$1, startupInfo$1, processInformation$1);
    }

    public static final /* synthetic */ boolean js7$launcher$forwindows$WindowsProcess$LoggedOn$$$_$_$$anonfun$3(WindowsLogon logon$1, WinNT.HANDLEByReference _$2) {
        return WindowsApi$.MODULE$.advapi32().LogonUser(logon$1.userName().string(), null, logon$1.credential().password().string(), 4, 0, _$2);
    }

    private static final boolean loadUserProfile$$anonfun$1(WinNT.HANDLE userToken$1, PROFILEINFO profileInfo$1) {
        return WindowsApi$.MODULE$.myUserenv().LoadUserProfile(userToken$1, profileInfo$1);
    }

    private static final boolean getExitCodeProcess$$anonfun$1(WinNT.HANDLE hProcess$2, IntByReference ref$1) {
        return WindowsApi$.MODULE$.kernel32().GetExitCodeProcess(hProcess$2, ref$1);
    }

    private final boolean isValid$1(char c) {
        return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) || AllowedUserNameCharacters.apply((Object)BoxesRunTime.boxToCharacter((char)c));
    }

    private final /* synthetic */ boolean injectableUserName$$anonfun$1(char c) {
        return this.isValid$1(c);
    }

    private static final Object injectableUserName$$anonfun$2(String name$1) {
        return "Unsupported character in Windows user name: '" + name$1 + "'";
    }
}

