/*
 * Decompiled with CFR 0.152.
 */
package js7.provider;

import cats.Applicative;
import cats.Functor;
import cats.Semigroupal;
import cats.Traverse;
import cats.data.NonEmptyList;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Resource;
import cats.effect.unsafe.IORuntime;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.configutils.Configs$;
import js7.base.configutils.Configs$RichConfig$;
import js7.base.generic.Completed$package$Completed$;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.service.MainService;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.utils.Atomic$package$Atomic$extensions$;
import js7.base.utils.Closer;
import js7.base.utils.HasCloser;
import js7.base.utils.ProgramTermination;
import js7.base.utils.ProgramTermination$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.common.files.DirectoryReader;
import js7.common.files.DirectoryReader$;
import js7.common.files.PathSeqDiff;
import js7.common.files.PathSeqDiffer$;
import js7.controller.client.HttpControllerApi;
import js7.core.item.ItemPaths$;
import js7.core.item.ItemReader;
import js7.core.item.TypedSourceReader;
import js7.data.item.InventoryItem;
import js7.data.item.InventoryItemDiff;
import js7.data.item.InventoryItemDiff$;
import js7.data.item.InventoryItemPath;
import js7.data.item.InventoryItemPath$;
import js7.data.item.ItemOperation;
import js7.data.item.ItemOperation$AddOrChangeSigned$;
import js7.data.item.ItemOperation$AddOrChangeSimple$;
import js7.data.item.ItemOperation$AddVersion$;
import js7.data.item.ItemOperation$Remove$;
import js7.data.item.ItemSigner;
import js7.data.item.SignableItem;
import js7.data.item.UnsignedSimpleItem;
import js7.data.item.VersionId;
import js7.data.item.VersionedItem;
import js7.data.item.VersionedItemPath;
import js7.data.workflow.WorkflowControl;
import js7.data.workflow.WorkflowPathControl;
import js7.provider.Observing;
import js7.provider.OrderProvider;
import js7.provider.Provider$;
import js7.provider.VersionIdGenerator;
import js7.provider.configuration.ProviderConfiguration;
import js7.provider.scheduledorder.OrderScheduleGenerator;
import js7.proxy.ControllerApi;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.View;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public final class Provider
implements HasCloser,
OrderProvider,
Observing,
Service,
MainService,
StoppableByRequest,
Service.StoppableByRequest {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Provider.class.getDeclaredField("js7$provider$OrderProvider$$typedSourceReader$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Provider.class.getDeclaredField("loginUntilReachable$lzy1"));
    private Closer js7$base$utils$HasCloser$$_closer;
    private volatile Object js7$provider$OrderProvider$$typedSourceReader$lzy1;
    private OrderScheduleGenerator js7$provider$OrderProvider$$orderScheduleGenerator;
    private FiniteDuration js7$provider$Observing$$minimumSilence;
    private FiniteDuration js7$provider$Observing$$watchDuration;
    private FiniteDuration js7$provider$Observing$$errorWaitDuration;
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private final ItemSigner<SignableItem> itemSigner;
    private final HttpControllerApi httpControllerApi;
    private final ControllerApi controllerApi;
    private final ProviderConfiguration conf;
    private final IORuntime IORuntime;
    private final NonEmptyList<FiniteDuration> firstRetryLoginDurations;
    private final TypedSourceReader typedSourceReader;
    private final VersionIdGenerator newVersionId;
    private final AtomicReference<Vector<DirectoryReader.Entry>> lastEntries;
    private final IO untilTerminated;
    private volatile Object loginUntilReachable$lzy1;

    public static Resource<IO, Provider> resource(ProviderConfiguration providerConfiguration, IORuntime iORuntime) {
        return Provider$.MODULE$.resource(providerConfiguration, iORuntime);
    }

    public Provider(ItemSigner<SignableItem> itemSigner, HttpControllerApi httpControllerApi, ControllerApi controllerApi, ProviderConfiguration conf, IORuntime IORuntime2) {
        this.itemSigner = itemSigner;
        this.httpControllerApi = httpControllerApi;
        this.controllerApi = controllerApi;
        this.conf = conf;
        this.IORuntime = IORuntime2;
        HasCloser.$init$(this);
        OrderProvider.$init$(this);
        Observing.$init$(this);
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        Either either = Checked$.MODULE$.Ops(Configs$RichConfig$.MODULE$.nonEmptyFiniteDurations$extension(Configs$.MODULE$.RichConfig(conf.config()), "js7.provider.controller.login-retry-delays"));
        this.firstRetryLoginDurations = (NonEmptyList)Checked$Ops$.MODULE$.orThrow$extension(either);
        this.typedSourceReader = new TypedSourceReader(conf.liveDirectory(), (Iterable<ItemReader>)Provider$.js7$provider$Provider$$$readers);
        this.newVersionId = new VersionIdGenerator();
        Vector initial$proxy1 = package$.MODULE$.Vector().empty();
        this.lastEntries = new AtomicReference<Vector>(initial$proxy1);
        this.untilTerminated = this.untilStopped().as((Object)ProgramTermination$.MODULE$.apply(ProgramTermination$.MODULE$.apply$default$1()));
        Statics.releaseFence();
    }

    @Override
    public Closer js7$base$utils$HasCloser$$_closer() {
        return this.js7$base$utils$HasCloser$$_closer;
    }

    @Override
    public void js7$base$utils$HasCloser$_setter_$js7$base$utils$HasCloser$$_closer_$eq(Closer x$0) {
        this.js7$base$utils$HasCloser$$_closer = x$0;
    }

    @Override
    public TypedSourceReader js7$provider$OrderProvider$$typedSourceReader() {
        Object object = this.js7$provider$OrderProvider$$typedSourceReader$lzy1;
        if (object instanceof TypedSourceReader) {
            return (TypedSourceReader)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (TypedSourceReader)this.js7$provider$OrderProvider$$typedSourceReader$lzyINIT1();
    }

    private Object js7$provider$OrderProvider$$typedSourceReader$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.js7$provider$OrderProvider$$typedSourceReader$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    TypedSourceReader typedSourceReader = null;
                    try {
                        typedSourceReader = OrderProvider.js7$provider$OrderProvider$$typedSourceReader$(this);
                        object2 = typedSourceReader == null ? LazyVals.NullValue$.MODULE$ : typedSourceReader;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.js7$provider$OrderProvider$$typedSourceReader$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return typedSourceReader;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public OrderScheduleGenerator js7$provider$OrderProvider$$orderScheduleGenerator() {
        return this.js7$provider$OrderProvider$$orderScheduleGenerator;
    }

    @Override
    public void js7$provider$OrderProvider$_setter_$js7$provider$OrderProvider$$orderScheduleGenerator_$eq(OrderScheduleGenerator x$0) {
        this.js7$provider$OrderProvider$$orderScheduleGenerator = x$0;
    }

    @Override
    public FiniteDuration js7$provider$Observing$$minimumSilence() {
        return this.js7$provider$Observing$$minimumSilence;
    }

    @Override
    public FiniteDuration js7$provider$Observing$$watchDuration() {
        return this.js7$provider$Observing$$watchDuration;
    }

    @Override
    public FiniteDuration js7$provider$Observing$$errorWaitDuration() {
        return this.js7$provider$Observing$$errorWaitDuration;
    }

    @Override
    public void js7$provider$Observing$_setter_$js7$provider$Observing$$minimumSilence_$eq(FiniteDuration x$0) {
        this.js7$provider$Observing$$minimumSilence = x$0;
    }

    @Override
    public void js7$provider$Observing$_setter_$js7$provider$Observing$$watchDuration_$eq(FiniteDuration x$0) {
        this.js7$provider$Observing$$watchDuration = x$0;
    }

    @Override
    public void js7$provider$Observing$_setter_$js7$provider$Observing$$errorWaitDuration_$eq(FiniteDuration x$0) {
        this.js7$provider$Observing$$errorWaitDuration = x$0;
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    @Override
    public HttpControllerApi httpControllerApi() {
        return this.httpControllerApi;
    }

    @Override
    public ProviderConfiguration conf() {
        return this.conf;
    }

    public IORuntime IORuntime() {
        return this.IORuntime;
    }

    public Config config() {
        return this.conf().config();
    }

    @Override
    public IO<ProgramTermination> untilTerminated() {
        return this.untilTerminated;
    }

    @Override
    public IO<Service.Started> start() {
        return this.startService((IO)this.run());
    }

    private IO<BoxedUnit> run() {
        if (this.conf().testSuppressStart()) {
            return this.untilStopRequested();
        }
        return (IO)this.stream().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain();
    }

    @Override
    public IO<BoxedUnit> stop() {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.stop$$anonfun$1();
            return BoxedUnit.UNIT;
        }).$times$greater(StoppableByRequest.stop$(this));
    }

    public IO<Either<Problem, Completed$package$Completed$>> initiallyUpdateControllerConfiguration(Option<VersionId> versionId) {
        return this.readDirectory().flatMap((Function1 & Serializable)localEntries -> this.controllerDiff((Seq<DirectoryReader.Entry>)localEntries).flatMap((Function1 & Serializable)checkedDiff -> {
            Either either = implicits$.MODULE$.catsSyntaxEither(checkedDiff);
            return ((IO)EitherOps$.MODULE$.traverse$extension(either, (Function1 & Serializable)_$1 -> this.execute(versionId, (InventoryItemDiff<InventoryItemPath, InventoryItem>)_$1), (Applicative)IO$.MODULE$.asyncForIO())).map((Function1 & Serializable)_$2 -> _$2.flatten((.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)checkedCompleted -> {
                checkedCompleted.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Completed$package$Completed$ completed$package$Completed$ = x$1;
                    Atomic$package$Atomic$extensions$.MODULE$.$colon$eq(this.lastEntries, localEntries);
                });
                return checkedCompleted;
            });
        }));
    }

    public Option<VersionId> initiallyUpdateControllerConfiguration$default$1() {
        return None$.MODULE$;
    }

    public IO<Either<Problem, InventoryItemDiff<InventoryItemPath, InventoryItem>>> testControllerDiff() {
        return this.readDirectory().flatMap((Function1 & Serializable)localEntries -> this.controllerDiff((Seq<DirectoryReader.Entry>)localEntries).map((Function1 & Serializable)diff -> diff));
    }

    private IO<Either<Problem, InventoryItemDiff<InventoryItemPath, InventoryItem>>> controllerDiff(Seq<DirectoryReader.Entry> localEntries) {
        return MonixLikeExtensions$.MODULE$.parZip2(IO$.MODULE$, this.readLocalItems((Seq<Path>)((Seq)localEntries.map((Function1 & Serializable)_$3 -> _$3.file()))), this.fetchControllerItems()).map((Function1 & Serializable)pair -> {
            Tuple2 tuple2 = pair;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either checkedLocalItemSeq = (Either)tuple2._1();
            Iterable controllerItems = (Iterable)tuple2._2();
            Tuple2 $1$ = tuple2;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$1$, (Object)checkedLocalItemSeq, (Object)controllerItems);
            Tuple2 $1$2 = (Tuple2)tuple3._1();
            Either checkedLocalItemSeq2 = (Either)tuple3._2();
            Iterable controllerItems2 = (Iterable)tuple3._3();
            return Tuple2$.MODULE$.apply(pair, (Object)$1$2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Tuple2 pair = (Tuple2)tuple2._1();
                if (tuple22 != null) {
                    Either checkedLocalItemSeq = (Either)tuple22._1();
                    Iterable controllerItems = (Iterable)tuple22._2();
                    return checkedLocalItemSeq.map((Function1 & Serializable)_$4 -> InventoryItemDiff$.MODULE$.diff((Iterable<InventoryItem>)_$4, (Iterable<InventoryItem>)controllerItems, true));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private IO<Either<Problem, Seq<InventoryItem>>> readLocalItems(Seq<Path> files) {
        return IO$.MODULE$.apply(() -> this.readLocalItems$$anonfun$1(files));
    }

    public IO<Either<Problem, Completed$package$Completed$>> updateControllerConfiguration(Option<VersionId> versionId) {
        return this.loginUntilReachable().map((Function1 & Serializable)x$1 -> {
            Completed$package$Completed$ completed$package$Completed$;
            Completed$package$Completed$ $3$ = completed$package$Completed$ = x$1;
            Vector<DirectoryReader.Entry> last = this.lastEntries.get();
            return Tuple2$.MODULE$.apply((Object)$3$, last);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Vector last = (Vector)tuple2._2();
                return this.readDirectory().flatMap((Function1 & Serializable)currentEntries -> {
                    Either either = implicits$.MODULE$.catsSyntaxEither(this.toItemDiff(PathSeqDiffer$.MODULE$.diff((Seq<DirectoryReader.Entry>)currentEntries, (Seq<DirectoryReader.Entry>)last)));
                    return ((IO)EitherOps$.MODULE$.traverse$extension(either, (Function1 & Serializable)_$5 -> this.execute(versionId, (InventoryItemDiff<InventoryItemPath, InventoryItem>)_$5), (Applicative)IO$.MODULE$.asyncForIO())).map((Function1 & Serializable)_$6 -> _$6.flatten((.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)checkedCompleted -> checkedCompleted.flatMap((Function1 & Serializable)completed -> {
                        if (!this.lastEntries.compareAndSet((Vector<DirectoryReader.Entry>)last, (Vector<DirectoryReader.Entry>)currentEntries)) {
                            Problem problem = Problem$.MODULE$.pure("Provider has been concurrently used");
                            Logger LoggerImpl_this = Provider$.js7$provider$Provider$$$logger;
                            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                                LoggerImpl_this.underlying().debug(problem.toString());
                            }
                            return package$.MODULE$.Left().apply((Object)problem);
                        }
                        return package$.MODULE$.Right().apply(completed);
                    }));
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Option<VersionId> updateControllerConfiguration$default$1() {
        return None$.MODULE$;
    }

    public IO<Completed$package$Completed$> loginUntilReachable() {
        Object object = this.loginUntilReachable$lzy1;
        if (object instanceof IO) {
            return (IO)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (IO)this.loginUntilReachable$lzyINIT1();
    }

    private Object loginUntilReachable$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.loginUntilReachable$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    IO iO = null;
                    try {
                        iO = IO$.MODULE$.defer(this::loginUntilReachable$lzyINIT1$$anonfun$1);
                        object2 = iO == null ? LazyVals.NullValue$.MODULE$ : iO;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.loginUntilReachable$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return iO;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private IO<Either<Problem, Completed$package$Completed$>> execute(Option<VersionId> versionId, InventoryItemDiff<InventoryItemPath, InventoryItem> diff) {
        if (diff.isEmpty() && versionId.isEmpty()) {
            return IO$.MODULE$.apply(Provider::execute$$anonfun$1);
        }
        VersionId v = (VersionId)versionId.getOrElse(this::$anonfun$1);
        this.logUpdate(v, diff);
        return this.updateItems(this.itemSigner, v, diff);
    }

    private IO<Either<Problem, Completed$package$Completed$>> updateItems(ItemSigner<SignableItem> itemSigner, VersionId versionId, InventoryItemDiff<InventoryItemPath, InventoryItem> diff) {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(diff.containsVersionedItem());
        Stream addVersion = Stream$.MODULE$.iterable(Option$.MODULE$.option2Iterable(ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> Provider.$anonfun$2(versionId))));
        Stream addOrChange = Stream$.MODULE$.iterable(diff.addedOrChanged()).map((Function1 & Serializable)x$1 -> {
            InventoryItem inventoryItem = x$1;
            if (inventoryItem instanceof VersionedItem) {
                VersionedItem item = (VersionedItem)inventoryItem;
                return item.withVersion(versionId);
            }
            InventoryItem o = inventoryItem;
            return o;
        }).map((Function1 & Serializable)x$1 -> {
            ItemOperation.AddOrChangeOperation addOrChangeOperation;
            InventoryItem inventoryItem = x$1;
            if (inventoryItem instanceof UnsignedSimpleItem) {
                UnsignedSimpleItem item = (UnsignedSimpleItem)inventoryItem;
                addOrChangeOperation = ItemOperation$AddOrChangeSimple$.MODULE$.apply(item);
            } else if (inventoryItem instanceof SignableItem) {
                SignableItem item = (SignableItem)inventoryItem;
                addOrChangeOperation = ItemOperation$AddOrChangeSigned$.MODULE$.apply(itemSigner.toSignedString(item));
            } else {
                throw new MatchError((Object)inventoryItem);
            }
            return addOrChangeOperation;
        });
        Stream remove = Stream$.MODULE$.iterable(diff.removed()).map((Function1 & Serializable)_$7 -> ItemOperation$Remove$.MODULE$.apply((InventoryItemPath)_$7));
        return this.controllerApi.updateItems((Stream<IO, ItemOperation>)addVersion.$plus$plus(() -> Provider.updateItems$$anonfun$1(addOrChange)).$plus$plus(() -> Provider.updateItems$$anonfun$2(remove)));
    }

    private void logUpdate(VersionId versionId, InventoryItemDiff<InventoryItemPath, InventoryItem> diff) {
        Logger LoggerImpl_this = Provider$.js7$provider$Provider$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("Version {}", (Object)versionId.string());
        }
        ((IterableOnceOps)diff.removed().sorted(InventoryItemPath$.MODULE$.inventoryItemPathOrdering())).foreach((Function1)(JProcedure1 & Serializable)o -> {
            Logger LoggerImpl_this = Provider$.js7$provider$Provider$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("Delete {}", o);
                return;
            }
        });
        ((IterableOnceOps)((SeqOps)diff.addedOrChanged().map((Function1 & Serializable)_$8 -> _$8.path())).sorted(InventoryItemPath$.MODULE$.inventoryItemPathOrdering())).foreach((Function1)(JProcedure1 & Serializable)o -> {
            Logger LoggerImpl_this = Provider$.js7$provider$Provider$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("AddOrChange {}", o);
                return;
            }
        });
    }

    private IO<Iterable<InventoryItem>> fetchControllerItems() {
        return this.httpControllerApi().retryUntilReachable(this.httpControllerApi().retryUntilReachable$default$1(), this::fetchControllerItems$$anonfun$1).map((Function1 & Serializable)_$9 -> (View)_$9.items().filter((Function1 & Serializable)o -> !(o instanceof WorkflowPathControl) && !(o instanceof WorkflowControl)));
    }

    private IO<Vector<DirectoryReader.Entry>> readDirectory() {
        return IO$.MODULE$.apply(this::readDirectory$$anonfun$1);
    }

    private Either<Problem, InventoryItemDiff<InventoryItemPath, InventoryItem>> toItemDiff(PathSeqDiff diff) {
        Either<Problem, Seq<InventoryItem>> checkedAddedOrChanged = this.typedSourceReader.readItems((Seq<Path>)((Seq)diff.added().$plus$plus(diff.changed())));
        Either checkedDeleted = (Either)implicits$.MODULE$.toTraverseOps((Object)diff.deleted().toVector(), (Traverse)implicits$.MODULE$.catsStdInstancesForVector()).traverse((Function1 & Serializable)path -> ItemPaths$.MODULE$.fileToVersionedItemPath((Iterable<VersionedItemPath.Companion<? extends VersionedItemPath>>)Provider$.js7$provider$Provider$$$versionedItemPathCompanions, this.conf().liveDirectory(), (Path)path), (Applicative)implicits$.MODULE$.catsStdInstancesForEither());
        return (Either)implicits$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(checkedAddedOrChanged, (Object)checkedDeleted)).mapN((Function2 & Serializable)(add, del) -> InventoryItemDiff$.MODULE$.apply(add, del), (Functor)implicits$.MODULE$.catsStdInstancesForEither(), (Semigroupal)implicits$.MODULE$.catsStdInstancesForEither());
    }

    private Iterator<FiniteDuration> retryLoginDurations() {
        return ScalaUtils$syntax$.MODULE$.continueWithLast(this.firstRetryLoginDurations.iterator());
    }

    private final void stop$$anonfun$1() {
        this.close();
    }

    private final Either readLocalItems$$anonfun$1(Seq files$1) {
        return this.typedSourceReader.readItems((Seq<Path>)files$1);
    }

    private final IO loginUntilReachable$lzyINIT1$$anonfun$1() {
        if (this.httpControllerApi().hasSession()) {
            return CatsEffectExtensions$.MODULE$.inline$completedIO();
        }
        return this.httpControllerApi().loginUntilReachable(this.retryLoginDurations(), this.httpControllerApi().loginUntilReachable$default$2(), this.httpControllerApi().loginUntilReachable$default$3()).map((Function1 & Serializable)completed -> {
            block0: {
                Logger LoggerImpl_this = Provider$.js7$provider$Provider$$$logger;
                if (!LoggerImpl_this.underlying().isInfoEnabled()) break block0;
                LoggerImpl_this.underlying().info("Logged-in at Controller");
            }
            return completed;
        });
    }

    private static final Either execute$$anonfun$1() {
        return Checked$.MODULE$.completed();
    }

    private final VersionId $anonfun$1() {
        return this.newVersionId.apply();
    }

    private static final ItemOperation.AddVersion a$proxy1$1(VersionId versionId$7) {
        return ItemOperation$AddVersion$.MODULE$.apply(versionId$7);
    }

    private static final ItemOperation.AddVersion $anonfun$2(VersionId versionId$9) {
        return Provider.a$proxy1$1(versionId$9);
    }

    private static final Stream updateItems$$anonfun$1(Stream addOrChange$1) {
        return addOrChange$1;
    }

    private static final Stream updateItems$$anonfun$2(Stream remove$1) {
        return remove$1;
    }

    private final IO fetchControllerItems$$anonfun$1() {
        return this.httpControllerApi().snapshot(this.httpControllerApi().snapshot$default$1());
    }

    private final Vector readDirectory$$anonfun$1() {
        return DirectoryReader$.MODULE$.entries(this.conf().liveDirectory(), DirectoryReader$.MODULE$.entries$default$2()).toVector();
    }
}

