/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.javadsl.model;

import java.io.File;
import java.nio.file.Path;
import org.apache.pekko.http.impl.util.JavaAccessors;
import org.apache.pekko.http.javadsl.model.ContentType;
import org.apache.pekko.http.javadsl.model.HttpEntity;
import org.apache.pekko.http.javadsl.model.UniversalEntity;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Chunked$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;

public final class HttpEntities {
    public static final HttpEntity.Strict EMPTY = HttpEntity$.MODULE$.Empty();

    private HttpEntities() {
    }

    public static HttpEntity.Strict create(String string) {
        return HttpEntity$.MODULE$.apply(string);
    }

    public static HttpEntity.Strict create(byte[] byArray) {
        return HttpEntity$.MODULE$.apply(byArray);
    }

    public static HttpEntity.Strict create(ByteString byteString) {
        return HttpEntity$.MODULE$.apply(byteString);
    }

    public static HttpEntity.Strict create(ContentType.NonBinary nonBinary, String string) {
        return HttpEntity$.MODULE$.apply((ContentType.NonBinary)nonBinary, string);
    }

    public static HttpEntity.Strict create(ContentType contentType, byte[] byArray) {
        return HttpEntity$.MODULE$.apply((org.apache.pekko.http.scaladsl.model.ContentType)contentType, byArray);
    }

    public static HttpEntity.Strict create(ContentType contentType, ByteString byteString) {
        return HttpEntity$.MODULE$.apply((org.apache.pekko.http.scaladsl.model.ContentType)contentType, byteString);
    }

    public static UniversalEntity create(ContentType contentType, File file) {
        return JavaAccessors.HttpEntity(contentType, file);
    }

    public static UniversalEntity create(ContentType contentType, Path path) {
        return JavaAccessors.HttpEntity(contentType, path);
    }

    public static UniversalEntity create(ContentType contentType, File file, int n) {
        return HttpEntities.create(contentType, file.toPath(), n);
    }

    public static UniversalEntity create(ContentType contentType, Path path, int n) {
        return HttpEntity$.MODULE$.fromPath((org.apache.pekko.http.scaladsl.model.ContentType)contentType, path, n);
    }

    public static HttpEntity.Default create(ContentType contentType, long l, org.apache.pekko.stream.javadsl.Source<ByteString, ?> source) {
        return new HttpEntity.Default((org.apache.pekko.http.scaladsl.model.ContentType)contentType, l, HttpEntities.toScala(source));
    }

    public static HttpEntity.Chunked create(ContentType contentType, org.apache.pekko.stream.javadsl.Source<ByteString, ?> source) {
        return HttpEntity$Chunked$.MODULE$.fromData((org.apache.pekko.http.scaladsl.model.ContentType)contentType, HttpEntities.toScala(source));
    }

    public static HttpEntity.CloseDelimited createCloseDelimited(ContentType contentType, org.apache.pekko.stream.javadsl.Source<ByteString, ?> source) {
        return new HttpEntity.CloseDelimited((org.apache.pekko.http.scaladsl.model.ContentType)contentType, HttpEntities.toScala(source));
    }

    public static HttpEntity.IndefiniteLength createIndefiniteLength(ContentType contentType, org.apache.pekko.stream.javadsl.Source<ByteString, ?> source) {
        return new HttpEntity.IndefiniteLength((org.apache.pekko.http.scaladsl.model.ContentType)contentType, HttpEntities.toScala(source));
    }

    public static HttpEntity.Chunked createChunked(ContentType contentType, org.apache.pekko.stream.javadsl.Source<ByteString, ?> source) {
        return HttpEntity$Chunked$.MODULE$.fromData((org.apache.pekko.http.scaladsl.model.ContentType)contentType, HttpEntities.toScala(source));
    }

    private static Source<ByteString, Object> toScala(org.apache.pekko.stream.javadsl.Source<ByteString, ?> source) {
        return source.asScala();
    }
}

