/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.sign.keys.keyStore;

import java.util.HashMap;
import java.util.Map;

public enum KeystoreType {
    PKCS12("PKCS12"),
    JKS("JKS");

    private final String value;
    private static final Map<String, KeystoreType> CONSTANTS;

    private KeystoreType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public String value() {
        return this.value;
    }

    public static KeystoreType fromValue(String value) {
        KeystoreType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, KeystoreType>();
        for (KeystoreType c : KeystoreType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

