/*
 * Decompiled with CFR 0.152.
 */
package sos.connection;

import com.sos.keepass.SOSKeePassResolver;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSDB2Connection;
import sos.connection.SOSFbSQLConnection;
import sos.connection.SOSMSSQLConnection;
import sos.connection.SOSMySQLConnection;
import sos.connection.SOSOracleConnection;
import sos.connection.SOSPgSQLConnection;
import sos.connection.SOSSybaseConnection;
import sos.connection.util.SOSProfiler;
import sos.util.SOSClassUtil;
import sos.util.SOSCommandline;
import sos.util.SOSString;
import sos.xml.SOSXMLXPath;

public abstract class SOSConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSConnection.class);
    protected static final String NLS_DE = "DE";
    protected static final String NLS_ISO = "ISO";
    protected static final String CAST_PATTERN = "(\\s*%cast\\s*)*\\s*(\\()*\\s*(\\s*%cast\\s*)+\\s*(\\(\\s*\\S+\\s*(\\S+?).*?)\\)(\\s*(\\+|\\-)*[0-9]*\\s*\\S*(\\)))*";
    protected Properties configFileProperties = new Properties();
    protected Statement statement;
    protected ResultSet resultSet;
    protected boolean lowerCase = true;
    protected int compatibility = 0;
    protected boolean fieldNameUpperCase = true;
    protected boolean tableNameUpperCase = true;
    protected String driver;
    protected String url;
    protected String dbuser;
    protected String dbpassword;
    protected String dbname;
    private boolean execReturnsResultSet = false;
    private static final String EXEC_COMMENT_RETURN_RESULTSET = "EXECRETURNSRESULTSET";
    private static final String REPLACE_BACKSLASH = "\\\\'";
    private static final String REPLACEMENT_BACKSLASH = "XxxxX";
    private static final String REPLACE_DOUBLE_APOSTROPHE = "''";
    private static final String REPLACEMENT_DOUBLE_APOSTROPHE = "YyyyY";
    private static final String HIBERNATE_PROPERTY_DIALECT = "hibernate.dialect";
    private static final String HIBERNATE_PROPERTY_CONNECTION_DRIBER_CLASS = "hibernate.connection.driver_class";
    private static final String HIBERNATE_PROPERTY_CONNECTION_URL = "hibernate.connection.url";
    private static final String HIBERNATE_PROPERTY_CONNECTION_USERNAME = "hibernate.connection.username";
    private static final String HIBERNATE_PROPERTY_CONNECTION_PASSWORD = "hibernate.connection.password";
    private static final String HIBERNATE_SOS_PROPERTY_CREDENTIAL_STORE_FILE = "hibernate.sos.credential_store_file";
    private static final String HIBERNATE_SOS_PROPERTY_CREDENTIAL_STORE_KEY_FILE = "hibernate.sos.credential_store_key_file";
    private static final String HIBERNATE_SOS_PROPERTY_CREDENTIAL_STORE_PASSWORD = "hibernate.sos.credential_store_password";
    private static final String HIBERNATE_SOS_PROPERTY_CREDENTIAL_STORE_ENTRY_PATH = "hibernate.sos.credential_store_entry_path";
    private String beginProcedure = "";
    private int majorVersion = -1;
    private int minorVersion = 0;
    private String productVersion = "";
    private boolean useExecuteBatch = false;
    private int batchSize = 100;
    private boolean flgColumnNamesCaseSensitivity = false;
    private long lngMaxNoOfRecordsToProcess = -1L;
    public Connection connection;
    public static SOSProfiler profiler = null;

    public SOSConnection() throws Exception {
    }

    public SOSConnection(Connection connection) throws Exception {
        this.connection = connection;
    }

    public SOSConnection(String configFileName) throws Exception {
        String sCompatibility;
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        LOGGER.trace(".. configFileName: " + configFileName);
        File file = new File(configFileName);
        if (!file.exists()) {
            throw new Exception("make sure that the file [" + configFileName + "] does exist!");
        }
        FileInputStream fs = null;
        InputStream in = null;
        try {
            fs = new FileInputStream(configFileName);
            in = new BufferedInputStream(fs);
            if (file.getName().toLowerCase().endsWith(".xml")) {
                SOSXMLXPath xpath = new SOSXMLXPath(in);
                String dialect = SOSConnection.getHibernateConfigurationValue(xpath, HIBERNATE_PROPERTY_DIALECT);
                this.configFileProperties = new Properties();
                this.configFileProperties.setProperty("[configuration]", "");
                this.configFileProperties.setProperty("class", SOSConnection.getClassNameByHibernateDialect(dialect));
                this.configFileProperties.setProperty("driver", SOSConnection.getHibernateConfigurationValue(xpath, HIBERNATE_PROPERTY_CONNECTION_DRIBER_CLASS));
                this.configFileProperties.setProperty("url", SOSConnection.getHibernateConfigurationValue(xpath, HIBERNATE_PROPERTY_CONNECTION_URL));
                this.configFileProperties.setProperty("user", SOSConnection.getHibernateConfigurationValue(xpath, HIBERNATE_PROPERTY_CONNECTION_USERNAME));
                this.configFileProperties.setProperty("password", SOSConnection.getHibernateConfigurationValue(xpath, HIBERNATE_PROPERTY_CONNECTION_PASSWORD));
                this.resolveCredentialStoreProperties(xpath);
                if (this.configFileProperties.getProperty("class").equals(SOSMSSQLConnection.class.getSimpleName())) {
                    this.configFileProperties.setProperty("compatibility", "normal");
                } else {
                    this.configFileProperties.setProperty("compatibility", "");
                }
            } else {
                this.configFileProperties.load(in);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
        }
        if (SOSString.isEmpty((String)this.configFileProperties.getProperty("driver"))) {
            throw new Exception("driver missing.");
        }
        this.driver = this.configFileProperties.getProperty("driver");
        if (!SOSString.isEmpty((String)this.driver)) {
            this.driver = this.driver.trim();
        }
        this.url = this.configFileProperties.getProperty("url");
        if (!SOSString.isEmpty((String)this.url)) {
            this.url = this.url.trim();
        }
        this.dbname = this.configFileProperties.getProperty("db");
        if (!SOSString.isEmpty((String)this.dbname)) {
            this.dbname = this.dbname.trim();
        }
        this.dbuser = this.configFileProperties.getProperty("user");
        if (!SOSString.isEmpty((String)this.dbuser)) {
            this.dbuser = this.dbuser.trim();
        }
        this.dbpassword = this.configFileProperties.getProperty("password");
        if (!SOSString.isEmpty((String)this.dbpassword)) {
            this.dbpassword = this.dbpassword.trim();
        }
        if (!SOSString.isEmpty((String)(sCompatibility = this.configFileProperties.getProperty("compatibility")))) {
            this.setCompatibility(SOSConnection.getCompatibility(sCompatibility));
        }
        this.processPassword();
    }

    private void resolveCredentialStoreProperties(SOSXMLXPath xpath) throws Exception {
        String password;
        String username;
        if (this.configFileProperties == null) {
            return;
        }
        String f = SOSConnection.getHibernateConfigurationValue(xpath, HIBERNATE_SOS_PROPERTY_CREDENTIAL_STORE_FILE);
        String kf = SOSConnection.getHibernateConfigurationValue(xpath, HIBERNATE_SOS_PROPERTY_CREDENTIAL_STORE_KEY_FILE);
        String p = SOSConnection.getHibernateConfigurationValue(xpath, HIBERNATE_SOS_PROPERTY_CREDENTIAL_STORE_PASSWORD);
        String ep = SOSConnection.getHibernateConfigurationValue(xpath, HIBERNATE_SOS_PROPERTY_CREDENTIAL_STORE_ENTRY_PATH);
        SOSKeePassResolver r = new SOSKeePassResolver(f, kf, p);
        r.setEntryPath(ep);
        String url = this.configFileProperties.getProperty("url");
        if (url != null) {
            this.configFileProperties.setProperty("url", r.resolve(url));
        }
        if ((username = this.configFileProperties.getProperty("user")) != null) {
            this.configFileProperties.setProperty("user", r.resolve(username));
        }
        if ((password = this.configFileProperties.getProperty("password")) != null) {
            this.configFileProperties.setProperty("password", r.resolve(password));
        }
    }

    public SOSConnection(String driver, String url, String dbuser, String dbpassword) throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        if (SOSString.isEmpty((String)driver)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database driver.");
        }
        this.driver = driver;
        this.url = url;
        this.dbuser = dbuser;
        this.dbpassword = dbpassword;
        this.processPassword();
        LOGGER.trace(".. driver=" + driver + ", url=" + url + ", dbuser=" + dbuser);
    }

    private void processPassword() {
        this.dbpassword = SOSCommandline.getExternalPassword((String)this.dbpassword);
    }

    public static String getClassName(String configFileName) throws Exception {
        LOGGER.trace("calling " + SOSClassUtil.getMethodName());
        LOGGER.trace(".. configuration file: " + configFileName);
        File file = new File(configFileName);
        if (!file.exists()) {
            throw new Exception("configuration file not found: " + configFileName);
        }
        Properties config = new Properties();
        FileInputStream fs = null;
        InputStream in = null;
        try {
            fs = new FileInputStream(configFileName);
            in = new BufferedInputStream(fs);
            if (file.getName().toLowerCase().endsWith(".xml")) {
                SOSXMLXPath xpath = new SOSXMLXPath(in);
                String dialect = SOSConnection.getHibernateConfigurationValue(xpath, HIBERNATE_PROPERTY_DIALECT);
                config.put("class", SOSString.isEmpty((String)dialect) ? "" : SOSConnection.getClassNameByHibernateDialect(dialect));
            } else {
                config.load(in);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
        }
        if (SOSString.isEmpty((String)config.getProperty("class"))) {
            throw new Exception("class missing.");
        }
        return config.getProperty("class").trim();
    }

    private static String getHibernateConfigurationValue(SOSXMLXPath xpath, String name) throws Exception {
        String val = xpath.selectSingleNodeValue("/hibernate-configuration/session-factory/property[@name='" + name + "']");
        return val == null ? "" : val;
    }

    private static String getClassNameByHibernateDialect(String dialectClassName) throws Exception {
        if (SOSString.isEmpty((String)dialectClassName)) {
            throw new Exception("dialectClassName is NULL");
        }
        if ((dialectClassName = dialectClassName.toLowerCase()).contains("db2")) {
            return SOSDB2Connection.class.getSimpleName();
        }
        if (dialectClassName.contains("firebird")) {
            return SOSFbSQLConnection.class.getSimpleName();
        }
        if (dialectClassName.contains("sqlserver")) {
            return SOSMSSQLConnection.class.getSimpleName();
        }
        if (dialectClassName.contains("mysql")) {
            return SOSMySQLConnection.class.getSimpleName();
        }
        if (dialectClassName.contains("oracle")) {
            return SOSOracleConnection.class.getSimpleName();
        }
        if (dialectClassName.contains("postgre")) {
            return SOSPgSQLConnection.class.getSimpleName();
        }
        if (dialectClassName.contains("sybase")) {
            return SOSSybaseConnection.class.getSimpleName();
        }
        return "unknown";
    }

    public static SOSConnection createInstance(String configFileName) throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        String className = SOSConnection.getClassName(configFileName);
        LOGGER.trace(".. creating instance for: " + className);
        Object[] arguments = new Object[]{configFileName};
        return SOSConnection.createInstance(className, arguments);
    }

    public static SOSConnection createInstance(String className, Connection connection) throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        Object[] arguments = new Object[]{connection};
        return SOSConnection.createInstance(className, arguments);
    }

    public static SOSConnection createInstance(String className, String driver, String url, String dbuser, String dbpassword) throws Exception {
        Object[] arguments = new Object[]{driver, url, dbuser, dbpassword};
        return SOSConnection.createInstance(className, arguments);
    }

    public Connection getConnection() throws Exception {
        if (this.connection == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established.");
        }
        return this.connection;
    }

    public Map<String, String> getSingle(String query) throws Exception {
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData meta = null;
        int columnCount = 0;
        String key = null;
        String value = null;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            query = this.normalizeStatement(query, this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            try {
                if (profiler != null) {
                    profiler.start(query);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(query);
            meta = rs.getMetaData();
            columnCount = meta.getColumnCount();
            if (rs.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    key = this.normalizeKey(meta.getColumnName(i));
                    value = rs.getString(i);
                    if (SOSString.isEmpty((String)value)) {
                        value = "";
                    }
                    results.put(this.normalizeKey(key), value.trim());
                }
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(SOSClassUtil.getMethodName() + ": query failed: " + query + ": " + e.getMessage(), e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
        return results;
    }

    public Properties getSingleAsProperties(String query) throws Exception {
        Properties results = new Properties();
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData meta = null;
        int columnCount = 0;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            query = this.normalizeStatement(query, this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            if (profiler != null) {
                try {
                    profiler.start(query);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(query);
            meta = rs.getMetaData();
            columnCount = meta.getColumnCount();
            if (rs.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String key = this.normalizeKey(meta.getColumnName(i));
                    String value = rs.getString(i);
                    if (SOSString.isEmpty((String)value)) {
                        value = "";
                    }
                    LOGGER.trace(SOSClassUtil.getMethodName() + ", key= " + key + ", value= " + value);
                    results.setProperty(this.normalizeKey(key), value.trim());
                }
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(SOSClassUtil.getMethodName() + ": query failed: " + query + ": " + e.getMessage(), e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
        return results;
    }

    public Properties getArrayAsProperties(String query) throws Exception {
        Properties results = new Properties();
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData meta = null;
        int columnCount = 0;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            query = this.normalizeStatement(query, this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            if (profiler != null) {
                try {
                    profiler.start(query);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(query);
            meta = rs.getMetaData();
            columnCount = meta.getColumnCount();
            while (rs.next()) {
                if (columnCount <= 1) continue;
                String key = rs.getString(1);
                String value = rs.getString(2);
                if (SOSString.isEmpty((String)value)) {
                    value = "";
                }
                LOGGER.trace(SOSClassUtil.getMethodName() + ", key= " + key + ", value= " + value);
                results.setProperty(this.normalizeKey(key), value.trim());
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(SOSClassUtil.getMethodName() + ": query failed: " + query + ": " + e.getMessage(), e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
        return results;
    }

    public String getSingleValue(String query) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        String result = "";
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            query = this.normalizeStatement(query, this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            if (profiler != null) {
                profiler.start(query);
            }
            if ((rs = (stmt = this.connection.createStatement()).executeQuery(query)).next() && SOSString.isEmpty((String)(result = rs.getString(1)))) {
                result = "";
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + ".. successfully executed.");
        }
        catch (Exception e) {
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(SOSClassUtil.getMethodName() + ": query failed: " + query + ": " + e.getMessage(), e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
        return result.trim();
    }

    public List<Map<String, String>> getArray(String query) throws Exception {
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        HashMap record = new LinkedHashMap();
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData meta = null;
        int columnCount = 0;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName() + ": " + query);
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            query = this.normalizeStatement(query, this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            if (profiler != null) {
                try {
                    profiler.start(query);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(query);
            meta = rs.getMetaData();
            columnCount = meta.getColumnCount();
            while (rs.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String key = this.normalizeKey(meta.getColumnName(i));
                    String value = rs.getString(meta.getColumnName(i));
                    if (SOSString.isEmpty((String)value)) {
                        value = "";
                    }
                    record.put(this.normalizeKey(key), value.trim());
                }
                results.add(record);
                record = new HashMap();
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(SOSClassUtil.getMethodName() + ": query failed: " + query + ": " + e.getMessage(), e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
        return results;
    }

    public Vector<Map<String, String>> getArrayAsVector(String query) throws Exception {
        Vector<Map<String, String>> results = new Vector<Map<String, String>>();
        HashMap record = new LinkedHashMap();
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData meta = null;
        int columnCount = 0;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName() + ": " + query);
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            query = this.normalizeStatement(query, this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            if (profiler != null) {
                try {
                    profiler.start(query);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(query);
            meta = rs.getMetaData();
            columnCount = meta.getColumnCount();
            while (rs.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String key = this.normalizeKey(meta.getColumnName(i));
                    String value = rs.getString(meta.getColumnName(i));
                    if (SOSString.isEmpty((String)value)) {
                        value = "";
                    }
                    record.put(this.normalizeKey(key), value.trim());
                }
                results.add(record);
                record = new HashMap();
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(SOSClassUtil.getMethodName() + ": query failed: " + query + ": " + e.getMessage(), e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
        return results;
    }

    public List<String> getArrayValue(String query) throws Exception {
        ArrayList<String> results = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            query = this.normalizeStatement(query, this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            if (profiler != null) {
                profiler.start(query);
            }
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String value = rs.getString(1);
                if (SOSString.isEmpty((String)value)) continue;
                results.add(value.trim());
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(SOSClassUtil.getMethodName() + ": query failed: " + query + ": " + e.getMessage(), e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
        return results;
    }

    public long updateBlob(String tableName, String columnName, byte[] data, String condition) throws Exception {
        ByteArrayInputStream in = null;
        Statement pstmt = null;
        StringBuilder query = null;
        String theQuery = null;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            if (tableName == null) {
                throw new NullPointerException("tableName is null.");
            }
            if (columnName == null) {
                throw new NullPointerException("columnName is null.");
            }
            if (data == null || data.length <= 0) {
                throw new NullPointerException("missing data.");
            }
            in = new ByteArrayInputStream(data);
            query = new StringBuilder();
            query.append("UPDATE ");
            if (this.tableNameUpperCase) {
                query.append(tableName.toUpperCase());
            } else {
                query.append(tableName);
            }
            if (this.fieldNameUpperCase) {
                query.append(" SET \"").append(columnName.toUpperCase()).append("\" = ? ");
            } else {
                query.append(" SET ").append(columnName).append(" = ? ");
            }
            if (!SOSString.isEmpty((String)condition)) {
                query.append(" WHERE ").append(condition);
            }
            theQuery = this.normalizeStatement(query.toString(), this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + theQuery);
            if (profiler != null) {
                try {
                    profiler.start(theQuery);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            pstmt = this.connection.prepareStatement(theQuery);
            pstmt.setBinaryStream(1, in, data.length);
            pstmt.executeUpdate();
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(SOSClassUtil.getMethodName() + ":" + e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
        return data.length;
    }

    public long updateClob(String tableName, String columnName, String data, String condition) throws Exception {
        Statement pstmt = null;
        StringBuilder query = null;
        long totalBytesWritten = 0L;
        String theQuery = null;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            if (SOSString.isEmpty((String)tableName)) {
                throw new NullPointerException("tableName is null.");
            }
            if (SOSString.isEmpty((String)columnName)) {
                throw new NullPointerException("columnName is null.");
            }
            if (SOSString.isEmpty((String)data)) {
                throw new NullPointerException("missing data.");
            }
            query = new StringBuilder();
            query.append("UPDATE ");
            if (this.tableNameUpperCase) {
                query.append(tableName.toUpperCase());
            } else {
                query.append(tableName);
            }
            if (this.fieldNameUpperCase) {
                query.append(" SET \"").append(columnName.toUpperCase()).append("\" = ? ");
            } else {
                query.append(" SET ").append(columnName).append(" = ? ");
            }
            if (!SOSString.isEmpty((String)condition)) {
                query.append(" WHERE ").append(condition);
            }
            theQuery = this.normalizeStatement(query.toString(), this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + theQuery);
            if (profiler != null) {
                try {
                    profiler.start(theQuery);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            pstmt = this.connection.prepareStatement(theQuery);
            totalBytesWritten = data.length();
            pstmt.setCharacterStream(1, new StringReader(data), (int)totalBytesWritten);
            pstmt.executeUpdate();
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            if (profiler != null) {
                profiler.stop("ERROR", e.getMessage());
            }
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.getMessage(), e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
        return totalBytesWritten;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getClob(String query) throws Exception {
        ResultSet rs = null;
        Statement stmt = null;
        Reader in = null;
        StringBuilder sb = new StringBuilder();
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. Maybe the connect method was not called.");
            }
            query = this.normalizeStatement(query, this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            if (profiler != null) {
                try {
                    profiler.start(query);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stmt = this.connection.createStatement();
            try {
                rs = stmt.executeQuery(query);
            }
            catch (Exception e) {
                LOGGER.debug(".. query failed: " + query + ": " + e.getMessage());
                throw new Exception(SOSClassUtil.getMethodName() + ": " + e.getMessage());
            }
            if (rs.next()) {
                in = rs.getCharacterStream(1);
                if (in == null) {
                    LOGGER.debug(".. ResultSet returns NULL value.");
                    String e = "";
                    return e;
                }
                int bytesRead = in.read();
                if (bytesRead == -1) {
                    LOGGER.debug(".. CLOB column has 0 bytes.");
                    String e = "";
                    return e;
                }
                sb.append((char)bytesRead);
                while ((bytesRead = in.read()) != -1) {
                    sb.append((char)bytesRead);
                }
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
            return sb.toString();
        }
        catch (Exception e) {
            if (profiler == null) throw new Exception(SOSClassUtil.getMethodName() + ":" + e.getMessage(), e);
            try {
                profiler.stop("ERROR", e.getMessage());
                throw new Exception(SOSClassUtil.getMethodName() + ":" + e.getMessage(), e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(SOSClassUtil.getMethodName() + ":" + e.getMessage(), e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getClob(String query, String fileName) throws Exception {
        OutputStream out = null;
        ResultSet rs = null;
        Statement stmt = null;
        int bytesRead = 0;
        long readBytes = 0L;
        Reader in = null;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            query = this.normalizeStatement(query, this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            if (profiler != null) {
                profiler.start(query);
            }
            if ((rs = (stmt = this.connection.createStatement()).executeQuery(query)).next()) {
                in = rs.getCharacterStream(1);
                if (in == null) {
                    LOGGER.trace(".. ResultSet returns NULL value.");
                    long l = readBytes;
                    return l;
                }
                bytesRead = in.read();
                if (bytesRead == -1) {
                    LOGGER.trace(".. CLOB column has 0 bytes.");
                    long l = readBytes;
                    return l;
                }
                out = new FileOutputStream(fileName);
                ((FileOutputStream)out).write(bytesRead);
                ++readBytes;
                while ((bytesRead = in.read()) != -1) {
                    ((FileOutputStream)out).write(bytesRead);
                    ++readBytes;
                }
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
            return readBytes;
        }
        catch (Exception e) {
            if (profiler == null) throw new Exception(SOSClassUtil.getMethodName() + ":" + e.getMessage(), e);
            profiler.stop("ERROR", e.getMessage());
            throw new Exception(SOSClassUtil.getMethodName() + ":" + e.getMessage(), e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
            if (out != null) {
                try {
                    ((FileOutputStream)out).close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
    }

    public long updateClob(String tableName, String columnName, File file, String condition) throws Exception {
        Statement pstmt = null;
        StringBuilder query = null;
        long totalBytesWritten = 0L;
        String theQuery = null;
        Reader in = null;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            if (tableName == null) {
                throw new NullPointerException("tableName is null.");
            }
            if (columnName == null) {
                throw new NullPointerException("columnName is null.");
            }
            if (!file.exists()) {
                throw new Exception("file doesn't exist.");
            }
            query = new StringBuilder();
            query.append("UPDATE ");
            if (this.tableNameUpperCase) {
                query.append(tableName.toUpperCase()).append(" SET \"");
            } else {
                query.append(tableName).append(" SET ");
            }
            if (this.fieldNameUpperCase) {
                query.append(columnName.toUpperCase()).append("\" = ? ");
            } else {
                query.append(columnName).append(" = ? ");
            }
            if (condition != null) {
                query.append(" WHERE ").append(condition);
            }
            theQuery = this.normalizeStatement(query.toString(), this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + theQuery);
            if (profiler != null) {
                try {
                    profiler.start(theQuery);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            pstmt = this.connection.prepareStatement(theQuery);
            totalBytesWritten = file.length();
            in = new FileReader(file);
            pstmt.setCharacterStream(1, in, (int)totalBytesWritten);
            pstmt.executeUpdate();
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(SOSClassUtil.getMethodName() + ":" + e.getMessage(), e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return totalBytesWritten;
    }

    public long updateBlob(String tableName, String columnName, String fileName, String condition) throws Exception {
        Statement pstmt = null;
        long totalBytesRead = 0L;
        InputStream in = null;
        StringBuilder query = null;
        String theQuery = null;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            if (SOSString.isEmpty((String)tableName)) {
                throw new NullPointerException("tableName is null.");
            }
            if (SOSString.isEmpty((String)columnName)) {
                throw new NullPointerException("columnName is null.");
            }
            if (SOSString.isEmpty((String)fileName)) {
                throw new Exception("fileName is null.");
            }
            File file = new File(fileName);
            if (!file.exists()) {
                throw new Exception(SOSClassUtil.getMethodName() + ": file doesn't exist.");
            }
            in = new FileInputStream(file);
            query = new StringBuilder();
            query.append("UPDATE ");
            if (this.tableNameUpperCase) {
                query.append(tableName.toUpperCase());
            } else {
                query.append(tableName);
            }
            if (this.fieldNameUpperCase) {
                query.append(" SET \"").append(columnName.toUpperCase()).append("\" = ? ");
            } else {
                query.append(" SET ").append(columnName).append(" = ? ");
            }
            if (!SOSString.isEmpty((String)condition)) {
                query.append(" WHERE ").append(condition);
            }
            theQuery = this.normalizeStatement(query.toString(), this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + theQuery);
            if (profiler != null) {
                profiler.start(theQuery);
            }
            pstmt = this.connection.prepareStatement(theQuery);
            totalBytesRead = file.length();
            LOGGER.trace(".. length: " + totalBytesRead);
            pstmt.setBinaryStream(1, in, (int)totalBytesRead);
            pstmt.executeUpdate();
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.connection != null) {
                this.connection.rollback();
            }
            throw new Exception(SOSClassUtil.getMethodName() + ":" + e.getMessage(), e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
        return totalBytesRead;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getBlob(String query, String fileName) throws Exception {
        InputStream in = null;
        FileOutputStream out = null;
        ResultSet rs = null;
        Statement stmt = null;
        long readBytes = 0L;
        int len = 0;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. Maybe the connect method was not called.");
            }
            query = this.normalizeStatement(query, this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            if (profiler != null) {
                try {
                    profiler.start(query);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((rs = (stmt = this.connection.createStatement()).executeQuery(query)).next()) {
                in = rs.getBinaryStream(1);
                if (in == null) {
                    long l = readBytes;
                    return l;
                }
                byte[] buff = new byte[1024];
                len = in.read(buff);
                if (len <= 0) {
                    LOGGER.trace(".. BLOB column has 0 bytes.");
                    long l = readBytes;
                    return l;
                }
                out = new FileOutputStream(fileName);
                out.write(buff, 0, len);
                readBytes += (long)len;
                while (0 < (len = in.read(buff))) {
                    out.write(buff, 0, len);
                    readBytes += (long)len;
                }
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
            return readBytes;
        }
        catch (Exception e) {
            if (profiler == null) throw new Exception(SOSClassUtil.getMethodName() + ": " + e.getMessage(), e);
            try {
                profiler.stop("ERROR", e.getMessage());
                throw new Exception(SOSClassUtil.getMethodName() + ": " + e.getMessage(), e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.getMessage(), e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
    }

    public byte[] getBlob(String query) throws Exception {
        ResultSet rs = null;
        Statement stmt = null;
        byte[] result = new byte[]{};
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            query = this.normalizeStatement(query, this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            if (profiler != null) {
                try {
                    profiler.start(query);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((rs = (stmt = this.connection.createStatement()).executeQuery(query)).next()) {
                result = rs.getBytes(1);
            }
            if (result == null) {
                LOGGER.trace(".. BLOB column has 0 bytes.");
                byte[] byArray = result;
                return byArray;
            }
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        }
        catch (Exception e) {
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(SOSClassUtil.getMethodName() + ":" + e.getMessage(), e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public void executeQuery(String query) throws Exception {
        this.executeQuery(query, -1, -1, -1);
    }

    public void executeQuery(String query, int resultSetType, int resultSetConcurrency) throws Exception {
        this.executeQuery(query, resultSetType, resultSetConcurrency, -1);
    }

    public void executeQuery(String query, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws Exception {
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. Maybe the connect method was not called.");
            }
            query = this.normalizeStatement(query, this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            if (profiler != null) {
                try {
                    profiler.start(query);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.statement != null) {
                this.statement.close();
            }
            this.statement = resultSetType > 0 && resultSetConcurrency > 0 ? (resultSetHoldability > 0 ? this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability) : this.connection.createStatement(resultSetType, resultSetConcurrency)) : this.connection.createStatement();
            this.resultSet = this.statement.executeQuery(query);
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            if (this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(SOSClassUtil.getMethodName() + ":" + e.getMessage(), e);
        }
    }

    public void closeQuery() throws Exception {
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            if (this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ":" + e.getMessage(), e);
        }
    }

    public int executeUpdate(String query) throws Exception {
        int rowCount;
        block26: {
            rowCount = 0;
            Statement stmt = null;
            try {
                LOGGER.trace("calling " + SOSClassUtil.getMethodName());
                if (this.connection == null) {
                    throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
                }
                query = this.normalizeStatement(query, this.getReplacement());
                LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
                if (profiler != null) {
                    profiler.start(query);
                }
                stmt = this.connection.createStatement();
                rowCount = stmt.executeUpdate(query);
                LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
                try {
                    if (profiler == null) break block26;
                    try {
                        profiler.stop("", "");
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                try {
                    if (profiler != null) {
                        try {
                            profiler.stop("ERROR", e.getMessage());
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new Exception(SOSClassUtil.getMethodName() + ":" + e.getMessage(), e);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                try {
                    if (profiler != null) {
                        try {
                            profiler.stop("", "");
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {}
            }
        }
        return rowCount;
    }

    public void execute(String query) throws Exception {
        Statement stmt = null;
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            query = this.normalizeStatement(query, this.getReplacement());
            LOGGER.debug(SOSClassUtil.getMethodName() + ": " + query);
            if (profiler != null) {
                profiler.start(query);
            }
            stmt = this.connection.createStatement();
            stmt.execute(query);
            LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
            if (profiler != null) {
                try {
                    profiler.stop("", "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception(SOSClassUtil.getMethodName() + ":" + e.getMessage(), e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
    }

    public void commit() throws Exception {
        LOGGER.trace("calling " + SOSClassUtil.getMethodName());
        if (this.connection == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
        }
        this.connection.commit();
        LOGGER.debug(SOSClassUtil.getMethodName() + " successfully executed.");
    }

    public void rollback() throws Exception {
        LOGGER.trace("calling " + SOSClassUtil.getMethodName());
        if (this.connection == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
        }
        this.connection.rollback();
        LOGGER.debug(SOSClassUtil.getMethodName() + " successfully executed.");
    }

    public void setAutoCommit(boolean autoCommit) throws Exception {
        if (this.connection == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
        }
        this.connection.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws Exception {
        if (this.connection == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
        }
        return this.connection.getAutoCommit();
    }

    public Map<String, String> get() throws Exception {
        LinkedHashMap<String, String> record = new LinkedHashMap<String, String>();
        try {
            if (this.connection == null) {
                throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
            }
            if (profiler != null) {
                try {
                    profiler.start("");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.resultSet.next()) {
                ResultSetMetaData objMeta = this.resultSet.getMetaData();
                long lngNoOfRecordsToProcess = objMeta.getColumnCount();
                if (this.lngMaxNoOfRecordsToProcess > 0L) {
                    lngNoOfRecordsToProcess = this.lngMaxNoOfRecordsToProcess;
                }
                int i = 1;
                while ((long)i <= lngNoOfRecordsToProcess) {
                    String columnName = objMeta.getColumnName(i);
                    String columnValue = this.resultSet.getString(columnName);
                    if (SOSString.isEmpty((String)columnValue)) {
                        columnValue = "";
                    }
                    String strV = columnName;
                    if (!this.flgColumnNamesCaseSensitivity) {
                        strV = this.normalizeKey(columnName);
                    }
                    record.put(strV, columnValue.trim());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            if (profiler != null) {
                try {
                    profiler.stop("ERROR", e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
        if (profiler != null) {
            try {
                profiler.stop("", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return record;
    }

    public int fieldCount() throws Exception {
        if (this.connection == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
        }
        return this.resultSet.getMetaData().getColumnCount();
    }

    public String[] fieldNames() throws Exception {
        int fieldCount = this.fieldCount();
        Object[] fieldNames = new String[fieldCount];
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        if (this.connection == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
        }
        for (int i = 0; i < fieldCount; ++i) {
            fieldNames[i] = this.normalizeKey(this.resultSet.getMetaData().getColumnName(i + 1));
        }
        Arrays.sort(fieldNames);
        LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        return fieldNames;
    }

    public String fieldName(int index) throws Exception {
        if (this.connection == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
        }
        return this.resultSet.getMetaData().getColumnName(index);
    }

    public Map<String, String> fieldDesc(int index) throws Exception {
        HashMap<String, String> fieldDesc = new HashMap<String, String>();
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        if (this.connection == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": sorry, there is no successful connection established. may be the connect method was not called");
        }
        fieldDesc.put("columnDisplaySize", String.valueOf(this.resultSet.getMetaData().getColumnDisplaySize(index)));
        fieldDesc.put("columnLabel", this.resultSet.getMetaData().getColumnLabel(index));
        fieldDesc.put("columnName", this.resultSet.getMetaData().getColumnName(index));
        fieldDesc.put("columnType", String.valueOf(this.resultSet.getMetaData().getColumnType(index)));
        fieldDesc.put("columnTypeName", this.resultSet.getMetaData().getColumnTypeName(index));
        fieldDesc.put("precision", String.valueOf(this.resultSet.getMetaData().getPrecision(index)));
        fieldDesc.put("scale", String.valueOf(this.resultSet.getMetaData().getScale(index)));
        LOGGER.trace(SOSClassUtil.getMethodName() + " successfully executed.");
        return fieldDesc;
    }

    public String normalizeStatement(String inputString) throws Exception {
        return this.normalizeStatement(inputString, this.getReplacement());
    }

    public String normalizeStatement(String inputString, String[] replacement) throws Exception {
        LOGGER.trace("Calling " + SOSClassUtil.getMethodName());
        LOGGER.trace("..inputString=" + inputString);
        if (!inputString.matches("(?s).*(%lcase|%ucase|%now|%updlock|%cast|%timestamp).*")) {
            return inputString;
        }
        if (replacement.length < 4) {
            return inputString;
        }
        StringBuilder aPattern = new StringBuilder();
        aPattern.append("(%lcase|%ucase|%now|%updlock)|").append("(%timestamp\\('[0-9]{1,2}\\.[0-9]{1,2}\\.[0-9]{1,4}'\\))|").append("(%timestamp\\('[0-9]{1,2}\\.[0-9]{1,2}\\.[0-9]{1,4}[ \t]?[0-9]{2}:[0-9]{2}(?::[0-9]{2}\\.?[0-9]*)?'\\))|").append("(%timestamp_iso\\('[0-9]{1,4}[-]?[0-9]{1,2}[-]?[0-9]{1,2}'\\))|").append("(%timestamp_iso\\('[0-9]{1,4}[-]?[0-9]{1,2}[-]?[0-9]{1,2}[ \t]?[0-9]{2}:[0-9]{2}(?::[0-9]{2}\\.?[0-9]*)?'\\))");
        Pattern pattern = Pattern.compile(aPattern.toString());
        Matcher matcher = pattern.matcher(inputString);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String replaceString = matcher.group();
            if (matcher.group(1) != null) {
                replaceString = replaceString.replaceAll("%lcase", replacement[0]);
                replaceString = replaceString.replaceAll("%ucase", replacement[1]);
                replaceString = replaceString.replaceAll("%now", replacement[2]);
                replaceString = replaceString.replaceAll("%updlock", replacement[3]);
            }
            if (matcher.group(2) != null || matcher.group(3) != null) {
                replaceString = this.toDate(this.toTimestamp(replaceString, NLS_DE));
            }
            if (matcher.group(4) != null || matcher.group(5) != null) {
                replaceString = this.toDate(this.toTimestamp(replaceString, NLS_ISO));
            }
            matcher.appendReplacement(buffer, replaceString);
        }
        matcher.appendTail(buffer);
        LOGGER.trace(SOSClassUtil.getMethodName() + ", result [" + buffer.toString() + "]");
        if (inputString.matches("(.*%cast.*)")) {
            return this.replaceCasts(buffer.toString());
        }
        return buffer.toString();
    }

    public abstract void connect() throws Exception;

    public abstract String toDate(String var1) throws Exception;

    public String getLastSequenceValue(String sequence) throws Exception {
        return this.getSingleValue(this.getLastSequenceQuery(sequence));
    }

    protected abstract String getLastSequenceQuery(String var1);

    public void disconnect() throws Exception {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        if (this.connection != null) {
            this.connection.rollback();
            this.connection.close();
            this.connection = null;
            try {
                LOGGER.debug(SOSClassUtil.getMethodName() + ": successfully disconnected.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toTimestamp(String dateString, String nlsFormat) throws Exception {
        String datePatternSeparator;
        String[] datePart = null;
        String[] timePart = new String[]{"00", "00", "00"};
        String[] timePart2 = new String[]{};
        StringBuilder result = new StringBuilder();
        String year = "";
        String month = "";
        String day = "";
        if (nlsFormat.equalsIgnoreCase(NLS_DE)) {
            datePatternSeparator = "[.]";
        } else if (nlsFormat.equalsIgnoreCase(NLS_ISO)) {
            datePatternSeparator = "[-]";
        } else {
            throw new Exception("invalid nlsFormat.");
        }
        dateString = dateString.substring(dateString.indexOf(39) + 1, dateString.lastIndexOf(39));
        Pattern p = Pattern.compile("[ ]");
        String[] dateTime = p.split(dateString);
        p = Pattern.compile(datePatternSeparator);
        datePart = p.split(dateTime[0]);
        if (dateTime.length > 1) {
            p = Pattern.compile("[:]");
            timePart2 = p.split(dateTime[1]);
        }
        for (int i = 0; i < timePart2.length; ++i) {
            timePart[i] = timePart2[i];
        }
        if (nlsFormat.equalsIgnoreCase(NLS_DE)) {
            year = datePart[2];
            month = datePart[1];
            day = datePart[0];
        } else if (nlsFormat.equalsIgnoreCase(NLS_ISO)) {
            year = datePart[0];
            month = datePart[1];
            day = datePart[2];
        }
        switch (year.length()) {
            case 1: {
                year = "200" + year;
                break;
            }
            case 2: {
                year = "20" + year;
                break;
            }
            case 3: {
                year = "2" + year;
            }
        }
        result.append(year).append("-").append(month).append("-").append(day);
        result.append(" ").append(timePart[0]).append(":").append(timePart[1]).append(":").append(timePart[2]);
        return result.toString();
    }

    protected String normalizeKey(String key) throws Exception {
        if (SOSString.isEmpty((String)key)) {
            throw new Exception(this.getClass() + ":" + SOSClassUtil.getMethodName() + ": invalid key.");
        }
        if (this.lowerCase) {
            return key.toLowerCase();
        }
        return key.toUpperCase();
    }

    public void setKeysToLowerCase() throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        LOGGER.trace(".. now keys set to lower case.");
        this.lowerCase = true;
    }

    public void setKeysToUpperCase() throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        LOGGER.trace(".. now keys set to upper case.");
        this.lowerCase = false;
    }

    protected abstract boolean prepareGetStatements(StringBuffer var1, StringBuffer var2, StringBuffer var3) throws Exception;

    public ArrayList<String> getStatements(String contentOfClobAttribute) throws Exception {
        String[] commands;
        if (contentOfClobAttribute == null || contentOfClobAttribute.isEmpty()) {
            throw new Exception(SOSClassUtil.getMethodName() + ": contentOfClobAttribute is empty");
        }
        LOGGER.debug(SOSClassUtil.getMethodName() + ": contentOfClobAttribute = " + contentOfClobAttribute);
        contentOfClobAttribute = contentOfClobAttribute.replaceAll("\r\n", "\n");
        ArrayList<String> statements = new ArrayList<String>();
        StringBuffer splitSB = new StringBuffer();
        StringBuffer endSB = new StringBuffer();
        StringBuffer contentSB = new StringBuffer(contentOfClobAttribute);
        boolean enableProcedureSearch = true;
        boolean alwaysAddEndSB = this.prepareGetStatements(contentSB, splitSB, endSB);
        contentOfClobAttribute = this.stripOuterComments(contentSB.toString());
        for (String command : commands = contentOfClobAttribute.replaceAll("\\;[ \\t]", ";").split(splitSB.toString())) {
            String s;
            if (command == null || command.trim().isEmpty()) continue;
            String statement = command.trim();
            if (enableProcedureSearch) {
                if (this.endsWithEnd(statement)) {
                    if (this.isProcedureSyntax(statement)) {
                        statements.add(statement + endSB.toString());
                        LOGGER.debug(SOSClassUtil.getMethodName() + " : statement =" + statement + endSB.toString());
                        continue;
                    }
                    s = statement.replaceAll(REPLACE_BACKSLASH, REPLACEMENT_BACKSLASH);
                    s = s.replaceAll(REPLACE_DOUBLE_APOSTROPHE, REPLACEMENT_DOUBLE_APOSTROPHE);
                    this.splitStatements(statements, new StringBuffer(s.trim()), null, endSB.toString(), true, 0);
                    if ("".equals(this.beginProcedure)) continue;
                    int posPLSQL = statement.indexOf(this.beginProcedure);
                    String substatement = statement.substring(posPLSQL);
                    statements.add(substatement + endSB.toString());
                    LOGGER.debug(SOSClassUtil.getMethodName() + " : statement =" + substatement + endSB.toString());
                    continue;
                }
                s = statement.replaceAll(REPLACE_BACKSLASH, REPLACEMENT_BACKSLASH);
                s = s.replaceAll(REPLACE_DOUBLE_APOSTROPHE, REPLACEMENT_DOUBLE_APOSTROPHE);
                String end = alwaysAddEndSB ? endSB.toString() : "";
                this.splitStatements(statements, new StringBuffer(s.trim()), null, end, false, 0);
                continue;
            }
            s = statement.replaceAll(REPLACE_BACKSLASH, REPLACEMENT_BACKSLASH);
            s = s.replaceAll(REPLACE_DOUBLE_APOSTROPHE, REPLACEMENT_DOUBLE_APOSTROPHE);
            this.splitStatements(statements, new StringBuffer(s.trim()), null, endSB.toString(), false, 0);
        }
        return statements;
    }

    private boolean endsWithEnd(String statement) {
        String patterns = "end[\\s]*[\\S]*[;]*$";
        Pattern p = Pattern.compile(patterns, 2);
        Matcher matcher = p.matcher(statement);
        return matcher.find();
    }

    private void splitStatements(List<String> statements, StringBuffer st, Integer position, String procedurEnd, boolean returnProcedureBegin, int count) throws Exception {
        this.beginProcedure = "";
        ++count;
        int semicolon = -1;
        int apostropheFirst = -1;
        if (position == null) {
            semicolon = st.indexOf(";");
            apostropheFirst = st.indexOf("'");
        } else {
            semicolon = st.indexOf(";", position);
            apostropheFirst = st.indexOf("'", position);
        }
        if (apostropheFirst > semicolon || apostropheFirst == -1) {
            StringBuffer sub;
            String value = "";
            value = semicolon == -1 ? st.toString().trim() : st.toString().substring(0, semicolon).trim();
            value = value.replaceAll(REPLACEMENT_BACKSLASH, REPLACE_BACKSLASH);
            if (this.isProcedureSyntax(value = value.replaceAll(REPLACEMENT_DOUBLE_APOSTROPHE, REPLACE_DOUBLE_APOSTROPHE))) {
                if (returnProcedureBegin) {
                    this.beginProcedure = value;
                    return;
                }
                if (!"".equals(procedurEnd)) {
                    value = value + procedurEnd;
                }
            }
            if (!"".equals(value)) {
                statements.add(value);
                LOGGER.debug(SOSClassUtil.getMethodName() + ": statement = " + value);
            }
            if (semicolon != -1 && (sub = new StringBuffer(st.substring(semicolon + 1))) != null && sub.length() != 0) {
                this.splitStatements(statements, sub, null, procedurEnd, returnProcedureBegin, count);
            }
        } else {
            int apostropheSecond = st.indexOf("'", apostropheFirst + 1);
            if (apostropheSecond != -1) {
                this.splitStatements(statements, st, new Integer(apostropheSecond + 1), procedurEnd, returnProcedureBegin, count);
            } else {
                throw new Exception("Schliessende Hochkomma nicht gefunden !!!!!!!!!!!!!!!! = " + apostropheFirst + " = " + st);
            }
        }
    }

    private boolean isProcedureSyntax(String statement) throws Exception {
        if (statement == null) {
            throw new Exception("statement is empty");
        }
        if ((statement = statement.toLowerCase().trim()).startsWith("procedure") || statement.startsWith("function") || statement.startsWith("declare") || statement.startsWith("begin")) {
            return true;
        }
        StringBuilder patterns = new StringBuilder();
        patterns.append("^(re)?create+[\\s]*procedure");
        patterns.append("|^create+[\\s]*function");
        patterns.append("|^create+[\\s]*operator");
        patterns.append("|^create+[\\s]*package");
        patterns.append("|^create+[\\s]*trigger");
        patterns.append("|^drop+[\\s]*function");
        patterns.append("|^drop+[\\s]*operator");
        patterns.append("|^drop+[\\s]*package");
        patterns.append("|^drop+[\\s]*procedure");
        patterns.append("|^drop+[\\s]*trigger");
        patterns.append("|^create+[\\s]*or+[\\s]*replace+[\\s]*procedure");
        patterns.append("|^create+[\\s]*or+[\\s]*replace+[\\s]*function");
        patterns.append("|^create+[\\s]*or+[\\s]*replace+[\\s]*package");
        patterns.append("|^create+[\\s]*or+[\\s]*replace+[\\s]*operator");
        patterns.append("|^create+[\\s]*or+[\\s]*replace+[\\s]*trigger");
        Pattern p = Pattern.compile(patterns.toString());
        Matcher matcher = p.matcher(statement);
        return matcher.find();
    }

    private String stripOuterComments(String statement) throws Exception {
        if (statement == null) {
            throw new Exception("statement is empty");
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(statement, "\n");
        boolean addRow = true;
        boolean isVersionComment = false;
        boolean isMySQL = this instanceof SOSMySQLConnection;
        while (st.hasMoreTokens()) {
            String row = st.nextToken().trim();
            if (row == null || row.isEmpty() || row.startsWith("--") || row.startsWith("//") || row.startsWith("#") || (row = row.replaceAll("^[/][*](?s).*?[*][/][\\s]*;*", "")).isEmpty()) continue;
            if (isMySQL) {
                String rowUpper = row.toUpperCase();
                if (rowUpper.startsWith("DELIMITER")) continue;
                if (rowUpper.startsWith("END$$;")) {
                    row = "END;";
                }
            }
            if (row.startsWith("/*!")) {
                block17: {
                    String[] contentArr = row.substring(3).trim().split(" ");
                    if (contentArr[0].length() == 5 || contentArr[0].length() == 6) {
                        String version = contentArr[0].length() == 5 ? "0" + contentArr[0] : contentArr[0];
                        try {
                            int major = Integer.parseInt(version.substring(0, 2));
                            if (this.getMajorVersion() >= major) {
                                LOGGER.trace("using sql comment : db major version = " + this.getMajorVersion() + " comment major version = " + major + " ");
                                int minor = Integer.parseInt(version.substring(2, 4));
                                if (this.getMinorVersion() >= minor) {
                                    isVersionComment = true;
                                    LOGGER.trace("using sql comment : db minor version = " + this.getMinorVersion() + " comment minor version = " + minor + " ");
                                } else {
                                    LOGGER.trace("skip sql comment : db minor version = " + this.getMinorVersion() + " comment minor version = " + minor + " ");
                                }
                                break block17;
                            }
                            LOGGER.trace("skip sql comment : db major version = " + this.getMajorVersion() + " comment major version = " + major + " ");
                        }
                        catch (Exception e) {
                            LOGGER.warn("skip sql comment : no numerical major/minor version in comment = " + version + " database major version = " + this.getMajorVersion() + " minor version = " + this.getMinorVersion());
                        }
                    } else {
                        LOGGER.warn("skip sql comment : invalid comment major version length = " + contentArr[0] + " db major version = " + this.getMajorVersion());
                    }
                }
                if (isVersionComment) continue;
                addRow = false;
                continue;
            }
            if (row.startsWith("/*")) {
                addRow = false;
                continue;
            }
            if (row.endsWith("*/") || row.endsWith("*/;")) {
                if (isVersionComment) {
                    if (!addRow) {
                        addRow = true;
                        continue;
                    }
                    isVersionComment = false;
                    continue;
                }
                if (!addRow) {
                    addRow = true;
                    continue;
                }
            }
            if (!addRow) continue;
            sb.append(row + "\n");
        }
        return sb.toString();
    }

    public void setMaxNoOfRecordsToProcess(long plngMaxNoOfRecordsToProcess) {
        this.lngMaxNoOfRecordsToProcess = plngMaxNoOfRecordsToProcess;
    }

    public void setColumnNamesCaseSensitivity(boolean pflgColumnNamesCaseSensitivity) {
        this.flgColumnNamesCaseSensitivity = pflgColumnNamesCaseSensitivity;
    }

    public void executeBatch(ArrayList<String> statements) throws Exception {
        String methodName = SOSClassUtil.getMethodName();
        Statement st = this.connection.createStatement();
        try {
            long count = 0L;
            long countAddBatches = 0L;
            for (int i = 0; i < statements.size(); ++i) {
                String sql = this.normalizeStatement(statements.get(i).toString().trim());
                String sqlToLower = sql.toLowerCase();
                if ("commit".equals(sqlToLower)) {
                    if (countAddBatches > 0L) {
                        LOGGER.debug(String.format("%s: call executeBatch - %s batches", methodName, countAddBatches));
                        st.executeBatch();
                        countAddBatches = 0L;
                    }
                    LOGGER.debug(String.format("%s: call connection commit", methodName));
                    this.connection.commit();
                    continue;
                }
                if ("rollback".equals(sqlToLower)) {
                    if (countAddBatches > 0L) {
                        LOGGER.debug(String.format("%s: call executeBatch - %s batches", methodName, countAddBatches));
                        st.executeBatch();
                        countAddBatches = 0L;
                    }
                    this.executeUpdate("ROLLBACK");
                    continue;
                }
                if (sqlToLower.startsWith("select") || sqlToLower.startsWith("exec") && (this.execReturnsResultSet || sqlToLower.contains(EXEC_COMMENT_RETURN_RESULTSET.toLowerCase()))) {
                    if (countAddBatches > 0L) {
                        LOGGER.debug(String.format("%s: call executeBatch - %s batches", methodName, countAddBatches));
                        st.executeBatch();
                        countAddBatches = 0L;
                    }
                    try {
                        LOGGER.debug(String.format("%s: call executeQuery - %s", methodName, sql));
                        this.statement = st;
                        if (this.resultSet != null) {
                            this.resultSet.close();
                        }
                        this.resultSet = st.executeQuery(sql);
                        continue;
                    }
                    catch (Exception ex) {
                        try {
                            if (this.resultSet != null) {
                                this.resultSet.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (this.statement != null) {
                                this.statement.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw ex;
                    }
                }
                LOGGER.debug(String.format("%s: call addBatch - %s", methodName, sql));
                st.addBatch(sql);
                ++countAddBatches;
                if (++count % (long)this.batchSize != 0L) continue;
                LOGGER.debug(String.format("%s: call executeBatch - %s batches", methodName, countAddBatches));
                st.executeBatch();
                countAddBatches = 0L;
            }
            if (countAddBatches > 0L) {
                LOGGER.debug(String.format("%s: call executeBatch - %s batches", methodName, countAddBatches));
                st.executeBatch();
            }
        }
        catch (Exception ex) {
            if (!this.getAutoCommit() && this instanceof SOSPgSQLConnection) {
                try {
                    this.executeUpdate("ROLLBACK");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ex instanceof SQLException) {
                SQLException sex = (SQLException)ex;
                if (sex.getNextException() == null) {
                    throw ex;
                }
                throw sex.getNextException();
            }
            throw ex;
        }
        finally {
            try {
                st.close();
            }
            catch (Exception exception) {}
        }
    }

    public void executeStatements(String contentOfClobAttribute) throws Exception {
        String methodName = SOSClassUtil.getMethodName();
        ArrayList<String> statements = null;
        boolean executeBatch = this.getUseExecuteBatch();
        boolean supportsBatchUpdates = false;
        try {
            supportsBatchUpdates = this.connection.getMetaData().supportsBatchUpdates();
        }
        catch (Exception ex) {
            LOGGER.warn(String.format("%s: %s", methodName, ex.getMessage()));
        }
        if (executeBatch) {
            executeBatch = supportsBatchUpdates;
        }
        LOGGER.info(String.format("%s: executeBatch = %s (supportsBatchUpdates = %s, useExecuteBatch = %s, batchSize = %s)", methodName, executeBatch, supportsBatchUpdates, this.getUseExecuteBatch(), this.batchSize));
        try {
            statements = this.getStatements(contentOfClobAttribute);
            if (statements == null || statements.isEmpty()) {
                LOGGER.info("no sql statements found");
            } else if (executeBatch) {
                this.executeBatch(statements);
            } else {
                boolean hasOpenResultSet = false;
                for (int i = 0; i < statements.size(); ++i) {
                    String statement = statements.get(i).toString().trim();
                    String sqlToLower = statement.toLowerCase();
                    if (sqlToLower.startsWith("select") || sqlToLower.startsWith("exec") && (this.execReturnsResultSet || sqlToLower.contains(EXEC_COMMENT_RETURN_RESULTSET.toLowerCase()))) {
                        if (hasOpenResultSet) {
                            this.closeQuery();
                            hasOpenResultSet = false;
                        }
                        this.executeQuery(statement);
                        hasOpenResultSet = true;
                        continue;
                    }
                    this.executeUpdate(statement);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + " : " + e.getMessage(), e);
        }
    }

    public void setProfiler(SOSProfiler _profiler) {
        profiler = _profiler;
    }

    public void setFieldNameToUpperCase(boolean value) {
        this.fieldNameUpperCase = value;
    }

    public void setTableNameToUpperCase(boolean value) {
        this.tableNameUpperCase = value;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public String getUrl() {
        return this.url;
    }

    public GregorianCalendar getTimestamp() throws Exception {
        return this.getDateTime("yyyy-MM-dd HH:mm:ss");
    }

    public GregorianCalendar getDate() throws Exception {
        return this.getDateTime("yyyy-MM-dd");
    }

    protected GregorianCalendar getDateTime(String format) throws Exception {
        return new GregorianCalendar();
    }

    protected abstract String replaceCasts(String var1) throws Exception;

    public int parseMajorVersion(String productVersion) throws Exception {
        String dbVersion = productVersion.replaceAll("[^0-9\\.]", "");
        String[] split = dbVersion.split("\\.");
        if (split.length < 2) {
            throw new Exception("Failed to parse major Version from String \"" + productVersion + "\"");
        }
        return Integer.parseInt(split[0]);
    }

    public int parseMinorVersion(String productVersion) throws Exception {
        String dbVersion = productVersion.replaceAll("[^0-9\\.]", "");
        String[] split = dbVersion.split("\\.");
        if (split.length < 2) {
            throw new Exception("Failed to parse minor Version from String \"" + productVersion + "\"");
        }
        return Integer.parseInt(split[1]);
    }

    public int getCompatibility() {
        return this.compatibility;
    }

    public void setCompatibility(int compatibility) {
        this.compatibility = compatibility;
    }

    public void setUseExecuteBatch(boolean executeBatch) {
        this.useExecuteBatch = executeBatch;
    }

    public boolean getUseExecuteBatch() {
        return this.useExecuteBatch;
    }

    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public static int getCompatibility(String compatibility) {
        if ("normal".equalsIgnoreCase(compatibility)) {
            return 1;
        }
        if ("strict".equalsIgnoreCase(compatibility)) {
            return 2;
        }
        if ("off".equalsIgnoreCase(compatibility)) {
            return 0;
        }
        return 0;
    }

    private static Class getClass(String name) throws Exception {
        if (name.indexOf(46) == -1) {
            name = "sos.connection." + name;
        }
        return Class.forName(name);
    }

    private static SOSConnection createInstance(String className, Object[] arguments) throws Exception {
        try {
            Class connectionClass = SOSConnection.getClass(className);
            Class[] parameterTypes = new Class[arguments.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypes[i] = arguments[i] instanceof Connection ? Connection.class : arguments[i].getClass();
            }
            Constructor connectionConstructor = connectionClass.getConstructor(parameterTypes);
            return (SOSConnection)connectionConstructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new Exception("Error occured creating connection object for class " + className + ": " + e.getMessage(), e);
        }
    }

    public abstract String[] getReplacement();

    public abstract void prepare(Connection var1) throws Exception;

    public int getMajorVersion() {
        return this.majorVersion;
    }

    protected void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    protected void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    protected void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public boolean isExecReturnsResultSet() {
        return this.execReturnsResultSet;
    }

    public void setExecReturnsResultSet(boolean execReturnsResultSet) {
        this.execReturnsResultSet = execReturnsResultSet;
    }
}

