/*
 * Decompiled with CFR 0.152.
 */
package sos.connection;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.Statement;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;
import sos.connection.SOSConnectionVersionLimiter;
import sos.util.SOSClassUtil;
import sos.util.SOSDate;
import sos.util.SOSString;

public class SOSMSSQLConnection
extends SOSConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSMSSQLConnection.class);
    private static final String[] REPLACEMENT = new String[]{"LOWER", "UPPER", "GETDATE()", "WITH (UPDLOCK)"};
    private static final SOSConnectionVersionLimiter VERSION_LIMITER = new SOSConnectionVersionLimiter();
    private int lockTimeout = 3000;

    public SOSMSSQLConnection(Connection connection) throws Exception {
        super(connection);
    }

    public SOSMSSQLConnection(String configFileName) throws Exception {
        super(configFileName);
        String sLockTimeout = this.configFileProperties.getProperty("lock_timeout");
        if (!SOSString.isEmpty((String)sLockTimeout)) {
            try {
                this.setLockTimeout(Integer.parseInt(sLockTimeout));
            }
            catch (Exception e) {
                throw new Exception("Bad value for lock_timeout: " + e.getMessage(), e);
            }
        }
    }

    public SOSMSSQLConnection(String driver, String url, String dbuser, String dbpassword) throws Exception {
        super(driver, url, dbuser, dbpassword);
    }

    public SOSMSSQLConnection(String driver, String url, String dbname, String dbuser, String dbpassword) throws Exception {
        super(driver, url, dbuser, dbpassword);
        if (dbname == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database name.");
        }
        this.dbname = dbname;
    }

    @Override
    public void connect() throws Exception {
        Properties properties = new Properties();
        if (SOSString.isEmpty((String)this.url)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database url.");
        }
        if (SOSString.isEmpty((String)this.driver)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing database driver.");
        }
        if (!SOSString.isEmpty((String)this.dbname)) {
            properties.setProperty("databasename", this.dbname);
        }
        if (this.dbuser != null && !this.dbuser.isEmpty() && !"[SSO]".equalsIgnoreCase(this.dbuser)) {
            properties.setProperty("user", this.dbuser);
            properties.setProperty("password", this.dbpassword);
        }
        properties.setProperty("selectMethod", "cursor");
        try {
            LOGGER.trace("calling " + SOSClassUtil.getMethodName());
            Driver driver = (Driver)Class.forName(this.driver).newInstance();
            this.connection = driver.connect(this.url, properties);
            if (this.connection == null) {
                throw new Exception("can't connect to database");
            }
            VERSION_LIMITER.check(this);
            LOGGER.debug(".. successfully connected to " + this.url);
            this.prepare(this.connection);
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString(), e);
        }
    }

    @Override
    public void prepare(Connection connection) throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        Statement stmt = null;
        String isoDateFormat = "set DATEFORMAT ymd";
        String defaultLanguage = "set LANGUAGE British";
        String lockTimeout = "set LOCK_TIMEOUT " + this.getLockTimeout();
        try {
            if (connection == null) {
                throw new Exception("can't connect to database");
            }
            connection.setTransactionIsolation(2);
            connection.setAutoCommit(false);
            stmt = connection.createStatement();
            stmt.execute(isoDateFormat + ";" + defaultLanguage + ";" + lockTimeout);
            LOGGER.trace(".. " + defaultLanguage + " successfully set.");
            LOGGER.trace(".. " + isoDateFormat + " successfully set.");
            LOGGER.trace(".. " + lockTimeout + " successfully set.");
            connection.rollback();
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString(), e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public String toDate(String dateString) throws Exception {
        if (SOSString.isEmpty((String)dateString)) {
            throw new Exception(SOSClassUtil.getMethodName() + ": dateString has no value.");
        }
        return "{ ts '" + dateString + "'}";
    }

    @Override
    protected GregorianCalendar getDateTime(String format) throws Exception {
        GregorianCalendar gc = new GregorianCalendar();
        String timestamp = this.getSingleValue("select CURRENT_TIMESTAMP");
        if (timestamp.length() > 19) {
            timestamp = timestamp.substring(0, 19);
        }
        Date date = SOSDate.getDate((String)timestamp, (String)format);
        gc.setTime(date);
        return gc;
    }

    @Override
    protected String replaceCasts(String inputString) throws Exception {
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        Pattern pattern = Pattern.compile("(\\s*%cast\\s*)*\\s*(\\()*\\s*(\\s*%cast\\s*)+\\s*(\\(\\s*\\S+\\s*(\\S+?).*?)\\)(\\s*(\\+|\\-)*[0-9]*\\s*\\S*(\\)))*");
        Matcher matcher = pattern.matcher(inputString);
        StringBuffer buffer = new StringBuffer();
        LOGGER.trace("..inputString [" + inputString + "]");
        while (matcher.find()) {
            String token;
            String replaceString = matcher.group().toLowerCase();
            if (matcher.group(1) != null && matcher.group(6) != null) {
                token = matcher.group(6).replaceFirst("\\)", "").trim();
                if (token.matches(".*varchar.*")) {
                    replaceString = replaceString.replaceAll("varchar", " as varchar");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                } else if (token.matches(".*character.*")) {
                    replaceString = replaceString.replaceAll("character", " as character");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                } else if (token.matches(".*integer.*")) {
                    replaceString = replaceString.replaceAll("integer", " as integer");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                } else if (token.matches(".*timestamp.*")) {
                    replaceString = replaceString.replaceAll("timestamp", " as datetime");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                } else if (token.matches(".*datetime.*")) {
                    replaceString = replaceString.replaceAll("datetime", " as datetime");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                }
            }
            if (matcher.group(3) != null && matcher.group(4) != null) {
                token = matcher.group(4).replaceFirst("\\(", "").trim();
                if (token.matches(".*varchar.*")) {
                    replaceString = replaceString.replaceAll("varchar", " as varchar");
                    replaceString = replaceString.replaceAll("%cast", "cast");
                } else if (token.matches(".*character.*")) {
                    replaceString = replaceString.replaceAll("character", " as character");
                    replaceString = replaceString.replaceAll("%cast", "cast");
                } else if (token.matches(".*integer.*")) {
                    replaceString = replaceString.replaceAll("integer", " as integer");
                    replaceString = replaceString.replaceAll("%cast", "cast");
                } else if (token.matches(".*timestamp.*")) {
                    replaceString = replaceString.replaceAll("timestamp", " as datetime");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                } else if (token.matches(".*datetime.*")) {
                    replaceString = replaceString.replaceAll("datetime", " as datetime");
                    replaceString = replaceString.replaceFirst("%cast", "cast");
                }
            }
            replaceString = replaceString.toUpperCase();
            matcher.appendReplacement(buffer, replaceString);
        }
        matcher.appendTail(buffer);
        LOGGER.debug(".. result [" + buffer.toString() + "]");
        return buffer.toString();
    }

    @Override
    protected String getLastSequenceQuery(String sequence) {
        return "SELECT @@IDENTITY";
    }

    @Override
    public int parseMajorVersion(String productVersion) throws Exception {
        Pattern pattern = Pattern.compile("[0-9]*\\.[0-9]*\\.[0-9]*");
        Matcher matcher = pattern.matcher(productVersion);
        if (matcher.find()) {
            return super.parseMajorVersion(matcher.group());
        }
        throw new Exception("Failed to parse major Version from String \"" + productVersion + "\"");
    }

    @Override
    public int parseMinorVersion(String productVersion) throws Exception {
        Pattern pattern = Pattern.compile("[0-9]*\\.[0-9]*\\.[0-9]*");
        Matcher matcher = pattern.matcher(productVersion);
        if (matcher.find()) {
            return super.parseMinorVersion(matcher.group());
        }
        throw new Exception("Failed to parse minor Version from String \"" + productVersion + "\"");
    }

    @Override
    protected boolean prepareGetStatements(StringBuffer contentSB, StringBuffer splitSB, StringBuffer endSB) throws Exception {
        if (contentSB == null) {
            throw new Exception("contentSB is null");
        }
        if (splitSB == null) {
            throw new Exception("splitSB is null");
        }
        if (endSB == null) {
            throw new Exception("endSB is null");
        }
        splitSB.append("(?i)\nGO\\s*\n|\n/\n");
        endSB.append("");
        return true;
    }

    @Override
    public String[] getReplacement() {
        return REPLACEMENT;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    static {
        VERSION_LIMITER.setMinSupportedVersion(8, 0);
        VERSION_LIMITER.setMaxSupportedVersion(9, 0);
    }
}

