/*
 * Decompiled with CFR 0.152.
 */
package sos.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.settings.SOSSettings;
import sos.util.SOSClassUtil;
import sos.util.SOSString;

public class SOSProfileSettings
extends SOSSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSProfileSettings.class);
    private static final Pattern SECTION_PATTERN = Pattern.compile("^\\s*\\[([^\\]]*)\\].*$");
    private static final Pattern ENTRY_PATTERN = Pattern.compile("^([^=#;]+)[ \t\n]*=(.*)$");
    private final ArrayList<String> sections = new ArrayList();
    private final Properties entries = new Properties();
    protected boolean lowerCase = true;

    public SOSProfileSettings(String source) throws Exception {
        super(source);
        this.load();
    }

    public SOSProfileSettings(String source, String section) throws Exception {
        super(source, section);
        this.load();
    }

    private void load() throws Exception {
        String sectionName = null;
        BufferedReader in = null;
        String key = null;
        String value = null;
        String line = null;
        try {
            File file = new File(this.source);
            if (!file.exists()) {
                throw new Exception("couldn't find settings-file [" + file.getAbsolutePath() + "].");
            }
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            while ((line = in.readLine()) != null) {
                Matcher matcher = SECTION_PATTERN.matcher(line = line.replaceAll("\\r", ""));
                if (matcher.matches()) {
                    sectionName = matcher.group(1);
                    this.sections.add(sectionName);
                    continue;
                }
                matcher = ENTRY_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                key = matcher.group(1).trim();
                value = matcher.group(2).trim();
                this.entries.put(sectionName + "#" + key, value);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(SOSClassUtil.getMethodName() + ": profile [" + this.source + "] successfully loaded.");
            }
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getSectionEntry(String section, String entry) throws Exception {
        try {
            String value = this.entries.getProperty(section + "#" + entry);
            return value;
        }
        catch (Exception e) {
            throw new Exception("error occurred in " + SOSClassUtil.getMethodName() + ": " + e);
        }
    }

    @Override
    public String getSectionEntry(String entry) throws Exception {
        try {
            return this.getSectionEntry(this.section, entry);
        }
        catch (Exception e) {
            throw new Exception("error occurred in " + SOSClassUtil.getMethodName() + ": " + e);
        }
    }

    @Override
    public Properties getSection(String section) throws Exception {
        try {
            Properties properties = new Properties();
            Pattern p = Pattern.compile("[#]");
            String[] keyValue = null;
            Enumeration<Object> enuma = this.entries.keys();
            while (enuma.hasMoreElements()) {
                keyValue = p.split(enuma.nextElement().toString());
                if (this.getSectionEntry(section, keyValue[1]) == null) continue;
                properties.put(this.normalizeKey(keyValue[1]), this.getSectionEntry(section, keyValue[1]));
            }
            return properties;
        }
        catch (Exception e) {
            throw new Exception("error occurred in " + SOSClassUtil.getMethodName() + ": " + e);
        }
    }

    public Properties getSection(String section, boolean usePrefix, String propertyPrefix) throws Exception {
        try {
            Properties properties = new Properties();
            Pattern p = Pattern.compile("[#]");
            String[] keyValue = null;
            Enumeration<Object> enuma = this.entries.keys();
            while (enuma.hasMoreElements()) {
                keyValue = p.split(enuma.nextElement().toString());
                if (this.getSectionEntry(section, keyValue[1]) == null) continue;
                properties.put(this.normalizeKey(propertyPrefix + keyValue[1]), this.getSectionEntry(section, keyValue[1]));
            }
            return properties;
        }
        catch (Exception e) {
            throw new Exception("error occurred in " + SOSClassUtil.getMethodName() + ": " + e);
        }
    }

    @Override
    public Properties getSection() throws Exception {
        try {
            return this.getSection(this.section);
        }
        catch (Exception e) {
            throw new Exception("error occurred in " + SOSClassUtil.getMethodName() + ": " + e);
        }
    }

    @Override
    public Properties getSection(String application, String section) throws Exception {
        try {
            return this.getSection(this.section);
        }
        catch (Exception e) {
            throw new Exception("error occurred in " + SOSClassUtil.getMethodName() + ": " + e);
        }
    }

    public ArrayList<String> getSections() throws Exception {
        return this.sections;
    }

    public synchronized int getSequence(String section, String entry) throws Exception {
        String sectionName = null;
        String line = null;
        File inFile = null;
        File outFile = null;
        OutputStream out = null;
        BufferedReader in = null;
        int result = -1;
        try {
            inFile = new File(this.source);
            if (!inFile.exists()) {
                throw new Exception("couldn't find profile [" + this.source + "].");
            }
            outFile = new File(this.source + "~");
            out = new FileOutputStream(outFile);
            in = new BufferedReader(new InputStreamReader(new FileInputStream(this.source)));
            while ((line = in.readLine()) != null) {
                Matcher sectionMatcher = SECTION_PATTERN.matcher(line);
                Matcher entryMatcher = ENTRY_PATTERN.matcher(line);
                if (sectionMatcher.matches()) {
                    sectionName = sectionMatcher.group(1);
                    out.write(line.getBytes());
                } else if (entryMatcher.matches()) {
                    String name = entryMatcher.group(1).trim();
                    String value = entryMatcher.group(2).trim();
                    if (name.equals(entry) && sectionName.equals(section) && value.matches("[0-9]+")) {
                        result = Integer.valueOf(value.trim()) + 1;
                        out.write(new String(entry + "=" + result).getBytes());
                    } else {
                        out.write(line.getBytes());
                    }
                } else {
                    out.write(line.getBytes());
                }
                out.write(10);
                out.flush();
            }
        }
        catch (Exception e) {
            try {
                outFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString());
        }
        finally {
            if (outFile != null) {
                try {
                    outFile.renameTo(inFile);
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            this.load();
        }
        return result;
    }

    @Override
    public void setKeysToLowerCase() throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        LOGGER.debug(".. now keys set to lower case.");
        this.lowerCase = true;
    }

    @Override
    public void setKeysToUpperCase() throws Exception {
        LOGGER.debug("calling " + SOSClassUtil.getMethodName());
        LOGGER.debug(".. now keys set to upper case.");
        this.lowerCase = false;
    }

    protected String normalizeKey(String key) throws Exception {
        try {
            if (SOSString.isEmpty((String)key)) {
                throw new Exception(SOSClassUtil.getMethodName() + ": invalid key.");
            }
            if (this.getIgnoreCase()) {
                return key;
            }
            if (this.lowerCase) {
                return key.toLowerCase();
            }
            return key.toUpperCase();
        }
        catch (Exception e) {
            throw new Exception("error occurred in " + SOSClassUtil.getMethodName() + ": " + e);
        }
    }

    @Override
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }
}

