/*
 * Decompiled with CFR 0.152.
 */
package sos.settings.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSClassUtil;

public class SOSSettingsProfile2XMLConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSettingsProfile2XMLConverter.class);
    private String source = "";
    private String xmlEncoding = "ISO-8859-1";
    private String xmlStylesheet = "";
    private static final Pattern SECTION_PATTERN = Pattern.compile("^\\s*\\[([^\\]]*)\\].*$");
    private static final Pattern ENTRY_PATTERN = Pattern.compile("^([; a-z A-Z 0-9_]+)[ \t\n]*=(.*)$");
    private static final String INDENT = "  ";
    private String newLine = System.getProperty("line.separator");
    private Map<String, Map<String, String>> sections = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, List<String>> entryNotes = new LinkedHashMap<String, List<String>>();

    public SOSSettingsProfile2XMLConverter(String source) throws Exception {
        this.source = source;
        this.load();
    }

    private void load() throws Exception {
        String sectionName = null;
        BufferedReader in = null;
        String key = null;
        String value = null;
        String line = null;
        LinkedHashMap<String, String> entries = null;
        ArrayList<String> notes = null;
        try {
            File file = new File(this.source);
            if (!file.exists()) {
                throw new Exception("couldn't find source [" + this.source + "].");
            }
            in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            this.sections = new LinkedHashMap<String, Map<String, String>>();
            entries = new LinkedHashMap<String, String>();
            this.entryNotes = new LinkedHashMap<String, List<String>>();
            notes = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                Matcher matcher = SECTION_PATTERN.matcher(line);
                if (matcher.matches()) {
                    entries = new LinkedHashMap();
                    notes = new ArrayList();
                    sectionName = matcher.group(1);
                } else {
                    matcher = ENTRY_PATTERN.matcher(line);
                    if (matcher.matches()) {
                        key = matcher.group(1).trim();
                        value = matcher.group(2).trim();
                        entries.put(key, value);
                        if (!notes.isEmpty()) {
                            this.entryNotes.put(key, notes);
                            notes = new ArrayList();
                        }
                    } else if ((line = line.trim()).startsWith(";") && line.length() > 1) {
                        notes.add(line.substring(1).trim());
                    }
                }
                this.sections.put(sectionName, entries);
            }
            LOGGER.debug(SOSClassUtil.getMethodName() + ": profile [" + this.source + "] successfully loaded.");
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void process(String application, String xmlFilename) throws Exception {
        FileWriter f = new FileWriter(xmlFilename);
        f.write("<?xml version=\"1.0\" encoding=\"" + this.xmlEncoding + "\" ?>" + this.newLine);
        if (this.xmlStylesheet != null && !this.xmlStylesheet.isEmpty()) {
            f.write("<?xml-stylesheet type=\"text/xsl\" href=\"" + this.xmlStylesheet + "\" ?>" + this.newLine);
            f.write(this.newLine);
        }
        f.write("<settings>" + this.newLine);
        f.write(this.newLine);
        f.write("  <application name=\"" + application + "\">" + this.newLine);
        f.write(this.writeNote("de", "", "    "));
        f.write(this.writeNote("en", "", "    "));
        f.write(this.newLine);
        f.write("    <sections>" + this.newLine);
        for (Map.Entry<String, Map<String, String>> secMapEntry : this.sections.entrySet()) {
            String sectionName = secMapEntry.getKey();
            Map<String, String> entries = secMapEntry.getValue();
            f.write("      <section name=\"" + sectionName + "\">" + this.newLine);
            f.write(this.writeNote("de", "", "        "));
            f.write(this.writeNote("en", "", "        "));
            f.write(this.newLine);
            f.write("        <entries>" + this.newLine);
            for (Map.Entry<String, String> entMapEntry : entries.entrySet()) {
                String entryName = entMapEntry.getKey();
                String entryValue = entMapEntry.getValue();
                String disabled = "";
                String noteValue = "";
                if (entryName.startsWith(";")) {
                    entryName = entryName.substring(1);
                    disabled = "disabled=\"true\"";
                }
                f.write("          <entry name=\"" + entryName + "\" " + disabled + ">" + this.newLine);
                f.write("            <value>" + this.newLine);
                f.write("              " + this.writeCDATA(entryValue) + this.newLine);
                f.write("            </value>" + this.newLine);
                if (this.entryNotes != null && this.entryNotes.containsKey(entryName)) {
                    List<String> notes = this.entryNotes.get(entryName);
                    int notesSize = notes.size();
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < notesSize; ++i) {
                        String before = i > 0 ? "                      " : "";
                        String after = i == notesSize - 1 ? "" : this.newLine;
                        sb.append(before).append(notes.get(i)).append(after);
                    }
                    noteValue = sb.toString();
                }
                f.write(this.writeNote("de", noteValue, "            "));
                f.write(this.writeNote("en", noteValue, "            "));
                f.write("          </entry>" + this.newLine);
                f.write(this.newLine);
            }
            f.write("        </entries>" + this.newLine);
            f.write("      </section>" + this.newLine);
            f.write(this.newLine);
        }
        f.write("    </sections>" + this.newLine);
        f.write(this.newLine);
        f.write("  </application>" + this.newLine);
        f.write(this.newLine);
        f.write("</settings>");
        f.close();
    }

    private String writeNote(String language, String value, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("<note language=\"").append(language).append("\">").append(this.newLine).append(indent).append(INDENT).append("<div xmlns=\"http://www.w3.org/1999/xhtml\">").append(this.newLine).append(indent).append(INDENT).append(INDENT).append("<p>").append(this.newLine).append(indent).append(INDENT).append(INDENT).append(INDENT).append(this.writeCDATA(value)).append(this.newLine).append(indent).append(INDENT).append(INDENT).append("</p>").append(this.newLine).append(indent).append(INDENT).append("</div>").append(this.newLine).append(indent).append("</note>").append(this.newLine);
        return sb.toString();
    }

    private String writeCDATA(String val) {
        return "<![CDATA[" + val + "]]>";
    }

    public String getXMLEncoding() {
        return this.xmlEncoding;
    }

    public void setXMLEncoding(String encoding) {
        this.xmlEncoding = encoding;
    }

    public String getXmlStylesheet() {
        return this.xmlStylesheet;
    }

    public void setXmlStylesheet(String xmlStylesheet) {
        this.xmlStylesheet = xmlStylesheet;
    }
}

