/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.classes.calendar;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sos.exception.SOSInvalidDataException;
import com.sos.exception.SOSMissingDataException;
import com.sos.joc.model.calendar.Calendar;
import com.sos.joc.model.calendar.CalendarDatesFilter;
import com.sos.joc.model.calendar.Dates;
import com.sos.joc.model.calendar.Frequencies;
import com.sos.joc.model.calendar.Holidays;
import com.sos.joc.model.calendar.MonthDays;
import com.sos.joc.model.calendar.Months;
import com.sos.joc.model.calendar.Repetition;
import com.sos.joc.model.calendar.RepetitionText;
import com.sos.joc.model.calendar.WeekDays;
import com.sos.joc.model.calendar.WeeklyDay;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class FrequencyResolver {
    private static TimeZone UTC = TimeZone.getTimeZone("UTC");
    private SortedMap<String, java.util.Calendar> dates = new TreeMap<String, java.util.Calendar>();
    private SortedMap<String, java.util.Calendar> datesWithoutRestrictions = new TreeMap<String, java.util.Calendar>();
    private SortedSet<String> restrictions = new TreeSet<String>();
    private SortedSet<String> withExcludes = new TreeSet<String>();
    private java.util.Calendar calendarFrom = null;
    private java.util.Calendar dateFrom = null;
    private java.util.Calendar dateTo = null;
    private Frequencies includes = null;
    private Frequencies excludes = null;
    private static DateTimeFormatter df = DateTimeFormatter.ISO_LOCAL_DATE.withZone(ZoneOffset.UTC);
    private static ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public SortedMap<String, java.util.Calendar> getDates() {
        return this.dates;
    }

    public SortedSet<String> getWithExcludes() {
        return this.withExcludes;
    }

    public Dates resolve(CalendarDatesFilter calendarFilter) throws SOSMissingDataException, SOSInvalidDataException {
        if (calendarFilter != null) {
            return this.resolve(calendarFilter.getCalendar(), calendarFilter.getDateFrom(), calendarFilter.getDateTo());
        }
        Dates d = new Dates();
        d.setDates(new ArrayList<String>());
        d.setWithExcludes(new ArrayList<String>());
        d.setDeliveryDate(Date.from(Instant.now()));
        return d;
    }

    public Dates resolve(String calendarJson, String from, String to) throws SOSMissingDataException, SOSInvalidDataException, JsonParseException, JsonMappingException, IOException {
        return this.resolve((Calendar)objectMapper.readValue(calendarJson, Calendar.class), from, to);
    }

    public Dates resolve(Calendar calendar, String from, String to) throws SOSMissingDataException, SOSInvalidDataException {
        this.init(calendar, from, to);
        Dates d = new Dates();
        d.setDates(new ArrayList<String>());
        if (this.dateFrom.compareTo(this.dateTo) <= 0) {
            this.addDates();
            this.addHolidays();
            this.addWeekDays();
            this.addMonthDays();
            this.addUltimos();
            this.addMonths();
            this.addRepetitions();
            this.removeDates();
            this.removeWeekDays();
            this.removeMonthDays();
            this.removeUltimos();
            this.removeMonths();
            this.removeHolidays();
            this.removeRepetitions();
            d.getDates().addAll(this.dates.keySet());
            d.setWithExcludes(new ArrayList<String>(this.withExcludes));
        } else {
            d.setDates(new ArrayList<String>());
        }
        d.setDeliveryDate(Date.from(Instant.now()));
        return d;
    }

    public Dates resolveFromToday(String calendarJson) throws SOSMissingDataException, SOSInvalidDataException, JsonParseException, JsonMappingException, IOException {
        return this.resolve(calendarJson, df.format(Instant.now()), null);
    }

    public Dates resolveFromToday(Calendar calendar) throws SOSMissingDataException, SOSInvalidDataException {
        return this.resolve(calendar, df.format(Instant.now()), null);
    }

    public Dates resolveFromUTCYesterday(String calendarJson) throws SOSMissingDataException, SOSInvalidDataException, JsonParseException, JsonMappingException, IOException {
        return this.resolve(calendarJson, df.format(ZonedDateTime.now(ZoneOffset.UTC).minusDays(1L)), null);
    }

    public Dates resolveFromUTCYesterday(Calendar calendar) throws SOSMissingDataException, SOSInvalidDataException {
        return this.resolve(calendar, df.format(ZonedDateTime.now(ZoneOffset.UTC).minusDays(1L)), null);
    }

    public Dates resolveRestrictions(String basedCalendarJson, String calendarJson, String from, String to) throws SOSMissingDataException, SOSInvalidDataException, JsonParseException, JsonMappingException, IOException {
        return this.resolveRestrictions((Calendar)objectMapper.readValue(basedCalendarJson, Calendar.class), (Calendar)objectMapper.readValue(calendarJson, Calendar.class), from, to);
    }

    public Dates resolveRestrictions(Calendar basedCalendar, Calendar calendar, String from, String to) throws SOSMissingDataException, SOSInvalidDataException {
        this.init(basedCalendar, null, null);
        Dates d = new Dates();
        d.setDates(new ArrayList<String>());
        if (this.dateFrom.compareTo(this.dateTo) <= 0) {
            this.addDates();
            this.addHolidays();
            this.addWeekDays();
            this.addMonthDays();
            this.addUltimos();
            this.addMonths();
            this.addRepetitions();
            this.removeDates();
            this.removeWeekDays();
            this.removeMonthDays();
            this.removeUltimos();
            this.removeMonths();
            this.removeHolidays();
            this.removeRepetitions();
            if (calendar != null && !this.dates.isEmpty()) {
                this.dateFrom = this.getFrom(from);
                this.dateTo = this.getTo(to);
                for (Map.Entry<String, java.util.Calendar> entry : this.dates.entrySet()) {
                    if (entry.getValue().before(this.dateFrom)) continue;
                    if (entry.getValue().after(this.dateTo)) break;
                    this.datesWithoutRestrictions.put(entry.getKey(), entry.getValue());
                }
                if (this.dateFrom.compareTo(this.dateTo) <= 0) {
                    String s = df.format(this.dateFrom.toInstant());
                    this.dateFrom = this.getFirstDayOfMonthCalendar(this.dateFrom);
                    this.includes = calendar.getIncludes();
                    this.addDatesRestrictions();
                    this.addWeekDaysRestrictions();
                    this.addMonthDaysRestrictions();
                    this.addUltimosRestrictions();
                    this.addMonthsRestrictions();
                    this.addRepetitionsRestrictions();
                    this.restrictions = this.restrictions.stream().filter(dt -> dt.compareTo(s) >= 0).collect(Collectors.toCollection(TreeSet::new));
                }
            }
            this.restrictions.addAll(this.datesWithoutRestrictions.keySet());
            d.getDates().addAll(this.restrictions);
        }
        d.setDeliveryDate(Date.from(Instant.now()));
        return d;
    }

    public Dates resolveRestrictionsFromToday(String basedCalendarJson, String calendarJson) throws SOSMissingDataException, SOSInvalidDataException, JsonParseException, JsonMappingException, IOException {
        return this.resolveRestrictions(basedCalendarJson, calendarJson, df.format(Instant.now()), null);
    }

    public Dates resolveRestrictionsFromToday(Calendar basedCalendar, String calendarJson) throws SOSMissingDataException, SOSInvalidDataException, JsonParseException, JsonMappingException, IOException {
        return this.resolveRestrictions(basedCalendar, (Calendar)objectMapper.readValue(calendarJson, Calendar.class), df.format(Instant.now()), null);
    }

    public Dates resolveRestrictionsFromToday(Calendar basedCalendar, Calendar calendar) throws SOSMissingDataException, SOSInvalidDataException {
        return this.resolveRestrictions(basedCalendar, calendar, df.format(Instant.now()), null);
    }

    public Dates resolveRestrictionsFromUTCYesterday(String basedCalendarJson, String calendarJson) throws SOSMissingDataException, SOSInvalidDataException, JsonParseException, JsonMappingException, IOException {
        return this.resolveRestrictions(basedCalendarJson, calendarJson, df.format(ZonedDateTime.now(ZoneOffset.UTC).minusDays(1L)), null);
    }

    public Dates resolveRestrictionsFromUTCYesterday(Calendar basedCalendar, String calendarJson) throws SOSMissingDataException, SOSInvalidDataException, JsonParseException, JsonMappingException, IOException {
        return this.resolveRestrictions(basedCalendar, (Calendar)objectMapper.readValue(calendarJson, Calendar.class), df.format(ZonedDateTime.now(ZoneOffset.UTC).minusDays(1L)), null);
    }

    public Dates resolveRestrictionsFromUTCYesterday(Calendar basedCalendar, Calendar calendar) throws SOSMissingDataException, SOSInvalidDataException {
        return this.resolveRestrictions(basedCalendar, calendar, df.format(ZonedDateTime.now(ZoneOffset.UTC).minusDays(1L)), null);
    }

    public void init(Calendar calendar, String from, String to) throws SOSMissingDataException, SOSInvalidDataException {
        if (calendar == null) {
            throw new SOSMissingDataException("calendar object is undefined");
        }
        this.setDateFrom(from, calendar.getFrom());
        this.setDateTo(to, calendar.getTo());
        this.includes = calendar.getIncludes();
        this.excludes = calendar.getExcludes();
    }

    public void setDateFrom(String dateFrom, String calendarFrom) throws SOSMissingDataException, SOSInvalidDataException {
        if ((dateFrom == null || dateFrom.isEmpty()) && (calendarFrom == null || calendarFrom.isEmpty())) {
            this.dateFrom = this.getTodayCalendar();
            this.calendarFrom = this.getTodayCalendar();
        } else {
            java.util.Calendar calFrom = this.getCalendarFromString(calendarFrom, "calendar field 'from' must have the format YYYY-MM-DD.");
            java.util.Calendar dFrom = this.getCalendarFromString(dateFrom, "'dateFrom' parameter must have the format YYYY-MM-DD.");
            this.dateFrom = calFrom == null ? dFrom : (dFrom == null ? calFrom : (calFrom.before(dFrom) ? dFrom : calFrom));
            this.calendarFrom = calFrom == null ? (java.util.Calendar)dFrom.clone() : (java.util.Calendar)calFrom.clone();
        }
    }

    public void setDateTo(String dateTo, String calendarTo) throws SOSMissingDataException, SOSInvalidDataException {
        if ((dateTo == null || dateTo.isEmpty()) && (calendarTo == null || calendarTo.isEmpty())) {
            throw new SOSMissingDataException("'dateTo' parameter and calendar field 'to' are undefined.");
        }
        java.util.Calendar calTo = this.getCalendarFromString(calendarTo, "calendar field 'to' must have the format YYYY-MM-DD.");
        java.util.Calendar dTo = this.getCalendarFromString(dateTo, "'dateTo' parameter must have the format YYYY-MM-DD.");
        this.dateTo = calTo == null ? dTo : (dTo == null ? calTo : (calTo.after(dTo) ? dTo : calTo));
    }

    public void addDates() throws SOSInvalidDataException {
        if (this.includes != null) {
            this.addDates(this.includes.getDates());
        }
    }

    public void removeDates() throws SOSInvalidDataException {
        if (this.excludes != null && this.dates.size() > 0) {
            this.removeDates(this.excludes.getDates());
        }
    }

    public void addHolidays() throws SOSInvalidDataException {
        if (this.includes != null) {
            this.addHolidays(this.includes.getHolidays());
        }
    }

    public void removeHolidays() throws SOSInvalidDataException {
        if (this.excludes != null && this.dates.size() > 0) {
            this.removeHolidays(this.excludes.getHolidays());
        }
    }

    public void addWeekDays() throws SOSInvalidDataException {
        if (this.includes != null) {
            this.addWeekDays(this.includes.getWeekdays());
        }
    }

    public void removeWeekDays() throws SOSInvalidDataException {
        if (this.excludes != null && this.dates.size() > 0) {
            this.removeWeekDays(this.excludes.getWeekdays());
        }
    }

    public void addMonthDays() throws SOSInvalidDataException {
        if (this.includes != null) {
            this.addMonthDays(this.includes.getMonthdays());
        }
    }

    public void removeMonthDays() throws SOSInvalidDataException {
        if (this.excludes != null && this.dates.size() > 0) {
            this.removeMonthDays(this.excludes.getMonthdays());
        }
    }

    public void addUltimos() throws SOSInvalidDataException {
        if (this.includes != null) {
            this.addUltimos(this.includes.getUltimos());
        }
    }

    public void removeUltimos() throws SOSInvalidDataException {
        if (this.excludes != null && this.dates.size() > 0) {
            this.removeUltimos(this.excludes.getUltimos());
        }
    }

    public void addRepetitions() throws SOSInvalidDataException {
        if (this.includes != null) {
            this.addRepetitions(this.includes.getRepetitions());
        }
    }

    public void removeRepetitions() throws SOSInvalidDataException {
        if (this.excludes != null && this.dates.size() > 0) {
            this.removeRepetitions(this.excludes.getRepetitions());
        }
    }

    public void addMonths() throws SOSInvalidDataException {
        if (this.includes != null) {
            this.addMonths(this.includes.getMonths());
        }
    }

    public void removeMonths() throws SOSInvalidDataException {
        if (this.excludes != null && this.dates.size() > 0) {
            this.removeMonths(this.excludes.getMonths());
        }
    }

    public String getToday() {
        return df.format(Instant.now());
    }

    private java.util.Calendar getCalendarFromString(String cal) throws SOSInvalidDataException {
        return this.getCalendarFromString(cal, "dates must have the format YYYY-MM-DD.");
    }

    private java.util.Calendar getCalendarFromString(String cal, String msg) throws SOSInvalidDataException {
        java.util.Calendar calendar = null;
        if (cal != null && !cal.isEmpty()) {
            if (!cal.matches("^\\d{4}-\\d{2}-\\d{2}$")) {
                throw new SOSInvalidDataException(msg);
            }
            calendar = java.util.Calendar.getInstance(UTC);
            calendar.setTime(Date.from(Instant.parse(cal + "T12:00:00Z")));
        }
        return calendar;
    }

    private void addDates(List<String> list) throws SOSInvalidDataException {
        this.addAll(this.resolveDates(list));
    }

    private void removeDates(List<String> list) throws SOSInvalidDataException {
        this.removeAll(this.resolveDates(list));
    }

    private void addHolidays(List<Holidays> holidays) throws SOSInvalidDataException {
        if (holidays != null) {
            for (Holidays holiday : holidays) {
                this.addDates(holiday.getDates());
            }
        }
    }

    private void removeHolidays(List<Holidays> holidays) throws SOSInvalidDataException {
        if (holidays != null) {
            for (Holidays holiday : holidays) {
                this.removeDates(holiday.getDates());
            }
        }
    }

    private void addWeekDays(List<WeekDays> weekDays) throws SOSInvalidDataException {
        this.addWeekDays(weekDays, this.dateFrom, this.dateTo);
    }

    private void addWeekDays(List<WeekDays> weekDays, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        if (weekDays != null) {
            for (WeekDays weekDay : weekDays) {
                this.addAll(this.resolveWeekDays(weekDay.getDays(), this.getFrom(weekDay.getFrom(), from), this.getTo(weekDay.getTo(), to)));
            }
        }
    }

    private void removeWeekDays(List<WeekDays> weekDays) throws SOSInvalidDataException {
        this.removeWeekDays(weekDays, this.dateFrom, this.dateTo);
    }

    private void removeWeekDays(List<WeekDays> weekDays, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        if (weekDays != null) {
            for (WeekDays weekDay : weekDays) {
                this.removeAll(this.resolveWeekDays(weekDay.getDays(), this.getFrom(weekDay.getFrom(), from), this.getTo(weekDay.getTo(), to)));
            }
        }
    }

    private void addMonthDays(List<MonthDays> monthDays) throws SOSInvalidDataException {
        this.addMonthDays(monthDays, this.dateFrom, this.dateTo);
    }

    private void addMonthDays(List<MonthDays> monthDays, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        if (monthDays != null) {
            for (MonthDays monthDay : monthDays) {
                this.addAll(this.resolveMonthDays(monthDay.getDays(), monthDay.getWeeklyDays(), this.getFrom(monthDay.getFrom(), from), this.getTo(monthDay.getTo(), to)));
            }
        }
    }

    private void removeMonthDays(List<MonthDays> monthDays) throws SOSInvalidDataException {
        this.removeMonthDays(monthDays, this.dateFrom, this.dateTo);
    }

    private void removeMonthDays(List<MonthDays> monthDays, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        if (monthDays != null) {
            for (MonthDays monthDay : monthDays) {
                this.removeAll(this.resolveMonthDays(monthDay.getDays(), monthDay.getWeeklyDays(), this.getFrom(monthDay.getFrom(), from), this.getTo(monthDay.getTo(), to)));
            }
        }
    }

    private void addUltimos(List<MonthDays> monthDays) throws SOSInvalidDataException {
        this.addUltimos(monthDays, this.dateFrom, this.dateTo);
    }

    private void addUltimos(List<MonthDays> ultimos, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        if (ultimos != null) {
            for (MonthDays ultimo : ultimos) {
                this.addAll(this.resolveUltimos(ultimo.getDays(), ultimo.getWeeklyDays(), this.getFrom(ultimo.getFrom(), from), this.getTo(ultimo.getTo(), to)));
            }
        }
    }

    private void removeUltimos(List<MonthDays> monthDays) throws SOSInvalidDataException {
        this.removeUltimos(monthDays, this.dateFrom, this.dateTo);
    }

    private void removeUltimos(List<MonthDays> ultimos, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        if (ultimos != null) {
            for (MonthDays ultimo : ultimos) {
                this.removeAll(this.resolveUltimos(ultimo.getDays(), ultimo.getWeeklyDays(), this.getFrom(ultimo.getFrom(), from), this.getTo(ultimo.getTo(), to)));
            }
        }
    }

    private void addRepetitions(List<Repetition> repetitions) throws SOSInvalidDataException {
        if (repetitions != null) {
            for (Repetition repetition : repetitions) {
                this.addAll(this.resolveRepetitions(repetition.getRepetition(), repetition.getStep(), this.getFrom(repetition.getFrom(), this.calendarFrom), this.getFrom(repetition.getFrom()), this.getTo(repetition.getTo())));
            }
        }
    }

    private void removeRepetitions(List<Repetition> repetitions) throws SOSInvalidDataException {
        if (repetitions != null) {
            for (Repetition repetition : repetitions) {
                this.removeAll(this.resolveRepetitions(repetition.getRepetition(), repetition.getStep(), this.getFrom(repetition.getFrom(), this.calendarFrom), this.getFrom(repetition.getFrom()), this.getTo(repetition.getTo())));
            }
        }
    }

    private void addMonths(List<Months> months) throws SOSInvalidDataException {
        if (months != null) {
            java.util.Calendar monthStart = java.util.Calendar.getInstance(UTC);
            java.util.Calendar monthEnd = java.util.Calendar.getInstance(UTC);
            for (Months month : months) {
                if (month.getMonths() == null) continue;
                java.util.Calendar from = this.getFrom(month.getFrom());
                java.util.Calendar to = this.getTo(month.getTo());
                while (from.compareTo(to) <= 0) {
                    int lastDayOfMonth = from.getActualMaximum(5);
                    if (month.getMonths().contains(from.get(2) + 1)) {
                        java.util.Calendar monthFrom = this.getFromPerMonth(monthStart, from);
                        java.util.Calendar monthTo = this.getFromToMonth(monthEnd, from, to, lastDayOfMonth);
                        this.addWeekDays(month.getWeekdays(), monthFrom, monthTo);
                        this.addMonthDays(month.getMonthdays(), monthFrom, monthTo);
                        this.addUltimos(month.getUltimos(), monthFrom, monthTo);
                    }
                    from.set(5, lastDayOfMonth);
                    from.add(5, 1);
                }
            }
        }
    }

    private void removeMonths(List<Months> months) throws SOSInvalidDataException {
        if (months != null) {
            java.util.Calendar monthStart = java.util.Calendar.getInstance(UTC);
            java.util.Calendar monthEnd = java.util.Calendar.getInstance(UTC);
            for (Months month : months) {
                if (month.getMonths() == null) continue;
                java.util.Calendar from = this.getFrom(month.getFrom());
                java.util.Calendar to = this.getTo(month.getTo());
                while (from.compareTo(to) <= 0) {
                    int lastDayOfMonth = from.getActualMaximum(5);
                    if (month.getMonths().contains(from.get(2) + 1)) {
                        java.util.Calendar monthFrom = this.getFromPerMonth(monthStart, from);
                        java.util.Calendar monthTo = this.getFromToMonth(monthEnd, from, to, lastDayOfMonth);
                        this.removeWeekDays(month.getWeekdays(), monthFrom, monthTo);
                        this.removeMonthDays(month.getMonthdays(), monthFrom, monthTo);
                        this.removeUltimos(month.getUltimos(), monthFrom, monthTo);
                    }
                    from.set(5, lastDayOfMonth);
                    from.add(5, 1);
                }
            }
        }
    }

    private java.util.Calendar getFromPerMonth(java.util.Calendar monthStart, java.util.Calendar refFrom) throws SOSInvalidDataException {
        monthStart.set(1, refFrom.get(1));
        monthStart.set(2, refFrom.get(2));
        monthStart.set(5, 1);
        return this.getFrom(monthStart, refFrom);
    }

    private java.util.Calendar getFromToMonth(java.util.Calendar monthEnd, java.util.Calendar refFrom, java.util.Calendar refTo, int lastDayOfMonth) throws SOSInvalidDataException {
        monthEnd.set(1, refFrom.get(1));
        monthEnd.set(2, refFrom.get(2));
        monthEnd.set(5, lastDayOfMonth);
        return this.getTo(monthEnd, refTo);
    }

    private void addAll(Map<String, java.util.Calendar> map) {
        if (map != null) {
            this.dates.putAll(map);
        }
    }

    private boolean removeAll(Map<String, java.util.Calendar> map) {
        boolean removeAffects = false;
        if (map != null) {
            for (String item : map.keySet()) {
                if (this.dates.remove(item) == null) continue;
                this.withExcludes.add(item);
                removeAffects = true;
            }
        }
        return removeAffects;
    }

    private void addRestrictions(Set<String> set) {
        if (set != null) {
            this.restrictions.addAll(set);
        }
    }

    private java.util.Calendar getFrom(String from) throws SOSInvalidDataException {
        return this.getFrom(from, this.dateFrom);
    }

    private java.util.Calendar getTo(String to) throws SOSInvalidDataException {
        return this.getTo(to, this.dateTo);
    }

    private java.util.Calendar getFrom(String from, java.util.Calendar fromRef) throws SOSInvalidDataException {
        java.util.Calendar cal = java.util.Calendar.getInstance(UTC);
        if (from == null || from.isEmpty()) {
            return (java.util.Calendar)fromRef.clone();
        }
        if (!from.matches("^\\d{4}-\\d{2}-\\d{2}$")) {
            throw new SOSInvalidDataException("json field 'from' must have the format YYYY-MM-DD.");
        }
        cal.setTime(Date.from(Instant.parse(from + "T12:00:00Z")));
        if (cal.after(fromRef)) {
            return cal;
        }
        return (java.util.Calendar)fromRef.clone();
    }

    private java.util.Calendar getFrom(java.util.Calendar from, java.util.Calendar fromRef) throws SOSInvalidDataException {
        if (from == null) {
            return (java.util.Calendar)fromRef.clone();
        }
        if (from.after(fromRef)) {
            return from;
        }
        return (java.util.Calendar)fromRef.clone();
    }

    private java.util.Calendar getTo(String to, java.util.Calendar toRef) throws SOSInvalidDataException {
        if (to == null || to.isEmpty()) {
            return (java.util.Calendar)toRef.clone();
        }
        if (!to.matches("^\\d{4}-\\d{2}-\\d{2}$")) {
            throw new SOSInvalidDataException("json field 'to' must have the format YYYY-MM-DD.");
        }
        java.util.Calendar cal = java.util.Calendar.getInstance(UTC);
        cal.setTime(Date.from(Instant.parse(to + "T12:00:00Z")));
        if (cal.before(toRef)) {
            return cal;
        }
        return (java.util.Calendar)toRef.clone();
    }

    private java.util.Calendar getTo(java.util.Calendar to, java.util.Calendar toRef) throws SOSInvalidDataException {
        if (to == null) {
            return (java.util.Calendar)toRef.clone();
        }
        if (to.before(toRef)) {
            return to;
        }
        return (java.util.Calendar)toRef.clone();
    }

    private boolean isBetweenFromTo(java.util.Calendar cal) throws SOSInvalidDataException {
        return cal != null && cal.compareTo(this.dateTo) <= 0 && cal.compareTo(this.dateFrom) >= 0;
    }

    private int getWeekOfMonthOfWeeklyDay(java.util.Calendar currentDay) {
        int dayOfMonth = currentDay.get(5);
        int weekOfMonthOfWeeklyDay = dayOfMonth / 7;
        if (dayOfMonth % 7 > 0) {
            ++weekOfMonthOfWeeklyDay;
        }
        return weekOfMonthOfWeeklyDay;
    }

    private int getWeekOfMonthOfUltimoWeeklyDay(java.util.Calendar currentDay) {
        int dayOfMonth = currentDay.get(5);
        int maxDaysOfMonth = currentDay.getActualMaximum(5);
        dayOfMonth = maxDaysOfMonth - dayOfMonth + 1;
        int weekOfMonthOfWeeklyDay = dayOfMonth / 7;
        if (dayOfMonth % 7 > 0) {
            ++weekOfMonthOfWeeklyDay;
        }
        return weekOfMonthOfWeeklyDay;
    }

    private Map<String, java.util.Calendar> resolveDates(List<String> dates) throws SOSInvalidDataException {
        HashMap<String, java.util.Calendar> d = new HashMap<String, java.util.Calendar>();
        if (dates != null && !dates.isEmpty()) {
            for (String date : dates) {
                java.util.Calendar cal = this.getCalendarFromString(date);
                if (!this.isBetweenFromTo(cal)) continue;
                d.put(date, cal);
            }
        }
        return d;
    }

    private Map<String, java.util.Calendar> resolveWeekDays(List<Integer> days, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        if (days == null || days.isEmpty()) {
            throw new SOSInvalidDataException("json field 'days' in 'weekdays' is undefined.");
        }
        if (days.contains(7) && !days.contains(0)) {
            days.add(0);
        }
        HashMap<String, java.util.Calendar> dates = new HashMap<String, java.util.Calendar>();
        while (from.compareTo(to) <= 0) {
            if (days.contains(from.get(7) - 1)) {
                dates.put(df.format(from.toInstant()), (java.util.Calendar)from.clone());
            }
            from.add(5, 1);
        }
        return dates;
    }

    private Set<String> resolveBasedOnWeekDays(List<Integer> days, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        if (days == null || days.isEmpty()) {
            throw new SOSInvalidDataException("json field 'days' in 'weekdays' is undefined.");
        }
        if (days.contains(7) && !days.contains(0)) {
            days.add(0);
        }
        HashSet<String> dates = new HashSet<String>();
        for (Map.Entry<String, java.util.Calendar> date : this.dates.entrySet()) {
            if (date == null || date.getValue() == null) continue;
            if (date.getValue().after(to)) break;
            if (date.getValue().before(from) || !days.contains(date.getValue().get(7) - 1)) continue;
            dates.add(date.getKey());
        }
        HashMap<String, java.util.Calendar> tmpDatesWithoutRestrictions = new HashMap<String, java.util.Calendar>(this.datesWithoutRestrictions);
        for (Map.Entry entry : tmpDatesWithoutRestrictions.entrySet()) {
            if (((java.util.Calendar)entry.getValue()).before(from) || ((java.util.Calendar)entry.getValue()).after(to)) continue;
            this.datesWithoutRestrictions.remove(entry.getKey());
        }
        return dates;
    }

    private Map<String, java.util.Calendar> resolveMonthDays(List<Integer> days, List<WeeklyDay> weeklyDays, java.util.Calendar from, java.util.Calendar to) {
        HashMap<String, java.util.Calendar> dates = new HashMap<String, java.util.Calendar>();
        WeeklyDay weeklyDay = new WeeklyDay();
        while (from.compareTo(to) <= 0) {
            if (days != null && days.contains(from.get(5))) {
                dates.put(df.format(from.toInstant()), (java.util.Calendar)from.clone());
            }
            if (weeklyDays != null) {
                weeklyDay.setDay(from.get(7) - 1);
                weeklyDay.setWeekOfMonth(this.getWeekOfMonthOfWeeklyDay(from));
                if (weeklyDays.contains(weeklyDay)) {
                    dates.put(df.format(from.toInstant()), (java.util.Calendar)from.clone());
                }
            }
            from.add(5, 1);
        }
        return dates;
    }

    private Set<String> resolveBasedOnMonthDays(List<Integer> days, List<WeeklyDay> weeklyDays, java.util.Calendar from, java.util.Calendar to) {
        HashSet<String> dates = new HashSet<String>();
        WeeklyDay weeklyDay = new WeeklyDay();
        int dayOfMonth = 0;
        int lastMonth = -1;
        int[] weeklyDayOfMonth = new int[]{0, 0, 0, 0, 0, 0, 0};
        for (Map.Entry<String, java.util.Calendar> date : this.dates.entrySet()) {
            if (date == null || date.getValue() == null) continue;
            if (date.getValue().after(to)) break;
            java.util.Calendar curDate = date.getValue();
            int curMonth = curDate.get(2);
            if (curMonth != lastMonth) {
                dayOfMonth = 0;
                for (int i = 0; i < weeklyDayOfMonth.length; ++i) {
                    weeklyDayOfMonth[i] = 0;
                }
                lastMonth = curMonth;
            }
            if (curDate.before(from)) continue;
            if (days != null && days.contains(++dayOfMonth)) {
                dates.add(date.getKey());
            }
            if (weeklyDays == null) continue;
            int curDayOfWeek = curDate.get(7) - 1;
            weeklyDay.setDay(curDayOfWeek);
            weeklyDayOfMonth[curDayOfWeek] = weeklyDayOfMonth[curDayOfWeek] + 1;
            weeklyDay.setWeekOfMonth(weeklyDayOfMonth[curDayOfWeek]);
            if (!weeklyDays.contains(weeklyDay)) continue;
            dates.add(date.getKey());
        }
        HashMap<String, java.util.Calendar> tmpDatesWithoutRestrictions = new HashMap<String, java.util.Calendar>(this.datesWithoutRestrictions);
        for (Map.Entry entry : tmpDatesWithoutRestrictions.entrySet()) {
            if (((java.util.Calendar)entry.getValue()).before(from) || ((java.util.Calendar)entry.getValue()).after(to)) continue;
            this.datesWithoutRestrictions.remove(entry.getKey());
        }
        return dates;
    }

    private Map<String, java.util.Calendar> resolveUltimos(List<Integer> days, List<WeeklyDay> weeklyDays, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        HashMap<String, java.util.Calendar> dates = new HashMap<String, java.util.Calendar>();
        WeeklyDay weeklyDay = new WeeklyDay();
        while (from.compareTo(to) <= 0) {
            int dayOfUltimo;
            if (days != null && days.contains(dayOfUltimo = from.getActualMaximum(5) + 1 - from.get(5))) {
                dates.put(df.format(from.toInstant()), (java.util.Calendar)from.clone());
            }
            if (weeklyDays != null) {
                weeklyDay.setDay(from.get(7) - 1);
                weeklyDay.setWeekOfMonth(this.getWeekOfMonthOfUltimoWeeklyDay(from));
                if (weeklyDays.contains(weeklyDay)) {
                    dates.put(df.format(from.toInstant()), (java.util.Calendar)from.clone());
                }
            }
            from.add(5, 1);
        }
        return dates;
    }

    private Set<String> resolveBasedOnUltimos(List<Integer> days, List<WeeklyDay> weeklyDays, java.util.Calendar from, java.util.Calendar to) {
        TreeMap<String, java.util.Calendar> reverseDates = new TreeMap<String, java.util.Calendar>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.compareTo(o1);
            }
        });
        reverseDates.putAll(this.dates);
        HashSet<String> dates = new HashSet<String>();
        WeeklyDay weeklyDay = new WeeklyDay();
        int dayOfMonth = 0;
        int lastMonth = -1;
        int[] weeklyDayOfMonth = new int[]{0, 0, 0, 0, 0, 0, 0};
        for (Map.Entry date : reverseDates.entrySet()) {
            if (date == null || date.getValue() == null) continue;
            if (((java.util.Calendar)date.getValue()).before(from)) break;
            java.util.Calendar curDate = (java.util.Calendar)date.getValue();
            int curMonth = curDate.get(2);
            if (curMonth != lastMonth) {
                dayOfMonth = 0;
                for (int i = 0; i < weeklyDayOfMonth.length; ++i) {
                    weeklyDayOfMonth[i] = 0;
                }
                lastMonth = curMonth;
            }
            if (curDate.after(to)) continue;
            if (days != null && days.contains(++dayOfMonth)) {
                dates.add((String)date.getKey());
            }
            if (weeklyDays == null) continue;
            int curDayOfWeek = curDate.get(7) - 1;
            weeklyDay.setDay(curDayOfWeek);
            weeklyDayOfMonth[curDayOfWeek] = weeklyDayOfMonth[curDayOfWeek] + 1;
            weeklyDay.setWeekOfMonth(weeklyDayOfMonth[curDayOfWeek]);
            if (!weeklyDays.contains(weeklyDay)) continue;
            dates.add((String)date.getKey());
        }
        HashMap<String, java.util.Calendar> tmpDatesWithoutRestrictions = new HashMap<String, java.util.Calendar>(this.datesWithoutRestrictions);
        for (Map.Entry entry : tmpDatesWithoutRestrictions.entrySet()) {
            if (((java.util.Calendar)entry.getValue()).before(from) || ((java.util.Calendar)entry.getValue()).after(to)) continue;
            this.datesWithoutRestrictions.remove(entry.getKey());
        }
        return dates;
    }

    private Map<String, java.util.Calendar> resolveRepetitions(RepetitionText repetition, Integer step, java.util.Calendar calFrom, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        if (repetition == null) {
            throw new SOSInvalidDataException("json field 'repetition' in 'repetitions' is undefined.");
        }
        if (step == null) {
            step = 1;
        }
        HashMap<String, java.util.Calendar> dates = new HashMap<String, java.util.Calendar>();
        int dayOfMonth = calFrom.get(5);
        while (calFrom.compareTo(to) <= 0) {
            if (calFrom.compareTo(from) >= 0) {
                dates.put(df.format(calFrom.toInstant()), (java.util.Calendar)calFrom.clone());
            }
            switch (repetition) {
                case DAILY: {
                    calFrom.add(5, step);
                    break;
                }
                case MONTHLY: {
                    calFrom.add(2, step);
                    if (dayOfMonth <= calFrom.get(5) || calFrom.getActualMaximum(5) < dayOfMonth) break;
                    calFrom.set(5, dayOfMonth);
                    break;
                }
                case WEEKLY: {
                    calFrom.add(5, step * 7);
                    break;
                }
                case YEARLY: {
                    calFrom.add(1, step);
                    if (dayOfMonth <= calFrom.get(5) || calFrom.getActualMaximum(5) < dayOfMonth) break;
                    calFrom.set(5, dayOfMonth);
                }
            }
        }
        return dates;
    }

    private Set<String> resolveBasedOnRepetitions(RepetitionText repetition, Integer step, java.util.Calendar calFrom, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        if (repetition == null) {
            throw new SOSInvalidDataException("json field 'repetition' in 'repetitions' is undefined.");
        }
        if (step == null) {
            step = 1;
        }
        HashSet<String> dates = new HashSet<String>();
        int refDayOfMonth = -1;
        int refWeekDay = -1;
        int refMonth = -1;
        int curStep = 0;
        block6: for (Map.Entry<String, java.util.Calendar> date : this.dates.entrySet()) {
            if (date == null || date.getValue() == null) continue;
            if (date.getValue().after(to)) break;
            java.util.Calendar curDate = date.getValue();
            if (curDate.before(calFrom)) continue;
            if (refDayOfMonth == -1) {
                refDayOfMonth = curDate.get(5);
                refWeekDay = curDate.get(7);
                refMonth = curDate.get(2);
            }
            if (curDate.before(from)) continue;
            switch (repetition) {
                case DAILY: {
                    if (curStep % step == 0) {
                        dates.add(date.getKey());
                    }
                    ++curStep;
                    break;
                }
                case MONTHLY: {
                    if (refDayOfMonth <= -1) break;
                    int curDayOfMonth = curDate.get(5);
                    if (refDayOfMonth == curDayOfMonth) {
                        if (curStep % step == 0) {
                            dates.add(date.getKey());
                        }
                        ++curStep;
                        break;
                    }
                    if (refDayOfMonth <= curDate.getActualMaximum(5) || curDayOfMonth != curDate.getActualMaximum(5)) continue block6;
                    if (curStep % step == 0) {
                        dates.add(date.getKey());
                    }
                    ++curStep;
                    break;
                }
                case WEEKLY: {
                    if (refWeekDay <= -1) break;
                    int curWeekDay = curDate.get(7);
                    if (refWeekDay != curWeekDay) continue block6;
                    if (curStep % step == 0) {
                        dates.add(date.getKey());
                    }
                    ++curStep;
                    break;
                }
                case YEARLY: {
                    if (refDayOfMonth <= -1) break;
                    int curDayOfMonth = curDate.get(5);
                    int curMonth = curDate.get(2);
                    if (curMonth != refMonth) break;
                    if (curDayOfMonth == refDayOfMonth) {
                        if (curStep % step == 0) {
                            dates.add(date.getKey());
                        }
                        ++curStep;
                        break;
                    }
                    if (refMonth != 1 || refDayOfMonth != 29 || curDayOfMonth != 28) break;
                    if (curStep % step == 0) {
                        dates.add(date.getKey());
                    }
                    ++curStep;
                }
            }
        }
        HashMap<String, java.util.Calendar> tmpDatesWithoutRestrictions = new HashMap<String, java.util.Calendar>(this.datesWithoutRestrictions);
        for (Map.Entry entry : tmpDatesWithoutRestrictions.entrySet()) {
            if (((java.util.Calendar)entry.getValue()).before(from) || ((java.util.Calendar)entry.getValue()).after(to)) continue;
            this.datesWithoutRestrictions.remove(entry.getKey());
        }
        return dates;
    }

    private java.util.Calendar getTodayCalendar() {
        java.util.Calendar cal = java.util.Calendar.getInstance(UTC);
        cal.setTime(Date.from(Instant.now()));
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    private java.util.Calendar getFirstDayOfMonthCalendar(java.util.Calendar curCalendar) {
        curCalendar.set(5, 1);
        return (java.util.Calendar)curCalendar.clone();
    }

    private void addDatesRestrictions() throws SOSInvalidDataException {
        if (this.includes != null && this.includes.getDates() != null && !this.includes.getDates().isEmpty()) {
            for (Map.Entry<String, java.util.Calendar> date : this.dates.entrySet()) {
                if (date == null || date.getValue() == null) continue;
                if (date.getValue().after(this.dateTo)) break;
                if (date.getValue().before(this.dateFrom) || !this.includes.getDates().contains(date.getKey())) continue;
                this.restrictions.add(date.getKey());
            }
            this.datesWithoutRestrictions.clear();
        }
    }

    private void addWeekDaysRestrictions() throws SOSInvalidDataException {
        if (this.includes != null) {
            this.addWeekDaysRestrictions(this.includes.getWeekdays(), this.dateFrom, this.dateTo);
        }
    }

    private void addWeekDaysRestrictions(List<WeekDays> weekDays, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        if (weekDays != null) {
            for (WeekDays weekDay : weekDays) {
                this.addRestrictions(this.resolveBasedOnWeekDays(weekDay.getDays(), this.getFrom(weekDay.getFrom(), from), this.getTo(weekDay.getTo(), to)));
            }
        }
    }

    private void addMonthDaysRestrictions() throws SOSInvalidDataException {
        if (this.includes != null) {
            this.addMonthDaysRestrictions(this.includes.getMonthdays(), this.dateFrom, this.dateTo);
        }
    }

    private void addMonthDaysRestrictions(List<MonthDays> monthDays, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        if (monthDays != null) {
            for (MonthDays monthDay : monthDays) {
                this.addRestrictions(this.resolveBasedOnMonthDays(monthDay.getDays(), monthDay.getWeeklyDays(), this.getFrom(monthDay.getFrom(), from), this.getTo(monthDay.getTo(), to)));
            }
        }
    }

    private void addUltimosRestrictions() throws SOSInvalidDataException {
        if (this.includes != null && this.includes.getUltimos() != null) {
            this.addUltimosRestrictions(this.includes.getUltimos(), this.dateFrom, this.dateTo);
        }
    }

    private void addUltimosRestrictions(List<MonthDays> ultimos, java.util.Calendar from, java.util.Calendar to) throws SOSInvalidDataException {
        if (ultimos != null) {
            for (MonthDays ultimo : ultimos) {
                this.addRestrictions(this.resolveBasedOnUltimos(ultimo.getDays(), ultimo.getWeeklyDays(), this.getFrom(ultimo.getFrom(), from), this.getTo(ultimo.getTo(), to)));
            }
        }
    }

    private void addMonthsRestrictions() throws SOSInvalidDataException {
        if (this.includes != null && this.includes.getMonths() != null) {
            java.util.Calendar monthStart = java.util.Calendar.getInstance(UTC);
            java.util.Calendar monthEnd = java.util.Calendar.getInstance(UTC);
            for (Months month : this.includes.getMonths()) {
                if (month.getMonths() == null) continue;
                java.util.Calendar from = this.getFrom(month.getFrom());
                java.util.Calendar to = this.getTo(month.getTo());
                while (from.compareTo(to) <= 0) {
                    int lastDayOfMonth = from.getActualMaximum(5);
                    if (month.getMonths().contains(from.get(2) + 1)) {
                        java.util.Calendar monthFrom = this.getFromPerMonth(monthStart, from);
                        java.util.Calendar monthTo = this.getFromToMonth(monthEnd, from, to, lastDayOfMonth);
                        this.addWeekDaysRestrictions(month.getWeekdays(), monthFrom, monthTo);
                        this.addMonthDaysRestrictions(month.getMonthdays(), monthFrom, monthTo);
                        this.addUltimosRestrictions(month.getUltimos(), monthFrom, monthTo);
                    }
                    from.set(5, lastDayOfMonth);
                    from.add(5, 1);
                }
            }
        }
    }

    private void addRepetitionsRestrictions() throws SOSInvalidDataException {
        if (this.includes != null && this.includes.getRepetitions() != null) {
            for (Repetition repetition : this.includes.getRepetitions()) {
                this.addRestrictions(this.resolveBasedOnRepetitions(repetition.getRepetition(), repetition.getStep(), this.getFrom(repetition.getFrom(), this.calendarFrom), this.getFrom(repetition.getFrom()), this.getTo(repetition.getTo())));
            }
        }
    }
}

