/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ConfigurationObjectType {
    JOB("JOB"),
    JOBCHAIN("JOBCHAIN"),
    ORDER("ORDER"),
    PROCESSCLASS("PROCESSCLASS"),
    AGENTCLUSTER("AGENTCLUSTER"),
    LOCK("LOCK"),
    SCHEDULE("SCHEDULE"),
    FOLDER("FOLDER"),
    JOBSCHEDULER("JOBSCHEDULER"),
    DAILYPLAN("DAILYPLAN"),
    TASK_HISTORY("TASK_HISTORY"),
    ORDER_HISTORY("ORDER_HISTORY"),
    JOBSTREAM_HISTORY("JOBSTREAM_HISTORY"),
    YADE("YADE"),
    YADE_HISTORY("YADE_HISTORY"),
    EVENT("EVENT"),
    AUDITLOG("AUDITLOG");

    private final String value;
    private static final Map<String, ConfigurationObjectType> CONSTANTS;

    private ConfigurationObjectType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ConfigurationObjectType fromValue(String value) {
        ConfigurationObjectType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ConfigurationObjectType>();
        for (ConfigurationObjectType c : ConfigurationObjectType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

