/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.order;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OrderType {
    PERMANENT("PERMANENT"),
    AD_HOC("AD_HOC"),
    FILE_ORDER("FILE_ORDER");

    private final String value;
    private static final Map<String, OrderType> CONSTANTS;

    private OrderType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static OrderType fromValue(String value) {
        OrderType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, OrderType>();
        for (OrderType c : OrderType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

