/*
 * Decompiled with CFR 0.152.
 */
package com.sos.DataExchange;

import com.sos.DataExchange.Jade4DMZEngineClientHandler;
import com.sos.DataExchange.JadeBaseEngine;
import com.sos.DataExchange.SOSDataExchangeEngine;
import com.sos.DataExchange.helpers.UpdateXmlToOptionHelper;
import com.sos.DataExchange.history.YadeHistory;
import com.sos.DataExchange.history.YadeTransferResultHelper;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.credentialstore.options.SOSCredentialStoreOptions;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.keepass.SOSKeePassDatabase;
import com.sos.vfs.common.SOSFileList;
import com.sos.vfs.common.options.SOSBaseOptions;
import com.sos.vfs.common.options.SOSProviderOptions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSDataExchange", defaultLocale="en")
public class Jade4DMZ
extends JadeBaseEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jade4DMZ.class);
    private static final String INTERNALLY_COMMAND_DELIMITER = "SOSJUMPCD";
    private SOSFileList fileList = null;
    private String uuid = null;
    private String sourceListFilename = null;
    private String historyFilename = null;
    private String initialTargetDir = null;
    private YadeHistory history = null;
    private String jumpDir;
    private Instant startTime;
    private Instant endTime;
    private Boolean transactional;

    public Jade4DMZ() throws Exception {
    }

    public Jade4DMZ(SOSBaseOptions jadeOptions) throws Exception {
        super(jadeOptions);
    }

    public void execute() {
        this.startTime = Instant.now();
        this.setLogger();
        this.initialTargetDir = this.getOptions().targetDir.getValue();
        Throwable exception = null;
        Operation operation = null;
        try {
            if (((SOSBaseOptions)this.objOptions).operation.isOperationCopyToInternet() || ((SOSBaseOptions)this.objOptions).operation.isOperationSendUsingDMZ()) {
                operation = Operation.copyToInternet;
            } else if (((SOSBaseOptions)this.objOptions).operation.isOperationCopyFromInternet() || ((SOSBaseOptions)this.objOptions).operation.isOperationReceiveUsingDMZ()) {
                operation = Operation.copyFromInternet;
            } else if (((SOSBaseOptions)this.objOptions).operation.isOperationRemove()) {
                operation = Operation.remove;
            } else if (((SOSBaseOptions)this.objOptions).operation.isOperationGetList()) {
                operation = Operation.getlist;
            } else {
                throw new JobSchedulerException(String.format("unsuported operation \"%s\"", ((SOSBaseOptions)this.objOptions).operation.getValue()));
            }
            UpdateXmlToOptionHelper updateHelper = new UpdateXmlToOptionHelper(this.getOptions());
            if (updateHelper.checkBefore()) {
                updateHelper.executeBefore();
                this.objOptions = updateHelper.getOptions();
            }
            ((SOSBaseOptions)this.objOptions).checkMandatory();
            if (this.history != null) {
                this.history.beforeTransfer((SOSBaseOptions)this.objOptions, null);
            }
            this.jumpDir = this.transfer(operation);
            if (this.history != null) {
                this.history.afterTransfer();
            }
        }
        catch (JobSchedulerException e) {
            if (this.history != null) {
                this.history.onException(e);
            }
            exception = e;
            throw e;
        }
        catch (Exception e) {
            exception = e;
            throw new JobSchedulerException("Transfer failed", (Throwable)e);
        }
        finally {
            this.endTime = Instant.now();
            if (this.history != null) {
                this.history.sendYadeEventOnEnd();
            }
            YadeTransferResultHelper.process2file((SOSBaseOptions)this.objOptions, this.startTime, this.endTime, exception, this.fileList, this.getOptions().sourceDir.getValue(), this.getOptions().targetDir.getValue(), this.jumpDir);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String transfer(Operation operation) {
        String jumpDir = this.normalizeDirectoryPath(this.getOptions().jumpDir.getValue());
        String uuid = "jade-dmz-" + this.getUUID();
        String dir = jumpDir + uuid;
        LOGGER.info(String.format("operation=%s, jump dir=%s, jump platform=%s", new Object[]{operation, dir, ((SOSBaseOptions)this.objOptions).jump_platform.getValue()}));
        SOSDataExchangeEngine jade = null;
        Jade4DMZEngineClientHandler clientHandler = null;
        this.fileList = null;
        try {
            clientHandler = new Jade4DMZEngineClientHandler(this.getOptions(), operation, jumpDir, uuid, dir);
            jade = new SOSDataExchangeEngine(this.getTransferOptions(operation, dir, clientHandler));
            jade.setEngineClientHandler(clientHandler);
            jade.execute();
            this.fileList = jade.getFileList();
            if (operation.equals((Object)Operation.copyFromInternet) && ((SOSBaseOptions)this.objOptions).removeFiles.value()) {
                try {
                    jade.executeTransferCommands("source remove files", jade.getSourceProvider(), true, this.getJadeOnDMZCommand4RemoveSource(), null);
                }
                catch (Exception ex) {
                    if (this.fileList != null && this.fileList.count() > 0L) {
                        throw ex;
                    }
                    LOGGER.info(ex.toString());
                }
            }
            if (this.history != null) {
                this.history.afterDMZFileTransfer(this.fileList, this.initialTargetDir);
            }
            if (jade == null) return dir;
            if (clientHandler != null) {
                clientHandler.onEnd(jade);
            }
        }
        catch (Exception e) {
            try {
                if (this.history == null) throw new JobSchedulerException("Transfer failed", (Throwable)e);
                this.history.onDMZFileTransferException(this.fileList, this.initialTargetDir);
                throw new JobSchedulerException("Transfer failed", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (jade == null) throw throwable;
                if (clientHandler != null) {
                    clientHandler.onEnd(jade);
                }
                try {
                    jade.disconnect();
                    throw throwable;
                }
                catch (Exception ex) {
                    LOGGER.warn(String.format("exception on disconnect: %s", ex.toString()), (Throwable)ex);
                }
                throw throwable;
            }
        }
        try {
            jade.disconnect();
            return dir;
        }
        catch (Exception ex) {
            LOGGER.warn(String.format("exception on disconnect: %s", ex.toString()), (Throwable)ex);
            return dir;
        }
    }

    private SOSProviderOptions createJumpOptions(String dir) throws Exception {
        SOSProviderOptions options = new SOSProviderOptions();
        options.protocol.setValue("sftp");
        options.host.setValue(((SOSBaseOptions)this.objOptions).jumpHost.getValue());
        options.port.setValue(((SOSBaseOptions)this.objOptions).jumpPort.getValue());
        options.user.setValue(((SOSBaseOptions)this.objOptions).jumpUser.getValue());
        options.required_authentications.setValue(((SOSBaseOptions)this.objOptions).jump_required_authentications.getValue());
        options.preferred_authentications.setValue(((SOSBaseOptions)this.objOptions).jump_preferred_authentications.getValue());
        options.sshAuthMethod.setValue(((SOSBaseOptions)this.objOptions).jumpSshAuthMethod.getValue());
        options.password.setValue(((SOSBaseOptions)this.objOptions).jumpPassword.getValue());
        options.sshAuthFile.setValue(((SOSBaseOptions)this.objOptions).jumpSshAuthFile.getValue());
        options.passphrase.setValue(((SOSBaseOptions)this.objOptions).jump_passphrase.getValue());
        options.strictHostKeyChecking.value(((SOSBaseOptions)this.objOptions).jumpStrictHostkeyChecking.value());
        options.directory.setValue(dir);
        options.configuration_files.setValue(((SOSBaseOptions)this.objOptions).jumpConfigurationFiles.getValue());
        options.proxyProtocol.setValue(((SOSBaseOptions)this.objOptions).jumpProxyProtocol.getValue());
        options.proxyHost.setValue(((SOSBaseOptions)this.objOptions).jumpProxyHost.getValue().trim());
        options.proxyPort.setValue(((SOSBaseOptions)this.objOptions).jumpProxyPort.getValue().trim());
        options.proxyUser.setValue(((SOSBaseOptions)this.objOptions).jumpProxyUser.getValue().trim());
        options.proxyPassword.setValue(((SOSBaseOptions)this.objOptions).jumpProxyPassword.getValue());
        options.server_alive_interval.setValue(((SOSBaseOptions)this.objOptions).jump_server_alive_interval.getValue());
        options.server_alive_count_max.setValue(((SOSBaseOptions)this.objOptions).jump_server_alive_count_max.getValue());
        options.connect_timeout.setValue(((SOSBaseOptions)this.objOptions).jump_connect_timeout.getValue());
        options.channel_connect_timeout.setValue(((SOSBaseOptions)this.objOptions).jump_channel_connect_timeout.getValue());
        if (((SOSBaseOptions)this.objOptions).jump_use_credential_store.value()) {
            SOSCredentialStoreOptions csOptions = new SOSCredentialStoreOptions();
            csOptions.useCredentialStore.setValue(((SOSBaseOptions)this.objOptions).jump_use_credential_store.getValue());
            csOptions.credentialStoreFileName.setValue(((SOSBaseOptions)this.objOptions).jump_CredentialStore_FileName.getValue());
            csOptions.credentialStoreAuthenticationMethod.setValue(((SOSBaseOptions)this.objOptions).jump_CredentialStore_AuthenticationMethod.getValue());
            csOptions.credentialStoreKeyFileName.setValue(((SOSBaseOptions)this.objOptions).jump_CredentialStore_KeyFileName.getValue());
            csOptions.credentialStorePassword.setValue(((SOSBaseOptions)this.objOptions).jump_CredentialStore_Password.getValue());
            csOptions.credentialStoreKeyPath.setValue(((SOSBaseOptions)this.objOptions).jump_CredentialStore_KeyPath.getValue());
            csOptions.credentialStoreKeePassModule.setValue(((SOSBaseOptions)this.objOptions).jump_CredentialStore_KeePass_Module.getValue());
            options.setCredentialStore(csOptions);
            Path jumpKpdPath = Paths.get(csOptions.credentialStoreFileName.getValue(), new String[0]);
            Object jumpKpd = null;
            Object kpd = ((SOSBaseOptions)this.objOptions).getSource().keepass_database.value();
            if (kpd != null && ((SOSKeePassDatabase)kpd).getHandler().getKeePassFile().equals(jumpKpdPath)) {
                LOGGER.debug("set jump settings from source KeePass");
                jumpKpd = kpd;
            }
            if (jumpKpd == null && (kpd = ((SOSBaseOptions)this.objOptions).getTarget().keepass_database.value()) != null && ((SOSKeePassDatabase)kpd).getHandler().getKeePassFile().equals(jumpKpdPath)) {
                LOGGER.debug("set jump settings from target KeePass");
                jumpKpd = kpd;
            }
            if (jumpKpd == null) {
                LOGGER.debug("set jump settings from jump KeePass");
            }
            options.keepass_database.value(jumpKpd);
            options.checkCredentialStoreOptions();
            options.keepass_database.value(null);
            csOptions.useCredentialStore.setValue("false");
            ((SOSBaseOptions)this.objOptions).jumpHost.setValue(options.host.getValue());
        }
        return options;
    }

    private SOSBaseOptions createPostTransferOptions(Operation operation, String dir) throws Exception {
        SOSBaseOptions options = new SOSBaseOptions();
        options = this.addJADEOptionsForTarget(operation, options);
        SOSProviderOptions sourceOptions = this.setLocalOptionsPrefixed("source_", dir);
        SOSProviderOptions targetOptions = ((SOSBaseOptions)this.objOptions).getTarget();
        options.getTransfer().setSource(sourceOptions);
        options.getTransfer().setTarget(targetOptions);
        return options;
    }

    private SOSBaseOptions createPreTransferOptions(Operation operation, String dir) throws Exception {
        String prefix = "target_";
        SOSBaseOptions options = new SOSBaseOptions();
        options = this.addJADEOptionsForSource(operation, options);
        SOSProviderOptions targetOptions = this.setLocalOptionsPrefixed(prefix, dir);
        targetOptions.preCommand.setValue(((SOSBaseOptions)this.objOptions).jumpPreCommand.getValue());
        targetOptions.postCommand.setValue(((SOSBaseOptions)this.objOptions).jumpPostCommandOnSuccess.getValue());
        targetOptions.preTransferCommands.setValue(((SOSBaseOptions)this.objOptions).jumpPreTransferCommands.getValue());
        targetOptions.postTransferCommands.setValue(((SOSBaseOptions)this.objOptions).jumpPostTransferCommandsOnSuccess.getValue());
        targetOptions.postTransferCommandsOnError.setValue(((SOSBaseOptions)this.objOptions).jumpPostTransferCommandsOnError.getValue());
        targetOptions.postTransferCommandsFinal.setValue(((SOSBaseOptions)this.objOptions).jumpPostTransferCommandsFinal.getValue());
        targetOptions.commandDelimiter.setValue(((SOSBaseOptions)this.objOptions).jumpCommandDelimiter.getValue());
        targetOptions.preCommand.setPrefix(prefix);
        targetOptions.postCommand.setPrefix(prefix);
        targetOptions.preTransferCommands.setPrefix(prefix);
        targetOptions.postTransferCommands.setPrefix(prefix);
        targetOptions.postTransferCommandsOnError.setPrefix(prefix);
        targetOptions.postTransferCommandsFinal.setPrefix(prefix);
        targetOptions.commandDelimiter.setPrefix(prefix);
        options.getTransfer().setTarget(targetOptions);
        SOSProviderOptions sourceOptions = ((SOSBaseOptions)this.objOptions).getSource();
        options.getTransfer().setSource(sourceOptions);
        options.removeFiles.value(false);
        if (((SOSBaseOptions)this.objOptions).removeFiles.value() || ((SOSBaseOptions)this.objOptions).resultSetFileName.isDirty()) {
            options.resultSetFileName.setValue(this.getSourceListFilename());
        }
        return options;
    }

    private SOSBaseOptions getTransferOptions(Operation operation, String dir, Jade4DMZEngineClientHandler clientHandler) throws Exception {
        LOGGER.debug(String.format("operation = %s, jump dir = %s", new Object[]{operation, dir}));
        SOSBaseOptions options = null;
        SOSProviderOptions jumpOptions = this.createJumpOptions(dir);
        if (operation.equals((Object)Operation.copyToInternet)) {
            options = this.createTransferToDMZOptions(operation, dir);
            SOSBaseOptions jumpCommandOptions = this.createPostTransferOptions(operation, dir);
            jumpOptions.preCommand.setValue(this.getJumpCommand(((SOSBaseOptions)this.objOptions).jumpPreCommand.getValue()));
            jumpOptions.postCommand.setValue(this.getJumpCommand(((SOSBaseOptions)this.objOptions).jumpPostCommandOnSuccess.getValue()));
            jumpOptions.preTransferCommands.setValue(this.getJumpCommand(((SOSBaseOptions)this.objOptions).jumpPreTransferCommands.getValue()));
            String firstCommand = "";
            String jumpPostTransferCommandsOnSuccess = this.getJumpCommand(((SOSBaseOptions)this.objOptions).jumpPostTransferCommandsOnSuccess.getValue());
            if (!SOSString.isEmpty((String)jumpPostTransferCommandsOnSuccess)) {
                firstCommand = jumpPostTransferCommandsOnSuccess.endsWith(INTERNALLY_COMMAND_DELIMITER) ? jumpPostTransferCommandsOnSuccess : jumpPostTransferCommandsOnSuccess + INTERNALLY_COMMAND_DELIMITER;
            }
            jumpOptions.postTransferCommands.setValue(firstCommand + this.getJadeOnDMZCommand(operation, jumpCommandOptions));
            jumpOptions.postTransferCommandsOnError.setValue(this.getJumpCommand(((SOSBaseOptions)this.objOptions).jumpPostTransferCommandsOnError.getValue()));
            jumpOptions.postTransferCommandsFinal.setValue(this.getJumpCommand(((SOSBaseOptions)this.objOptions).jumpPostTransferCommandsFinal.getValue()));
            jumpOptions.commandDelimiter.setValue(INTERNALLY_COMMAND_DELIMITER);
            jumpOptions = this.setProviderOptionsPrefix(jumpOptions, "target_");
            options.getTransfer().setSource(((SOSBaseOptions)this.objOptions).getSource());
            options.getTransfer().setTarget(jumpOptions);
        } else {
            options = this.createTransferFromDMZOptions(operation, dir);
            SOSBaseOptions jumpCommandOptions = this.createPreTransferOptions(operation, dir);
            if (clientHandler.isCopyFromInternetWithFileList()) {
                jumpCommandOptions.fileListName.setValue(clientHandler.getJumpFileListName());
            }
            jumpOptions.preTransferCommands.setValue(this.getJadeOnDMZCommand(operation, jumpCommandOptions));
            jumpOptions = this.setProviderOptionsPrefix(jumpOptions, "source_");
            jumpOptions.commandDelimiter.setValue(INTERNALLY_COMMAND_DELIMITER);
            options.getTransfer().setSource(jumpOptions);
            options.getTransfer().setTarget(((SOSBaseOptions)this.objOptions).getTarget());
        }
        options.setDmzOption("operation", operation.name());
        options.setDmzOption("history", this.getHistoryFilename());
        options.setDmzOption("resultfile", this.getSourceListFilename());
        options.settings = ((SOSBaseOptions)this.objOptions).settings;
        options.profile = ((SOSBaseOptions)this.objOptions).profile;
        options.setOriginalSettingsFile(((SOSBaseOptions)this.objOptions).getOriginalSettingsFile());
        options.setDeleteSettingsFileOnExit(((SOSBaseOptions)this.objOptions).getDeleteSettingsFileOnExit());
        return options;
    }

    private String getJumpCommand(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll(((SOSBaseOptions)this.objOptions).jumpCommandDelimiter.getValue(), INTERNALLY_COMMAND_DELIMITER);
    }

    private SOSProviderOptions setProviderOptionsPrefix(SOSProviderOptions options, String prefix) {
        options.protocol.setPrefix(prefix);
        options.host.setPrefix(prefix);
        options.port.setPrefix(prefix);
        options.user.setPrefix(prefix);
        options.password.setPrefix(prefix);
        options.sshAuthMethod.setPrefix(prefix);
        options.sshAuthFile.setPrefix(prefix);
        options.proxyProtocol.setPrefix(prefix);
        options.proxyHost.setPrefix(prefix);
        options.proxyPort.setPrefix(prefix);
        options.proxyUser.setPrefix(prefix);
        options.proxyPassword.setPrefix(prefix);
        options.preCommand.setPrefix(prefix);
        options.postCommand.setPrefix(prefix);
        options.preTransferCommands.setPrefix(prefix);
        options.postTransferCommands.setPrefix(prefix);
        options.directory.setPrefix(prefix);
        options.postTransferCommandsFinal.setPrefix(prefix);
        options.postTransferCommandsOnError.setPrefix(prefix);
        options.keepass_database.setPrefix(prefix);
        options.keepass_database_entry.setPrefix(prefix);
        options.keepass_attachment_property_name.setPrefix(prefix);
        options.passphrase.setPrefix(prefix);
        options.preferred_authentications.setPrefix(prefix);
        options.required_authentications.setPrefix(prefix);
        options.server_alive_interval.setPrefix(prefix);
        options.server_alive_count_max.setPrefix(prefix);
        options.connect_timeout.setPrefix(prefix);
        options.channel_connect_timeout.setPrefix(prefix);
        return options;
    }

    private SOSProviderOptions setLocalOptionsPrefixed(String prefix, String dir) {
        SOSProviderOptions options = new SOSProviderOptions();
        options.protocol.setValue("local");
        options.host.setValue(((SOSBaseOptions)this.objOptions).jumpHost.getValue());
        options.directory.setValue(dir);
        options.protocol.setPrefix(prefix);
        options.host.setPrefix(prefix);
        options.directory.setPrefix(prefix);
        return options;
    }

    private SOSBaseOptions createTransferFromDMZOptions(Operation operation, String dir) throws Exception {
        SOSBaseOptions options = new SOSBaseOptions();
        options = this.addJADEOptionsOnClient(options);
        options = this.addJADEOptionsForTarget(operation, options);
        options.sourceDir.setValue(dir);
        options.targetDir.setValue(((SOSBaseOptions)this.objOptions).getTarget().directory.getValue());
        options.jump_platform.setValue(((SOSBaseOptions)this.objOptions).jump_platform.getValue());
        return options;
    }

    private SOSBaseOptions createTransferToDMZOptions(Operation operation, String dir) throws Exception {
        SOSBaseOptions options = new SOSBaseOptions();
        options = this.addJADEOptionsOnClient(options);
        options = this.addJADEOptionsForSource(operation, options);
        options.sourceDir.setValue(((SOSBaseOptions)this.objOptions).getSource().directory.getValue());
        options.targetDir.setValue(dir);
        options.removeFiles = ((SOSBaseOptions)this.objOptions).removeFiles;
        options.jump_platform.setValue(((SOSBaseOptions)this.objOptions).jump_platform.getValue());
        return options;
    }

    private SOSBaseOptions addJADEOptionsForSource(Operation operation, SOSBaseOptions options) {
        if (operation.equals((Object)Operation.remove)) {
            options.operation.setValue("delete");
        } else if (operation.equals((Object)Operation.getlist)) {
            options.operation.setValue("getlist");
        } else {
            options.operation.setValue("copy");
        }
        options.transactional.value(this.getTransactional().booleanValue());
        options.atomicPrefix = ((SOSBaseOptions)this.objOptions).atomicPrefix;
        options.atomicSuffix = ((SOSBaseOptions)this.objOptions).atomicSuffix;
        options.bufferSize = ((SOSBaseOptions)this.objOptions).bufferSize;
        options.checkSteadyCount = ((SOSBaseOptions)this.objOptions).checkSteadyCount;
        options.checkSteadyStateInterval = ((SOSBaseOptions)this.objOptions).checkSteadyStateInterval;
        options.checkSteadyStateOfFiles = ((SOSBaseOptions)this.objOptions).checkSteadyStateOfFiles;
        options.pollingWait4SourceFolder = ((SOSBaseOptions)this.objOptions).pollingWait4SourceFolder;
        options.pollingEndAt = ((SOSBaseOptions)this.objOptions).pollingEndAt;
        options.pollingServerPollForever = ((SOSBaseOptions)this.objOptions).pollingServerPollForever;
        options.pollingServerDuration = ((SOSBaseOptions)this.objOptions).pollingServerDuration;
        options.pollKeepConnection = ((SOSBaseOptions)this.objOptions).pollKeepConnection;
        options.pollInterval = ((SOSBaseOptions)this.objOptions).pollInterval;
        options.pollMinfiles = ((SOSBaseOptions)this.objOptions).pollMinfiles;
        options.pollingDuration = ((SOSBaseOptions)this.objOptions).pollingDuration;
        options.pollTimeout = ((SOSBaseOptions)this.objOptions).pollTimeout;
        options.maxFiles = ((SOSBaseOptions)this.objOptions).maxFiles;
        options.fileListName = ((SOSBaseOptions)this.objOptions).fileListName;
        options.filePath = ((SOSBaseOptions)this.objOptions).filePath;
        options.fileSpec = ((SOSBaseOptions)this.objOptions).fileSpec;
        options.forceFiles = ((SOSBaseOptions)this.objOptions).forceFiles;
        options.recursive = ((SOSBaseOptions)this.objOptions).recursive;
        options.skipTransfer = ((SOSBaseOptions)this.objOptions).skipTransfer;
        options.keepModificationDate = ((SOSBaseOptions)this.objOptions).keepModificationDate;
        options.verbose = ((SOSBaseOptions)this.objOptions).verbose;
        options.protocolCommandListener = ((SOSBaseOptions)this.objOptions).protocolCommandListener;
        options.zeroByteTransfer = ((SOSBaseOptions)this.objOptions).zeroByteTransfer;
        options.checkIntegrityHash = ((SOSBaseOptions)this.objOptions).checkIntegrityHash;
        options.integrityHashType = ((SOSBaseOptions)this.objOptions).integrityHashType;
        options.ssh_provider = ((SOSBaseOptions)this.objOptions).ssh_provider;
        options.webdav_provider = ((SOSBaseOptions)this.objOptions).webdav_provider;
        options.smb_provider = ((SOSBaseOptions)this.objOptions).smb_provider;
        return options;
    }

    private SOSBaseOptions addJADEOptionsForTarget(Operation operation, SOSBaseOptions options) {
        if (operation.equals((Object)Operation.remove)) {
            options.operation.setValue("delete");
            options.transactional.value(false);
            options.fileSpec.setValue("_not_exists_");
            options.atomicPrefix = ((SOSBaseOptions)this.objOptions).atomicPrefix;
            options.atomicSuffix = ((SOSBaseOptions)this.objOptions).atomicSuffix;
            options.bufferSize = ((SOSBaseOptions)this.objOptions).bufferSize;
            options.makeDirs.value(false);
            options.appendFiles.value(false);
            options.checkInterval = ((SOSBaseOptions)this.objOptions).checkInterval;
            options.checkRetry = ((SOSBaseOptions)this.objOptions).checkRetry;
            options.checkSize.value(false);
            options.forceFiles.value(false);
            options.overwriteFiles.value(true);
            options.recursive.value(false);
            options.skipTransfer.value(false);
            options.keepModificationDate = ((SOSBaseOptions)this.objOptions).keepModificationDate;
            options.verbose = ((SOSBaseOptions)this.objOptions).verbose;
            options.protocolCommandListener = ((SOSBaseOptions)this.objOptions).protocolCommandListener;
            options.zeroByteTransfer = ((SOSBaseOptions)this.objOptions).zeroByteTransfer;
            options.checkIntegrityHash.value(false);
            options.createIntegrityHashFile.value(false);
            options.integrityHashType = ((SOSBaseOptions)this.objOptions).integrityHashType;
        } else if (operation.equals((Object)Operation.getlist)) {
            options.operation.setValue("getlist");
            options.transactional.value(this.getTransactional().booleanValue());
            options.fileSpec.setValue(".*");
            options.atomicPrefix = ((SOSBaseOptions)this.objOptions).atomicPrefix;
            options.atomicSuffix = ((SOSBaseOptions)this.objOptions).atomicSuffix;
            options.bufferSize = ((SOSBaseOptions)this.objOptions).bufferSize;
            options.makeDirs = ((SOSBaseOptions)this.objOptions).makeDirs;
            options.appendFiles = ((SOSBaseOptions)this.objOptions).appendFiles;
            options.checkInterval = ((SOSBaseOptions)this.objOptions).checkInterval;
            options.checkRetry = ((SOSBaseOptions)this.objOptions).checkRetry;
            options.checkSize = ((SOSBaseOptions)this.objOptions).checkSize;
            options.forceFiles = ((SOSBaseOptions)this.objOptions).forceFiles;
            options.overwriteFiles = ((SOSBaseOptions)this.objOptions).overwriteFiles;
            options.recursive = ((SOSBaseOptions)this.objOptions).recursive;
            options.skipTransfer = ((SOSBaseOptions)this.objOptions).skipTransfer;
            options.keepModificationDate = ((SOSBaseOptions)this.objOptions).keepModificationDate;
            options.verbose = ((SOSBaseOptions)this.objOptions).verbose;
            options.protocolCommandListener = ((SOSBaseOptions)this.objOptions).protocolCommandListener;
            options.zeroByteTransfer = ((SOSBaseOptions)this.objOptions).zeroByteTransfer;
            options.checkIntegrityHash = ((SOSBaseOptions)this.objOptions).checkIntegrityHash;
            options.createIntegrityHashFile = ((SOSBaseOptions)this.objOptions).createIntegrityHashFile;
            options.integrityHashType = ((SOSBaseOptions)this.objOptions).integrityHashType;
        } else {
            options.operation.setValue("copy");
            options.transactional.value(this.getTransactional().booleanValue());
            options.fileSpec.setValue(".*");
            options.atomicPrefix = ((SOSBaseOptions)this.objOptions).atomicPrefix;
            options.atomicSuffix = ((SOSBaseOptions)this.objOptions).atomicSuffix;
            options.bufferSize = ((SOSBaseOptions)this.objOptions).bufferSize;
            options.makeDirs = ((SOSBaseOptions)this.objOptions).makeDirs;
            options.appendFiles = ((SOSBaseOptions)this.objOptions).appendFiles;
            options.checkInterval = ((SOSBaseOptions)this.objOptions).checkInterval;
            options.checkRetry = ((SOSBaseOptions)this.objOptions).checkRetry;
            options.checkSize = ((SOSBaseOptions)this.objOptions).checkSize;
            options.forceFiles = ((SOSBaseOptions)this.objOptions).forceFiles;
            options.overwriteFiles = ((SOSBaseOptions)this.objOptions).overwriteFiles;
            options.recursive = ((SOSBaseOptions)this.objOptions).recursive;
            options.skipTransfer = ((SOSBaseOptions)this.objOptions).skipTransfer;
            options.keepModificationDate = ((SOSBaseOptions)this.objOptions).keepModificationDate;
            options.verbose = ((SOSBaseOptions)this.objOptions).verbose;
            options.protocolCommandListener = ((SOSBaseOptions)this.objOptions).protocolCommandListener;
            options.zeroByteTransfer = ((SOSBaseOptions)this.objOptions).zeroByteTransfer;
            options.checkIntegrityHash = ((SOSBaseOptions)this.objOptions).checkIntegrityHash;
            options.createIntegrityHashFile = ((SOSBaseOptions)this.objOptions).createIntegrityHashFile;
            options.integrityHashType = ((SOSBaseOptions)this.objOptions).integrityHashType;
        }
        options.ssh_provider = ((SOSBaseOptions)this.objOptions).ssh_provider;
        options.webdav_provider = ((SOSBaseOptions)this.objOptions).webdav_provider;
        options.smb_provider = ((SOSBaseOptions)this.objOptions).smb_provider;
        return options;
    }

    private SOSBaseOptions addJADEOptionsOnClient(SOSBaseOptions options) {
        options.mailOnSuccess = ((SOSBaseOptions)this.objOptions).mailOnSuccess;
        options.mailOnError = ((SOSBaseOptions)this.objOptions).mailOnError;
        options.mailOnEmptyFiles = ((SOSBaseOptions)this.objOptions).mailOnEmptyFiles;
        options.setMailOptions(((SOSBaseOptions)this.objOptions).getMailOptions());
        options.sendTransferHistory = ((SOSBaseOptions)this.objOptions).sendTransferHistory;
        options.backgroundServiceHost = ((SOSBaseOptions)this.objOptions).backgroundServiceHost;
        options.backgroundServiceJobChainName = ((SOSBaseOptions)this.objOptions).backgroundServiceJobChainName;
        options.backgroundServicePort = ((SOSBaseOptions)this.objOptions).backgroundServicePort;
        options.schedulerHost = ((SOSBaseOptions)this.objOptions).schedulerHost;
        options.schedulerJobChain = ((SOSBaseOptions)this.objOptions).schedulerJobChain;
        options.schedulerPort = ((SOSBaseOptions)this.objOptions).schedulerPort;
        options.schedulerTransferMethod = ((SOSBaseOptions)this.objOptions).schedulerTransferMethod;
        options.history = ((SOSBaseOptions)this.objOptions).history;
        options.historyFileName = ((SOSBaseOptions)this.objOptions).historyFileName;
        options.historyFileAppendMode = ((SOSBaseOptions)this.objOptions).historyFileAppendMode;
        options.mandator = ((SOSBaseOptions)this.objOptions).mandator;
        options.compressFiles = ((SOSBaseOptions)this.objOptions).compressFiles;
        options.compressedFileExtension = ((SOSBaseOptions)this.objOptions).compressedFileExtension;
        options.cumulateFiles = ((SOSBaseOptions)this.objOptions).cumulateFiles;
        options.cumulativeFileName = ((SOSBaseOptions)this.objOptions).cumulativeFileName;
        options.cumulativeFileSeparator = ((SOSBaseOptions)this.objOptions).cumulativeFileSeparator;
        options.cumulativeFileDelete = ((SOSBaseOptions)this.objOptions).cumulativeFileDelete;
        options.expectedSizeOfResultSet = ((SOSBaseOptions)this.objOptions).expectedSizeOfResultSet;
        options.raiseErrorIfResultSetIs = ((SOSBaseOptions)this.objOptions).raiseErrorIfResultSetIs;
        options.logFilename = ((SOSBaseOptions)this.objOptions).logFilename;
        options.log4jPropertyFileName = ((SOSBaseOptions)this.objOptions).log4jPropertyFileName;
        options.resultSetFileName = ((SOSBaseOptions)this.objOptions).resultSetFileName;
        options.system_property_files = ((SOSBaseOptions)this.objOptions).system_property_files;
        options.ssh_provider = ((SOSBaseOptions)this.objOptions).ssh_provider;
        options.webdav_provider = ((SOSBaseOptions)this.objOptions).webdav_provider;
        options.smb_provider = ((SOSBaseOptions)this.objOptions).smb_provider;
        return options;
    }

    private String getJadeOnDMZCommand(Operation operation, SOSBaseOptions options) throws Exception {
        options.history.setValue("");
        options.getSource().user.setDefaultValue("");
        options.getTarget().user.setDefaultValue("");
        options.getSource().include.setValue("");
        options.getTarget().include.setValue("");
        options.getSource().keepass_attachment_property_name.setValue("");
        options.getTarget().keepass_attachment_property_name.setValue("");
        StringBuilder command = new StringBuilder(((SOSBaseOptions)this.objOptions).jumpCommand.getValue() + " ");
        command.append("-SendTransferHistory=false ");
        String c = command.toString().toLowerCase();
        if (c.contains(" -transactional=false") || c.contains(" -transactional=\"false\"")) {
            options.transactional.setValue("");
            options.atomicSuffix.setValue("");
            options.atomicPrefix.setValue("");
        } else if (c.contains(" -transactional=true") || c.contains(" -transactional=\"true\"")) {
            options.transactional.setValue("true");
        }
        command.append(options.getOptionsAsQuotedCommandLine());
        command.append(options.getSource().getOptionsAsQuotedCommandLine());
        if (!operation.equals((Object)Operation.remove)) {
            command.append(options.getTarget().getOptionsAsQuotedCommandLine());
        }
        return command.toString();
    }

    private String getJadeOnDMZCommand4RemoveSource() throws Exception {
        SOSBaseOptions opts = new SOSBaseOptions();
        opts.operation.setValue("delete");
        opts.verbose = ((SOSBaseOptions)this.objOptions).verbose;
        opts.fileListName.setValue(this.getSourceListFilename());
        opts.forceFiles.value(false);
        opts.ssh_provider.setValue(((SOSBaseOptions)this.objOptions).ssh_provider.getValue());
        ((SOSBaseOptions)this.objOptions).getSource().user.setDefaultValue("");
        ((SOSBaseOptions)this.objOptions).getSource().directory.setNotDirty();
        ((SOSBaseOptions)this.objOptions).getSource().postCommand.setNotDirty();
        ((SOSBaseOptions)this.objOptions).getSource().postTransferCommands.setNotDirty();
        ((SOSBaseOptions)this.objOptions).getSource().postFtpCommands.setNotDirty();
        ((SOSBaseOptions)this.objOptions).getSource().preCommand.setNotDirty();
        ((SOSBaseOptions)this.objOptions).getSource().preFtpCommands.setNotDirty();
        ((SOSBaseOptions)this.objOptions).getSource().preTransferCommands.setNotDirty();
        ((SOSBaseOptions)this.objOptions).getSource().tfnPostCommand.setNotDirty();
        StringBuilder command = new StringBuilder(((SOSBaseOptions)this.objOptions).jumpCommand.getValue() + " ");
        ((SOSBaseOptions)this.objOptions).getSource().postTransferCommandsFinal.setNotDirty();
        command.append("-SendTransferHistory=false ");
        command.append(opts.getOptionsAsQuotedCommandLine());
        command.append(((SOSBaseOptions)this.objOptions).getSource().getOptionsAsQuotedCommandLine());
        return command.toString();
    }

    public SOSFileList getFileList() {
        return this.fileList;
    }

    public SOSBaseOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new SOSBaseOptions();
        }
        return (SOSBaseOptions)this.objOptions;
    }

    private String normalizeDirectoryPath(String path) {
        return (path = path.replaceAll("\\\\", "/")).endsWith("/") ? path : path + "/";
    }

    private String getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        return this.uuid;
    }

    private String getSourceListFilename() {
        if (this.sourceListFilename == null) {
            this.sourceListFilename = this.normalizeDirectoryPath(((SOSBaseOptions)this.objOptions).jumpDir.getValue()) + "jade-dmz-" + this.getUUID() + ".source.tmp";
        }
        return this.sourceListFilename;
    }

    private String getHistoryFilename() {
        if (this.historyFilename == null) {
            this.historyFilename = this.normalizeDirectoryPath(((SOSBaseOptions)this.objOptions).jumpDir.getValue()) + "jade-dmz-" + this.getUUID() + ".history.csv";
        }
        return this.historyFilename;
    }

    private Boolean getTransactional() {
        if (this.transactional == null) {
            this.transactional = ((SOSBaseOptions)this.objOptions).transactional.isDirty() ? Boolean.valueOf(((SOSBaseOptions)this.objOptions).transactional.value()) : Boolean.valueOf(true);
        }
        return this.transactional;
    }

    public void setHistory(YadeHistory h) {
        this.history = h;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public String getJumpDir() {
        return this.jumpDir;
    }

    protected static enum Operation {
        copyToInternet,
        copyFromInternet,
        remove,
        getlist;

    }
}

