/*
 * Decompiled with CFR 0.152.
 */
package com.sos.DataExchange;

import com.sos.DataExchange.converter.JadeXml2IniConverter;
import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.vfs.common.options.SOSBaseOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class JadeBaseEngine
extends JSJobUtilitiesClass<SOSBaseOptions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JadeBaseEngine.class);
    public static final String SCHEMA_RESSOURCE_NAME = "YADE_configuration_v1.12.xsd";
    private boolean isLoggerConfigured = false;

    public JadeBaseEngine() {
    }

    public JadeBaseEngine(SOSBaseOptions opt) {
        super((Object)opt);
        this.setProvidersFromEnv();
        if (((SOSBaseOptions)this.objOptions).settings.isDirty()) {
            CLIArgCache cache = new CLIArgCache();
            ((SOSBaseOptions)this.objOptions).setOptions(this.setOptionsFromFile());
            cache.restoreOptions();
            ((SOSBaseOptions)this.objOptions).settings.setNotDirty();
        } else if (((SOSBaseOptions)this.objOptions).operation.isDirty()) {
            ((SOSBaseOptions)this.objOptions).setChildClasses(((SOSBaseOptions)this.objOptions).getSettings());
        }
    }

    private void setProvidersFromEnv() {
        String val;
        if (!((SOSBaseOptions)this.objOptions).ssh_provider.isDirty() && (val = SOSBaseOptions.getSSHProviderFromEnv()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("set ssh_provider=%s from environment", val));
            }
            ((SOSBaseOptions)this.objOptions).ssh_provider.setValue(val);
        }
        if (!((SOSBaseOptions)this.objOptions).webdav_provider.isDirty() && (val = SOSBaseOptions.getWEBDAVProviderFromEnv()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("set webdav_provider=%s from environment", val));
            }
            ((SOSBaseOptions)this.objOptions).webdav_provider.setValue(val);
        }
        if (!((SOSBaseOptions)this.objOptions).smb_provider.isDirty() && (val = SOSBaseOptions.getSMBProviderFromEnv()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("set smb_provider=%s from environment", val));
            }
            ((SOSBaseOptions)this.objOptions).smb_provider.setValue(val);
        }
    }

    public void setLogger() {
        if (this.isLoggerConfigured) {
            return;
        }
        this.getLoggerContext();
        Level level = this.checkLevel();
        if (level == null) {
            this.isLoggerConfigured = true;
            return;
        }
        if (level.equals((Object)Level.INFO)) {
            Configurator.setRootLevel((Level)Level.INFO);
        } else if (level.equals((Object)Level.DEBUG)) {
            Configurator.setRootLevel((Level)Level.DEBUG);
            Configurator.setLevel((String)"com.mchange", (Level)Level.INFO);
            Configurator.setLevel((String)"org.hibernate", (Level)Level.INFO);
            Configurator.setLevel((String)"org.hibernate.persister.entity.AbstractEntityPersister", (Level)Level.DEBUG);
            Configurator.setLevel((String)"org.hibernate.SQL", (Level)Level.DEBUG);
            Configurator.setLevel((String)"org.hibernate.loader.entity.plan.EntityLoader", (Level)Level.DEBUG);
            LOGGER.debug(String.format("set loglevel to DEBUG due to option verbose = %s", ((SOSBaseOptions)this.objOptions).verbose.value()));
        } else if (level.equals((Object)Level.TRACE)) {
            Configurator.setRootLevel((Level)Level.TRACE);
            Configurator.setLevel((String)"com.mchange", (Level)Level.INFO);
            Configurator.setLevel((String)"org.hibernate", (Level)Level.INFO);
            Configurator.setLevel((String)"org.hibernate.persister.entity.AbstractEntityPersister", (Level)Level.DEBUG);
            Configurator.setLevel((String)"org.hibernate.type.descriptor.sql", (Level)Level.TRACE);
            Configurator.setLevel((String)"org.hibernate.SQL", (Level)Level.DEBUG);
            Configurator.setLevel((String)"org.hibernate.loader.entity.plan.EntityLoader", (Level)Level.DEBUG);
            LOGGER.debug(String.format("set loglevel to TRACE due to option verbose = %s", ((SOSBaseOptions)this.objOptions).verbose.value()));
        }
        this.isLoggerConfigured = true;
    }

    private LoggerContext getLoggerContext() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        if (((SOSBaseOptions)this.getOptions()).log4jPropertyFileName.isDirty()) {
            File log4j = new File(((SOSBaseOptions)this.getOptions()).log4jPropertyFileName.getValue());
            if (log4j.isFile() && log4j.canRead()) {
                LOGGER.info(String.format("use log4j configuration file %s", ((SOSBaseOptions)this.getOptions()).log4jPropertyFileName.getValue()));
                context.setConfigLocation(log4j.toURI());
                context.updateLoggers();
            } else {
                LOGGER.warn(String.format("log4j configuration file %s not found or is not readable", ((SOSBaseOptions)this.getOptions()).log4jPropertyFileName.getValue()));
            }
        }
        return context;
    }

    private Level checkLevel() {
        Level level = null;
        int verbose = ((SOSBaseOptions)this.objOptions).verbose.value();
        if (verbose <= 1) {
            if (!LOGGER.isInfoEnabled()) {
                level = Level.INFO;
            }
        } else if (verbose > 8) {
            if (!LOGGER.isTraceEnabled()) {
                level = Level.TRACE;
            }
        } else if (!LOGGER.isDebugEnabled()) {
            level = Level.DEBUG;
        }
        return level;
    }

    private HashMap<String, String> setOptionsFromFile() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[setOptionsFromFile]settings=%s", ((SOSBaseOptions)this.objOptions).settings.getValue()));
        }
        String config = ((SOSBaseOptions)this.objOptions).settings.getValue();
        ((SOSBaseOptions)this.objOptions).setOriginalSettingsFile(config);
        ((SOSBaseOptions)this.objOptions).setDeleteSettingsFileOnExit(false);
        if (config.toLowerCase().endsWith(".xml")) {
            Path iniFile = this.convertXml2Ini(config);
            ((SOSBaseOptions)this.objOptions).settings.setValue(iniFile.toString());
            ((SOSBaseOptions)this.objOptions).setDeleteSettingsFileOnExit(true);
        }
        return ((SOSBaseOptions)this.objOptions).readSettingsFile(null);
    }

    public Path convertXml2Ini(String xmlFile) {
        String method = "convertXml2Ini";
        LOGGER.debug(String.format("%s: xmlFile=%s", method, xmlFile));
        InputStream schemaStream = null;
        Path tmpIniFile = null;
        try {
            schemaStream = this.loadSchemaFromJar();
            if (schemaStream == null) {
                throw new Exception(String.format("schema(%s) stream from the jar file is null", SCHEMA_RESSOURCE_NAME));
            }
            tmpIniFile = Files.createTempFile("sos.yade_settings_", ".ini", new FileAttribute[0]);
            JadeXml2IniConverter converter = new JadeXml2IniConverter();
            converter.process(new InputSource(schemaStream), xmlFile, tmpIniFile.toString());
            LOGGER.debug(String.format("%s: converted to %s", method, tmpIniFile.toString()));
            Path path = tmpIniFile;
            return path;
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s: exception=%s", method, e.toString()), (Throwable)e);
            if (tmpIniFile != null) {
                try {
                    Files.deleteIfExists(tmpIniFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new JobSchedulerException((Throwable)e);
        }
        finally {
            if (schemaStream != null) {
                try {
                    schemaStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private InputStream loadSchemaFromJar() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = Class.class.getClassLoader();
        }
        try {
            URL url = cl.getResource(SCHEMA_RESSOURCE_NAME);
            LOGGER.debug(String.format("loadSchemaFromJar: schema=%s", url.toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cl.getResourceAsStream(SCHEMA_RESSOURCE_NAME);
    }

    private class CLIArgCache {
        private final String filePath;
        private final String fileSpec;
        private final String fileListName;
        private final String sourceDir;
        private final String sourceExcludedDirectories;
        private final String targetDir;
        private final String sshProvider;
        private final String webDAVProvider;
        private final String smbProvider;

        private CLIArgCache() {
            this.filePath = ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).filePath.isDirty() ? ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).filePath.getValue() : null;
            this.fileSpec = ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).fileSpec.isDirty() ? ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).fileSpec.getValue() : null;
            this.fileListName = ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).fileListName.isDirty() ? ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).fileListName.getValue() : null;
            this.sourceDir = ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).sourceDir.isDirty() ? ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).sourceDir.getValue() : null;
            this.sourceExcludedDirectories = ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).sourceExcludedDirectories.isDirty() ? ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).sourceExcludedDirectories.getValue() : null;
            this.targetDir = ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).targetDir.isDirty() ? ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).targetDir.getValue() : null;
            this.sshProvider = ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).ssh_provider.isDirty() ? ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).ssh_provider.getValue() : null;
            this.webDAVProvider = ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).webdav_provider.isDirty() ? ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).webdav_provider.getValue() : null;
            this.smbProvider = ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).smb_provider.isDirty() ? ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).smb_provider.getValue() : null;
        }

        private void restoreOptions() {
            if (this.filePath != null) {
                ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).filePath.setValue(this.filePath);
            }
            if (this.fileSpec != null) {
                ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).fileSpec.setValue(this.fileSpec);
            }
            if (this.fileListName != null) {
                ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).fileListName.setValue(this.fileListName);
            }
            if (this.sourceDir != null) {
                ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).sourceDir.setValue(this.sourceDir);
                try {
                    if (((SOSBaseOptions)JadeBaseEngine.this.objOptions).getSource() != null) {
                        ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).getSource().directory.setValue(this.sourceDir);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.sourceExcludedDirectories != null) {
                ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).sourceExcludedDirectories.setValue(this.sourceExcludedDirectories);
                try {
                    if (((SOSBaseOptions)JadeBaseEngine.this.objOptions).getSource() != null) {
                        ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).getSource().excluded_directories.setValue(this.sourceExcludedDirectories);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.targetDir != null) {
                ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).targetDir.setValue(this.targetDir);
                try {
                    if (((SOSBaseOptions)JadeBaseEngine.this.objOptions).getTarget() != null) {
                        ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).getTarget().directory.setValue(this.targetDir);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.sshProvider != null) {
                ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).ssh_provider.setValue(this.sshProvider);
            }
            if (this.webDAVProvider != null) {
                ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).webdav_provider.setValue(this.webDAVProvider);
            }
            if (this.smbProvider != null) {
                ((SOSBaseOptions)((JadeBaseEngine)JadeBaseEngine.this).objOptions).smb_provider.setValue(this.smbProvider);
            }
        }
    }
}

