/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.checkblacklist;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jitl.checkblacklist.JobSchedulerCheckBlacklistOptions;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Job;
import sos.spooler.Job_chain;
import sos.spooler.Order;
import sos.spooler.Variable_set;

public class JobSchedulerCheckBlacklistJSAdapterClass
extends JobSchedulerJobAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerCheckBlacklistJSAdapterClass.class);
    private DocumentBuilder docBuilder;
    private JobSchedulerCheckBlacklistOptions jobSchedulerCheckBlacklistOptions;
    private int counter;

    public boolean spooler_init() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = docFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            try {
                LOGGER.error("Error occured during initialisation: " + e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return super.spooler_init();
    }

    public boolean spooler_process() throws Exception {
        try {
            super.spooler_process();
            this.doProcessing();
            return this.getSpoolerProcess().isOrderJob();
        }
        catch (Exception e) {
            throw new JobSchedulerException("Fatal Error:" + e.getMessage(), (Throwable)e);
        }
    }

    private void doProcessing() throws Exception {
        this.jobSchedulerCheckBlacklistOptions = new JobSchedulerCheckBlacklistOptions();
        this.jobSchedulerCheckBlacklistOptions.setCurrentNodeName(this.getCurrentNodeName(this.getSpoolerProcess().getOrder(), true));
        this.jobSchedulerCheckBlacklistOptions.setAllOptions(this.getSchedulerParameterAsProperties(this.getSpoolerProcess().getOrder()));
        this.jobSchedulerCheckBlacklistOptions.checkMandatory();
        this.checkBlacklist();
    }

    private void checkBlacklist() throws Exception {
        try {
            Node answerNode;
            String answer = this.spooler.execute_xml("<show_state what=\"job_chain_orders,blacklist\"/>");
            Document spoolerDocument = this.docBuilder.parse(new ByteArrayInputStream(answer.getBytes()));
            Element spoolerElement = spoolerDocument.getDocumentElement();
            for (answerNode = spoolerElement.getFirstChild(); answerNode != null && answerNode.getNodeType() != 1; answerNode = answerNode.getNextSibling()) {
            }
            if (answerNode == null) {
                throw new JobSchedulerException("answer contains no xml elements, is null");
            }
            Element answerElement = (Element)answerNode;
            if (!"answer".equals(answerElement.getNodeName())) {
                throw new JobSchedulerException("element <answer> is missing");
            }
            NodeList schedulerNodes = answerElement.getElementsByTagName("blacklist");
            LOGGER.debug(schedulerNodes.getLength() + " blacklists found.");
            this.counter = schedulerNodes.getLength();
            if ("blacklist".equalsIgnoreCase(this.jobSchedulerCheckBlacklistOptions.granuality.getValue())) {
                this.execute("There are orders in " + schedulerNodes.getLength() + " blacklists", null);
            } else {
                for (int i = 0; i < schedulerNodes.getLength(); ++i) {
                    Node blacklistNode = schedulerNodes.item(i);
                    if (blacklistNode == null || blacklistNode.getNodeType() != 1) continue;
                    Element blacklist = (Element)blacklistNode;
                    this.handleBlacklistEntry(blacklist);
                }
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException("Error occured checking blacklists: " + e, (Throwable)e);
        }
    }

    private void handleBlacklistEntry(Element blacklist) throws Exception {
        NodeList blacklistOrders = blacklist.getElementsByTagName("order");
        LOGGER.info(blacklistOrders.getLength() + " orders in blacklists found.");
        for (int i = 0; i < blacklistOrders.getLength(); ++i) {
            Node orderNode = blacklistOrders.item(i);
            if (orderNode == null || orderNode.getNodeType() != 1) continue;
            Element order = (Element)orderNode;
            BlackList b = new BlackList();
            b.job_chain = order.getAttribute("job_chain");
            b.id = "";
            b.created = "";
            if ("order".equalsIgnoreCase(this.jobSchedulerCheckBlacklistOptions.granuality.getValue())) {
                b.id = order.getAttribute("id");
                b.created = order.getAttribute("created");
                this.execute("Blacklist found for job_chain:" + b.job_chain + " file=" + b.id + "; created:" + b.created, b);
                continue;
            }
            this.execute(blacklistOrders.getLength() + " order found in Blacklist for job_chain:" + this.jobSchedulerCheckBlacklistOptions.job_chain.getValue(), b);
            break;
        }
    }

    private void execute(String s, BlackList b) throws Exception {
        String level = this.jobSchedulerCheckBlacklistOptions.level.getValue();
        String job = this.jobSchedulerCheckBlacklistOptions.job.getValue();
        String jobChain = this.jobSchedulerCheckBlacklistOptions.job_chain.getValue();
        if ("info".equalsIgnoreCase(level)) {
            LOGGER.info(s);
        }
        if ("warning".equalsIgnoreCase(level)) {
            LOGGER.warn(s);
        }
        if ("error".equalsIgnoreCase(level)) {
            LOGGER.error(s);
        }
        if (this.counter > 0) {
            if (!"".equals(job)) {
                Job j = this.spooler.job(job);
                if (j != null) {
                    if (b != null) {
                        Variable_set p = this.spooler.create_variable_set();
                        p.merge(this.spooler_task.params());
                        p.set_var("filename", b.id);
                        p.set_var("blacklist_job_chain", b.job_chain);
                        p.set_var("created", b.created);
                        j.start(p);
                    } else {
                        j.start(this.spooler.create_variable_set());
                    }
                } else {
                    LOGGER.warn("Job: " + job + " unknown");
                }
            }
            if (!"".equalsIgnoreCase(jobChain)) {
                Job_chain jc = this.spooler.job_chain(jobChain);
                if (jc != null) {
                    Order o = this.spooler.create_order();
                    if (b != null) {
                        o.params().merge(this.spooler_task.params());
                        o.params().set_var("filename", b.id);
                        o.params().set_var("blacklist_job_chain", b.job_chain);
                        o.params().set_var("created", b.created);
                    }
                    jc.add_order(o);
                } else {
                    LOGGER.warn("Job_chain: " + jobChain + " unknown");
                }
            }
        }
    }

    private class BlackList {
        protected String id;
        protected String job_chain;
        protected String created;

        private BlackList() {
        }
    }
}

