/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.checkhistory;

import com.sos.exception.SOSException;
import com.sos.jitl.checkhistory.HistoryHelper;
import com.sos.jitl.checkhistory.JobSchedulerHistoryInfo;
import com.sos.jitl.checkhistory.classes.HistoryDataSource;
import com.sos.jitl.checkhistory.classes.HistoryWebserviceExecuter;
import com.sos.jitl.checkhistory.interfaces.IJobSchedulerHistory;
import com.sos.jitl.checkhistory.interfaces.IJobSchedulerHistoryInfo;
import com.sos.jitl.restclient.WebserviceCredentials;
import com.sos.scheduler.model.answers.HistoryEntry;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Spooler;

public class JobHistory
implements IJobSchedulerHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobHistory.class);
    private HistoryEntry lastCompletedHistoryEntry = null;
    private HistoryEntry lastRunningHistoryEntry = null;
    private HistoryEntry lastCompletedSuccessfullHistoryEntry = null;
    private HistoryEntry lastCompletedWithErrorHistoryEntry = null;
    private String timeLimit;
    private HistoryHelper jobHistoryHelper = new HistoryHelper();
    private String actHistoryObjectName = "";
    private String relativePath;
    private WebserviceCredentials webserviceCredentials;
    private HistoryDataSource historyDatasourceExecuter;

    public JobHistory(WebserviceCredentials webserviceCredentials) {
        this.webserviceCredentials = webserviceCredentials;
        this.timeLimit = "";
    }

    public JobHistory(Spooler spooler) {
        this.webserviceCredentials = new WebserviceCredentials();
        String jocUser = spooler.variables().value("joc_user");
        this.webserviceCredentials.setJocUrl(spooler.variables().value("joc_url"));
        this.webserviceCredentials.setAccessToken(spooler.variables().value(jocUser + "_X-Access-Token"));
        this.webserviceCredentials.setUser(jocUser);
        this.webserviceCredentials.setKeyPassword(spooler.variables().value("key_password"));
        this.webserviceCredentials.setKeyStorePassword(spooler.variables().value("keystore_password"));
        this.webserviceCredentials.setKeyStorePath(spooler.variables().value("keystore_path"));
        this.webserviceCredentials.setKeyStoreType(spooler.variables().value("keystore_type"));
        this.webserviceCredentials.setTrustStorePassword(spooler.variables().value("truststore_password"));
        this.webserviceCredentials.setTrustStorePath(spooler.variables().value("truststore_path"));
        this.webserviceCredentials.setTrustStoreType(spooler.variables().value("truststore_type"));
        this.webserviceCredentials.setSchedulerId(spooler.id());
        this.timeLimit = "";
    }

    public JobSchedulerHistoryInfo getJobInfo(String jobName) throws Exception {
        try {
            return (JobSchedulerHistoryInfo)this.getJobSchedulerHistoryInfo(jobName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public JobSchedulerHistoryInfo getJobInfo(String jobName, String timeLimit_) throws Exception {
        try {
            return (JobSchedulerHistoryInfo)this.getJobSchedulerHistoryInfo(jobName, timeLimit_);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public IJobSchedulerHistoryInfo getJobSchedulerHistoryInfo(String jobName) throws Exception {
        this.lastCompletedHistoryEntry = null;
        this.lastRunningHistoryEntry = null;
        this.lastCompletedSuccessfullHistoryEntry = null;
        this.lastCompletedWithErrorHistoryEntry = null;
        return this.jobSchedulerHistoryInfo(jobName);
    }

    public IJobSchedulerHistoryInfo getJobSchedulerHistoryInfo(String jobName, String timeLimit_) throws Exception {
        this.lastCompletedHistoryEntry = null;
        this.lastRunningHistoryEntry = null;
        this.lastCompletedSuccessfullHistoryEntry = null;
        this.lastCompletedWithErrorHistoryEntry = null;
        this.timeLimit = timeLimit_;
        return this.jobSchedulerHistoryInfo(jobName);
    }

    public IJobSchedulerHistoryInfo jobSchedulerHistoryInfo(String jobName) throws Exception {
        this.getHistoryByWebServiceCall(jobName);
        JobSchedulerHistoryInfo jobHistoryInfo = new JobSchedulerHistoryInfo();
        if (this.lastCompletedHistoryEntry != null) {
            jobHistoryInfo.lastCompleted.found = true;
            jobHistoryInfo.lastCompleted.top = this.lastRunningHistoryEntry == null || this.lastRunningHistoryEntry.getTaskId() == null || this.lastRunningHistoryEntry.getTaskId().compareTo(this.lastCompletedHistoryEntry.getTaskId()) <= 0;
            jobHistoryInfo.lastCompleted.errorMessage = this.lastCompletedHistoryEntry.getErrorText();
            jobHistoryInfo.lastCompleted.executionResult = this.jobHistoryHelper.big2int(this.lastCompletedHistoryEntry.getExitCode());
            jobHistoryInfo.lastCompleted.start = this.jobHistoryHelper.getDateFromString(this.lastCompletedHistoryEntry.getStartTime());
            jobHistoryInfo.lastCompleted.end = this.jobHistoryHelper.getDateFromString(this.lastCompletedHistoryEntry.getEndTime());
            jobHistoryInfo.lastCompleted.error = this.jobHistoryHelper.big2int(this.lastCompletedHistoryEntry.getError());
            jobHistoryInfo.lastCompleted.errorCode = this.lastCompletedHistoryEntry.getErrorCode();
            jobHistoryInfo.lastCompleted.id = this.jobHistoryHelper.big2int(this.lastCompletedHistoryEntry.getId());
            jobHistoryInfo.lastCompleted.jobName = this.lastCompletedHistoryEntry.getJobName();
            jobHistoryInfo.lastCompleted.duration = this.jobHistoryHelper.getDuration(jobHistoryInfo.lastCompleted.start, jobHistoryInfo.lastCompleted.end);
        } else {
            jobHistoryInfo.lastCompleted.found = false;
            LOGGER.debug(String.format("no completed job run found for the job:%s", jobName));
        }
        if (this.lastCompletedSuccessfullHistoryEntry != null) {
            jobHistoryInfo.lastCompletedSuccessful.found = true;
            jobHistoryInfo.lastCompletedSuccessful.top = !(this.lastRunningHistoryEntry != null && this.lastRunningHistoryEntry.getTaskId() != null && this.lastRunningHistoryEntry.getTaskId().compareTo(this.lastCompletedSuccessfullHistoryEntry.getTaskId()) > 0 || this.lastCompletedWithErrorHistoryEntry != null && this.lastCompletedWithErrorHistoryEntry.getTaskId() != null && this.lastCompletedWithErrorHistoryEntry.getTaskId().compareTo(this.lastCompletedSuccessfullHistoryEntry.getTaskId()) > 0);
            jobHistoryInfo.lastCompletedSuccessful.errorMessage = this.lastCompletedSuccessfullHistoryEntry.getErrorText();
            jobHistoryInfo.lastCompletedSuccessful.executionResult = this.jobHistoryHelper.big2int(this.lastCompletedSuccessfullHistoryEntry.getExitCode());
            jobHistoryInfo.lastCompletedSuccessful.start = this.jobHistoryHelper.getDateFromString(this.lastCompletedSuccessfullHistoryEntry.getStartTime());
            jobHistoryInfo.lastCompletedSuccessful.end = this.jobHistoryHelper.getDateFromString(this.lastCompletedSuccessfullHistoryEntry.getEndTime());
            jobHistoryInfo.lastCompletedSuccessful.error = this.jobHistoryHelper.big2int(this.lastCompletedSuccessfullHistoryEntry.getError());
            jobHistoryInfo.lastCompletedSuccessful.errorCode = this.lastCompletedSuccessfullHistoryEntry.getErrorCode();
            jobHistoryInfo.lastCompletedSuccessful.id = this.jobHistoryHelper.big2int(this.lastCompletedSuccessfullHistoryEntry.getId());
            jobHistoryInfo.lastCompletedSuccessful.jobName = this.lastCompletedSuccessfullHistoryEntry.getJobName();
            jobHistoryInfo.lastCompletedSuccessful.duration = this.jobHistoryHelper.getDuration(jobHistoryInfo.lastCompletedSuccessful.start, jobHistoryInfo.lastCompletedSuccessful.end);
        } else {
            jobHistoryInfo.lastCompletedSuccessful.found = false;
            LOGGER.debug(String.format("no successfull job run found for the job:%s", jobName));
        }
        if (this.lastCompletedWithErrorHistoryEntry != null) {
            jobHistoryInfo.lastCompletedWithError.found = true;
            jobHistoryInfo.lastCompletedWithError.top = !(this.lastRunningHistoryEntry != null && this.lastRunningHistoryEntry.getTaskId() != null && this.lastRunningHistoryEntry.getTaskId().compareTo(this.lastCompletedWithErrorHistoryEntry.getTaskId()) > 0 || this.lastCompletedSuccessfullHistoryEntry != null && this.lastCompletedSuccessfullHistoryEntry.getTaskId() != null && this.lastCompletedSuccessfullHistoryEntry.getTaskId().compareTo(this.lastCompletedWithErrorHistoryEntry.getTaskId()) > 0);
            jobHistoryInfo.lastCompletedWithError.errorMessage = this.lastCompletedWithErrorHistoryEntry.getErrorText();
            jobHistoryInfo.lastCompletedWithError.executionResult = this.jobHistoryHelper.big2int(this.lastCompletedWithErrorHistoryEntry.getExitCode());
            jobHistoryInfo.lastCompletedWithError.start = this.jobHistoryHelper.getDateFromString(this.lastCompletedWithErrorHistoryEntry.getStartTime());
            jobHistoryInfo.lastCompletedWithError.end = this.jobHistoryHelper.getDateFromString(this.lastCompletedWithErrorHistoryEntry.getEndTime());
            jobHistoryInfo.lastCompletedWithError.error = this.jobHistoryHelper.big2int(this.lastCompletedWithErrorHistoryEntry.getError());
            jobHistoryInfo.lastCompletedWithError.errorCode = this.lastCompletedWithErrorHistoryEntry.getErrorCode();
            jobHistoryInfo.lastCompletedWithError.id = this.jobHistoryHelper.big2int(this.lastCompletedWithErrorHistoryEntry.getId());
            jobHistoryInfo.lastCompletedWithError.jobName = this.lastCompletedWithErrorHistoryEntry.getJobName();
            jobHistoryInfo.lastCompletedWithError.duration = this.jobHistoryHelper.getDuration(jobHistoryInfo.lastCompletedWithError.start, jobHistoryInfo.lastCompletedWithError.end);
        } else {
            jobHistoryInfo.lastCompletedWithError.found = false;
            LOGGER.debug(String.format("no job runs with error found for the job:%s", jobName));
        }
        if (this.lastRunningHistoryEntry != null) {
            jobHistoryInfo.running.found = true;
            jobHistoryInfo.running.top = !jobHistoryInfo.lastCompleted.top;
            jobHistoryInfo.running.errorMessage = this.lastRunningHistoryEntry.getErrorText();
            jobHistoryInfo.running.executionResult = this.jobHistoryHelper.big2int(this.lastRunningHistoryEntry.getExitCode());
            jobHistoryInfo.running.start = this.jobHistoryHelper.getDateFromString(this.lastRunningHistoryEntry.getStartTime());
            jobHistoryInfo.running.end = null;
            jobHistoryInfo.running.error = this.jobHistoryHelper.big2int(this.lastRunningHistoryEntry.getError());
            jobHistoryInfo.running.errorCode = this.lastRunningHistoryEntry.getErrorCode();
            jobHistoryInfo.running.id = this.jobHistoryHelper.big2int(this.lastRunningHistoryEntry.getId());
            jobHistoryInfo.running.jobName = this.lastRunningHistoryEntry.getJobName();
            jobHistoryInfo.running.duration = "";
        } else {
            jobHistoryInfo.running.found = false;
            LOGGER.debug(String.format("no running jobs found for the job:%s", jobName));
        }
        return jobHistoryInfo;
    }

    private void createDatasource() throws SOSException, URISyntaxException {
        if (this.historyDatasourceExecuter == null) {
            this.historyDatasourceExecuter = new HistoryWebserviceExecuter(this.webserviceCredentials);
            this.historyDatasourceExecuter.login(this.webserviceCredentials.getAccessToken());
        }
    }

    private void getHistoryByWebServiceCall(String jobName) throws Exception {
        this.actHistoryObjectName = jobName = this.jobHistoryHelper.normalizePath(this.relativePath, jobName);
        this.createDatasource();
        this.historyDatasourceExecuter.setTimeLimit(this.timeLimit);
        this.historyDatasourceExecuter.setJobName(jobName);
        this.historyDatasourceExecuter.setSchedulerId(this.webserviceCredentials.getSchedulerId());
        this.lastCompletedSuccessfullHistoryEntry = this.historyDatasourceExecuter.getLastCompletedSuccessfullJobHistoryEntry();
        this.lastCompletedHistoryEntry = this.historyDatasourceExecuter.getLastCompletedJobHistoryEntry();
        this.lastCompletedWithErrorHistoryEntry = this.historyDatasourceExecuter.getLastCompletedWithErrorJobHistoryEntry();
        this.lastRunningHistoryEntry = this.historyDatasourceExecuter.getLastRunningJobHistoryEntry();
    }

    public String getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public void setTimeLimit(String timeLimit) {
        this.timeLimit = timeLimit;
    }

    @Override
    public String getActHistoryObjectName() {
        return this.actHistoryObjectName;
    }

    @Override
    public void setRelativePath(String relativePath_) {
        if (!relativePath_.startsWith("/")) {
            relativePath_ = "/" + relativePath_;
        }
        this.relativePath = relativePath_ = relativePath_.replace('\\', '/');
    }

    @Override
    public WebserviceCredentials getWebserviceCredentials() {
        return this.webserviceCredentials;
    }

    public void setHistoryDatasourceExecuter(HistoryDataSource historyDatasourceExecuter) {
        this.historyDatasourceExecuter = historyDatasourceExecuter;
    }
}

