/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.checkhistory.classes;

import com.sos.jitl.checkhistory.classes.HistoryDataSource;
import com.sos.jitl.checkhistory.classes.HistoryInterval;
import com.sos.jitl.restclient.WebserviceCredentials;
import com.sos.joc.model.order.OrderHistoryItem;
import com.sos.scheduler.model.answers.HistoryEntry;
import com.sos.scheduler.model.answers.JobChain;
import java.math.BigInteger;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryWebserviceExecuter
extends HistoryDataSource {
    private static final String JOB_STRING_FOR_WEBSERVICE = "{'jobschedulerId':'%s','limit':1,'jobs':[{'job':'%s'}],'historyStates':";
    private static final String JOB_CHAIN_ORDER_STRING_FOR_WEBSERVICE = "{'jobschedulerId':'%s','limit':1,'orders':[{'jobChain':'%s','orderId':'%s'}],'historyStates':";
    private static final String JOB_CHAIN_STRING_FOR_WEBSERVICE = "{'jobschedulerId':'%s','limit':1,'orders':[{'jobChain':'%s'}],'historyStates':";
    private static final String JOB_CHAIN_ORDER_HISTORY_STRING_FOR_WEBSERVICE = "{'jobschedulerId':'%s','historyIds':['%s']}";
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryWebserviceExecuter.class);

    public HistoryWebserviceExecuter(WebserviceCredentials webserviceCredentials) {
        super(webserviceCredentials);
    }

    @Override
    public HistoryEntry getJobHistoryEntry(String state) throws Exception {
        String body;
        if (this.accessToken.isEmpty()) {
            throw new Exception("AccessToken is empty. Login not executed");
        }
        if (!"".equals(this.timeLimit)) {
            HistoryInterval historyInterval = this.historyHelper.getUTCIntervalFromTimeLimit(this.timeLimit);
            historyInterval.getUtcFrom();
            body = String.format(JOB_STRING_FOR_WEBSERVICE, this.schedulerId, this.jobName) + "[" + state + "],'dateFrom':'" + historyInterval.getUtcFrom() + "','dateTo':'" + historyInterval.getUtcTo() + "'}";
        } else {
            body = String.format(JOB_STRING_FOR_WEBSERVICE, this.schedulerId, this.jobName) + "[" + state + "]}";
        }
        body = body.replace("'", "\"");
        String answer = this.jobSchedulerRestApiClient.postRestService(new URI(this.webserviceCredentials.getJocUrl() + "/tasks/history"), body);
        HistoryEntry h = this.json2HistoryEntry(answer);
        if (h.getId() == null) {
            return null;
        }
        return this.json2HistoryEntry(answer);
    }

    @Override
    public JobChain.OrderHistory.Order getJobChainHistoryEntry(String state) throws Exception {
        String body;
        if (this.accessToken.isEmpty()) {
            throw new Exception("AccessToken is empty. Login not executed");
        }
        if (!"".equals(this.timeLimit)) {
            HistoryInterval historyInterval = this.historyHelper.getUTCIntervalFromTimeLimit(this.timeLimit);
            historyInterval.getUtcFrom();
            body = this.orderId == null || this.orderId.isEmpty() ? String.format(JOB_CHAIN_STRING_FOR_WEBSERVICE, this.schedulerId, this.jobChainName) + "[" + state + "],'dateFrom':'" + historyInterval.getUtcFrom() + "','dateTo':'" + historyInterval.getUtcTo() + "'}" : String.format(JOB_CHAIN_ORDER_STRING_FOR_WEBSERVICE, this.schedulerId, this.jobChainName, this.orderId) + "[" + state + "],'dateFrom':'" + historyInterval.getUtcFrom() + "','dateTo':'" + historyInterval.getUtcTo() + "'}";
        } else {
            body = this.orderId == null || this.orderId.isEmpty() ? String.format(JOB_CHAIN_STRING_FOR_WEBSERVICE, this.schedulerId, this.jobChainName) + "[" + state + "]}" : String.format(JOB_CHAIN_ORDER_STRING_FOR_WEBSERVICE, this.schedulerId, this.jobChainName, this.orderId) + "[" + state + "]}";
        }
        body = body.replace("'", "\"");
        String answer = this.jobSchedulerRestApiClient.postRestService(new URI(this.webserviceCredentials.getJocUrl() + "/orders/history"), body);
        JobChain.OrderHistory.Order o = this.json2JobChainHistoryEntry(answer);
        if (o.getHistoryId() == null) {
            return null;
        }
        return o;
    }

    @Override
    public OrderHistoryItem getJobChainOrderHistoryEntry(BigInteger orderHistoryId) throws Exception {
        if (this.accessToken.isEmpty()) {
            throw new Exception("AccessToken is empty. Login not executed");
        }
        String body = String.format(JOB_CHAIN_ORDER_HISTORY_STRING_FOR_WEBSERVICE, this.schedulerId, orderHistoryId);
        body = body.replace("'", "\"");
        String answer = this.jobSchedulerRestApiClient.postRestService(new URI(this.webserviceCredentials.getJocUrl() + "/orders/history"), body);
        OrderHistoryItem o = this.json2JobChainOrderHistoryEntry(answer);
        if (o.getHistoryId() == null) {
            return null;
        }
        return o;
    }
}

