/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.checkrunhistory;

import com.sos.JSHelper.Basics.IJSCommands;
import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Basics.JSToolBox;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.jitl.checkrunhistory.IJobSchedulerHistory;
import com.sos.jitl.checkrunhistory.IJobSchedulerHistoryInfo;
import com.sos.jitl.checkrunhistory.JobChainHistory;
import com.sos.jitl.checkrunhistory.JobHistory;
import com.sos.jitl.checkrunhistory.JobHistoryHelper;
import com.sos.jitl.checkrunhistory.JobSchedulerCheckRunHistoryOptions;
import com.sos.localization.Messages;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Mail;
import sos.spooler.Spooler;

@I18NResourceBundle(baseName="com_sos_scheduler_messages", defaultLocale="en")
public class JobSchedulerCheckRunHistory
extends JSToolBox
implements JSJobUtilities,
IJSCommands {
    private final String conClassName = "JobSchedulerCheckRunHistory";
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerCheckRunHistory.class);
    protected JobSchedulerCheckRunHistoryOptions objOptions = null;
    private JSJobUtilities objJSJobUtilities = this;
    private IJSCommands objJSCommands = this;
    private String historyObjectName = "";
    private String pathOfJob = "";

    public void setPathOfJob(String _pathOfJob) {
        this.pathOfJob = _pathOfJob;
    }

    public JobSchedulerCheckRunHistory() {
        this.Messages = new Messages("com_sos_scheduler_messages");
    }

    public JobSchedulerCheckRunHistoryOptions options() {
        if (this.objOptions == null) {
            this.objOptions = new JobSchedulerCheckRunHistoryOptions();
        }
        return this.objOptions;
    }

    private IJobSchedulerHistory getHistoryObject(Spooler schedulerInstance) {
        IJobSchedulerHistory jobSchedulerHistory;
        if (this.options().schedulerPort.value() == 0 && this.options().schedulerHostName.getValue().isEmpty()) {
            LOGGER.debug("Get answer from JobScheduler instance");
            if (this.options().getJobChainName().getValue().isEmpty()) {
                this.historyObjectName = this.options().getJobName().getValue();
                jobSchedulerHistory = new JobHistory(schedulerInstance);
            } else {
                this.historyObjectName = this.options().getJobChainName().getValue();
                jobSchedulerHistory = new JobChainHistory(schedulerInstance);
            }
        } else {
            LOGGER.debug(String.format("Get answer from %s:%s", this.options().schedulerHostName.getValue(), this.options().schedulerPort.value()));
            if (this.options().getJobChainName().getValue().isEmpty()) {
                this.historyObjectName = this.options().getJobName().getValue();
                jobSchedulerHistory = new JobHistory(this.options().schedulerHostName.getValue(), this.options().schedulerPort.value());
            } else {
                this.historyObjectName = this.options().getJobChainName().getValue();
                jobSchedulerHistory = new JobChainHistory(this.options().schedulerHostName.getValue(), this.options().schedulerPort.value());
            }
        }
        jobSchedulerHistory.setRelativePath(this.pathOfJob);
        return jobSchedulerHistory;
    }

    public JobSchedulerCheckRunHistory Execute() throws Exception {
        String conMethodName = "JobSchedulerCheckRunHistory::Execute";
        LOGGER.debug(String.format(this.Messages.getMsg("JSJ-I-110"), "JobSchedulerCheckRunHistory::Execute"));
        boolean result = false;
        this.options().checkMandatory();
        LOGGER.debug(this.options().toString());
        try {
            String startTime = "00:00:00";
            String endTime = "00:00:00";
            String query = this.options().query.getValue();
            String[] queries = query.split("(;|,)");
            JobHistoryHelper jobHistoryHelper = new JobHistoryHelper();
            String methodName = jobHistoryHelper.getMethodName(this.options().query.getValue());
            if (this.options().start_time.isDirty()) {
                startTime = this.options().start_time.getValue();
            }
            if (this.options().end_time.isDirty()) {
                endTime = this.options().end_time.getValue();
            }
            String message = this.options().message.getValue();
            String mailTo = this.options().mail_to.getValue();
            String mailCc = this.options().mail_cc.getValue();
            String mailBcc = this.options().mail_bcc.getValue();
            Spooler schedulerInstance = (Spooler)this.objJSCommands.getSpoolerObject();
            IJobSchedulerHistory jobHistory = this.getHistoryObject(schedulerInstance);
            if (schedulerInstance != null) {
                Mail mail = schedulerInstance.log().mail();
                if (this.isNotEmpty(mailTo)) {
                    mail.set_to(mailTo);
                }
                if (this.isNotEmpty(mailCc)) {
                    mail.set_cc(mailCc);
                }
                if (this.isNotEmpty(mailBcc)) {
                    mail.set_bcc(mailBcc);
                }
                if (this.isNotEmpty(message)) {
                    mail.set_subject(message);
                }
            }
            if ("isCompletedBefore".equalsIgnoreCase(methodName) || "isCompletedSuccessfulBefore".equalsIgnoreCase(methodName) || "isCompletedWithErrorBefore".equalsIgnoreCase(methodName)) {
                String time = jobHistoryHelper.getParameter(endTime, query);
                jobHistory.setTimeLimit(time);
            }
            String[] historyObjectNames = this.historyObjectName.split("(;|,)");
            String delimiter = "";
            for (int i = 0; i < historyObjectNames.length; ++i) {
                String actHistoryObjectName = historyObjectNames[i];
                actHistoryObjectName = Matcher.quoteReplacement(actHistoryObjectName);
                String strTemp = message.replaceAll("(?im)\\[?JOB_NAME\\]?", actHistoryObjectName);
                message = this.Messages.getMsg("JCH_T_0001", new Object[]{actHistoryObjectName, strTemp});
                IJobSchedulerHistoryInfo jobSchedulerHistoryInfo = jobHistory.getJobSchedulerHistoryInfo(actHistoryObjectName);
                actHistoryObjectName = jobHistory.getActHistoryObjectName();
                jobSchedulerHistoryInfo.setEndTime(endTime);
                jobSchedulerHistoryInfo.setStartTime(startTime);
                String actQuery = "";
                if (queries.length == 1) {
                    actQuery = query;
                } else if (queries.length > i) {
                    actQuery = queries[i];
                }
                result = jobSchedulerHistoryInfo.queryHistory(actQuery);
                LOGGER.debug("--->" + actQuery + "(" + actHistoryObjectName + ")=" + result);
                this.options().result.value(result);
                this.options().numberOfCompleted.setValue(this.options().numberOfCompleted.getValue() + delimiter + actHistoryObjectName + ":" + String.valueOf(jobHistory.getNumberOfCompleted()));
                this.options().numberOfCompletedSuccessful.setValue(this.options().numberOfCompletedSuccessful.getValue() + delimiter + actHistoryObjectName + ":" + String.valueOf(jobHistory.getNumberOfCompletedSuccessful()));
                this.options().numberOfCompletedWithError.setValue(this.options().numberOfCompletedWithError.getValue() + delimiter + actHistoryObjectName + ":" + String.valueOf(jobHistory.getNumberOfCompletedWithError()));
                this.options().numberOfStarts.setValue(this.options().numberOfStarts.getValue() + delimiter + actHistoryObjectName + ":" + String.valueOf(jobHistory.getCount()));
                delimiter = ",";
                if (jobSchedulerHistoryInfo.getLastCompleted().error == 0) {
                    LOGGER.info(this.Messages.getMsg("JCH_I_0001", new Object[]{actHistoryObjectName, jobSchedulerHistoryInfo.getLastCompleted().end, ""}));
                    if (jobSchedulerHistoryInfo.getLastCompletedWithError().found) {
                        LOGGER.info(this.Messages.getMsg("JCH_I_0003", new Object[]{actHistoryObjectName, jobSchedulerHistoryInfo.getLastCompletedWithError().end, jobSchedulerHistoryInfo.getLastCompletedWithError().errorMessage}));
                    } else {
                        LOGGER.info(this.Messages.getMsg("JCH_I_0006", new Object[]{actHistoryObjectName}));
                    }
                } else {
                    LOGGER.info(this.Messages.getMsg("JCH_I_0002", new Object[]{actHistoryObjectName, jobSchedulerHistoryInfo.getLastCompleted().end, jobSchedulerHistoryInfo.getLastCompleted().errorMessage}));
                    if (jobSchedulerHistoryInfo.getLastCompletedSuccessful().found) {
                        LOGGER.info(this.Messages.getMsg("JCH_I_0004", new Object[]{actHistoryObjectName, jobSchedulerHistoryInfo.getLastCompletedSuccessful().end}));
                    } else {
                        LOGGER.info(this.Messages.getMsg("JCH_I_0005", new Object[]{actHistoryObjectName}));
                    }
                }
                if (!result) {
                    message = message + " " + methodName + "=false";
                    if ("true".equals(this.options().failOnQueryResultFalse.getValue())) {
                        LOGGER.error(message);
                        throw new JobSchedulerException(message);
                    }
                    LOGGER.info(message);
                    continue;
                }
                message = message + " " + methodName + "=true";
                if (this.options().failOnQueryResultTrue.value()) {
                    LOGGER.error(message);
                    throw new JobSchedulerException(message);
                }
                LOGGER.info(message);
            }
        }
        catch (Exception e) {
            LOGGER.error(this.Messages.getMsg("JSJ-F-107", new Object[]{"JobSchedulerCheckRunHistory::Execute"}) + ":" + e.getMessage(), (Throwable)e);
            throw e;
        }
        return this;
    }

    public String replaceSchedulerVars(String pstrString2Modify) {
        LOGGER.debug("replaceSchedulerVars as Dummy-call executed. No Instance of JobUtilites specified.");
        return pstrString2Modify;
    }

    public void setJSParam(String pstrKey, String pstrValue) {
    }

    public void setJSParam(String pstrKey, StringBuilder pstrValue) {
    }

    public void setJSJobUtilites(JSJobUtilities pobjJSJobUtilities) {
        this.objJSJobUtilities = pobjJSJobUtilities == null ? this : pobjJSJobUtilities;
        LOGGER.debug("objJSJobUtilities = " + this.objJSJobUtilities.getClass().getName());
    }

    public void setJSCommands(IJSCommands pobjJSCommands) {
        if (pobjJSCommands == null) {
            this.objJSCommands = this;
        } else {
            this.objJSCommands = pobjJSCommands;
            LOGGER.debug("pobjJSCommands = " + pobjJSCommands.getClass().getName());
        }
    }

    public Object getSpoolerObject() {
        return null;
    }

    public String executeXML(String pstrJSXmlCommand) {
        return null;
    }

    public void setStateText(String pstrStateText) {
    }

    public void setExitCode(int pintCC) {
    }

    public void setNextNodeState(String pstrNodeName) {
    }
}

