/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.dailyplan.db;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.classes.SearchStringHelper;
import com.sos.hibernate.classes.UtcTimeHelper;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.exceptions.SOSHibernateObjectOperationException;
import com.sos.jitl.dailyplan.db.DailyPlanAdjustment;
import com.sos.jitl.dailyplan.db.DailyPlanCalendarItem;
import com.sos.jitl.dailyplan.db.DailyPlanCalender2DBFilter;
import com.sos.jitl.dailyplan.db.DailyPlanDBItem;
import com.sos.jitl.dailyplan.db.DailyPlanDBLayer;
import com.sos.jitl.dailyplan.db.DailyPlanDate;
import com.sos.jitl.dailyplan.db.DailyPlanInterval;
import com.sos.jitl.dailyplan.job.CheckDailyPlanOptions;
import com.sos.jitl.dailyplan.job.CreateDailyPlanOptions;
import com.sos.jitl.inventory.db.DBLayerInventory;
import com.sos.jitl.jobstreams.classes.JSStarter;
import com.sos.jitl.jobstreams.db.DBItemJobStream;
import com.sos.jitl.jobstreams.db.DBItemJobStreamStarter;
import com.sos.jitl.jobstreams.db.DBItemJobStreamStarterJob;
import com.sos.jitl.jobstreams.db.DBLayerJobStreamStarters;
import com.sos.jitl.jobstreams.db.DBLayerJobStreams;
import com.sos.jitl.jobstreams.db.DBLayerJobStreamsStarterJobs;
import com.sos.jitl.jobstreams.db.FilterJobStreamStarterJobs;
import com.sos.jitl.jobstreams.db.FilterJobStreamStarters;
import com.sos.jitl.jobstreams.db.FilterJobStreams;
import com.sos.jitl.reporting.db.DBItemInventoryInstance;
import com.sos.jitl.reporting.db.DBItemInventoryJob;
import com.sos.jitl.reporting.db.DBItemInventoryOrder;
import com.sos.jitl.reporting.db.DBItemInventorySchedule;
import com.sos.jitl.reporting.db.DBLayerReporting;
import com.sos.joc.model.calendar.Period;
import com.sos.joc.model.plan.PlanFilter;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.answers.Calendar;
import com.sos.scheduler.model.answers.Order;
import com.sos.scheduler.model.commands.JSCmdShowCalendar;
import com.sos.scheduler.model.commands.JSCmdShowOrder;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.query.Query;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Spooler;

public class Calendar2DB {
    public static final String DBITEM_INVENTORY_INSTANCES = DBItemInventoryInstance.class.getSimpleName();
    private static final int DEFAULT_DAYS_OFFSET = 31;
    private static final int AVERAGE_DURATION_ONE_ITEM = 5;
    private static final int LIMIT_CALENDAR_CALL = 39999;
    private static final int DAYLOOP = 3;
    private static final int DEFAULT_LIMIT = 30;
    private static final Logger LOGGER = LoggerFactory.getLogger(Calendar2DB.class);
    private static final int MAX_DAY_OFFSET = 2000;
    private static final int MAX_LIST_SIZE = 20000;
    private static SchedulerObjectFactory schedulerObjectFactory = null;
    private Date from;
    private Date to;
    private int dayOffset;
    private String schedulerId = "";
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
    private DailyPlanDBLayer dailyPlanDBLayer;
    private DBLayerJobStreamStarters dbLayerJobStreamStarters;
    private CreateDailyPlanOptions options = null;
    private CheckDailyPlanOptions checkDailyPlanOptions;
    private Spooler spooler;
    List<DailyPlanDBItem> dailyPlanList;
    Map<String, DailyPlanCalender2DBFilter> listOfDailyPlanCalender2DBFilter;
    List<DailyPlanCalendarItem> listOfCalendars;
    private DailyPlanInterval dailyPlanInterval;
    private DBLayerInventory dbLayerInventory;
    private Map<String, Order> listOfOrders;
    private Map<String, Long> listOfDurations;
    private Map<String, DailyPlanDBItem> listOfPlanEntries;
    Date maxPlannedTime;

    public Calendar2DB(SOSHibernateSession session, String schedulerId) {
        this.dailyPlanDBLayer = new DailyPlanDBLayer(session);
        this.dbLayerJobStreamStarters = new DBLayerJobStreamStarters(session);
        this.listOfOrders = new HashMap<String, Order>();
        this.listOfDurations = new HashMap<String, Long>();
        this.listOfPlanEntries = new HashMap<String, DailyPlanDBItem>();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        this.schedulerId = schedulerId;
    }

    public void beginTransaction() throws SOSHibernateException {
        this.dailyPlanDBLayer.getSession().beginTransaction();
    }

    public void commit() throws SOSHibernateException {
        this.dailyPlanDBLayer.getSession().commit();
    }

    public void rollback() throws SOSHibernateException {
        this.dailyPlanDBLayer.getSession().rollback();
    }

    public List<DailyPlanDBItem> getStartTimesFromScheduler(Date from, Date to, PlanFilter planFilter) throws ParseException, SOSHibernateException {
        this.initSchedulerConnection();
        this.from = from;
        this.to = to;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.from);
        calendar.add(5, 2000);
        Date max = calendar.getTime();
        if (max.before(this.to)) {
            this.to = max;
        }
        this.fillListOfCalendars(true);
        return this.getCalendarFromJobScheduler(planFilter);
    }

    public void store() throws Exception {
        long timeStartAll = System.currentTimeMillis();
        try {
            this.initSchedulerConnection();
            this.fillListOfCalendars(false);
            long timeStart = System.currentTimeMillis();
            this.store(null);
            this.beginTransaction();
            this.processJobStreamStarterFilter();
            this.commit();
            long timeEnd = System.currentTimeMillis();
            LOGGER.debug("Duration store: " + (timeEnd - timeStart) + " ms");
            this.checkDaysSchedule();
            long timeEndAll = System.currentTimeMillis();
            LOGGER.debug("Duration total store " + (timeEndAll - timeStartAll) + " ms");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.rollback();
            throw e;
        }
    }

    private void storeJobStreamStarters(FilterJobStreams filterJobStreams, String timezone) throws Exception {
        LOGGER.debug("Store job stream start with timezone " + timezone);
        filterJobStreams.setSchedulerId(this.schedulerId);
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        DBLayerReporting dbLayerReporting = new DBLayerReporting(this.dailyPlanDBLayer.getSession());
        DBLayerJobStreamsStarterJobs dbLayerJobStreamsStarterJobs = new DBLayerJobStreamsStarterJobs(this.dailyPlanDBLayer.getSession());
        DBLayerJobStreams dbLayerJobStreams = new DBLayerJobStreams(this.dailyPlanDBLayer.getSession());
        List<DBItemJobStream> listOfJobStreams = dbLayerJobStreams.getJobStreamsList(filterJobStreams, 0);
        HashMap<Long, DBItemJobStream> mapOfJobStreams = new HashMap<Long, DBItemJobStream>();
        for (DBItemJobStream dbItemJobStream : listOfJobStreams) {
            mapOfJobStreams.put(dbItemJobStream.getId(), dbItemJobStream);
            LOGGER.trace("map add jobstream: " + dbItemJobStream.getId());
        }
        FilterJobStreamStarters filterJobStreamStarters = new FilterJobStreamStarters();
        filterJobStreamStarters.setJobStreamId(filterJobStreams.getJobStreamId());
        FilterJobStreamStarterJobs filterJobStreamStarterJobs = new FilterJobStreamStarterJobs();
        List<DBItemJobStreamStarter> listOfStarters = this.dbLayerJobStreamStarters.getJobStreamStartersList(filterJobStreamStarters, 0);
        for (DBItemJobStreamStarter dbItemJobStreamStarter : listOfStarters) {
            if (mapOfJobStreams.get(dbItemJobStreamStarter.getJobStream()) == null) continue;
            JSStarter jsStarter = new JSStarter(objectMapper);
            TimeZone timeZone = TimeZone.getTimeZone(timezone);
            jsStarter.setItemJobStreamStarter(this.from, this.to, dbItemJobStreamStarter, timeZone.getID());
            filterJobStreamStarterJobs.setJobStreamStarter(dbItemJobStreamStarter.getId());
            if (jsStarter.getJobStreamScheduler().getPlan() == null) continue;
            for (Period period : jsStarter.getJobStreamScheduler().getPlan().getPeriods()) {
                for (DBItemJobStreamStarterJob dbItemJobStreamStarterJob : dbLayerJobStreamsStarterJobs.getJobStreamStarterJobsList(filterJobStreamStarterJobs, 0)) {
                    boolean isNew;
                    String start;
                    this.dailyPlanInterval = new DailyPlanInterval(this.from, this.to);
                    DailyPlanCalender2DBFilter dailyPlanCalender2DBFilter = new DailyPlanCalender2DBFilter();
                    dailyPlanCalender2DBFilter.setForJob(dbItemJobStreamStarterJob.getJob());
                    if (period.getSingleStart() != null) {
                        start = period.getSingleStart();
                        LOGGER.debug("start jobstream: " + jsStarter.getItemJobStreamStarter().getJobStream() + " at " + start);
                    } else {
                        start = period.getBegin();
                        LOGGER.debug("start jobstream: " + jsStarter.getItemJobStreamStarter().getJobStream() + " at " + start);
                    }
                    DailyPlanDBItem dailyPlanDBItem = null;
                    this.dailyPlanDBLayer.resetFilter();
                    this.dailyPlanDBLayer.getFilter().setJob(dbItemJobStreamStarterJob.getJob());
                    DailyPlanDate dailyScheduleDate = new DailyPlanDate(this.dateFormat);
                    dailyScheduleDate.setSchedule(start);
                    this.dailyPlanDBLayer.getFilter().setPlannedStart(dailyScheduleDate.getSchedule());
                    this.dailyPlanDBLayer.getFilter().setSchedulerId(this.schedulerId);
                    List<DailyPlanDBItem> l = this.dailyPlanDBLayer.getDailyPlanList(0, true);
                    if (l.size() > 0) {
                        dailyPlanDBItem = l.get(0);
                        isNew = false;
                    } else {
                        dailyPlanDBItem = new DailyPlanDBItem(this.dateFormat);
                        isNew = true;
                    }
                    dailyPlanDBItem.setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    if (period.getSingleStart() != null) {
                        LOGGER.debug("start jobstream: " + jsStarter.getItemJobStreamStarter().getJobStream() + " at " + start);
                    } else {
                        dailyPlanDBItem.setPeriodBegin(period.getBegin());
                        dailyPlanDBItem.setPeriodEnd(period.getEnd());
                        try {
                            dailyPlanDBItem.setRepeatInterval(new BigInteger(period.getAbsoluteRepeat()), new BigInteger(period.getRepeat()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        LOGGER.debug("start jobstream: " + jsStarter.getItemJobStreamStarter().getJobStream() + " at " + start);
                    }
                    dailyPlanDBItem.setSchedulerId(this.schedulerId);
                    dailyPlanDBItem.setIsAssigned(false);
                    dailyPlanDBItem.setIsLate(false);
                    dailyPlanDBItem.setJobStreamStarterId(dbItemJobStreamStarter.getId());
                    dailyPlanDBItem.setJob(dbItemJobStreamStarterJob.getJob());
                    LOGGER.trace("map get jobstream: " + dbItemJobStreamStarter.getJobStream());
                    if (mapOfJobStreams.get(dbItemJobStreamStarter.getJobStream()) != null) {
                        dailyPlanDBItem.setJobStream(((DBItemJobStream)mapOfJobStreams.get(dbItemJobStreamStarter.getJobStream())).getJobStream());
                    } else {
                        LOGGER.debug("map jobstream does not contain: " + dbItemJobStreamStarter.getJobStream());
                        dailyPlanDBItem.setJobStream(String.valueOf(dbItemJobStreamStarter.getJobStream()));
                    }
                    dailyPlanDBItem.setJobChain(".");
                    dailyPlanDBItem.setOrderId(".");
                    dailyPlanDBItem.setPlannedStart(start);
                    Long duration = this.getDuration(dbLayerReporting, dbItemJobStreamStarterJob.getJob(), null);
                    if (dailyPlanDBItem.getPlannedStart() != null) {
                        dailyPlanDBItem.setExpectedEnd(new Date(dailyPlanDBItem.getPlannedStart().getTime() + duration));
                    }
                    dailyPlanDBItem.setStartStart(true);
                    dailyPlanDBItem.setState("PLANNED");
                    dailyPlanDBItem.setReportTriggerId(null);
                    dailyPlanDBItem.setReportExecutionId(null);
                    dailyPlanDBItem.setDateFormat(this.dateFormat);
                    dailyPlanDBItem.setModified(new Date());
                    if (isNew) {
                        dailyPlanDBItem.setCreated(new Date());
                        this.dailyPlanDBLayer.getSession().save((Object)dailyPlanDBItem);
                        LOGGER.debug("Store daily plan job stream item:" + dailyPlanDBItem.getId() + " at " + dailyPlanDBItem.getPlannedStartFormated());
                        continue;
                    }
                    try {
                        this.dailyPlanDBLayer.getSession().update((Object)dailyPlanDBItem);
                        LOGGER.debug("Update daily plan job stream item:" + dailyPlanDBItem.getId() + " at " + dailyPlanDBItem.getPlannedStartFormated());
                    }
                    catch (SOSHibernateObjectOperationException e) {
                        this.dailyPlanDBLayer.getSession().save((Object)dailyPlanDBItem);
                        LOGGER.debug("Store daily plan job stream item:" + dailyPlanDBItem.getId() + " at " + dailyPlanDBItem.getPlannedStartFormated());
                    }
                }
            }
        }
    }

    private void processJobStreamStarterFilter() throws Exception {
        String sql = String.format("from %s where schedulerId = :schedulerId", DBITEM_INVENTORY_INSTANCES);
        String timeZone = "UTC";
        Query query = this.dailyPlanDBLayer.getSession().createQuery(sql.toString());
        query.setParameter("schedulerId", (Object)this.schedulerId);
        List result = this.dailyPlanDBLayer.getSession().getResultList(query);
        if (result != null && !result.isEmpty()) {
            timeZone = ((DBItemInventoryInstance)result.get(0)).getTimeZone();
        }
        this.setFrom();
        this.setTo();
        FilterJobStreams filterJobStreams = new FilterJobStreams();
        this.storeJobStreamStarters(filterJobStreams, timeZone);
    }

    public void processJobStreamStarterFilter(FilterJobStreams filterJobStreams, String timezone) throws Exception {
        this.dayOffset = 31;
        this.setFrom();
        this.setTo();
        this.storeJobStreamStarters(filterJobStreams, timezone);
    }

    public void addDailyplan2DBFilter(DailyPlanCalender2DBFilter dailyPlanCalender2DBFilter, Long instanceId) throws SOSHibernateException, ParseException {
        if (this.listOfDailyPlanCalender2DBFilter == null) {
            this.initSchedulerConnection();
            this.listOfDailyPlanCalender2DBFilter = new HashMap<String, DailyPlanCalender2DBFilter>();
        }
        if (!"".equals(dailyPlanCalender2DBFilter.getForSchedule()) && dailyPlanCalender2DBFilter.getForSchedule() != null) {
            if (this.dbLayerInventory == null) {
                this.dbLayerInventory = new DBLayerInventory(this.dailyPlanDBLayer.getSession());
            }
            if (instanceId != null) {
                DBItemInventorySchedule dbItemInventorySchedule = this.dbLayerInventory.getSubstituteIfExists(dailyPlanCalender2DBFilter.getForSchedule(), instanceId);
                String schedule = dbItemInventorySchedule != null && !".".equals(dbItemInventorySchedule.getSubstituteName()) ? dbItemInventorySchedule.getSubstituteName() : dailyPlanCalender2DBFilter.getForSchedule();
                List<DBItemInventoryJob> listOfUsedJobs = this.dbLayerInventory.getJobsReferencingSchedule(instanceId, schedule);
                for (DBItemInventoryJob dbItemInventoryJob : listOfUsedJobs) {
                    dailyPlanCalender2DBFilter = new DailyPlanCalender2DBFilter();
                    dailyPlanCalender2DBFilter.setForJob(dbItemInventoryJob.getName());
                    this.listOfDailyPlanCalender2DBFilter.put(dailyPlanCalender2DBFilter.getKey(), dailyPlanCalender2DBFilter);
                }
                List<DBItemInventoryOrder> listOfUsedOrders = this.dbLayerInventory.getOrdersReferencingSchedule(instanceId, schedule);
                for (DBItemInventoryOrder dbItemInventoryOrder : listOfUsedOrders) {
                    dailyPlanCalender2DBFilter = new DailyPlanCalender2DBFilter();
                    dailyPlanCalender2DBFilter.setForJobChain(dbItemInventoryOrder.getJobChainName());
                    dailyPlanCalender2DBFilter.setForOrderId(dbItemInventoryOrder.getOrderId());
                    this.listOfDailyPlanCalender2DBFilter.put(dailyPlanCalender2DBFilter.getKey(), dailyPlanCalender2DBFilter);
                }
            }
        } else {
            this.listOfDailyPlanCalender2DBFilter.put(dailyPlanCalender2DBFilter.getKey(), dailyPlanCalender2DBFilter);
        }
    }

    public void processDailyplan2DBFilter() throws Exception {
        long timeStartAll = System.currentTimeMillis();
        long timeStoreSum = 0L;
        LOGGER.debug("processDailyplan2DBFilter: Start");
        if (this.listOfDailyPlanCalender2DBFilter == null) {
            this.listOfDailyPlanCalender2DBFilter = new HashMap<String, DailyPlanCalender2DBFilter>();
        }
        this.initSchedulerConnection();
        LOGGER.debug(String.format("processDailyplan2DBFilter: day_offset is %s SchedulerId is %s", this.dayOffset, this.schedulerId));
        if (this.from == null) {
            this.setFrom();
        }
        if (this.to == null) {
            this.setTo();
        }
        LOGGER.debug(String.format("from: %s, to: %s", this.from, this.to));
        try {
            this.fillListOfCalendars(false);
            DailyPlanCalendarItem dailyPlanCalendarItem = this.listOfCalendars.get(0);
            HashSet<String> calendarEntries = new HashSet<String>();
            for (Object calendarObject : dailyPlanCalendarItem.getCalendar().getAtOrPeriod()) {
                if (!(calendarObject instanceof com.sos.scheduler.model.answers.Period)) continue;
                com.sos.scheduler.model.answers.Period period = (com.sos.scheduler.model.answers.Period)calendarObject;
                String orderId = period.getOrder();
                String jobChain = period.getJobChain();
                String job = period.getJob();
                calendarEntries.add(job + ":" + jobChain + ":" + orderId);
            }
            long numberOfDailyPlanItems = calendarEntries.size();
            long numberOfFilters = this.listOfDailyPlanCalender2DBFilter.size();
            long estimatedDurationAll = 5L * numberOfDailyPlanItems * (long)this.dayOffset;
            long estimatatedDurationSelect = 5L * numberOfFilters * (long)this.dayOffset;
            long percentage = 0L;
            if (estimatedDurationAll > 0L) {
                percentage = 100L * estimatatedDurationSelect / estimatedDurationAll;
            }
            LOGGER.debug("-> estimated all: " + estimatedDurationAll);
            LOGGER.debug("-> estimated selected: " + estimatatedDurationSelect);
            LOGGER.debug("-> duration percentage selected: " + percentage);
            if (percentage < 90L) {
                for (Map.Entry<String, DailyPlanCalender2DBFilter> entry : this.listOfDailyPlanCalender2DBFilter.entrySet()) {
                    DailyPlanCalender2DBFilter dailyPlanCalender2DBFilter = entry.getValue();
                    long timeStart = System.currentTimeMillis();
                    this.store(dailyPlanCalender2DBFilter);
                    long timeEnd = System.currentTimeMillis();
                    LOGGER.debug("Duration: " + dailyPlanCalender2DBFilter.getName() + ":" + (timeEnd - timeStart) + " ms");
                    timeStoreSum += timeEnd - timeStart;
                }
            } else {
                long timeStoreStart = System.currentTimeMillis();
                this.store(null);
                long timeStoreEnd = System.currentTimeMillis();
                timeStoreSum += timeStoreEnd - timeStoreStart;
            }
            LOGGER.debug("Duration total: " + timeStoreSum + " ms");
            this.checkDaysSchedule();
            long timeEndAll = System.currentTimeMillis();
            LOGGER.debug("Duration process all: " + (timeEndAll - timeStartAll) + " ms");
        }
        catch (SOSHibernateException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.rollback();
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void fillListOfCalendars(boolean withTime) {
        if (this.listOfCalendars == null) {
            this.listOfCalendars = new ArrayList<DailyPlanCalendarItem>();
        }
        LOGGER.debug(String.format("fillListOfCalendars: from %s to %s", this.from, this.to));
        this.dailyPlanInterval = new DailyPlanInterval(this.from, this.to);
        Date tFrom = this.from;
        while (tFrom.before(this.to)) {
            Date before = this.addCalendar(this.from, 3, 5);
            if (this.to.before(before)) {
                before = this.to;
            }
            Date xFrom = this.from;
            Calendar calendar = this.getCalendar(this.from, before, withTime);
            DailyPlanCalendarItem dailyPlanCalendarItem = new DailyPlanCalendarItem(xFrom, before, calendar);
            LOGGER.debug(String.format("Calendar: from=%s to=%s", xFrom, before));
            this.listOfCalendars.add(dailyPlanCalendarItem);
            tFrom = this.addCalendar(this.from, 1, 13);
        }
    }

    private void initSchedulerConnection() throws ParseException {
        LOGGER.debug("initSchedulerConnection");
        this.dayOffset = this.options.dayOffset.isDirty() ? this.options.getdayOffset().value() : this.getDayOffsetFromPlan();
        if (this.dayOffset > 2000) {
            LOGGER.warn("Changing dayOffset from %s to %s. See: CVE-2020-6855", (Object)this.dayOffset, (Object)2000);
            this.dayOffset = 2000;
        }
        if (schedulerObjectFactory == null) {
            LOGGER.debug("schedulerObjectFactory is null");
            LOGGER.debug("Calender2DB");
            schedulerObjectFactory = this.spooler == null ? (this.options.basicAuthorization.isDirty() && !this.options.basicAuthorization.getValue().isEmpty() ? new SchedulerObjectFactory(this.options.getCommandUrl().getValue(), this.options.basicAuthorization.getValue()) : new SchedulerObjectFactory(this.options.getCommandUrl().getValue())) : new SchedulerObjectFactory(this.spooler);
            schedulerObjectFactory.initMarshaller(com.sos.scheduler.model.objects.Spooler.class);
            this.setFrom();
            this.setTo();
        }
    }

    private int getDayOffsetFromPlan() {
        this.maxPlannedTime = this.dailyPlanDBLayer.getMaxPlannedStart(this.schedulerId);
        Date today = new Date();
        int days = (int)((this.maxPlannedTime.getTime() - today.getTime()) / 86400000L);
        if (days == 0) {
            days = 31;
        }
        LOGGER.debug(String.format("Calculated  day_offset for SchedulerId: %s is %s ", this.schedulerId, days));
        return days;
    }

    private Calendar getCalendar(Date start, Date before, boolean withTime) {
        JSCmdShowCalendar jsCmdShowCalendar = schedulerObjectFactory.createShowCalendar();
        jsCmdShowCalendar.setWhat("orders");
        jsCmdShowCalendar.setLimit(39999);
        if (withTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            jsCmdShowCalendar.setFrom(sdf.format(start));
            jsCmdShowCalendar.setBefore(sdf.format(before));
            this.from = this.addCalendar(before, 1, 13);
        } else {
            start = this.addCalendar(start, -1, 5);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'23:59:59");
            jsCmdShowCalendar.setFrom(sdf.format(start));
            sdf = new SimpleDateFormat("yyyy-MM-dd'T'00:00:00");
            jsCmdShowCalendar.setBefore(sdf.format(before));
            this.from = this.addCalendar(before, 0, 5);
        }
        LOGGER.debug(String.format("... day_offset is %s SchedulerId is %s", this.dayOffset, this.schedulerId));
        LOGGER.debug(String.format("... calculating plan for %s - %s ", jsCmdShowCalendar.getFrom(), jsCmdShowCalendar.getBefore()));
        jsCmdShowCalendar.run();
        this.from = this.addCalendar(this.from, -1, 13);
        return jsCmdShowCalendar.getCalendar();
    }

    private void getCurrentDailyPlan(DailyPlanCalender2DBFilter dailyPlanCalender2DBFilter) throws Exception {
        this.dailyPlanDBLayer.setWhereFrom(this.dailyPlanInterval.getConvertedFrom());
        this.dailyPlanDBLayer.setWhereTo(this.dailyPlanInterval.getConvertedTo());
        this.dailyPlanDBLayer.setWhereSchedulerId(this.schedulerId);
        if (dailyPlanCalender2DBFilter != null) {
            this.dailyPlanDBLayer.getFilter().setCalender2DBFilter(dailyPlanCalender2DBFilter);
        }
        this.dailyPlanList = this.dailyPlanDBLayer.getDailyPlanList(0, true);
    }

    private void deleteItemsAfterTo(DailyPlanCalender2DBFilter dailyPlanCalender2DBFilter) throws SOSHibernateException {
        this.dailyPlanDBLayer.setWhereFrom(this.dailyPlanInterval.getConvertedTo());
        this.dailyPlanDBLayer.setWhereSchedulerId(this.schedulerId);
        if (dailyPlanCalender2DBFilter != null) {
            this.dailyPlanDBLayer.getFilter().setCalender2DBFilter(dailyPlanCalender2DBFilter);
        }
        this.dailyPlanDBLayer.delete(true);
    }

    private boolean isSetback(Order order) {
        return order.getSetback() != null;
    }

    private Order getOrder(String jobChain, String orderId) {
        if (orderId == null) {
            return null;
        }
        String orderKey = jobChain + "(" + orderId + ")";
        Order order = this.listOfOrders.get(orderKey);
        if (order == null) {
            JSCmdShowOrder jsCmdShowOrder = schedulerObjectFactory.createShowOrder();
            jsCmdShowOrder.setJobChain(jobChain);
            jsCmdShowOrder.setOrder(orderId);
            try {
                jsCmdShowOrder.run();
                order = jsCmdShowOrder.getAnswer().getOrder();
                this.listOfOrders.put(orderKey, order);
            }
            catch (Exception e) {
                String cause = "";
                if (e.getCause() != null) {
                    cause = e.getCause().toString();
                }
                LOGGER.info("order:" + orderKey + " not found --> " + e.toString() + ":" + cause);
                order = null;
            }
        }
        return order;
    }

    private Long getDuration(DBLayerReporting dbLayerReporting, String job, Order order) throws SOSHibernateException {
        Long duration = 0L;
        String key = "";
        key = order == null ? job : order.getJobChain() + "(" + order.getId() + ")";
        duration = this.listOfDurations.get(key);
        if (duration == null) {
            duration = order == null ? dbLayerReporting.getTaskEstimatedDuration(job, 30) : dbLayerReporting.getOrderEstimatedDuration(order.getJobChain(), order.getId(), 30);
            this.listOfDurations.put(key, duration);
        }
        return duration;
    }

    public Date addCalendar(Date date, Integer add, Integer c) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((java.util.Calendar)calendar).add(c, add);
        return calendar.getTime();
    }

    private boolean isBeforeToday(Date d) {
        DateTime dLocal = new DateTime((Object)d);
        DateTime today = new DateTime((Object)UtcTimeHelper.getNowUtc());
        return today.getDayOfYear() > dLocal.getDayOfYear();
    }

    private void store(DailyPlanCalender2DBFilter dailyPlanCalender2DBFilter) throws Exception {
        this.beginTransaction();
        DBLayerReporting dbLayerReporting = new DBLayerReporting(this.dailyPlanDBLayer.getSession());
        int i = 0;
        boolean isNew = false;
        this.deleteItemsAfterTo(dailyPlanCalender2DBFilter);
        this.getCurrentDailyPlan(dailyPlanCalender2DBFilter);
        for (DailyPlanCalendarItem dailyPlanCalendarItem : this.listOfCalendars) {
            this.from = dailyPlanCalendarItem.getFrom();
            this.to = dailyPlanCalendarItem.getTo();
            for (Object calendarObject : dailyPlanCalendarItem.getCalendar().getAtOrPeriod()) {
                boolean handleEntry;
                DailyPlanDBItem dailyPlanDBItem;
                Order order = null;
                String job = null;
                String jobChain = null;
                if (i < this.dailyPlanList.size()) {
                    isNew = false;
                    dailyPlanDBItem = this.dailyPlanList.get(i);
                    dailyPlanDBItem.setIsAssigned(false);
                    dailyPlanDBItem.setIsLate(false);
                    dailyPlanDBItem.setJob(".");
                    dailyPlanDBItem.setJobStream("");
                    dailyPlanDBItem.setJobChain(".");
                    dailyPlanDBItem.setOrderId(".");
                    dailyPlanDBItem.nullPlannedStart();
                    dailyPlanDBItem.setExpectedEnd(null);
                    dailyPlanDBItem.nullPeriodBegin();
                    dailyPlanDBItem.nullPeriodEnd();
                    dailyPlanDBItem.setRepeatInterval(null);
                    dailyPlanDBItem.setStartStart(false);
                    dailyPlanDBItem.setState("");
                    dailyPlanDBItem.setReportTriggerId(null);
                    dailyPlanDBItem.setReportExecutionId(null);
                    dailyPlanDBItem.setDateFormat(this.dateFormat);
                } else {
                    isNew = true;
                    dailyPlanDBItem = new DailyPlanDBItem(this.dateFormat);
                    dailyPlanDBItem.setCreated(new Date());
                }
                dailyPlanDBItem.setSchedulerId(String.valueOf(i));
                dailyPlanDBItem.setState("PLANNEDFORUPDATE");
                if (!(calendarObject instanceof com.sos.scheduler.model.answers.Period)) continue;
                com.sos.scheduler.model.answers.Period period = (com.sos.scheduler.model.answers.Period)calendarObject;
                String orderId = period.getOrder();
                String singleStart = period.getSingleStart();
                jobChain = period.getJobChain();
                job = period.getJob();
                if (job == null) {
                    order = this.getOrder(jobChain, orderId);
                }
                DailyPlanDBItem dailyPlanEntry = new DailyPlanDBItem(this.dateFormat);
                dailyPlanEntry.setJob(job);
                dailyPlanEntry.setJobChain(jobChain);
                dailyPlanEntry.setOrderId(orderId);
                dailyPlanEntry.setSchedulerId(this.schedulerId);
                if (job != null || order != null) {
                    if (singleStart != null) {
                        if (orderId == null || !this.isSetback(order)) {
                            dailyPlanEntry.setPlannedStart(singleStart);
                        }
                    } else {
                        dailyPlanEntry.setPlannedStart(period.getBegin());
                    }
                }
                if (!(handleEntry = this.listOfPlanEntries.get(this.getUniqueKey(dailyPlanEntry)) == null && !this.isBeforeToday(dailyPlanEntry.getPlannedStart()) && (dailyPlanCalender2DBFilter == null || dailyPlanCalender2DBFilter.handleEntry(job, jobChain, orderId)))) continue;
                ++i;
                this.listOfPlanEntries.put(this.getUniqueKey(dailyPlanEntry), dailyPlanEntry);
                if (job == null && order == null) continue;
                if (singleStart != null) {
                    if (orderId == null || !this.isSetback(order)) {
                        dailyPlanDBItem.setPlannedStart(singleStart);
                        LOGGER.debug("Start at :" + singleStart);
                        LOGGER.debug("Job Name :" + job);
                        LOGGER.debug("Job-Chain Name :" + jobChain);
                        LOGGER.debug("Order Name :" + orderId);
                    } else {
                        LOGGER.debug("Job-Chain Name :" + jobChain + "/" + orderId + " ignored because order is in setback state");
                    }
                } else {
                    dailyPlanDBItem.setPeriodBegin(period.getBegin());
                    dailyPlanDBItem.setPeriodEnd(period.getEnd());
                    dailyPlanDBItem.setRepeatInterval(period.getAbsoluteRepeat(), period.getRepeat());
                    LOGGER.debug("Absolute Repeat Interval :" + period.getAbsoluteRepeat());
                    LOGGER.debug("Timerange start :" + period.getBegin());
                    LOGGER.debug("Timerange end :" + period.getEnd());
                    LOGGER.debug("Job-Name :" + period.getJob());
                }
                dailyPlanDBItem.setJob(job);
                dailyPlanDBItem.setJobChain(jobChain);
                dailyPlanDBItem.setOrderId(orderId);
                Long duration = this.getDuration(dbLayerReporting, job, order);
                if (dailyPlanDBItem.getPlannedStart() != null) {
                    dailyPlanDBItem.setExpectedEnd(new Date(dailyPlanDBItem.getPlannedStart().getTime() + duration));
                }
                dailyPlanDBItem.setIsAssigned(false);
                dailyPlanDBItem.setModified(new Date());
                if (dailyPlanDBItem.getPlannedStart() == null || !"".equals(dailyPlanDBItem.getJob()) && "(Spooler)".equals(dailyPlanDBItem.getJob())) continue;
                if (isNew) {
                    this.dailyPlanDBLayer.getSession().save((Object)dailyPlanDBItem);
                    continue;
                }
                try {
                    this.dailyPlanDBLayer.getSession().update((Object)dailyPlanDBItem);
                }
                catch (SOSHibernateObjectOperationException e) {
                    this.dailyPlanDBLayer.getSession().save((Object)dailyPlanDBItem);
                }
            }
        }
        for (int ii = i; ii < this.dailyPlanList.size(); ++ii) {
            DailyPlanDBItem dailyPlanDBItem = this.dailyPlanList.get(ii);
            this.dailyPlanDBLayer.getSession().delete((Object)dailyPlanDBItem);
        }
        this.dailyPlanDBLayer.updateDailyPlanList(this.schedulerId);
        this.commit();
    }

    private String getUniqueKey(DailyPlanDBItem dailyPlanEntry) {
        return dailyPlanEntry.getPlannedStart() + dailyPlanEntry.getJob() + dailyPlanEntry.getJobOrJobchain() + dailyPlanEntry.getSchedulerId();
    }

    private List<DailyPlanDBItem> getCalendarFromJobScheduler(PlanFilter planFilter) throws ParseException, SOSHibernateException {
        Matcher regExMatcherJob = null;
        if (planFilter.getJob() != null && !planFilter.getJob().isEmpty()) {
            planFilter.setJob(SearchStringHelper.getRegexValue((String)planFilter.getJob()));
            regExMatcherJob = Pattern.compile(planFilter.getJob()).matcher("");
        }
        Matcher regExMatcherOrderId = null;
        if (planFilter.getOrderId() != null && !planFilter.getOrderId().isEmpty()) {
            planFilter.setOrderId(SearchStringHelper.getRegexValue((String)planFilter.getOrderId()));
            regExMatcherOrderId = Pattern.compile(planFilter.getOrderId()).matcher("");
        }
        Matcher regExMatcherJobChain = null;
        if (planFilter.getJobChain() != null && !planFilter.getJobChain().isEmpty()) {
            planFilter.setJobChain(SearchStringHelper.getRegexValue((String)planFilter.getJobChain()));
            regExMatcherJobChain = Pattern.compile(planFilter.getJobChain()).matcher("");
        }
        DBLayerReporting dbLayerReporting = new DBLayerReporting(this.dailyPlanDBLayer.getSession());
        this.dailyPlanList = new ArrayList<DailyPlanDBItem>();
        String fromTimeZoneString = DateTimeZone.getDefault().getID();
        String toTimeZoneString = "UTC";
        DateTimeZone fromZone = DateTimeZone.forID((String)toTimeZoneString);
        block0: for (DailyPlanCalendarItem dailyPlanCalendarItem : this.listOfCalendars) {
            this.from = dailyPlanCalendarItem.getFrom();
            Date utcFrom = UtcTimeHelper.convertTimeZonesToDate((String)fromTimeZoneString, (String)toTimeZoneString, (DateTime)new DateTime((Object)this.from).withZone(fromZone));
            this.to = dailyPlanCalendarItem.getTo();
            LOGGER.debug(String.format("Starttimes from Calendar: from=%s  to=%s", dailyPlanCalendarItem.getFrom(), dailyPlanCalendarItem.getTo()));
            for (Object calendarObject : dailyPlanCalendarItem.getCalendar().getAtOrPeriod()) {
                Order order = null;
                String job = null;
                String jobChain = null;
                DailyPlanDBItem dailyPlanDBItem = new DailyPlanDBItem(this.dateFormat);
                dailyPlanDBItem.setCreated(new Date());
                dailyPlanDBItem.setSchedulerId(this.schedulerId);
                dailyPlanDBItem.setState("PLANNED");
                if (!(calendarObject instanceof com.sos.scheduler.model.answers.Period)) continue;
                com.sos.scheduler.model.answers.Period period = (com.sos.scheduler.model.answers.Period)calendarObject;
                String orderId = period.getOrder();
                String singleStart = period.getSingleStart();
                jobChain = period.getJobChain();
                job = period.getJob();
                if (job == null) {
                    order = this.getOrder(jobChain, orderId);
                }
                if (job == null && order == null) continue;
                if (singleStart != null) {
                    if (orderId == null || !this.isSetback(order)) {
                        dailyPlanDBItem.setPlannedStart(singleStart);
                        LOGGER.debug("Start at :" + singleStart);
                        LOGGER.debug("Job Name :" + job);
                        LOGGER.debug("Job-Chain Name :" + jobChain);
                        LOGGER.debug("Order Name :" + orderId);
                    } else {
                        LOGGER.debug("Job-Chain Name :" + jobChain + "/" + orderId + " ignored because order is in setback state");
                    }
                } else {
                    dailyPlanDBItem.setPeriodBegin(period.getBegin());
                    if (dailyPlanDBItem.getPlannedStart() != null && dailyPlanDBItem.getPlannedStart().compareTo(utcFrom) < 0 && dailyPlanDBItem.getPlannedStart().compareTo(this.to) <= 0) {
                        dailyPlanDBItem.nullPlannedStart();
                    } else {
                        dailyPlanDBItem.setPeriodEnd(period.getEnd());
                        dailyPlanDBItem.setRepeatInterval(period.getAbsoluteRepeat(), period.getRepeat());
                        LOGGER.debug("Absolute Repeat Interval :" + period.getAbsoluteRepeat());
                        LOGGER.debug("Timerange start :" + period.getBegin());
                        LOGGER.debug("Timerange end :" + period.getEnd());
                        LOGGER.debug("Job-Name :" + period.getJob());
                    }
                }
                if (dailyPlanDBItem.getPlannedStart() == null || !"".equals(dailyPlanDBItem.getJob()) && "(Spooler)".equals(dailyPlanDBItem.getJob())) continue;
                dailyPlanDBItem.setJob(job);
                dailyPlanDBItem.setJobChain(jobChain);
                dailyPlanDBItem.setOrderId(orderId);
                Long duration = this.getDuration(dbLayerReporting, job, order);
                dailyPlanDBItem.setExpectedEnd(new Date(dailyPlanDBItem.getPlannedStart().getTime() + duration));
                dailyPlanDBItem.setIsAssigned(false);
                dailyPlanDBItem.setModified(new Date());
                if (this.dailyPlanList.size() > 20000) continue block0;
                boolean add = true;
                if (regExMatcherJob != null) {
                    regExMatcherJob.reset(dailyPlanDBItem.getJob());
                    boolean bl = add = add && regExMatcherJob.matches();
                }
                if (regExMatcherJobChain != null) {
                    regExMatcherJobChain.reset(dailyPlanDBItem.getJobChain());
                    boolean bl = add = add && regExMatcherJobChain.matches();
                }
                if (regExMatcherOrderId != null) {
                    regExMatcherOrderId.reset(dailyPlanDBItem.getOrderId());
                    boolean bl = add = add && regExMatcherOrderId.matches();
                }
                if (!add) continue;
                this.dailyPlanList.add(dailyPlanDBItem);
            }
        }
        return this.dailyPlanList;
    }

    private void checkDaysSchedule() throws Exception {
        DailyPlanAdjustment dailyPlanAdjustment = new DailyPlanAdjustment(this.dailyPlanDBLayer.getSession());
        this.checkDailyPlanOptions = new CheckDailyPlanOptions();
        this.checkDailyPlanOptions.dayOffset.value(this.dayOffset);
        if (this.schedulerId != null) {
            this.checkDailyPlanOptions.scheduler_id.setValue(this.schedulerId);
        }
        dailyPlanAdjustment.setOptions(this.checkDailyPlanOptions);
        dailyPlanAdjustment.setTo(new Date());
        dailyPlanAdjustment.adjustWithHistory();
    }

    private void setFrom() throws ParseException {
        Date now = new Date();
        if (this.dayOffset < 0) {
            now = this.addCalendar(now, this.dayOffset, 5);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String froms = formatter.format(now);
        froms = froms + "T00:00:00";
        formatter = new SimpleDateFormat(this.dateFormat);
        this.from = formatter.parse(froms);
    }

    private void setTo() throws ParseException {
        Date now = new Date();
        if (this.dayOffset > 0) {
            now = this.addCalendar(now, this.dayOffset, 5);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String tos = formatter.format(now);
        tos = tos + "T00:00:00";
        formatter = new SimpleDateFormat(this.dateFormat);
        this.to = formatter.parse(tos);
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    public void setOptions(CreateDailyPlanOptions options) throws ParseException {
        this.options = options;
    }

    public void setSpooler(Spooler spooler) {
        this.spooler = spooler;
    }

    public int getDayOffset() {
        return this.dayOffset;
    }

    public Date getMaxPlannedTime(String schedulerId) {
        if (this.maxPlannedTime == null) {
            this.schedulerId = schedulerId;
            this.dayOffset = this.getDayOffsetFromPlan();
        }
        return this.maxPlannedTime;
    }
}

